/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as s}from"../../lit/index.js";class AwesomeExplosion extends e{static get styles(){return[s`
        :host {
          display: inline-block;
        }
        :host([size="tiny"]) #image {
          width: 80px;
          height: 80px;
        }
        :host([size="small"]) #image {
          width: 160px;
          height: 160px;
        }
        :host([size="medium"]) #image {
          width: 240px;
          height: 240px;
        }
        :host([size="large"]) #image {
          width: 320px;
          height: 320px;
        }
        :host([size="epic"]) #image {
          width: 720px;
          height: 720px;
        }

        :host([color="red"]) #image {
          filter: sepia() saturate(10000%) hue-rotate(30deg);
        }
        :host([color="purple"]) #image {
          filter: sepia() saturate(10000%) hue-rotate(290deg);
        }
        :host([color="blue"]) #image {
          filter: sepia() saturate(10000%) hue-rotate(210deg);
        }
        :host([color="orange"]) #image {
          filter: sepia() saturate(10000%) hue-rotate(320deg);
        }
        :host([color="yellow"]) #image {
          filter: sepia() saturate(10000%) hue-rotate(70deg);
        }
        #image {
          width: 240px;
          height: 240px;
        }
      `]}constructor(){super(),this.state="stop",this.image=new URL("./assets/explode.gif",import.meta.url).href,this.sound=new URL("./assets/273320__clagnut__fireworks.mp3",import.meta.url).href,this.size="medium",this.color="",this.resetSound=!1,setTimeout((()=>{this.addEventListener("click",this._setPlaySound.bind(this)),this.addEventListener("mouseover",this._setPlaySound.bind(this)),this.addEventListener("mouseout",this._setStopSound.bind(this))}),0)}render(){return t`
      <img
        loading="lazy"
        src="${this.image}"
        id="image"
        class="image-tag"
        alt=""
      />
    `}static get tag(){return"awesome-explosion"}updated(e){e.forEach(((e,t)=>{"state"==t&&(this.stopped=this._calculateStopped(this.state),this.playing=this._calculatePlaying(this.state),this.paused=this._calculatePaused(this.state))}))}static get properties(){return{state:{type:String,reflect:!0},stopped:{type:Boolean},playing:{type:Boolean},paused:{type:Boolean},image:{type:String},sound:{type:String},size:{type:String,reflect:!0},color:{type:String,reflect:!0},resetSound:{type:Boolean,reflect:!0,attribute:"reset-sound"}}}_calculateStopped(e,t){"stop"==e?(this.stopped=!0,void 0!==globalThis.audio&&(globalThis.audio.currentTime=0),this._stopSound(),this.dispatchEvent(new CustomEvent("awesome-event",{bubbles:!0,cancelable:!0,composed:!0,detail:{message:"Sound stopped"}}))):this.stopped=!1}_calculatePlaying(e,t){"play"==e?(this.playing=!0,this._playSound(),this.dispatchEvent(new CustomEvent("awesome-event",{bubbles:!0,cancelable:!0,composed:!0,detail:{message:"Sound played"}}))):this.playing=!1}_calculatePaused(e,t){"pause"==e?(this.paused=!0,this._stopSound(),this.dispatchEvent(new CustomEvent("awesome-event",{bubbles:!0,cancelable:!0,composed:!0,detail:{message:"Sound paused"}}))):this.paused=!1}_stopSound(){void 0!==globalThis.audio&&(globalThis.audio.pause(),this.resetSound&&(globalThis.audio.currentTime=0))}_setPlaySound(e){this.state="play"}_setStopSound(e){this.state="pause"}_playSound(){void 0===globalThis.audio&&(globalThis.audio=new Audio(this.sound)),globalThis.audio.play()}}customElements.define(AwesomeExplosion.tag,AwesomeExplosion);export{AwesomeExplosion};