import{html as e,css as i,unsafeCSS as t}from"../../../../lit/index.js";import"../../../simple-icon/lib/simple-icons.js";import"../../../simple-icon/lib/simple-icon-button-lite.js";import{SimpleColors as o}from"../../../simple-colors/simple-colors.js";import"../../../simple-tooltip/simple-tooltip.js";import{animate as s}from"../../../../@lit-labs/motion/index.js";const n=new URL("../assets/images/DropDownBorder.svg",import.meta.url);export class AppHaxSiteBars extends o{static get tag(){return"app-hax-site-bar"}constructor(){super(),this.icon="link",this.opened=!1,this.inprogress=!1,this.iconLink="/",this.textInfo={},this.siteId=""}static get properties(){return{...super.properties,opened:{type:Boolean,reflect:!0},icon:{type:String},inprogress:{type:Boolean,reflect:!0},iconLink:{type:String,attribute:"icon-link"},textInfo:{type:Object},siteId:{type:String,reflect:!0,attribute:"site-id"}}}updated(e){super.updated&&super.updated(e),e.forEach(((e,i)=>{"opened"===i&&void 0!==e&&this.dispatchEvent(new CustomEvent(`${i}-changed`,{detail:{value:this[i]}}))}))}static get styles(){return[super.styles,i`
        :host {
          --main-banner-width: 513px;
          --main-banner-height: 60px;
          --band-banner-height: 208px;
          display: inline-block;
          background-color: var(--simple-colors-default-theme-accent-3);
          color: var(--simple-colors-default-theme-grey-12);
          border-color: var(--simple-colors-default-theme-accent-4);
          border-style: solid;
          border-width: 5px 10px 5px 10px;
        }

        #labels {
          display: block;
          text-overflow: ellipsis;
          overflow: hidden;
          white-space: nowrap;
        }
        #labels ::slotted(*) {
          font-family: "Press Start 2P", sans-serif;
          font-size: 25px;
        }
        #labels ::slotted(a) {
          color: var(--simple-colors-default-theme-accent-11);
          padding: 8px 0;
          display: block;
        }
        #labels ::slotted(a:focus),
        #labels ::slotted(a:hover) {
          color: var(--simple-colors-default-theme-accent-3);
          background-color: var(--simple-colors-default-theme-accent-11);
        }

        :host([opened]) {
          background-color: var(--simple-colors-default-theme-accent-3);
        }
        #mainCard {
          display: flex;
          flex-direction: row;
          justify-content: space-between;
          align-items: center;
          width: var(--main-banner-width);
          height: var(--main-banner-height);
          padding: 2px 4px;
        }

        #band-container {
          display: block;
          visibility: hidden;
          height: 1px;
          width: var(--main-banner-width);
        }

        :host([opened]) #band-container {
          height: var(--band-banner-height);
          visibility: visible;
        }
        a {
          flex: 1;
        }
        #labels {
          flex: 6;
          overflow: hidden;
          text-overflow: ellipsis;
        }
        #icon {
          --simple-icon-width: 49px;
          --simple-icon-height: 49px;
          color: var(--simple-colors-default-theme-accent-11);
        }
        #icon:hover,
        #icon:focus,
        #icon:active {
          color: var(--simple-colors-default-theme-accent-3);
          background-color: var(--simple-colors-default-theme-accent-11);
        }
        #dots {
          --simple-icon-width: 49px;
          --simple-icon-height: 49px;
          color: var(--simple-colors-default-theme-grey-12);
          background-image: url(${t(n)});
          background-repeat: no-repeat;
          background-position: center;
        }
        @media (max-width: 640px) {
          :host {
            --main-banner-height: 40px;
            --band-banner-height: 140px;
          }
          #icon,
          #dots {
            --simple-icon-width: 30px;
            --simple-icon-height: 30px;
          }
          #mainCard {
            padding: 0;
          }
        }
      `]}__clickButton(){this.opened=!this.opened}render(){return e`
      <div id="mainCard">
        <a href="${this.iconLink}" tabindex="-1" id="icon">
          <simple-icon-button-lite
            icon="${this.icon}"
          ></simple-icon-button-lite>
        </a>
        <div id="labels">
          <slot name="heading"></slot>
        </div>
        <simple-icon-button-lite
          icon="more-vert"
          id="dots"
          @click=${this.__clickButton}
        ></simple-icon-button-lite>
      </div>
      <div id="band-container" ${s()}>
        <slot name="band"></slot>
      </div>
      <simple-tooltip for="icon" position="left">Access site</simple-tooltip>
      <simple-tooltip for="dots" position="right">More options</simple-tooltip>
    `}}customElements.define(AppHaxSiteBars.tag,AppHaxSiteBars);