import{SimpleColors as e}from"../../../simple-colors/simple-colors.js";import{html as t,css as s}from"../../../../lit/index.js";import{autorun as a,toJS as r}from"../../../../mobx/dist/mobx.esm.js";import{varGet as i}from"../../../utils/utils.js";import{store as o}from"./AppHaxStore.js";import"./app-hax-site-bar.js";import"./app-hax-site-details.js";export class AppHaxSearchResults extends e{static get tag(){return"app-hax-search-results"}constructor(){super(),this.searchItems=[],this.displayItems=[],this.searchTerm="",this.dark=!1,a((()=>{this.searchTerm=r(o.searchTerm)})),a((()=>{this.dark=r(o.darkMode)})),a((()=>{const e=r(o.manifest);e&&e.items&&(this.searchItems=e.items,this.displayItems=[...this.searchItems])}))}static get properties(){return{...super.properties,searchTerm:{type:String,reflect:!0},searchItems:{type:Array},displayItems:{type:Array}}}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"searchTerm"===t&&(this.displayItems=this.searchItems.filter((e=>!!(e.title.toLowerCase().includes(this.searchTerm.toLowerCase())||e.description.toLowerCase().includes(this.searchTerm.toLowerCase())||e.author.toLowerCase().includes(this.searchTerm.toLowerCase())||e.slug.toLowerCase().includes(this.searchTerm.toLowerCase())))))}))}static get styles(){return[super.styles,s`
        :host {
          overflow: hidden;
        }
        ul,
        li {
          margin: 0;
          padding: 0;
          list-style: none;
        }
        app-hax-site-bar {
          margin: 8px 0;
        }
        .description {
          max-height: 64px;
          overflow: hidden;
          max-width: 80%;
          text-overflow: ellipsis;
          word-break: break-all;
        }

        @media (max-width: 800px) {
          app-hax-site-bar {
            --main-banner-width: 60vw;
          }
          .description {
            max-height: 24px;
            font-size: 8px;
            font-family: sans-serif;
          }
        }
        @media (max-width: 640px) {
          app-hax-site-bar a {
            font-size: 14px;
          }
          app-hax-site-bar {
            --main-banner-width: 70vw;
          }
        }
        span[slot="band"] {
          height: 48px;
          overflow: hidden;
          text-overflow: ellipsis;
          margin-bottom: 8px;
        }
        :host([dark]) #noResult {
          color: var(--ddd-theme-default-coalyGray);
        }
      `]}render(){return t`
      <ul id="results">
        ${this.displayItems.length>0?this.displayItems.map((e=>t` <li>
                  <app-hax-site-bar
                    @opened-changed="${this.openedChanged}"
                    ?dark="${this.dark}"
                    accent-color="${i(e,"metadata.theme.variables.cssVariable","orange").replace("--simple-colors-default-theme-","").replace("-7","")}"
                    icon-link="${e.slug}"
                    icon="${i(e,"metadata.theme.variables.icon","link")}"
                  >
                    <a href="${e.slug}" slot="heading">${e.title}</a>
                    <span slot="subHeading">${e.author}</span>
                    <app-hax-site-details
                      slot="band"
                      .details="${this.getItemDetails(e)}"
                      site-id="${e.id}"
                    >
                      <div class="description" slot="pre">
                        ${e.description}
                      </div>
                    </app-hax-site-details>
                  </app-hax-site-bar>
                </li>`)):t`<div id="noResult">
              No results for
              ${""!==this.searchTerm?t`<strong>"${this.searchTerm}"</strong>`:"your account, try starting a new journey!"}.
            </div>`}
      </ul>
    `}getItemDetails(e){return{created:i(e,"metadata.site.created",new Date/1e3),updated:i(e,"metadata.site.updated",new Date/1e3),pages:i(e,"metadata.pageCount",0),url:e.slug}}openedChanged(e){o.appEl.playSound("click"),e.detail.value?this.shadowRoot.querySelector("app-hax-site-details").removeAttribute("tabindex"):this.shadowRoot.querySelector("app-hax-site-details").setAttribute("tabindex","-1")}}customElements.define(AppHaxSearchResults.tag,AppHaxSearchResults);