import{LitElement as t,html as e,css as o}from"../../../../lit/index.js";import"../../../simple-tooltip/simple-tooltip.js";import{store as i}from"./AppHaxStore.js";export class AppHaxSearchBar extends t{static get tag(){return"app-hax-search-bar"}constructor(){super(),this.searchTerm="",this.disabled=!1,this.showSearch=!1}static get properties(){return{searchTerm:{type:String},showSearch:{type:Boolean,reflect:!0,attribute:"show-search"},disabled:{type:Boolean,reflect:!0}}}updated(t){t.forEach(((t,e)=>{"searchItems"===e?this.displayItems=[...this.searchItems]:"searchTerm"===e?i.searchTerm=this.searchTerm:"showSearch"===e&&void 0!==t&&!1===this[e]&&(this.searchTerm="")}))}static get styles(){return[o`
        :host {
          overflow: hidden;
        }
        input {
          visibility: none;
          opacity: 0;
          width: 0;
          transition: all ease-in-out 0.3s;
          padding: 4px;
          font-family: "Press Start 2P", sans-serif;
          font-size: 20px;
          margin: 2px 0 0 16px;
        }
        :host([show-search]) input {
          visibility: visible;
          opacity: 1;
          width: 250px;
          max-width: 25vw;
        }
        @media (max-width: 780px) {
          :host([show-search]) input {
            width: 250px;
            max-width: 20vw;
          }
        }
        @media (max-width: 600px) {
          :host([show-search]) input {
            width: 200px;
            max-width: 20vw;
          }
        }

        simple-toolbar-button[disabled] {
          background-color: #cccccc;
          pointer-events: none;
          cursor: help;
        }
        simple-toolbar-button {
          min-width: 48px;
          margin: 0;
          --simple-toolbar-border-color: #dddddddd;
          height: 48px;
          --simple-toolbar-button-disabled-border-color: transparent;
          --simple-toolbar-button-disabled-opacity: 0.3;
          --simple-toolbar-button-padding: 3px 6px;
          --simple-toolbar-border-radius: 0;
        }
        simple-toolbar-button:hover,
        simple-toolbar-button:active,
        simple-toolbar-button:focus {
          background-color: var(--hax-ui-background-color-accent);
          color: var(--hax-ui-color);
        }
        simple-toolbar-button:hover,
        simple-toolbar-button:active,
        simple-toolbar-button:focus {
          --simple-toolbar-border-color: var(--hax-ui-color-accent);
        }
      `]}testKeydown(t){"Escape"!==t.key&&"Enter"!==t.key||this.toggleSearch()}search(){i.appEl.playSound("click"),this.searchTerm=this.shadowRoot.querySelector("#searchField").value}render(){return e`
      <simple-toolbar-button
        id="searchico"
        icon-position="left"
        show-text-label
        ?toggles="${this.showSearch}"
        ?disabled="${this.disabled}"
        label="Search Sites"
        icon="icons:search"
        @click="${this.toggleSearch}"
      ></simple-toolbar-button>
      <simple-tooltip for="searchico" position="bottom"
        >Toggle Search</simple-tooltip
      >
      <input
        ?disabled="${!this.showSearch}"
        id="searchField"
        @input="${this.search}"
        @keydown="${this.testKeydown}"
        type="text"
        placeholder="Site name.."
      />
    `}toggleSearch(){this.disabled||(this.shadowRoot.querySelector("#searchField").value="",i.appEl.playSound("click"),this.showSearch=!this.showSearch,setTimeout((()=>{this.shadowRoot.querySelector("#searchField").focus()}),300))}}customElements.define(AppHaxSearchBar.tag,AppHaxSearchBar);