import{css as t,html as e,unsafeCSS as i}from"../../../../lit/index.js";import{SimpleToastEl as a}from"../../../simple-toast/lib/simple-toast-el.js";import"../../../rpg-character/rpg-character.js";import"../../../future-terminal-text/future-terminal-text.js";const r=new URL("./images/SpeechBubbleL.svg",import.meta.url).href,s=new URL("./images/SpeechBubbleMiddle.svg",import.meta.url).href,l=new URL("./images/SpeechBubbleR.svg",import.meta.url).href;export class RPGCharacterToast extends a{static get tag(){return"rpg-character-toast"}constructor(){super(),this.awaitingMerlinInput=!1,this.windowControllers=new AbortController,this.text="Saved",this.closeText="Close",this.merlin=!1,this.classStyle="",this.future=!1,this.duration=3e3,this.accentColor="grey",this.dark=!1,this.eventCallback=null,this.fire=!1,this.hat="coffee",this.speed=500,this.walking=!1}static get styles(){return[super.styles,t`
        :host([opened]) {
          display: block;
          padding: 0;
          margin: 0;
          background-color: #22222222;
        }

        future-terminal-text {
          min-width: 300px;
          overflow-wrap: break-all;
          text-overflow: ellipsis;
          line-height: 36px;
          font-size: 18px;
          text-align: left;
          padding: 36px 0px;
          max-width: 50vw;
        }

        .merlin {
          --simple-icon-height: 100px;
          --simple-icon-width: 100px;
          background-color: var(--simple-colors-default-theme-accent-1, white);
          display: block;
          height: 150px;
          width: 100px;
          margin: 6px 0 0 0;
          padding: 16px;
        }
        .awaiting-input {
          --simple-icon-height: 50px;
          --simple-icon-width: 50px;
          width: 100px;
          margin: 6px 0px 0px;
          padding: 16px;
          color: var(--ddd-theme-default-wonderPurple);
          vertical-align: middle;
          display: inline-flex;
          height: 100px;
        }
        :host([hidden]) {
          display: none;
        }
        :host {
          --simple-toast-bottom: 0px;
          --simple-toast-bottom-offscreen: -284px;
          height: var(--rpg-character-toast-height, 142px);
          display: none;
          width: var(--simple-toast-width, auto);
          min-width: var(--simple-toast-min-width, 200px);
          color: var(
            --simple-toast-color,
            var(--simple-colors-default-theme-accent-12, black)
          );
          background-color: transparent;
          top: var(--simple-toast-top);
          bottom: var(--simple-toast-bottom, 36px);
          right: var(--simple-toast-right, 0px);
          border: var(--simple-toast-border);
          z-index: var(--simple-toast-z-index, 10000000);
          font-size: var(--simple-toast-font-size, 18px);
          font-family: sans-serif;
          font-weight: bold;
          text-align: center;
          vertical-align: middle;
        }
        rpg-character {
          width: 64px;
          margin: 0;
          padding: 0;
          display: var(--rpg-character-toast-display);
        }
        .bubble-wrapper {
          min-width: var(--simple-toast-min-width, 200px);
          display: block;
        }
        .bubble {
          height: var(--rpg-character-toast-height, 142px);
          display: inline-flex;
        }
        .mid {
          min-width: 100px;
          line-height: var(--rpg-character-toast-height, 142px);
          background-color: white;
          background-repeat: repeat-x;
          background-image: var(
            --rpg-character-toast-mid-background-image,
            url("${i(s)}")
          );
          padding: var(--rpg-character-toast-mid-padding, 54px 2px 0 2px);
          display: block;
        }
        .message {
          line-height: 16px;
          font-size: 14px;
          height: 16px;
          display: block;
          margin-top: 16px;
          margin-bottom: 16px;
        }
        .buttons {
          display: block;
          line-height: 16px;
          font-size: 16px;
          height: 16px;
        }
        .dismiss {
          padding: 4px;
          font-weight: bold;
          background-color: black;
          color: white;
          border: 4px solid black;
          border-radius: none;
          margin-left: 4px;
          cursor: pointer;
        }
        .leftedge {
          background-image: var(
            --rpg-character-toast-left-background-image,
            url("${i(r)}")
          );
          width: 20px;
          background-color: white;
        }
        .rightedge {
          background-image: var(
            --rpg-character-toast-right-background-image,
            url("${i(l)}")
          );
          width: 40px;
          background-color: white;
        }
        :host([dark-mode]) .mid,
        :host([dark-mode]) .leftedge,
        :host([dark-mode]) .rightedge {
          filter: invert(1);
        }
        .progress {
          width: calc(100% + 6px);
          border: 2px solid var(--ddd-theme-default-keystoneYellow);
          height: 8px;
          margin: -4px 0px 0px 0px;
        }

        .progress .progress__bar {
          height: 100%;
          width: 0%;
          background-color: var(--ddd-theme-default-keystoneYellow);
          animation-delay: 0.3s;
          animation-name: fill-bar;
          animation-duration: 3s;
          animation-iteration-count: 1;
          animation-fill-mode: forwards;
        }

        @keyframes fill-bar {
          from {
            width: 0%;
          }
          to {
            width: 100%;
          }
        }
      `]}static get properties(){return{...super.properties,darkMode:{type:Boolean,reflect:!0,attribute:"dark-mode"},fire:{type:Boolean},hat:{type:String},walking:{type:Boolean},speed:{type:Number},opened:{type:Boolean,reflect:!0},awaitingMerlinInput:{type:Boolean,attribute:"awaiting-merlin-input"},merlin:{type:Boolean},future:{type:Boolean},text:{type:String},classStyle:{type:String,attribute:"class-style"},duration:{type:Number},eventCallback:{type:String,attribute:"event-callback"}}}render(){return e` <div class="progress">
        <div
          class="progress__bar"
          style="animation-duration:${this.duration}ms;"
        ></div>
      </div>
      <div class="bubble bubble-wrapper" part="bubble-wrapper">
        <span class="bubble leftedge" part="bubble-left"></span>
        <span class="bubble mid" part="bubble-mid">
          <slot name="pre"></slot>
          ${this.future?e` <future-terminal-text
                fadein
                glitch
                glitch-max="3"
                glitch-duration="40"
              ></future-terminal-text>`:e`<div class="message">${this.text}</div>`}
          ${this.awaitingMerlinInput?e`<simple-icon-lite
                class="awaiting-input"
                icon="hax:loading"
              ></simple-icon-lite>`:""}
          ${this.merlin?"":e`<div class="buttons">
                <slot></slot
                ><button class="dismiss" @click="${this.hide}">
                  ${this.closeText}
                </button>
              </div>`}
        </span>
        <span class="bubble rightedge" part="bubble-right"></span>
        ${this.merlin?e` <simple-icon
              class="merlin"
              icon="hax:wizard-hat"
              accent-color="purple"
            ></simple-icon>`:e`
              <rpg-character
                height="180"
                width="64"
                seed="${this.userName}"
                ?fire="${this.fire}"
                hat="${this.hat}"
                speed="${this.speed}"
                part="rpg-character"
                ?walking="${this.walking}"
              ></rpg-character>
            `}
      </div>`}updated(t){super.updated(t),t.has("text")&&this.future&&this.shadowRoot.querySelector("future-terminal-text")&&(this.shadowRoot.querySelector("future-terminal-text").innerText=this.text,this.shadowRoot.querySelector("future-terminal-text")._doGlitch())}connectedCallback(){super.connectedCallback(),globalThis.addEventListener("rpg-character-toast-hide",this.hideSimpleToast.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("rpg-character-toast-show",this.showSimpleToast.bind(this),{signal:this.windowControllers.signal})}hideSimpleToast(t){this.awaitingMerlinInput=!1,this.hide()}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}showSimpleToast(t){for(;null!==this.firstChild;)this.removeChild(this.firstChild);setTimeout((()=>{t.detail.slot&&this.appendChild(t.detail.slot)}),0),this.duration=t.detail.duration?t.detail.duration:4e3,this.fire=!!t.detail.fire&&t.detail.fire,this.hat=t.detail.hat?t.detail.hat:"coffee",this.merlin=!!t.detail.merlin&&t.detail.merlin,this.walking=!!t.detail.walking&&t.detail.walking,this.speed=t.detail.speed?t.detail.speed:500,this.text=t.detail.text?t.detail.text:"Saved",this.future=!!t.detail.future&&t.detail.future,this.classStyle=t.detail.classStyle?t.detail.classStyle:"",this.eventCallback=t.detail.eventCallback?t.detail.eventCallback:null,this.dark=!!t.detail.dark&&t.detail.dark,this.accentColor=t.detail.accentColor?t.detail.accentColor:"grey",this.alwaysvisible=!!t.detail.alwaysvisible&&t.detail.alwaysvisible,t.detail.awaitingMerlinInput&&this.duration?setTimeout((()=>{this.style.animation="none",this.awaitingMerlinInput=t.detail.awaitingMerlinInput}),this.duration/2):this.awaitingMerlinInput=!1,this.show()}show(){this.opened||(this.opened=!0)}hide(){if(this.awaitingMerlinInput)this.style.animation="fadein 0.3s";else{if(this.walking=!1,this.speed=500,this.eventCallback){const t=new CustomEvent(this.eventCallback,{bubbles:!0,cancelable:!0,detail:!0,composed:!0});this.dispatchEvent(t)}this.alwaysvisible?this.style.animation="fadein 0.3s":this.opened=!1}}}customElements.define(RPGCharacterToast.tag,RPGCharacterToast);