/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{SchemaBehaviors as o}from"../schema-behaviors/schema-behaviors.js";import"../es-global-bridge/es-global-bridge.js";class AframePlayer extends(o(e)){static get styles(){return[i`
        :host {
          display: block;
          position: relative;
        }
        .a-hidden {
          display: hidden;
        }
      `]}render(){return t`
      <a-scene
        id="scene"
        class="embedded"
        embedded
        ?arjs="${this.ar}"
        style="height:${this.height};width:${this.width};"
      >
        <a-sky color="${this.skyColor}"></a-sky>
        <a-marker-camera preset="hiro"></a-marker-camera>
      </a-scene>
    `}static get tag(){return"aframe-player"}constructor(){super(),this.windowControllers=new AbortController,this.course="",this.height="480px",this.width="640px",this.skyColor="#DCDCDC",this.ar=!1,this.x="0",this.y="0",this.z="0",this.position={}}updated(e){e.forEach(((e,t)=>{["x","y","z","width","height"].includes(t)&&(this.position=this._computePosition(this.x,this.y,this.z,this.width,this.height)),"position"==t&&this._positionChanged(this[t])}))}static get properties(){return{...super.properties,source:{type:String},height:{type:String},width:{type:String},skyColor:{type:String,attribute:"sky-color"},ar:{type:Boolean},x:{type:String},y:{type:String},z:{type:String},position:{type:Object}}}createRenderRoot(){return this}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"3D player",description:"A 3D file / augmented reality player.",icon:"av:play-circle-filled",color:"amber",tags:["3D","augmented reality","AR","VR","video","aframe","webxr","webvr"],handles:[{type:"3d",source:"source"}],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"source",title:"Source",description:"The URL for this AR file.",inputMethod:"textfield",type:"bar",icon:"link",required:!0},{property:"x",title:"X",description:"X position of the element in AR.",inputMethod:"textfield",type:"bar",icon:"communication:location-on",required:!0},{property:"y",title:"Y",description:"Y position of the element in AR.",inputMethod:"textfield",type:"bar",icon:"communication:location-on",required:!0},{property:"z",title:"Z",description:"Z position of the element in AR.",inputMethod:"textfield",type:"bar",icon:"communication:location-on",required:!0},{property:"skyColor",title:"Sky color",description:"Select the color of the sky in the scene.",inputMethod:"colorpicker",type:"bar",icon:"editor:format-color-fill"}],advanced:[]}}}connectedCallback(){super.connectedCallback();"object"==typeof TWEEN&&this._aframeLoaded.bind(this),globalThis.addEventListener("es-bridge-aframePlayer-loaded",this._aframeLoaded.bind(this),{signal:this.windowControllers.signal}),globalThis.ESGlobalBridge.requestAvailability().load("aframePlayer","https://aframe.io/releases/0.9.2/aframe.min.js")}_aframeLoaded(e){this.querySelector("#scene").removeFullScreenStyles(),this.__entity=globalThis.document.createElement("a-entity"),this.__entity.setAttribute("gltf-model","url("+this.source+")"),this._positionChanged(this.position),this.querySelector("#scene").appendChild(this.__entity)}_computePosition(e,t,i,o,r){return{x:e,y:t,z:i}}_positionChanged(e){void 0!==this.__entity&&this.__entity.setAttribute("position",e)}}customElements.define(AframePlayer.tag,AframePlayer);export{AframePlayer};