/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as a}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";class A11yTab extends t{static get styles(){return[a`
        :host {
          display: block;
          margin-bottom: var(--a11y-tabs-content-padding);
          border: 1px solid var(--a11y-tabs-border-color);
          padding: var(--a11y-tabs-content-padding);
        }
        .sr-only {
          position: absolute;
          left: -99999px;
          height: 0;
          overflow: hidden;
        }
        .label-heading {
          display: flex;
          align-items: center;
          color: var(--a11y-tabs-selected-color, var(--a11y-tabs-focus-color));
          background-color: var(--a11y-tabs-background);
          font-weight: var(--a11y-tabs-selected-font-weight, normal);
          border-bottom: 1px solid var(--a11y-tabs-border-color);
          margin: 0 0 calc(var(--a11y-tabs-content-padding) / 2);
          padding: 0 0 calc(var(--a11y-tabs-content-padding) / 2);
          border-radius: var(--a11y-tabs-horizontal-border-radius, 2px)
            var(--a11y-tabs-horizontal-border-radius, 2px) 0 0;
        }
        simple-icon-lite {
          margin-right: 1em;
        }
        @media screen {
          :host {
            border: none;
            height: var(--a11y-tabs-tab-height, --a11y-tabs-height);
            overflow: var(--a11y-tabs-tab-overflow, --a11y-tabs-overflow);
            margin-bottom: unset;
          }
          :host([inactive]) {
            display: none;
          }
          #content-inner {
            height: var(--a11y-tabs-tab-height, --a11y-tabs-height);
            max-width: 100%;
            overflow: auto;
          }
          .label-heading {
            display: none;
          }
        }
      `]}render(){return e`
      <span class="sr-only">Tab ${this.xOfY}</span>
      <div class="label-heading" part="heading">
        <simple-icon-lite
          class="icon"
          ?hidden="${!this.icon}"
          .icon="${this.icon}"
          part="icon"
        >
        </simple-icon-lite>
        <slot name="label" ?hidden="${!this.label}"></slot>
        <div class="label" part="label">${this.label}</div>
      </div>
      <div id="content-inner" part="content"><slot></slot></div>
      <span class="sr-only">
        End of tab ${this.xOfY}. Back to <a href="#${this.id}">tabs</a>.
      </span>
    `}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Tab",description:"A single tab.",icon:"view-day",color:"grey",tags:["Layout","a11y","presentation","tab","layout","tabs"]},settings:{configure:[{property:"icon",title:"Tab Icon",inputMethod:"iconpicker"},{property:"disabled",title:"Disabled",inputMethod:"boolean"},{property:"label",title:"Tab Label",inputMethod:"textfield"},{slot:"",title:"Tab Content",description:"A content of the tab.",inputMethod:"code-editor"}],advanced:[{property:"id",title:"Unique ID",inputMethod:"textfield"},{property:"flag",title:"Optional Flag Text",inputMethod:"textfield"},{property:"flagIcon",title:"Optional Flag Icon",inputMethod:"iconpicker"}]}}}static get properties(){return{ariaLabelledby:{type:String,reflect:!0,attribute:"aria-labelledby"},flag:{type:String,reflect:!0},flagIcon:{type:String,attribute:"flag-icon"},disabled:{type:Boolean,reflect:!0,attribute:"disabled"},icon:{type:String},id:{type:String,reflect:!0,attribute:"id"},inactive:{type:Boolean,reflect:!0,attribute:"inactive"},label:{type:String},order:{type:Number},role:{type:String,reflect:!0,attribute:"role"},tabindex:{type:Number},total:{type:Number}}}constructor(){super(),this.disabled=!1,this.hidden=!1,this.order=1,this.role="tabpanel",this.total=1,this.tabindex=0,this.flag="",this.addEventListener("a11y-tab-flag",(t=>this.handleFlag(t)))}get observer(){return new MutationObserver((t=>this._labelChanged()))}get xOfY(){return`${this.order} of ${this.total}`}connectedCallback(){super.connectedCallback(),this._labelChanged(),this.observer.observe(this,{childList:!0})}disconnectedCallback(){this.observer.disconnect(),this.removeEventListener("a11y-tab-flag",(t=>this.handleFlag(t))),this._fireTabChanged(),super.disconnectedCallback()}updated(t){t.forEach(((t,e)=>{["id","order"].includes(e)&&!this.id&&(this.id=`tab-${this.order}`),["label","order"].includes(e)&&!this.label&&this._labelChanged(),"flag"===e&&this._fireTabChanged(),"flagIcon"===e&&this._fireTabChanged(),"icon"===e&&this._fireTabChanged(),"id"===e&&(this.ariaLabelledby=`${this.id}-button`,this._fireTabChanged()),"label"===e&&this._fireTabChanged(),"disabled"===e&&this.disabled&&this._fireTabChanged()}))}static get tag(){return"a11y-tab"}_handleFlag(t){this.flag=t.detail.flag,this.flagIcon=t.detail.flagIcon}_labelChanged(){this.label&&""!==this.label.trim()||(this.label=this.querySelector('*[slot="label"]')?this.querySelector('*[slot="label"]').innerHTML:`Tab ${this.order}`)}_fireTabChanged(){this.dispatchEvent(new CustomEvent("a11y-tab-changed",{bubbles:!0,cancelable:!0,composed:!1,detail:this}))}}customElements.define(A11yTab.tag,A11yTab);export{A11yTab};