/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as a,css as e}from"../../lit/index.js";import{ResponsiveUtilityBehaviors as s}from"../responsive-utility/lib/responsive-utility-behaviors.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import"../simple-tooltip/simple-tooltip.js";import"./lib/a11y-tab.js";class A11yTabs extends(s(t)){static get A11yTabsCoreStyles(){return[e`
        :host {
          display: block;
          height: var(--a11y-tabs-height);
          overflow: var(--a11y-tabs-overflow);
        }

        :host([hidden]) {
          display: none;
        }

        #tabs {
          display: none;
        }
        @media screen {
          :host([vertical]) {
            border-radius: var(--a11y-tabs-vertical-border-radius, 2px);
            display: flex;
            justify-content: space-between;
            align-items: stretch;
          }
          #content {
            flex: 1 1 calc(100% - 2 * var(--a11y-tabs-content-padding, 16px));
            overflow: auto;
          }
          #tabs {
            align-items: stretch;
            flex-wrap: var(--a11y-tabs-wrap, unset);
            margin: 0;
            display: flex;
            list-style: none;
            padding: 0;
            overflow: auto;
            max-width: 100%;
            overflow-x: auto;
            z-index: 1;
            justify-content: var(--a11y-tabs-horizontal-justify-tabs);
          }
          :host([vertical]) #tabs {
            flex: 0 0 auto;
            flex-direction: column;
            overflow-y: auto;
            max-width: unset;
            overflow-x: unset;
            z-index: unset;
            flex-wrap: var(--a11y-tabs-vertical-wrap);
          }
          :host([sticky]) #tabs {
            position: sticky;
            top: 0;
          }
          #tabs li {
            display: flex;
            align-items: stretch;
          }
          :host([full-width]) #tabs li {
            width: 100%;
          }
          :host([vertical]) #tabs li {
            flex-direction: column;
          }
          #tabs .flag-type {
            position: absolute;
            left: -99999px;
            height: 0;
            overflow: hidden;
          }
          :host(:not([vertical])) #content {
            margin-top: -1px;
          }
          #tabs button {
            width: 100%;
            min-width: unset;
            margin: 0;
          }

          :host([vertical]) #tabs button {
            display: flex;
            justify-content: space-between;
            align-items: center;
          }

          #tabs button[disabled] {
            pointer-events: none;
          }

          #tabs span.label,
          #tabs .flag-icon {
            margin-right: 8px;
          }

          :host([icons-only]) #tabs button {
            justify-content: center;
          }

          :host([icons-only]) #tabs span.label {
            display: none;
          }

          :host(:not([icons-only])) #tabs #tabs simple-tooltip {
            display: none;
          }
          simple-icon-lite:not([hidden]) {
            display: inline-block;
          }

          simple-icon-lite[hidden] {
            display: none;
          }
        }
      `]}static get A11yTabsThemeStyles(){return[e`
        :host {
          font-size: var(--a11y-tabs-font-size, unset);
          font-family: var(--a11y-tabs-font-family, unset);
          --a11y-tabs-focus-color: var(--a11y-tabs-color);
          --a11y-tabs-horizontal-border-radius: var(
            --a11y-tabs-border-radius,
            2px
          );
          --a11y-tabs-vertical-border-radius: var(
            --a11y-tabs-border-radius,
            2px
          );
          --a11y-tabs-vertical-button-padding: var(
            --a11y-tabs-button-padding,
            4px
          );
          --a11y-tabs-horizontal-button-padding: var(
            --a11y-tabs-button-padding,
            4px
          );
        }
        @media screen {
          :host([vertical]) {
            border-radius: var(--a11y-tabs-vertical-border-radius, 2px);
            border: 1px solid var(--a11y-tabs-border-color, #ddd);
          }

          #content {
            border: 1px solid var(--a11y-tabs-border-color, #ddd);
            padding: var(--a11y-tabs-content-padding, 16px);
            background-color: var(--a11y-tabs-content-background);
          }

          #tabs {
            background-color: var(--a11y-tabs-horizontal-background);
            font-family: var(
              --a11y-tabs-tab-font-family,
              var(--a11y-tabs-font-family, unset)
            );
            font-size: var(
              --a11y-tabs-tab-font-size,
              var(--a11y-tabs-font-size, unset)
            );
          }

          :host([vertical]) #tabs {
            border-left: none;
            background-color: var(--a11y-tabs-vertical-background);
            justify-content: var(--a11y-tabs-vertical-justify-tabs);
          }

          :host([vertical]) #tabs button {
            padding: var(--a11y-tabs-vertical-button-padding);
            border-radius: 0;
          }

          :host([vertical]) #content {
            border: none;
          }
          :host(:not([vertical])) #content {
            border-radius: var(--a11y-tabs-horizontal-border-radius, 2px);
          }

          #tabs button {
            text-transform: unset;
            color: var(--a11y-tabs-faded-color, #333);
            border: 1px solid var(--a11y-tabs-border-color);
            background-color: var(--a11y-tabs-faded-background, #f8f8f8);
            padding: var(--a11y-tabs-horizontal-button-padding);
            font-weight: var(--a11y-tabs-font-weight, normal);
            border-radius: var(--a11y-tabs-horizontal-border-radius, 2px)
              var(--a11y-tabs-horizontal-border-radius, 2px) 0 0;
          }

          button .label {
            text-decoration: var(--a11y-tabs-text-decoration, none);
          }

          :host(:not([vertical])) #tabs button {
            border-top-color: var(--a11y-tabs-border-accent);
          }

          :host(:not([vertical])) #tabs li:not(:first-of-type) button {
            border-left: none;
          }

          :host([vertical]) #tabs button {
            border-top: none;
            border-left-color: var(--a11y-tabs-border-accent);
          }

          #tabs button:focus,
          #tabs button:hover {
            color: var(--a11y-tabs-focus-color);
            font-weight: var(--a11y-tabs-focus-font-weight, normal);
          }

          button:focus .label,
          button:hover .label {
            text-decoration: var(--a11y-tabs-focus-text-decoration, underline);
          }

          :host(:not([vertical])) #tabs button:focus,
          :host(:not([vertical])) #tabs button:hover {
            border-top-color: var(--a11y-tabs-focus-border-accent);
          }

          :host([vertical]) #tabs button:focus,
          :host([vertical]) #tabs button:hover {
            border-left-color: var(--a11y-tabs-focus-border-accent);
          }

          #tabs button[aria-selected="true"] {
            font-weight: var(--a11y-tabs-selected-font-weight, normal);
            color: var(
              --a11y-tabs-selected-color,
              var(--a11y-tabs-focus-color)
            );
            background-color: var(--a11y-tabs-background);
          }

          button[aria-selected="true"] .label {
            text-decoration: var(--a11y-tabs-selected-text-decoration, none);
          }

          :host(:not([vertical])) #tabs button[aria-selected="true"] {
            border-bottom-color: var(--a11y-tabs-background);
            border-top-color: var(--a11y-tabs-selected-border-accent);
          }

          :host([vertical]) #tabs button[aria-selected="true"] {
            border-right-color: var(--a11y-tabs-background);
            border-left-color: var(--a11y-tabs-selected-border-accent);
          }

          #tabs button[disabled] {
            color: var(--a11y-tabs-disabled-color, #999);
            background-color: var(--a11y-tabs-disabled-background, #eee);
          }

          #tabs button[disabled]:focus,
          #tabs button[disabled]:hover {
            color: unset;
            font-weight: unset;
          }

          button[disabled]:focus .label,
          button[disabled]:hover .label {
            text-decoration: none;
          }

          :host(:not([vertical])) #tabs button[disabled] {
            border-left-color: var(--a11y-tabs-disabled-border-accent, unset);
          }

          :host([vertical]) #tabs button[disabled] {
            border-top-color: var(--a11y-tabs-disabled-border-accent, unset);
          }
        }
      `]}static get styles(){return[...this.A11yTabsCoreStyles,...this.A11yTabsThemeStyles]}render(){return a` <ul id="tabs" role="tablist" part="tablist">
        ${this.tabs.map(((t,e)=>a`
            <li part="tablist-item">${this._tabButton(t,e)}</li>
          `))}
      </ul>
      <div id="content" part="content">
        <slot></slot>
      </div>`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}static get properties(){return{...super.properties,ariaLabel:{type:String,reflect:!0,attribute:"aria-label"},activeTab:{type:String,reflect:!0,attribute:"active-tab"},fullWidth:{type:Boolean,reflect:!0,attribute:"full-width"},disabled:{type:Boolean,reflect:!0,attribute:"disabled"},hidden:{type:Boolean,reflect:!0,attribute:"hidden"},iconBreakpoint:{type:Number,attribute:"icon-breakpoint"},id:{type:String,reflect:!0},layoutBreakpoint:{type:Number,attribute:"layout-breakpoint"},responsiveSize:{type:String,reflect:!0,attribute:"responsive-size"},sticky:{type:Boolean,reflect:!0,attribute:"sticky"},__tabs:{type:Array},__tabButtons:{type:Array},__tabFocus:{type:Number}}}static get tag(){return"a11y-tabs"}constructor(){super(),this.fullWidth=!1,this.disableResponsive=!1,this.disabled=!1,this.hidden=!1,this.__tabs=[],this.__tabFocus=0,this.addEventListener("a11y-tab-changed",(t=>this.updateTabs()))}get buttons(){return this.__tabButtons}get iconsOnly(){return this.iconBreakpoint&&(this.tabs||[]).filter((t=>!t.icon)).length<1&&this.responsiveWidth<this.iconBreakpoint}get observer(){return new MutationObserver((()=>this.updateTabs()))}get tabQuery(){return"a11y-tab"}get tabs(){return Object.keys(this.__tabs||{}).map((t=>(this.__tabs[t].order=t+1,this.__tabs[t].total=this.__tabs.length,this.__tabs[t])))}get vertical(){return this.layoutBreakpoint&&this.layoutBreakpoint<this.responsiveWidth}connectedCallback(){super.connectedCallback(),this.observer.observe(this,{attributes:!1,childList:!0,subtree:!1})}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),setTimeout((()=>{this.updateTabs()}),0)}disconnectedCallback(){this.observer&&this.observer.disconnect&&this.observer.disconnect(),super.disconnectedCallback()}updated(t){t.forEach(((t,a)=>{"id"===a&&this._idChanged(this.id,t),"activeTab"===a&&this.activeTab!==t&&this._activeTabChanged(this.activeTab,t),"responsiveWidth"===a&&(this.vertical?this.setAttribute("vertical",!0):this.removeAttribute("vertical")),["iconsBreakpoint","responsiveWidth","__tabs"].includes(a)&&(this.iconsOnly?this.setAttribute("icons-only",!0):this.removeAttribute("icons-only"))}))}selectTab(t){let a=this.querySelectorAll(this.tabQuery);if(a&&a.length>0){let e=Object.keys(a||[]).filter((t=>!a[t].disabled)).map((t=>a[t].id)),s=e.filter((a=>a===t))[0]||e[0];a.forEach((t=>{t.inactive=t.id!==s})),this.activeTab=s}}updateTabs(t){this.__tabs=this.querySelectorAll(this.tabQuery),this.__tabButtons=this.shadowRoot.querySelectorAll("[role=tab]"),this.selectTab(this.activeTab)}_activeTabChanged(t,a){t!==a&&this.selectTab(t),globalThis.dispatchEvent(new CustomEvent("a11y-tabs-active-changed",{cancelable:!0,detail:this})),this.dispatchEvent(new CustomEvent("a11y-tabs-active-changed",{detail:this}))}_generateUUID(){return"ss-s-s-s-sss".replace(/s/g,Math.floor(65536*(1+Math.random())).toString(16).substring(1))}_handleTab(t){t.disabled||(this.activeTab=t.id)}_handleKey(t,a){0===this.buttons.length&&this.updateTabs(),this.__tabFocus=t;let focus=(a=1)=>{this.__tabFocus=this.__tabFocus+a,this.__tabFocus>=this.buttons.length?this.__tabFocus=0:this.__tabFocus<0&&(this.__tabFocus=this.buttons.length-1),this.buttons[this.__tabFocus].disabled&&this.__tabFocus!==t&&focus(a)};39!==a.keyCode&&37!==a.keyCode||(this.buttons[this.__tabFocus].setAttribute("tabindex",-1),focus(39===a.keyCode?1:-1),this.buttons[this.__tabFocus].disabled||(this.buttons[this.__tabFocus].setAttribute("tabindex",0),this.buttons[this.__tabFocus].focus()),a.preventDefault(),a.stopPropagation())}_idChanged(t,a){t||(this.id="a11y-tabs"+this._generateUUID())}_tabButton(t,e){return a`
      <button
        id="${t.id}-button"
        aria-selected="${t.id===this.activeTab?"true":"false"}"
        aria-controls="${t.id}"
        class="${t.id!==this.activeTab||this.disabled?"":"active"}"
        .flag="${t.flag}"
        @click="${a=>this._handleTab(t)}"
        @keydown="${t=>this._handleKey(e,t)}"
        ?disabled="${t.disabled||this.disabled}"
        tabindex="${t.id===this.activeTab?0:-1}"
        role="tab"
        part="${t.id!==this.activeTab||this.disabled?this.disabled||t.disabled?"tab-disabled":"":"tab-active"} tab tab-${t.id}"
      >
        ${this._tabIcon(t,"flagIcon")} ${this._tabLabel(t)}
        ${this._tabFlag(t)} ${this._tabIcon(t,"icon")}
      </button>
      ${this._tabTooltip(t)}
    `}_tabFlag(t){return a`
      <span class="flag-type" ?hidden="${!t.flag}" part="flag">
        ${t.flag}
      </span>
    `}_tabIcon(t,e){return t.flag?a`
          <simple-icon-lite
            class="icon"
            ?hidden="${!t[e]}"
            .icon="${t[e]}"
            .title="${t.flag}"
            part="icon"
          >
          </simple-icon-lite>
        `:a`
          <simple-icon-lite
            class="icon"
            ?hidden="${!t[e]}"
            .icon="${t[e]}"
            part="icon"
          >
          </simple-icon-lite>
        `}_tabLabel(t){return a` <span class="label" part="label">${t.label}</span> `}_tabTooltip(t){return a`
      <simple-tooltip for="${t.id}-button" part="tooltip">
        ${t.label}
      </simple-tooltip>
    `}}customElements.define(A11yTabs.tag,A11yTabs);export{A11yTabs};