/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as o}from"../../../lit/index.js";const A11yMenuButtonItemBehaviors=function(t){return class extends t{static get styles(){return[o`
          :host {
            margin: 0;
            padding: 0;
            display: block;
          }
          :host([hidden]) {
            display: none;
          }
          *[role="menuitem"][disabled] {
            cursor: not-allowed;
          }

          *[role="menuitem"],
          *[role="menuitem"]:visited {
            display: block;
            margin: 0;
            border-radius: 0;
            font-family: inherit;
            font-size: inherit;
            text-decoration: var(--a11y-menu-button-item-text-decoration, none);
            color: var(
              --a11y-menu-button-item-color,
              var(--a11y-menu-button-color, currentColor)
            );
            width: calc(
              100% - 2 *
                var(
                  --a11y-menu-button-item-horizontal-padding,
                  var(--a11y-menu-button-horizontal-padding, 5px)
                )
            );
            text-align: var(--a11y-menu-button-item-text-align, left);
            padding: var(
                --a11y-menu-button-item-vertical-padding,
                var(--a11y-menu-button-vertical-padding, 0)
              )
              var(
                --a11y-menu-button-item-horizontal-padding,
                var(--a11y-menu-button-horizontal-padding, 5px)
              );
            background-color: var(
              --a11y-menu-button-item-bg-color,
              var(--a11y-menu-button-bg-color, white)
            );
            border-left: var(--a11y-menu-button-item-border-left, none);
            border-right: var(--a11y-menu-button-item-border-right, none);
            border-top: var(--a11y-menu-button-item-border-top, none);
            border-bottom: var(--a11y-menu-button-item-border-bottom, none);
            border: var(--a11y-menu-button-item-border, none);
            transition: all 0.25s ease-in-out;
          }
          button[role="menuitem"],
          button[role="menuitem"]:visited {
            width: 100%;
          }

          :host(:focus-within) *[role="button"],
          *[role="menuitem"]:focus,
          *[role="menuitem"]:hover {
            text-decoration: var(
              --a11y-menu-button-item-focus-text-decoration,
              none
            );
            color: var(--a11y-menu-button-item-focus-color, currentColor);
            background-color: var(
              --a11y-menu-button-item-focus-bg-color,
              #e0e0ff
            );
            border-left: var(--a11y-menu-button-item-focus-border-left, unset);
            border-right: var(
              --a11y-menu-button-item-focus-border-right,
              unset
            );
            border-top: var(--a11y-menu-button-item-focus-border-top, unset);
            border-bottom: var(
              --a11y-menu-button-item-focus-border-bottom,
              unset
            );
            border: var(--a11y-menu-button-item-focus-border, unset);
          }
        `]}render(){return this.href&&""!==this.href.trim()?this.linkTemplate:this.buttonTemplate}static get tag(){return"a11y-menu-button-item"}static get properties(){return{disabled:{attribute:"disabled",type:Boolean},hidden:{attribute:"hidden",type:Boolean,reflect:!0},href:{attribute:"href",type:String},controls:{attribute:"controls",type:String},slot:{type:String,attribute:"slot",reflect:!0}}}constructor(){super(),this.slot="menuitem"}get linkTemplate(){return e` <li role="none">
        <a
          role="menuitem"
          href="${this.href}"
          ?disabled="${this.disabled}"
          part="button"
        >
          <slot></slot>
        </a>
      </li>`}get buttonTemplate(){return e`
        <li role="none">
          <button
            role="menuitem"
            controls="${this.controls}"
            ?disabled="${this.disabled}"
            part="button"
          >
            <slot></slot>
          </button>
        </li>
      `}get menuItem(){return this.shadowRoot&&this.shadowRoot.querySelector("[role=menuitem]")?this.shadowRoot.querySelector("[role=menuitem]"):void 0}focus(){this.menuItem&&this.menuItem.focus()}connectedCallback(){super.connectedCallback(),this.dispatchEvent(new CustomEvent("add-a11y-menu-button-item",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}disconnectedCallback(){super.disconnectedCallback(),this.dispatchEvent(new CustomEvent("remove-a11y-menu-button-item",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}}};class A11yMenuButtonItem extends(A11yMenuButtonItemBehaviors(t)){}customElements.define(A11yMenuButtonItem.tag,A11yMenuButtonItem);export{A11yMenuButtonItem,A11yMenuButtonItemBehaviors};