/**
 * Copyright 2018 Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as o}from"../../lit/index.js";import"./lib/a11y-menu-button-item.js";import"../absolute-position-behavior/absolute-position-behavior.js";import{normalizeEventPath as s}from"../utils/utils.js";const A11yMenuButtonBehaviors=function(t){return class extends t{static get menuButtonCoreStyles(){return[o`
          :host {
            padding: 0;
            display: inline-flex;
            position: relative;
            z-index: 1;
          }
          :host([expanded]) {
            z-index: var(--a11y-menu-button-focus-z-index, 1000);
          }
          button[part="button"] {
            display: block;
            text-decoration: inherit;
            font-family: inherit;
            font-size: inherit;
            margin: 0;
            width: 100%;
          }
          absolute-position-behavior {
            z-index: -1;
            overflow: hidden;
            transition: z-index 0s;
          }
          :host([expanded]) absolute-position-behavior {
            z-index: var(--a11y-menu-button-focus-z-index, 1000);
            transition: z-index 0s;
          }
          :host(:not([expanded])) absolute-position-behavior {
            border-color: none !important;
          }
          ul {
            margin: 0;
            padding: 0;
            list-style: none;
          }
        `]}static get menuButtonThemeStyles(){return[o`
          button[part="button"] {
            padding: var(--a11y-menu-button-vertical-padding, 2px)
              var(--a11y-menu-button-horizontal-padding, 5px);
            text-align: var(--a11y-menu-button-text-align, center);
            background-color: var(--a11y-menu-button-bg-color, white);
            color: var(--a11y-menu-button-color, currentColor);
            background-color: var(--a11y-menu-button-bg-color, white);
            border-radius: var(--a11y-menu-button-border-radius, 0);
            border-left: var(--a11y-menu-button-border-left, unset);
            border-top: var(--a11y-menu-button-border-top, unset);
            border-right: var(--a11y-menu-button-border-right, unset);
            border-bottom: var(--a11y-menu-button-border-bottom, unset);
            border: var(--a11y-menu-button-border, 1px solid #ddd);
            box-shadow: var(--a11y-menu-button-box-shadow, unset);
            transition: all 0.25s ease-in-out;
          }
          button[part="button"]:focus,
          button[part="button"]:hover {
            color: var(
              --a11y-menu-button-focus-color,
              var(--a11y-menu-button-color, currentColor)
            );
            background-color: var(
              --a11y-menu-button-focus-bg-color,
              var(--a11y-menu-button-bg-color, white)
            );
            border-left: var(
              --a11y-menu-button-focus-border-left,
              var(--a11y-menu-button-border-left, unset)
            );
            border-top: var(
              --a11y-menu-button-focus-border-top,
              var(--a11y-menu-button-border-top, unset)
            );
            border-right: var(
              --a11y-menu-button-focus-border-right,
              var(--a11y-menu-button-border-right, unset)
            );
            border-bottom: var(
              --a11y-menu-button-focus-border-bottom,
              var(--a11y-menu-button-border-bottom, unset)
            );
            border: var(
              --a11y-menu-button-focus-border,
              var(--a11y-menu-button-border, 1px solid #ddd)
            );
            box-shadow: var(
              --a11y-menu-button-box-shadow,
              var(--a11y-menu-button-focus-box-shadow, unset)
            );
          }
          :host([expanded]) absolute-position-behavior {
            width: var(--a11y-menu-button-list-width, unset);
            height: var(--a11y-menu-button-list-height, unset);
            border: var(
              --a11y-menu-button-list-border,
              var(--a11y-menu-button-border, 1px solid #ddd)
            );
            background-color: var(
              --a11y-menu-button-bg-color,
              var(--a11y-menu-button-list-bg-color, white)
            );
            box-shadow: var(--a11y-menu-button-list-box-shadow, unset);
          }
        `]}static get styles(){return[...this.menuButtonCoreStyles,...this.menuButtonThemeStyles]}render(){return e` ${this.buttonTemplate} ${this.menuTemplate} `}static get tag(){return"a11y-menu-button"}static get properties(){return{currentItem:{type:Object},disabled:{attribute:"disabled",type:Boolean},expanded:{attribute:"expanded",type:Boolean,reflect:!0},focused:{attribute:"focused",type:Boolean},hovered:{attribute:"hovered",type:Boolean},keepOpenOnClick:{attribute:"keep-open-on-click",type:Boolean},menuItems:{type:Array},noOpenOnHover:{attribute:"no-open-on-hover",type:Boolean},offset:{type:Number,attribute:"offset"},position:{type:String,attribute:"position",reflect:!0},positionAlign:{type:String,attribute:"position-align",reflect:!0}}}constructor(){super(),this.position="bottom",this.positionAlign="start",this.offset=0,this.expanded=!1,this.menuItems=[],this.keepOpenOnClick=!1,this.noOpenOnHover=!1,[...this.children].filter((t=>"menuitem"===t.slot)).forEach((t=>this.addItem(t))),this.addEventListener("keydown",this._handleKeydown),this.addEventListener("click",this._handleClick),this.addEventListener("focus",this._handleFocus),this.addEventListener("blur",this._handleBlur),this.addEventListener("mouseover",this._handleMouseover),this.addEventListener("mouseout",this._handleMouseout),this.addEventListener("add-a11y-menu-button-item",this._handleAddItem),this.addEventListener("remove-a11y-menu-button-item",this._handleRemoveItem)}get menuTemplate(){return e`
        <absolute-position-behavior
          ?auto="${this.expanded}"
          for="menubutton"
          position="${this.position}"
          position-align="${this.positionAlign}"
          .offset="${this.offset}"
          fit-to-visible-bounds
          part="menu-outer"
        >
          <ul
            id="menu"
            role="menu"
            aria-labelledby="menubutton"
            ?hidden="${!this.expanded}"
            @mousover="${t=>this.hover=!0}"
            @mousout="${t=>this.hover=!1}"
            part="menu"
          >
            ${this.listItemTemplate}
          </ul>
        </absolute-position-behavior>
      `}get buttonTemplate(){return e`
        <button
          id="menubutton"
          aria-haspopup="true"
          aria-controls="menu"
          aria-expanded="${this.expanded?"true":"false"}"
          part="button"
        >
          <slot name="button"></slot>
        </button>
      `}get listItemTemplate(){return e`<slot name="menuitem"></slot><slot></slot>`}get keyCode(){return{TAB:9,RETURN:13,ESC:27,SPACE:32,PAGEUP:33,PAGEDOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40}}close(t=!1){(t||!this.focused&&!this.hovered)&&(this.expanded=!1,this.dispatchEvent(new CustomEvent("close",{bubbles:!0,cancelable:!0,composed:!0,detail:this})))}open(){this.expanded=!0,this.dispatchEvent(new CustomEvent("open",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}focus(){this.shadowRoot&&this.shadowRoot.querySelector("#menubutton")&&this.shadowRoot.querySelector("#menubutton").focus()}focusOn(t){(t=t||this.firstItem)&&(this.open(),this.focused=!0,this.currentItem=t,t.focus())}focusByCharacter(t){t=t.toLowerCase();var e,o,firstChars=(t,e)=>{for(var o=t;o<this.firstChars.length;o++)if(e===this.firstChars[o])return o;return-1};(e=this.menuItems.indexOf(this.currentItem)+1)===this.menuItems.length&&(e=0),-1===(o=firstChars(e,t))&&(o=firstChars(0,t)),o>-1&&this.menuItems[o].focus()}get firstItem(){return this.menuItems[0]}get previousItem(){return this.getItem(-1)}get nextItem(){return this.getItem()}get lastItem(){return this.menuItems[this.menuItems.length-1]}get firstChars(){return this.menuItems.map((t=>((t.textContent||"").trim()||" ").substring(0,1).toLowerCase()))}getItemIndex(){let t=-1;return this.menuItems.forEach(((e,o)=>{e===this.currentItem&&(t=o)})),t}getItem(t=1){let e=this.getItemIndex(this.currentItem)+t;return!this.menuItems||e<0||this.menuItems.length<=e?void 0:this.menuItems[e]}get itemListeners(){return{click:this._handleItemClick,focus:this._handleFocus,blur:this._handleBlur,mouseover:this._handleMouseover,mouseout:this._handleMouseout,keydown:this._handleItemKeydown}}addItem(t){let e=this.itemListeners;this.menuItems=this.menuItems||[],Object.keys(e).forEach((o=>t.addEventListener(o,e[o].bind(this)))),this.menuItems.push(t)}removeItem(t){let e=this.itemListeners;this.menuItems&&(this.menuItems=[...this.menuItems.filter((e=>t!==e))]),Object.keys(e).forEach((o=>t.removeEventListener(o,e[o].bind(this))))}_handleAddItem(t){t.stopPropagation&&t.stopPropagation(),t.detail&&this.addItem(t.detail)}_handleRemoveItem(t){t.stopPropagation(),t.detail&&this.addItem(t.detail)}_handleItemClick(t){this.keepOpenOnClick||(this.focus(),this.close(!0)),this.dispatchEvent(new CustomEvent("item-click",{bubbles:!0,cancelable:!0,composed:!0,detail:t})),t.stopPropagation()}_excludeEvent(t){return!1}_handleItemKeydown(t){let e=!1,o=t.key,isPrintableCharacter=t=>1===t.length&&t.match(/\S/),n=(s(t)||[])[0];if((isPrintableCharacter(o)||!["INPUT","TEXTAREA","SELECT"].includes(n.tagName)&&!this._excludeEvent(t))&&!(t.ctrlKey||t.altKey||t.metaKey||t.keyCode===this.keyCode.SPACE||t.keyCode===this.keyCode.RETURN)){if(t.shiftKey)isPrintableCharacter(o)&&(this.focusByCharacter(o),e=!0),t.keyCode===this.keyCode.TAB&&(this.focus(),this.close(!0));else switch(t.keyCode){case this.keyCode.ESC:this.focus(),this.close(!0),e=!0;break;case this.keyCode.UP:this.focusOn(this.previousItem||this.lastItem),e=!0;break;case this.keyCode.DOWN:this.focusOn(this.nextItem||this.firstItem),e=!0;break;case this.keyCode.HOME:case this.keyCode.PAGEUP:this.currentItem=this.firstItem,e=!0;break;case this.keyCode.END:case this.keyCode.PAGEDOWN:this.currentItem=this.lastItem,e=!0;break;case this.keyCode.TAB:this.focus(),this.close(!0);break;default:isPrintableCharacter(o)&&this.focusByCharacter(o)}e&&(t.stopPropagation(),t.preventDefault())}}_handleKeydown(t){var e=!1;switch(t.keyCode){case this.keyCode.SPACE:case this.keyCode.RETURN:case this.keyCode.DOWN:this.focusOn(this.firstItem),e=!0;break;case this.keyCode.UP:this.popupMenu&&(this.focusOn(this.lastItem),e=!0)}e&&(t.stopPropagation(),t.preventDefault())}_handleClick(t){"touch"===t.pointerType||(this.expanded?this.close(!0):this.focusOn(this.firstItem))}_handleFocus(t){this.focused=!0}_handleBlur(t){this.focused=!1}_handleMouseover(t){this.hovered=!0,this.noOpenOnHover||this.open()}_handleMouseout(t){this.hovered=!1,setTimeout(this.close(),300)}}};class A11yMenuButton extends(A11yMenuButtonBehaviors(t)){}customElements.define(A11yMenuButton.tag,A11yMenuButton);export{A11yMenuButton,A11yMenuButtonBehaviors};