/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import"../../hax-iconset/lib/simple-hax-iconset.js";globalThis.A11yMediaYoutubeManager=globalThis.A11yMediaYoutubeManager||{getIframes:()=>{globalThis.A11yMediaYoutubeManager.queue.forEach((e=>{e.__yt=e._preloadVideo(!0)})),globalThis.A11yMediaYoutubeManager.queue=[]},queue:[]};class A11yMediaYoutube extends e{static get tag(){return"a11y-media-youtube"}static get styles(){return[i`
        iframe .ytp-pause-overlay {
          display: none !important;
        }
      `]}render(){return t`<slot></slot>`}static get properties(){return{...super.properties,id:{type:String},autoplay:{type:Boolean},height:{type:String},loop:{type:Boolean},muted:{type:Boolean},preload:{type:String,attribute:"preload",reflect:!0},playbackRate:{type:Number,attribute:"playback-rate"},t:{type:Number,attribute:"t",reflect:!0},videoId:{type:String,attribute:"video-id",reflect:!0},volume:{type:Number},width:{type:String},__video:{type:Object},__yt:{type:Object}}}constructor(){super(),this.autoplay=!1,this.height="100%",this.loop=!1,this.playbackRate=1,this.preload="metadata",this.muted=!1,this.volume=.7,this.width="100%",this.__video=null,this.__yt=null}static warmConnections(){A11yMediaYoutube.preconnected||(A11yMediaYoutube.addPrefetch("preconnect","https://www.youtube-nocookie.com"),A11yMediaYoutube.addPrefetch("preconnect","https://www.google.com"),A11yMediaYoutube.addPrefetch("preconnect","https://googleads.g.doubleclick.net"),A11yMediaYoutube.addPrefetch("preconnect","https://static.doubleclick.net"),A11yMediaYoutube.preconnected=!0)}static addPrefetch(e,t,i){const a=globalThis.document.createElement("link");a.rel=e,a.href=t,i&&(a.as=i),globalThis.document.head.append(a)}get api(){let e="a11y-media-youtube-api",t=globalThis.document.querySelector(`#${e}`);return t||(t=globalThis.document.createElement("script"),t.setAttribute("id",e),t.setAttribute("src","https://www.youtube.com/iframe_api"),t.setAttribute("type","text/javascript"),globalThis.document.body.appendChild(t)),t}get buffered(){return this.__yt&&this.__yt.buffered&&this.__yt.buffered.length>0?this.__yt.buffered.end(0):-1}get currentTime(){return this.__yt&&this.__yt.getCurrentTime?this.__yt.getCurrentTime():void 0}get duration(){return this.__yt&&this.__yt.getDuration?this.__yt.getDuration():0}get paused(){return!this.__yt||!this.__yt.getPlayerState||1!==this.__yt.getPlayerState()}get seekable(){let e={length:0};return this.duration>0&&(e.length=1,e.start=e=>0,e.end=e=>this.duration),e}init(){globalThis.A11yMediaYoutubeManager.queue.push(this),globalThis.A11yMediaYoutubeManager.api?globalThis.YT&&globalThis.A11yMediaYoutubeManager.getIframes():(globalThis.onYouTubeIframeAPIReady=e=>{globalThis.A11yMediaYoutubeManager.getIframes()},globalThis.A11yMediaYoutubeManager.api=this.api)}updated(e){let t=!1,i=!1,a=!1;e.forEach(((e,s)=>{"muted"===s&&this.setMute(this.muted),"duration"===s&&this.duration>0&&this._handleMediaLoaded(),"loop"===s&&this.setLoop(this.loop),"currentTime"===s&&this.seek(this.currentTime),"playbackRate"===s&&this.setPlaybackRate(this.playbackRate),"volume"===s&&this.setVolume(this.volume),"videoId"===s&&this.videoId&&!this.__yt&&this.init(),["id","height","width","preload"].includes(s)&&this.__yt&&(t=!0),["autoplay","videoId","__video"].includes(s)&&this.__video&&(i=!0),["preload","t"].includes(s)&&("auto"===this.preload||this.t)&&(a=!0)})),t?this.__yt=this._preloadVideo(!0):i&&(this._loadVideo(),a&&this._autoMetadata())}play(){if(this.__yt||(this.__yt=this._preloadVideo(!1)),this.__yt&&this.__yt.playVideo&&this.__video&&this.videoId){this.__playQueued=!0;var e=this.__yt;setTimeout((function(){e.playVideo(),this.__playQueued=!1}),1e3)}}pause(){this.__yt&&this.__yt.pauseVideo&&this.__yt.pauseVideo()}seek(e=0){this.__yt&&this.__yt.seekTo&&this.__yt.seekTo(e,!0)}setLoop(e){this.__yt&&this.__yt.setLoop&&this.media.setLoop(e)}setMute(e){this.__yt&&(e&&this.__yt.mute?this.__yt.mute():this.__yt.unMute&&this.__yt.unMute())}setPlaybackRate(e){this.__yt&&this.__yt.setPlaybackRate&&this.__yt.setPlaybackRate(Number(e))}setVolume(e=.7){this.__yt&&this.__yt.setVolume(100*e)}_getSeconds(e=0){let t=e.replace(/[hm]{1,2}&?/g,":0").replace(/[s]{1,2}$/g,"").split(/:/);return 3600*(t.length>2?parseInt(t[t.length-3]):0)+60*(t.length>1?parseInt(t[t.length-2]):0)+(t.length>0?parseFloat(t[t.length-1]):0)}_handleMediaStateChange(e){this.dispatchEvent(new CustomEvent("mediastatechange",{bubbles:!0,cancelable:!0,composed:!0,detail:e}))}_handleMediaLoaded(e){this.dispatchEvent(new CustomEvent("loadedmetadata",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}_handleTimeupdate(){this.dispatchEvent(new CustomEvent("timeupdate",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}_autoMetadata(){let e=this.t||0,t=this.autoplay;this.setMute(!0),this.__yt.playVideo();let i=12e4,a=setInterval((()=>{i--,(this.duration&&this.duration>0||i<=0)&&(this.pause(),this.setMute(this.muted),clearInterval(a),this.seek(e),t&&this.play())}),1);this.seek(e)}_loadVideo(e=this.preload){this.videoId&&this.__video.cueVideoById({videoId:this.videoId})}_preloadVideo(e=!1){let t=this,i=(!e||"none"!==this.preload)&&this.videoId&&!this.__video,a=globalThis.document.createElement("div"),s=`container-${this.id}`,o=null;if(globalThis.document.body.appendChild(a),a.setAttribute("id",s),i){A11yMediaYoutube.addPrefetch("preload",`https://img.youtube.com/vi/${this.videoId.replace(/[\?&].*/,"")}/hqdefault.jpg`,"image");let setYT=e=>this.__video=e.target,e=globalThis.location.port?`:${globalThis.location.port}`:"",i=`${globalThis.location.protocol}//${globalThis.location.hostname}${e}`;o=new YT.Player(s,{width:t.width,height:t.height,events:{onReady:setYT},playerVars:{color:"white",controls:0,autoplay:t.autoplay,disablekb:1,enablejsapi:1,origin:i,iv_load_policy:3,modestbranding:1,rel:0,widget_referrer:globalThis.location.href}}),o.timeupdate,o.addEventListener("onStateChange",(e=>{t.paused?clearInterval(o.timeupdate):o.timeupdate=setInterval((()=>t._handleTimeupdate()),1),this._handleMediaStateChange(e)})),this.innerHTML="",this.appendChild(o.getIframe()),a.remove()}return o}_removeIframe(){if(this.__yt){this.__yt.remove;try{this.__yt.destroy()}catch(e){console.warn(e)}}this.innerHTML=""}connectedCallback(){super.connectedCallback(),A11yMediaYoutube.warmConnections()}disconnectedCallback(){this._removeIframe(),super.disconnectedCallback()}}customElements.define(A11yMediaYoutube.tag,A11yMediaYoutube);export{A11yMediaYoutube};