/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as a}from"../../../lit/index.js";import"../../simple-search/lib/simple-search-content.js";class A11yMediaTranscriptCue extends t{static get properties(){return{...super.properties,active:{attribute:"active",type:Boolean,reflect:!0},disabled:{attribute:"disabled",type:Boolean,reflect:!0},end:{type:String},hideTimestamps:{attribute:"hide-timestamps",type:Boolean,reflect:!0},start:{type:String}}}static get tag(){return"a11y-media-transcript-cue"}constructor(){super(),this.active=!1,this.disabled=!1,this.hideTimestamps=!1,this.start="",this.end=""}static get styles(){return[a`
        :host {
          cursor: default;
          display: table-row;
          width: 100%;
          color: var(--a11y-media-transcript-cue-color);
          background-color: var(--a11y-media-transcript-cue-bg-color);
          transition:
            color 0.25s,
            background-color 0.25s;
          --simple-search-match-text-color: var(
            --a11y-media-transcript-match-color
          );
          --simple-search-match-bg-color: var(
            --a11y-media-transcript-match-bg-color
          );
          --simple-search-match-border-color: var(
            --a11y-media-transcript-match-border-color
          );
          --simple-search-match-border: none;
          --simple-search-match-border-radius: 4px;
          --simple-search-match-font-weight: normal;
        }
        :host([hide-timestamps]) {
          display: inline;
        }
        :host(:not([active]):not([disabled]):active),
        :host(:not([active]):not([disabled]):focus),
        :host(:not([active]):not([disabled]):hover) {
          cursor: pointer;
          color: var(--a11y-media-transcript-focused-cue-color);
          background-color: var(--a11y-media-transcript-focused-cue-bg-color);
          outline: 1px dotted var(--a11y-media-transcript-focused-cue-color);
        }
        :host([active]) {
          color: var(--a11y-media-transcript-active-cue-color);
          background-color: var(--a11y-media-transcript-active-cue-bg-color);
        }
        #text {
          display: table-cell;
          width: 100%;
          line-height: 200%;
        }
        :host([hide-timestamps]) #text {
          display: inline;
        }
        #time {
          display: table-cell;
          font-size: 80%;
          padding: 0 16px 0 0;
          white-space: nowrap;
          font-family: monospace;
        }
        :host([hide-timestamps]) #time {
          display: none;
        }
        @media print {
          :host,
          :host([active]),
          :host(:not([active]):not([disabled]):active),
          :host(:not([active]):not([disabled]):focus),
          :host(:not([active]):not([disabled]):hover) {
            color: #000000;
            background-color: #ffffff;
          }
        }
      `]}render(){return e`
      <span id="time"> ${this.start} - ${this.end} </span>
      <span id="text">
        <slot></slot>
      </span>
    `}updated(t){t.forEach(((t,e)=>{"active"===e&&this.active&&this.dispatchEvent(new CustomEvent("active-changed",{detail:{element:this,oldValue:t,value:this.active}}))}))}}customElements.define(A11yMediaTranscriptCue.tag,A11yMediaTranscriptCue);export{A11yMediaTranscriptCue};