/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as o,css as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";class A11yMediaButton extends t{static get properties(){return{accentColor:{attribute:"accent-color",type:String},dark:{type:Boolean},action:{attribute:"action",reflect:!0,type:String},controls:{attribute:"controls",reflect:!0,type:String},icon:{attribute:"icon",type:String},label:{attribute:"label",type:String},toggle:{attribute:"toggle",type:Boolean,reflect:!0},disabled:{attribute:"disabled",type:Boolean},tooltipPosition:{attribute:"tooltip-position",type:String}}}static get tag(){return"a11y-media-button"}constructor(){super(),this.accentColor="red",this.dark=!1,this.controls="video",this.disabled=!1,this.toggle=!1,this.tooltipPosition="bottom",import("../../simple-tooltip/simple-tooltip.js")}static get styles(){return[this.buttonStyles,i`
        :host {
          margin: 0;
          padding: 0;
        }
        #button {
          margin: 0;
          padding: 8px;
          line-height: 1;
          border: none;
          transition: color 0.25s;
          color: var(--a11y-media-button-color);
          background-color: var(--a11y-media-button-bg-color);
        }
        :host([toggle]) #button {
          color: var(--a11y-media-button-toggle-color);
          background-color: var(--a11y-media-button-toggle-bg-color);
        }
        :host([toggle]:active) #button,
        :host([toggle]:focus) #button,
        :host([toggle]:hover) #button,
        :host(:active) #button,
        :host(:focus) #button,
        :host(:hover) #button {
          color: var(--a11y-media-button-hover-color);
          background-color: var(--a11y-media-button-hover-bg-color);
        }
        :host([disabled]) #button {
          color: var(--a11y-media-button-disabled-color);
          cursor: not-allowed;
        }
        .sr-only {
          position: absolute;
          left: -99999;
          top: 0;
          height: 0;
          width: 0;
          overflow: hidden;
        }
        simple-tooltip {
          z-index: 100;
        }
        simple-tooltip:not(:defined) {
          display: none;
        }
        simple-icon-lite {
          display: inline-block;
        }
      `]}static get buttonStyles(){return[i`
        #button {
          margin: 0;
          border: none;
        }
        .sr-only {
          position: absolute;
          left: -99999;
          top: 0;
          height: 0;
          width: 0;
          overflow: hidden;
        }
        simple-tooltip {
          z-index: 100;
        }
        simple-tooltip:not(:defined) {
          display: none;
        }
      `]}render(){return o`
      <button
        id="button"
        aria-label="${this.label}"
        aria-pressed="${this.toggle?"true":"false"}"
        controls="${this.controls}"
        tabindex="0"
        @click="${this._buttonClick}"
        ?disabled="${this.disabled}"
        ?toggle="${this.toggle}"
      >
        <simple-icon-lite icon="${this.icon}"></simple-icon-lite>
      </button>
      ${this.label?o`
            <simple-tooltip for="button" position="${this.tooltipPosition}"
              >${this.label}</simple-tooltip
            >
          `:""}
    `}_buttonClick(t){this.dispatchEvent(new CustomEvent("button-click",{detail:this}))}}customElements.define(A11yMediaButton.tag,A11yMediaButton);export{A11yMediaButton};