/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import{DDD as s}from"../d-d-d/d-d-d.js";import{FullscreenBehaviors as o}from"../fullscreen-behaviors/fullscreen-behaviors.js";import"../anchor-behaviors/anchor-behaviors.js";import"../responsive-utility/responsive-utility.js";import{normalizeEventPath as l}from"../utils/utils.js";import"../absolute-position-behavior/absolute-position-behavior.js";import"../simple-tooltip/simple-tooltip.js";import"../simple-search/simple-search.js";import"../simple-range-input/simple-range-input.js";import"../simple-fields/lib/simple-fields-field.js";import"./lib/a11y-media-play-button.js";import"./lib/a11y-media-state-manager.js";import"./lib/a11y-media-button.js";import"./lib/a11y-media-transcript-cue.js";import"./lib/a11y-media-youtube.js";class A11yMediaPlayer extends(o(s)){static get styles(){return[super.styles,i`
        :host {
          display: block;
          overflow: hidden;
          width: calc(100% - 2px);
          font-family: var(--ddd-font-navigation);
          --a11y-media-controls-font-family: var(--ddd-font-navigation);
          --a11y-media-player-height: unset;
          --a11y-media-color: var(
            --simple-colors-default-theme-grey-11,
            #111111
          );
          --a11y-media-bg-color: var(
            --simple-colors-default-theme-grey-2,
            #eeeeee
          );
          --a11y-media-border-color: var(
            --simple-colors-default-theme-grey-3,
            #dddddd
          );
          --a11y-media-hover-color: var(
            --simple-colors-default-theme-grey-12,
            #000000
          );
          --a11y-media-hover-bg-color: var(
            --simple-colors-default-theme-grey-2,
            #eeeeee
          );
          --a11y-media-accent-color: var(
            --simple-colors-default-theme-accent-9,
            #333333
          );
          --a11y-media-faded-accent-color: var(
            --simple-colors-default-theme-accent-8,
            #444444
          );
          --a11y-media-disabled-color: var(
            --simple-colors-default-theme-grey-5,
            #bbbbbb
          );
          border: 1px solid
            var(
              --a11y-media-border-color,
              var(--simple-colors-default-theme-grey-3)
            );

          --a11y-media-settings-menu-color: var(--a11y-media-color);
          --a11y-media-settings-menu-bg-color: var(--a11y-media-bg-color);
          --a11y-media-settings-menu-hover-color: var(--a11y-media-hover-color);
          --a11y-media-settings-menu-hover-bg-color: var(
            --a11y-media-hover-bg-color
          );
          --simple-fields-accent-color: var(--a11y-media-accent-color);
          --simple-fields-background-color: var(--a11y-media-bg-color);
          --simple-fields-color: var(--a11y-media-color);
          --simple-fields-border-color: var(--a11y-media-border-color);
          --simple-fields-border-color-light: var(
            --a11y-media-border-color-light,
            var(--a11y-media-border-color)
          );

          --a11y-media-button-color: var(--a11y-media-color);
          --a11y-media-button-bg-color: var(--a11y-media-bg-color);
          --a11y-media-button-hover-color: var(--a11y-media-accent-color);
          --a11y-media-button-hover-bg-color: var(--a11y-media-hover-bg-color);
          --a11y-media-button-disabled-color: var(--a11y-media-disabled-color);
          --a11y-media-button-toggle-color: var(
            --a11y-media-faded-accent-color
          );

          --simple-range-input-bg: var(--a11y-media-accent-color);
          --simple-range-input-color: var(--a11y-media-color);
          --simple-range-input-track-height: 4px;
          --simple-range-input-pin-height: 10px;

          --simple-toast-color: var(--a11y-media-color);
          --simple-toast-background-color: var(--a11y-media-bg-color);

          --a11y-media-transcript-color: var(
            --simple-colors-default-theme-grey-7,
            #666666
          );
          --a11y-media-transcript-bg-color: var(
            --simple-colors-default-theme-grey-1,
            #ffffff
          );
          --a11y-media-transcript-accent-color: var(
            --simple-colors-default-theme-accent-8,
            #444444
          );
          --a11y-media-transcript-faded-accent-color: var(
            --simple-colors-default-theme-accent-10,
            #222222
          );
          --a11y-media-transcript-cue-color: var(
            --simple-colors-fixed-theme-grey-12,
            #000000
          );
          --a11y-media-transcript-cue-bg-color: var(
            --simple-colors-fixed-theme-grey-1,
            #ffffff
          );
          --a11y-media-transcript-active-cue-color: var(
            --simple-colors-fixed-theme-grey-12,
            #000000
          );
          --a11y-media-transcript-active-cue-bg-color: var(
            --simple-colors-fixed-theme-accent-1,
            #ffffff
          );
          --a11y-media-transcript-focused-cue-color: var(
            --simple-colors-fixed-theme-grey-12,
            #000000
          );
          --a11y-media-transcript-focused-cue-bg-color: var(
            --simple-colors-fixed-theme-grey-2,
            #eeeeee
          );
          --a11y-media-transcript-match-color: var(
            --simple-colors-fixed-theme-grey-1,
            #ffffff
          );
          --a11y-media-transcript-match-bg-color: var(
            --simple-colors-fixed-theme-accent-10,
            #222222
          );
          --a11y-media-transcript-match-border-color: var(
            --simple-colors-fixed-theme-accent-12,
            #000000
          );
        }

        :host([dark]) {
          border: 1px solid var(--simple-colors-default-theme-grey-1, #000000);
        }

        :host([dark-transcript]) {
          --a11y-media-transcript-bg-color: var(
            --simple-colors-dark-theme-grey-1,
            #000000
          );
          --a11y-media-transcript-cue-color: var(
            --simple-colors-dark-theme-grey-12,
            #ffffff
          );
          --a11y-media-transcript-cue-bg-color: var(
            --simple-colors-dark-theme-grey-1,
            #000000
          );
          --a11y-media-transcript-active-cue-color: var(
            --simple-colors-dark-theme-accent-10,
            #dddddd
          );
          --a11y-media-transcript-active-cue-bg-color: var(
            --simple-colors-dark-theme-grey-1,
            #000000
          );
          --a11y-media-transcript-match-color: var(
            --simple-colors-dark-theme-grey-1,
            #000000
          );
          --a11y-media-transcript-match-bg-color: var(
            --simple-colors-dark-theme-accent-10,
            #dddddd
          );
          --a11y-media-transcript-match-border-color: var(
            --simple-colors-dark-theme-accent-12,
            #ffffff
          );
          --a11y-media-transcript-focused-cue-color: var(
            --simple-colors-dark-theme-grey-12,
            #ffffff
          );
          --a11y-media-transcript-focused-cue-bg-color: var(
            --simple-colors-dark-theme-grey-2,
            #111111
          );
        }

        :host *::-webkit-scrollbar {
          width: var(--a11y-media-scrollbar-width, 5px);
        }

        :host([hidden]),
        *[hidden] {
          display: none !important;
        }

        :host([height]) {
          height: calc(var(--a11y-media-player-height) - 2px);
          max-height: calc(var(--a11y-media-player-height) - 2px);
          overflow: unset;
        }

        :host([height]) #player-section {
          max-height: var(--a11y-media-player-height);
        }

        :host([height]) #player-and-controls {
          max-height: calc(100% - 32px - 44px);
        }

        :host([height]) #player {
          height: calc(100% - 32px - 44px);
          padding-top: unset;
        }

        :host,
        #player-section {
          color: var(--a11y-media-hover-color);
          background-color: var(--a11y-media-bg-color);
        }

        :host > * {
          transition: all 0.5s;
        }

        :host,
        #player-section,
        #player,
        #transcript-section,
        #transcript-and-controls {
          display: flex;
          flex-flow: column;
          align-items: stretch;
          align-content: stretch;
        }

        #captionlink:link {
          text-decoration: none;
        }

        #player-and-controls,
        #player,
        #player > *,
        #cc-custom,
        #cc-text,
        #slider,
        #controls,
        #player-section,
        #transcript-section,
        #transcript-and-controls {
          width: 100%;
        }

        #transcript-and-controls > * {
          width: calc(100% - 1px);
        }

        :host > *,
        #player-and-controls,
        #player,
        #player > *,
        #cc-text {
          flex: 1 1 auto;
        }

        #controls,
        #searchbar {
          flex: 0 0 44px;
        }

        #player-and-controls {
          margin: 0 auto;
          display: flex;
        }

        #player {
          height: 400px;
          position: relative;
          background-size: cover;
          background-position: center;
        }

        #player > * {
          position: absolute;
          top: 0;
          left: 0;
          height: 100%;
        }

        #playbutton,
        #slider,
        #controls {
          z-index: 2;
        }

        #html5 {
          min-width: 100px;
          display: flex;
          align-items: stretch;
        }

        :host([audio-only]) #playbutton {
          opacity: 0;
        }

        #slider {
          flex: 0 0 32px;
          height: 32px;
          background-color: var(--a11y-media-bg-color);
          --simple-range-input-pin-height: 15px;
        }

        a11y-media-youtube {
          opacity: 1;
          transition: opacity 0.5s;
        }

        a11y-media-youtube.hidden {
          opacity: 0;
        }

        #cc-custom:not([hidden]) {
          font-size: 20px;
          transition: font-size 0.25s;
          display: flex;
        }

        #cc-text {
          align-self: flex-end;
          font-family: sans-serif;
          color: white;
          margin: 4px 10px;
          padding: 0.15em 4px;
          background-color: black;
          background-color: rgba(0, 0, 0, 0.8);
          transition: all 0.5s;
        }

        #player-and-controls[audio-no-thumb] #cc-text {
          align-self: center;
          color: var(--a11y-media-color);
          background-color: transparent;
        }

        #controls {
          display: block;
          width: 100%;
          max-width: 100%;
          height: 44px;
          max-height: 44px;
          position: relative;
          color: var(--a11y-media-color);
          background-color: var(--a11y-media-bg-color);
          --primary-text-color: var(--a11y-media-settings-menu-color);
        }

        #controls-left {
          position: absolute;
          left: 0;
          min-width: 200px;
        }

        #controls-right {
          position: absolute;
          right: 0;
          top: 0;
        }

        absolute-position-behavior {
          background-color: var(--a11y-media-settings-menu-bg-color);
          color: var(--a11y-media-settings-menu-color);
          border: 1px solid
            var(
              --a11y-media-border-color,
              var(--simple-colors-default-theme-grey-3)
            );
          max-height: 200px;
          overflow-y: scroll;
          overflow-x: hidden;
        }

        absolute-position-behavior::-webkit-scrollbar-track {
          background-color: var(--a11y-media-settings-menu-bg-color);
        }

        absolute-position-behavior::-webkit-scrollbar-thumb {
          background-color: var(--a11y-media-settings-menu-color);
        }

        absolute-position-behavior .setting {
          min-height: 42px;
          padding: 2px 10px;
          display: flex;
          justify-content: space-between;
          align-items: center;
        }

        absolute-position-behavior simple-field-field {
          margin-top: 0 !important;
          margin-bottom: 0 !important;
          background-color: var(--a11y-media-settings-menu-bg-color);
          color: var(--a11y-media-settings-menu-color);
        }

        .setting-text {
          margin-right: 1em;
          font-family: var(--a11y-media-controls-font-family);
        }

        .setting-control {
          max-width: 110px;
        }

        .setting-slider {
          flex: 0 0 110px;
          margin-left: -15px;
          margin-right: -15px;
        }

        #loop {
          flex: 0 0 40px;
        }

        #loop-label {
          flex: 1 1 auto;
        }

        .play-status {
          border: none;
          position: relative;
          font-size: 85%;
          font-family: var(--a11y-media-controls-font-family);
        }

        .play-status.control-bar {
          padding: 8px 13px 8px;
        }

        :host([hide-play-status]) .play-status {
          display: none;
        }

        #volume-and-mute {
          display: inline-block;
          position: relative;
        }

        #volume {
          position: absolute;
          left: 30px;
          top: 0px;
          width: 0;
          height: 40px;
          overflow: hidden;
          transition: width 0.5s;
          z-index: 3;
          border-radius: 4px;
          background-color: var(--a11y-media-bg-color);
        }

        #volume:active,
        #volume:focus,
        #volume:hover,
        #volume.focus,
        #volume-and-mute:active #volume,
        #volume-and-mute:focus #volume,
        #volume-and-mute:hover #volume {
          overflow: visible;
          width: 100px;
        }

        :host([responsive-size="xs"]) #volume:active,
        :host([responsive-size="xs"]) #volume:focus,
        :host([responsive-size="xs"]) #volume:hover,
        :host([responsive-size="xs"]) #volume.focus,
        :host([responsive-size="xs"]) #volume-and-mute:active #volume,
        :host([responsive-size="xs"]) #volume-and-mute:focus #volume,
        :host([responsive-size="xs"]) #volume-and-mute:hover #volume,
        :host([width]) #volume:active,
        :host([width]) #volume:focus,
        :host([width]) #volume:hover,
        :host([width]) #volume.focus,
        :host([width]) #volume-and-mute:active #volume,
        :host([width]) #volume-and-mute:focus #volume,
        :host([width]) #volume-and-mute:hover #volume {
          top: 0px;
        }

        #print-thumbnail {
          width: 100%;
          margin: 0;
          display: block;
          border-top: 1px solid #aaaaaa;
        }

        .media-caption:not(:empty) {
          padding: var(--ddd-spacing-2) var(--ddd-spacing-4);
          font-size: var(--ddd-font-size-xs);
          font-weight: bold;
        }

        .media-type {
          font-style: italic;
        }

        #searchbar {
          display: flex;
          align-items: stretch;
          justify-content: space-between;
          height: 44px;
          max-height: 44px;
          min-height: 44px;
          width: 100%;
          color: var(--a11y-media-color);
          background-color: var(--a11y-media-transcript-bg-color);
          --simple-fields-color: var(--a11y-media-color);
          --a11y-media-button-bg-color: var(--a11y-media-transcript-bg-color);
          --a11y-media-button-hover-bg-color: var(
            --a11y-media-transcript-bg-color
          );
          --simple-search-input-background-color: var(
            --a11y-media-transcript-bg-color
          );
          --simple-search-input-text-color: var(--a11y-media-color);
          --simple-search-input-line-color: var(--a11y-media-accent-color);
          --simple-search-input-placeholder-color: var(--a11y-media-color);
          --simple-search-button-color: var(--a11y-media-accent-color);
          --simple-search-button-hover-color: var(
            --a11y-media-faded-accent-color
          );
          --simple-search-button-bg-color: var(
            --a11y-media-transcript-bg-color
          );
          --simple-search-button-border-color: var(
            --a11y-media-transcript-bg-color
          );
          --simple-search-button-hover-border-color: var(
            --a11y-media-transcript-bg-color
          );
          --simple-search-button-disabled-color: var(
            --a11y-media-disabled-color
          );
          --simple-search-button-disabled-bg-color: var(
            --a11y-media-transcript-bg-color
          );
          --simple-search-button-disabled-border-color: var(
            --a11y-media-border-color
          );
          --simple-search-padding: 0 15px;
        }

        :host([dark]) #searchbar {
          background-color: var(--a11y-media-bg-color);
          --a11y-media-button-bg-color: var(--a11y-media-bg-color);
          --a11y-media-button-hover-bg-color: var(--a11y-media-bg-color);
          --simple-search-input-background-color: var(--a11y-media-bg-color);
          --simple-search-button-bg-color: var(--a11y-media-bg-color);
          --simple-search-button-border-color: var(--a11y-media-bg-color);
          --simple-search-button-hover-border-color: var(--a11y-media-bg-color);
          --simple-search-button-disabled-bg-color: var(--a11y-media-bg-color);
        }

        #searching {
          flex-grow: 2;
        }

        #autoscroll {
          padding-right: 8px;
        }

        #scrolling,
        #printing {
          display: flex;
          align-items: center;
        }

        #transcript-section {
          padding: 0 1px 0 0;
        }

        #transcript-and-controls {
          flex: 1 0 194px;
        }

        #transcript {
          flex: 1 0 150px;
          max-height: var(--a11y-media-transcript-max-height, unset);
          overflow-y: scroll;
          color: var(--a11y-media-transcript-cue-color);
          background-color: var(--a11y-media-transcript-cue-bg-color);
          border-left: 1px solid var(--a11y-media-transcript-bg-color);
        }

        #transcript::-webkit-scrollbar-track {
          background-color: var(--a11y-media-transcript-cue-bg-color);
        }

        #transcript::-webkit-scrollbar-thumb {
          background-color: var(--a11y-media-transcript-cue-color);
        }

        .transcript-from-track {
          display: table;
          width: calc(100% - 30px);
          padding: 0 15px 15px;
          color: var(--a11y-media-transcript-cue-color);
          background-color: var(--a11y-media-transcript-cue-bg-color);
          font-size: var(--a11y-media-transcript-cue-font-size, 14px);
          line-height: var(--a11y-media-transcript-cue-line-height, 28px);
        }

        .transcript-from-track[hideTimestamps] {
          display: block;
        }

        .sr-only {
          position: absolute;
          left: -9999px;
          font-size: 0;
          height: 0;
          width: 0;
          overflow: hidden;
        }

        absolute-position-behavior:not(:defined),
        simple-tooltip:not(:defined) {
          display: none;
        }

        ::slotted(iframe) {
          display: none;
        }
        @media screen {
          :host([full-flex]) {
            flex-flow: row;
            padding: 0;
          }

          :host([full-flex]) #player-section {
            max-width: 50%;
            flex: 1 0 auto;
          }

          :host([full-flex]) #transcript-section {
            min-width: 50%;
            flex: 0 1 auto;
          }

          :host([full-flex]) #transcript {
            position: absolute;
            top: 44px;
            left: 0;
            right: 0;
            bottom: 0;
            overflow-y: scroll;
          }

          #transcript-and-controls {
            position: relative;
          }

          :host([sticky-mode]) #player-section {
            position: fixed;
            top: 5px;
            right: 5px;
            width: 200px;
            max-width: 200px;
            z-index: 999999;
            border: 1px solid var(--a11y-media-bg-color);
            box-shadow: 1px 1px 20px 1px rgba(125, 125, 125);
            border-radius: 3.2px;
          }

          :host([fullscreen]) #player-section {
            width: 100%;
            height: 100vh;
            max-width: 100vw;
            position: absolute;
            position: sticky;
            left: 0;
            top: 0;
            z-index: 100000;
            transition: all 0.5s;
          }

          :host([dark][sticky-mode]) #player-section {
            border: 1px solid var(--a11y-media-bg-color);
          }

          :host([sticky][sticky-corner="top-left"]) #player-section {
            right: unset;
            left: 5px;
          }

          :host(
              :not([no-height]):not([stacked-layout]):not(
                  [responsive-size="xs"]
                ):not([responsive-size="sm"])
            )
            #player-and-controls.totop {
            position: absolute;
            top: 0;
            left: 0;
            width: 200px !important;
            z-index: 9999;
          }

          :host([sticky][sticky-corner="bottom-left"]) #player-and-controls {
            top: unset;
            right: unset;
            bottom: 5px;
          }

          :host([sticky][sticky-corner="bottom-right"]) #player-and-controls {
            top: unset;
            bottom: 5px;
          }

          :host([sticky-mode]) .screen-only.media-caption,
          :host([responsive-size="xs"]) .screen-only.media-caption {
            display: none;
          }

          :host([sticky-mode]) #player-and-controls[audio-no-thumb] {
            max-height: 0px;
            overflow: hidden;
          }

          :host([sticky-mode]) .hide-sticky,
          :host([sticky-mode]) .hide-full-xs,
          :host([sticky-mode]) .hide-full-sm,
          :host([sticky-mode]) .hide-flex,
          :host([width]) .hide-full-xs,
          :host([width]) .hide-full-sm,
          :host([width]) .hide-full-flex,
          :host([responsive-size="xs"]) .hide-full-xs,
          :host([responsive-size="xs"]) .hide-full-sm,
          :host([responsive-size="xs"]) .hide-full-flex,
          :host([responsive-size="sm"]) .hide-full-sm,
          :host([responsive-size="sm"]) .hide-full-flex,
          :host([flex-layout]) .hide-flex {
            display: none;
          }

          :host([responsive-size="xl"]) #cc-custom {
            font-size: 16px;
          }

          :host([responsive-size="lg"]) #cc-custom,
          :host([flex-layout][responsive-size="xl"]) #cc-custom {
            font-size: 14px;
          }

          :host([responsive-size="md"]) #cc-custom,
          :host([flex-layout][responsive-size="lg"]) #cc-custom {
            font-size: 12px;
          }

          :host([responsive-size="xs"]) #cc-custom,
          :host([width]) #cc-custom,
          :host([flex-layout][responsive-size="md"]) #cc-custom,
          :host([flex-layout][responsive-size="sm"]) #cc-custom {
            font-size: 10px;
          }

          :host([sticky-mode]) #cc-custom,
          :host([flex-layout][width]) #cc-custom,
          :host([flex-layout][responsive-size="xs"]) #cc-custom {
            display: none;
          }

          .media-caption {
            color: var(--a11y-media-caption-color, var(--a11y-media-bg-color));
            background-color: var(--a11y-media-accent-color);
          }

          #audio-only {
            text-align: center;
            font-style: italic;
            width: 100%;
            line-height: 160%;
          }

          #print-thumbnail,
          .print-only {
            width: 0;
            display: none;
          }
        }

        @media print {
          :host,
          :host([dark]) {
            outline: 1px solid #aaaaaa;
            background-color: #ffffff;
          }

          .screen-only,
          #searchbar,
          #print-thumbnail:not([src]),
          :host(:not([thumbnail-src])) #player {
            display: none;
          }

          .media-caption {
            background-color: #cccccc;
            color: #000000;
            font-size: 120%;
          }

          #transcript {
            padding: 0 15px 5px;
            color: #000;
            background-color: #ffffff;
            border-top: 1px solid #aaa;
          }
        }
      `]}render(){return e` <div class="sr-only" ?hidden="${!this.mediaCaption}">
        ${this.mediaCaption}
      </div>
      <div id="player-section">
        <div
          id="player-and-controls"
          .style="${this.mediaMaxWidth}"
          ?audio-no-thumb="${this.audioNoThumb}"
        >
          <div id="player" .style="${this.playerStyle}">
            <a11y-media-play-button
              id="playbutton"
              action="${this.__playing?"pause":"play"}"
              label="${this._getLocal(this.localization,this.__playing?"pause":"play","label")}"
              @button-click="${this.togglePlay}"
              ?audio-only="${this.audioOnly}"
              ?disabled="${this.audioNoThumb}"
              youtube-id="${this.youtubeId}"
            >
            </a11y-media-play-button>
            <div id="html5">
              <slot></slot>
            </div>
            ${this.videoId&&this.__playerReady?e`
                  <a11y-media-youtube
                    id="youtube-${this.id}"
                    class="${this.__currentTime>.3||this.__seeking?"":"hidden"}"
                    lang="${this.mediaLang}"
                    preload="${this.t?"auto":this.preload}"
                    .t="${this.t}"
                    video-id="${this.videoId}"
                    playback-rate="${this.playbackRate}"
                    @timeupdate="${this._handleTimeUpdate}"
                    ?hidden=${!this.isYoutube}
                  >
                  </a11y-media-youtube>
                `:""}
            ${0!==Object.keys(this.captionCues||[]).length&&this.showCustomCaptions?e`
                  <div id="cc-custom" aria-live="polite" class="screen-only">
                    <div id="cc-text">
                      ${this.captionCues?Object.keys(this.captionCues).map((t=>e`${this.captionCues[t].text?this.captionCues[t].text:""}`)):""}
                    </div>
                  </div>
                `:e``}
          </div>
        </div>
        <div id="progresslabel" class="sr-only">
          ${this._getLocal(this.localization,"seekSlider","label")}
        </div>
        <simple-range-input
          id="slider"
          class="screen-only"
          aria-labelledby="progresslabel"
          min="0"
          .max="${this.duration}"
          step="1"
          @value-changed="${this._handleSliderChanged}"
          @immediate-value-changed="${this._handleSliderDragging}"
          .value="${this.__currentTime}"
          ?disabled="${this.disableSeek}"
        >
        </simple-range-input>
        <div id="controls" controls="innerplayer">
          <div id="controls-left">
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              icon="${this._getLocal(this.localization,this.__playing?"pause":"play","icon")}"
              label="${this._getLocal(this.localization,this.__playing?"pause":"play","label")}"
              @click="${this.togglePlay}"
            ></a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              class="hide-flex hide-full-xs"
              icon="${this._getLocal(this.localization,"rewind","icon")}"
              label="${this._getLocal(this.localization,"rewind","label")}"
              ?disabled="${this.disableSeek||this.currentTime<=0}"
              ?hidden="${this.disableSeek}"
              @click="${t=>{this.rewind()}}"
            ></a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              class="hide-flex hide-full-xs"
              icon="${this._getLocal(this.localization,"forward","icon")}"
              label="${this._getLocal(this.localization,"forward","label")}"
              ?disabled="${this.disableSeek||this.currentTime>=this.duration}"
              ?hidden="${this.disableSeek}"
              @click="${t=>{this.forward()}}"
            ></a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              class="hide-flex"
              icon="${this._getLocal(this.localization,"restart","icon")}"
              label="${this._getLocal(this.localization,"restart","label")}"
              ?disabled="${this.disableSeek}"
              ?hidden="${"xs"===this.responsiveSize||"sm"===this.responsiveSize||this.disableSeek}"
              @click="${this.restart}"
            ></a11y-media-button>
            <div
              id="volume-and-mute"
              @focus="${t=>this.__volumeSlider=!0}"
              @blur="${t=>this.__volumeSlider=!1}"
            >
              <a11y-media-button
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                id="mute"
                icon="${this._getLocal(this.localization,this.muted?"unmute":"mute","icon")}"
                label="${this._getLocal(this.localization,this.muted?"unmute":"mute","label")}"
                @click="${t=>{this.toggleMute()}}"
              ></a11y-media-button>
              <simple-range-input
                id="volume"
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                aria-labelledby="volume-slider-label"
                label="${this._getLocal(this.localization,"volume","label")}"
                min="0"
                max="100"
                pin
                step="10"
                value="${this.muted?0:this.volume}"
                @value-changed="${this._handleVolumeChanged}"
                ?hidden="${"xs"===this.responsiveSize}"
              ></simple-range-input>
            </div>
            <span
              aria-live="polite"
              class="play-status control-bar hide-full-xs"
            >
              <span id="statbar">${this.status}</span>
            </span>
          </div>
          <div id="controls-right">
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              icon="${this._getLocal(this.localization,"captions","icon")}"
              label="${this._getLocal(this.localization,"captions","label")}"
              ?disabled="${!this.hasCaptions}"
              ?hidden="${!this.hasCaptions}"
              ?toggle="${this.captionsTrackKey>-1}"
              @click="${t=>this.toggleCC()}"
            >
            </a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              class="hide-full-xs"
              controls="transcript"
              icon="${this._getLocal(this.localization,"transcript","icon")}"
              label="${this._getLocal(this.localization,"transcript","label")}"
              ?disabled="${!this.hasCaptions||this.learningMode}"
              ?hidden="${!this.hasCaptions||this.standAlone||this.height&&this.responsiveSize.indexOf("s")>-1||this.learningMode}"
              ?toggle="${this.transcriptTrackKey>-1}"
              @click="${t=>this.toggleTranscript()}"
            >
            </a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              class="hide-full-sm"
              icon="${this._getLocal(this.localization,"copyLink","icon")}"
              label="${this._getLocal(this.localization,"copyLink","label")}"
              ?disabled="${!this.linkable||this.learningMode}"
              ?hidden="${!this.linkable||this.learningMode}"
              @click="${this._handleCopyLink}"
            ></a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              icon="${this._getLocal(this.localization,"fullscreen","icon")}"
              label="${this._getLocal(this.localization,"fullscreen","label")}"
              ?hidden="${this.audioNoThumb||!this.fullscreenButton}"
              ?toggle="${this.fullscreen}"
              @click="${t=>this.toggleFullscreen()}"
            >
            </a11y-media-button>
            <a11y-media-button
              accent-color="${this.accentColor}"
              ?dark="${this.dark}"
              id="settings-button"
              class="hide-sticky"
              controls="settings"
              icon="${this._getLocal(this.localization,"settings","icon")}"
              label="${this._getLocal(this.localization,"settings","label")}"
              @click="${t=>this.toggleSettings()}"
            ></a11y-media-button>
            ${this.isYoutube?e` <a11y-media-button
                  accent-color="${this.accentColor}"
                  ?dark="${this.dark}"
                  class="hide-sticky"
                  icon="mdi-social:youtube"
                  label="Open on YouTube"
                  ?hidden="${this.learningMode||this.hideYoutubeLink}"
                  @click="${this.goToYoutube}"
                ></a11y-media-button>`:""}
          </div>
          <absolute-position-behavior
            id="settings"
            auto
            fit-to-visible-bounds
            for="settings-button"
            offset="10"
            position-align="end"
            position="top"
            ?hidden="${!this.__settingsOpen}"
          >
            <div class="setting" ?hidden="${!this.hasCaptions}">
              <div class="setting-text">
                ${this._getLocal(this.localization,"captions","label")}
              </div>
              <simple-fields-field
                id="cc_tracks"
                class="setting-control"
                value="${this.captionsTrackKey}"
                .options="${this.captionsPicker}"
                ?hidden="${!this.hasCaptions}"
                ?disabled="${!this.hasCaptions}"
                @value-changed="${this.selectCaptionByKeyEvent}"
                type="select"
              >
              </simple-fields-field>
            </div>
            <div
              class="setting"
              ?hidden="${!this.hasCaptions||this.learningMode}"
            >
              <div class="setting-text">
                ${this._getLocal(this.localization,"transcript","label")}
              </div>
              <simple-fields-field
                id="transcript_tracks"
                class="setting-control"
                .value="${this.transcriptTrackKey}"
                .options="${this.transcriptPicker}"
                ?hidden="${!this.hasCaptions||this.learningMode}"
                ?disabled="${!this.hasCaptions||this.learningMode}"
                @value-changed="${this.selectTranscriptByKeyEvent}"
                type="select"
              >
              </simple-fields-field>
            </div>
            <div
              class="setting"
              ?hidden="${!this.hasCaptions||this.learningMode}"
            >
              <div id="print-label" class="setting-text">
                ${this._getLocal(this.localization,"print","label")}
              </div>
              <a11y-media-button
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                aria-labelledby="print-label"
                class="setting-control"
                icon="${this._getLocal(this.localization,"print","icon")}"
                ?disabled="${this.noPrinting||this.learningMode}"
                ?hidden="${this.noPrinting||this.learningMode}"
                @click="${this.print}"
              >
              </a11y-media-button>
            </div>
            <div
              class="setting"
              ?hidden="${!this.hasCaptions||this.learningMode}"
            >
              <div id="download-label" class="setting-text">
                ${this._getLocal(this.localization,"download","label")}
              </div>
              <a11y-media-button
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                aria-labelledby="download-label"
                class="setting-control"
                icon="${this._getLocal(this.localization,"download","icon")}"
                ?disabled="${this.noPrinting||this.learningMode}"
                ?hidden="${this.noPrinting||this.learningMode}"
                @click="${this.download}"
              >
              </a11y-media-button>
            </div>
            <div class="setting">
              <div id="loop-label" class="setting-text">
                ${this._getLocal(this.localization,"loop","label")}
              </div>
              <simple-fields-field
                type="checkbox"
                id="loop"
                class="setting-control"
                aria-labelledby="loop-label"
                @value-change="${this.toggleLoop}"
                ?value="${this.loop}"
              >
              </simple-fields-field>
            </div>
            <div class="setting">
              <div id="speed-label" class="setting-text">
                ${this._getLocal(this.localization,"speed","label")}
              </div>
              <simple-range-input
                id="speed"
                aria-labelledby="speed-label"
                class="setting-slider setting-control"
                min="0.5"
                max="2.5"
                pin
                step="0.25"
                value="${this.playbackRate}"
                @value-changed="${this._handleSpeedChanged}"
              >
              </simple-range-input>
            </div>
          </absolute-position-behavior>
        </div>
        <div
          aria-hidden="true"
          class="screen-only media-caption"
          ?hidden="${!this.mediaCaption}"
        >
          ${this.mediaCaption}
        </div>
        <div class="print-only media-caption">${this.printCaption}</div>
      </div>
      ${this.poster?e`<img
            id="print-thumbnail"
            aria-hidden="true"
            .src="${this.poster}"
          />`:""}
      <div
        id="transcript-section"
        ?hidden="${this.standAlone||!this.hasCaptions}"
      >
        <div id="transcript-and-controls" ?hidden="${this.hideTranscript}">
          <div id="searchbar">
            <div id="searching">
              <simple-search
                id="simplesearch"
                controls="transcript"
                next-button-icon="${this._getLocal(this.localization,"nextResult","icon")}"
                next-button-label="${this._getLocal(this.localization,"nextResult","label")}"
                prev-button-icon="${this._getLocal(this.localization,"prevResult","icon")}"
                prev-button-label="${this._getLocal(this.localization,"prevResult","label")}"
                search-input-icon="${this._getLocal(this.localization,"search","icon")}"
                search-input-label="${this._getLocal(this.localization,"search","label")}"
                selector=".searchable"
                ?disabled="${this.disableSearch}"
                ?hidden="${this.disableSearch}"
              >
              </simple-search>
            </div>
            <div id="scrolling">
              <a11y-media-button
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                id="scroll"
                controls="transcript"
                icon="${this._getLocal(this.localization,"autoScroll","icon")}"
                label="${this._getLocal(this.localization,"autoScroll","label")}"
                ?toggle="${!this.disableScroll}"
                @click="${t=>this.disableScroll=!this.disableScroll}"
              >
              </a11y-media-button>
            </div>
            <div
              id="printing"
              ?hidden="${this.disablePrintButton}"
              ?disabled="${this.disablePrintButton}"
            >
              <a11y-media-button
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                id="download"
                controls="transcript"
                icon="${this._getLocal(this.localization,"download","icon")}"
                label="${this._getLocal(this.localization,"download","label")}"
                @click="${this.download}"
              >
              </a11y-media-button>
              <a11y-media-button
                accent-color="${this.accentColor}"
                ?dark="${this.dark}"
                id="print"
                controls="transcript"
                icon="${this._getLocal(this.localization,"print","icon")}"
                label="${this._getLocal(this.localization,"print","label")}"
                @click="${this.print}"
              >
              </a11y-media-button>
            </div>
          </div>
          <div id="transcript" aria-live="polite">
            <a id="transcript-desc" class="sr-only" href="#bottom">
              ${this._getLocal(this.localization,"transcript","skip")}
            </a>
            ${this.transcriptCues.length>0?e`
                  <div class="transcript-from-track">
                    ${this.transcriptCues.map(((t,i)=>e`
                        <a11y-media-transcript-cue
                          controls="html5"
                          end="${this._getHHMMSS(t.endTime,this.media.duration)}"
                          lang="${t.track.language}"
                          role="button"
                          start="${this._getHHMMSS(t.endTime,this.media.duration)}"
                          tabindex="0"
                          @click="${e=>this._handleCueSeek(t)}"
                          @active-changed="${this._setActiveCue}"
                          ?active="${t.track.activeCues&&t.track.activeCues[0]===t}"
                          ?disabled="${this.disableInteractive||this.disableSeek||0===this.duration}"
                          ?hide-timestamps="${this.hideTimestamps}"
                        >
                          <span class="searchable">${t.text}</span>
                        </a11y-media-transcript-cue>
                      `))}
                  </div>
                `:e` <div id="loading" class="transcript-from-track">
                  ${this.status}
                </div>`}
          </div>
        </div>
      </div>
      <div id="bottom" class="sr-only"></div>`}static get properties(){return{...super.properties,__playerReady:{type:Boolean},allowConcurrent:{attribute:"allow-concurrent",type:Boolean},audioOnly:{attribute:"audio-only",type:Boolean,reflect:!0},autoplay:{attribute:"autoplay",type:Boolean},captionsTrack:{attribute:"captions-track",type:Object},cc:{attribute:"cc",type:Boolean},currentTime:{type:Number},crossorigin:{attribute:"crossorigin",type:String},disablePrintButton:{attribute:"disable-print-button",type:Boolean},disableSearch:{attribute:"disable-search",type:Boolean},disableScroll:{attribute:"disable-scroll",type:Boolean},disableSeek:{attribute:"disable-seek",type:Boolean},darkTranscript:{attribute:"dark-transcript",type:Boolean},disableFullscreen:{attribute:"disable-fullscreen",type:Boolean},disableInteractive:{attribute:"disable-interactive",type:Boolean},height:{attribute:"height",type:String},hideElapsedTime:{attribute:"hide-elapsed-time",type:Boolean},hideTimestamps:{attribute:"hide-timestamps",type:Boolean},hideTranscript:{attribute:"hide-transcript",type:Boolean,reflect:!0},id:{attribute:"id",type:String,reflect:!0},lang:{attribute:"lang",type:String},learningMode:{attribute:"learning-mode",type:Boolean},linkable:{attribute:"linkable",type:Boolean},localization:{attribute:"localization",type:Object},loop:{attribute:"loop",type:Boolean},mediaLang:{attribute:"media-lang",type:String},mediaTitle:{attribute:"media-title",type:String},muted:{attribute:"muted",type:Boolean},hideYoutubeLink:{type:Boolean,attribute:"hide-youtube-link"},playbackRate:{attribute:"playback-rate",type:Number},preload:{attribute:"preload",type:String,reflect:!0},responsiveSize:{attribute:"responsive-size",type:String,reflect:!0},search:{attribute:"search",type:Object},standAlone:{attribute:"stand-alone",type:Boolean,reflect:!0},source:{type:String,reflect:!0},sources:{attribute:"sources",type:Array},stackedLayout:{attribute:"stacked-layout",type:Boolean},sticky:{attribute:"sticky",type:Boolean,reflect:!0},stickyCorner:{attribute:"sticky-corner",type:String,reflect:!0},thumbnailSrc:{attribute:"thumbnail-src",type:String,reflect:!0},tracks:{attribute:"tracks",type:Array},transcriptTrack:{attribute:"transcript-track",type:Object},volume:{attribute:"volume",type:Number},width:{attribute:"width",type:String},youtubeId:{attribute:"youtube-id",reflect:!0,type:String},__currentTime:{type:Number},__captionsOption:{type:Number},__cues:{type:Array},__loadedTracks:{type:Object},__playing:{type:Boolean},__preloadedDuration:{type:Number},__settingsOpen:{type:Boolean},__transcriptOption:{type:Number}}}static get tag(){return"a11y-media-player"}constructor(){super(),globalThis.ResponsiveUtility.requestAvailability(),globalThis.A11yMediaStateManager.requestAvailability(),this.__playerReady=!1,this.audioOnly=!1,this.autoplay=!1,this.allowConcurrent=!1,this.cc=!1,this.darkTranscript=!1,this.disableFullscreen=!1,this.disableInteractive=!1,this.disablePrintButton=!1,this.disableSearch=!1,this.disableScroll=!1,this.disableSeek=!1,this.hideElapsedTime=!1,this.hideTimestamps=!1,this.hideTranscript=!1,this.id=null,this.lang="en",this.learningMode=!1,this.linkable=!1,this.localization={},this.loop=!1,this.mediaTitle="",this.mediaLang="en",this.muted=!1,this.hideYoutubeLink=!1,this.preload="metadata",this.playbackRate=1,this.search=null,this.standAlone=!1,this.responsiveSize="sm",this.captionsTrack=null,this.transcriptTrack=null,this.sources=[],this.stackedLayout=!1,this.sticky=!1,this.stickyCorner="top-right",this.tracks=[],this.volume=70,this.width=null,this.youtubeId=null,this.__cues=[],this.__currentTime=0,this.__captionsOption=-1,this.__loadedTracks=null,this.__playing=!1,this.__settingsOpen=!1,this.__transcriptOption=-1,this.querySelectorAll("video,audio").forEach((t=>{t.addEventListener("loadedmetadata",(e=>{this.__preloadedDuration=t.duration}))}))}get anchor(){let t=globalThis.AnchorBehaviors;return{target:!!t&&t.getTarget(this),params:t?t.params:{}}}get aspect(){let t=this.media&&this.media.aspectRatio?this.media.aspectRatio:16/9;return null===this.width||this.width,this.style.maxWidth=this.width,t}get audioNoThumb(){return this.audioOnly&&(null===this.thumbnailSrc||void 0===this.thumbnailSrc)}get buffered(){return this.media&&this.media.buffered&&this.media.buffered>0?this.media.buffered:0}get captionCues(){return this.captionsTrack&&this.captionsTrack.cues?this.isYoutube?Object.keys(this.captionsTrack.cues).map((t=>{let e=this.captionsTrack.cues[t];return e.startTime<=this.currentTime&&e.endTime>=this.currentTime?e:{}})):this.captionsTrack.activeCues:[]}get captionsPicker(){let t={};return t[-1]=this._getLocal(this.localization,"captions","off"),Object.keys(this.loadedTracks&&this.loadedTracks.textTracks?this.loadedTracks.textTracks:{}).forEach((e=>{t[e]=this.loadedTracks.textTracks[e].label||this.loadedTracks.textTracks[e].language})),t}get captionsTrackKey(){return this.cc?this._getTrackId(this.captionsTrack):-1}get cues(){return this.__cues}get duration(){return this.media&&this.media.duration&&this.media.duration>0?this.media.duration:this.__preloadedDuration?this.__preloadedDuration:0}get flexLayout(){return this.hasCaptions&&!this.standAlone&&!this.hideTranscript&&!this.audioNoThumb&&!this.stackedLayout}get fullFlex(){return this.flexLayout&&"xs"!==this.responsiveSize&&"sm"!==this.responsiveSize}get fullscreenButton(){return this.fullscreenEnabled&&!this.disableFullscreen&&!this.audioNoThumb}get hasCaptions(){return this.cues.length>1}get isYoutube(){return!!this.youtubeId}get loadedTracks(){return this.__loadedTracks}get localizationDefaults(){return{audio:{label:"Audio",notSupported:"HTML5 video is not supported."},autoScroll:{label:"Scroll Transcript",icon:"swap-vert"},captions:{label:"Closed Captions",icon:"av:closed-caption",off:"Off"},download:{label:"Download Transcript",icon:"file-download"},forward:{label:"Forward",icon:"av:fast-forward"},fullscreen:{label:"Fullscreen",icon:"fullscreen"},copyLink:{label:"Copy Media Link",icon:"link"},closeLink:{label:"Close",icon:"close"},loading:{label:"Loading..."},loop:{label:"Loop Playback"},mute:{label:"Mute",icon:"av:volume-up"},nextResult:{label:"Next",icon:"arrow-forward"},pause:{label:"Pause",icon:"av:pause"},play:{label:"Play",icon:"av:play-arrow"},prevResult:{label:"Previous",icon:"arrow-back"},print:{label:"Print Transcript",icon:"print"},restart:{label:"Restart",icon:"av:replay"},rewind:{label:"Backward",icon:"av:fast-rewind"},search:{label:"Search the transcript.",icon:"search"},seekSlider:{label:"Seek Slider"},settings:{label:"Settings",icon:"settings"},speed:{label:"Speed %"},transcript:{label:"Transcript",icon:"description",loading:"Loading the transcript(s)...",off:"Off",skip:"Skip to the transcript."},unmute:{label:"Unmute",icon:"av:volume-off"},video:{label:"Video",notSupported:"HTML5 video is not supported."},volume:{label:"Volume"},youTubeLoading:{label:"Loading...",startLoading:"Press play."},youTubeTranscript:{label:"Transcript will load once media plays."}}}get media(){return this.isYoutube?this.youtube:this.loadedTracks}get mediaCaption(){let t=this._getLocal(this.localization,"audio","label"),e=void 0!==this.mediaTitle&&null!==this.mediaTitle&&""!==this.mediaTitle;return this.audioOnly&&e?this.mediaTitle+" ("+t+")":this.audioOnly?t:e?this.mediaTitle:void 0}get mediaEnd(){return!(!this.mediaSeekable||!this.media.seekable.end(0))&&this.media.seekable.end(0)}get mediaMaxWidth(){return`max-width:${this.fullscreen||this.audioNoThumb?"unset":`calc(${100*this.aspect}vh - ${80*this.aspect}px)`};`}get mediaSeekable(){return!(!this.media||!this.media.seekable)&&this.media.seekable.length>0}get mediaStart(){return this.mediaSeekable&&this.media.seekable.start(0)?this.media.seekable.start(0):0}get playing(){return this.__playing}get playerStyle(){return`height:${this.audioNoThumb?"60px":"unset"};padding-top:${this.fullscreen||this.audioNoThumb||this.audioOnly||this.height?"unset":100/this.aspect+"%"};${this.poster&&(this.isYoutube||this.audioOnly)?`background-image:url('${this.poster}');`:""}`}get poster(){let t=this.thumbnailSrc?this.thumbnailSrc:!(!this.media||this.media.poster)&&this.media.poster;return!this.thumbnailSrc&&this.youtubeId?`https://img.youtube.com/vi/${this.youtubeId.replace(/[\?&].*/,"")}/hqdefault.jpg`:t}get printCaption(){let t=this._getLocal(this.localization,"audio","label"),e=this._getLocal(this.localization,"video","label"),i=void 0!==this.mediaTitle&&null!==this.mediaTitle&&""!==this.mediaTitle;return this.audioOnly&&i?this.mediaTitle+" ("+t+")":this.audioOnly?t:i?this.mediaTitle+" ("+e+")":e}get currentTime(){let t=!!this.shadowRoot&&this.shadowRoot.querySelector("#slider");return t&&!t.disabled&&t.dragging?this.shadowRoot.querySelector("#slider").immediateValue:this.__currentTime}get shareLink(){let t=globalThis.location.href.split(/[#?]/)[0],e=this.id?`?id=${this.id}`:"";return`${t}${e}${""!==e&&this.currentTime&&0!==this.currentTime?`&t=${this.currentTime}`:""}`}get showCustomCaptions(){return(this.isYoutube||this.audioOnly)&&this.hasCaptions&&this.cc}get status(){return this.duration>0?e`
          ${this._getHHMMSS(this.currentTime,this.duration)}/${this._getHHMMSS(this.duration)}
        `:this.isYoutube?this.__playing?this._getLocal(this.localization,"youTubeLoading","label"):this._getLocal(this.localization,"youTubeLoading","startLoading"):this._getLocal(this.localization,"loading","label")}get stickyMode(){return this.sticky&&"none"!==this.stickyCorner}get t(){let t=this._getSeconds(this.anchor.params.t||this.anchor.params.start||"0s");return this.anchor&&this.anchor.target===this?t:this.videoData?this.videoData.t||this.videoData.start:void 0}get transcriptCues(){return(this.cues?this.cues.slice():[]).filter((t=>t.track===this.transcriptTrack))}get transcriptPicker(){let t={};return t[-1]=this._getLocal(this.localization,"transcript","off"),Object.keys(this.loadedTracks&&this.loadedTracks.textTracks?this.loadedTracks.textTracks:{}).forEach((e=>{t[e]=this.loadedTracks.textTracks[e].label||this.loadedTracks.textTracks[e].language})),t}get transcriptTrackKey(){return this.hideTranscript?-1:this._getTrackId(this.transcriptTrack)}get videoData(){if(this.youtubeId){let t=this.youtubeId.split(/[\?\&]/),e={};return e.videoId=t[0],t.forEach(((t,i)=>{if(i>0){let i=t.split(/=/);e[i[0]]=this._getSeconds(i[1])}})),e}}get videoId(){if(this.videoData)return this.videoData.videoId}get youtube(){return null!==this.shadowRoot.querySelector("a11y-media-youtube")&&this.shadowRoot.querySelector("a11y-media-youtube")}_setAttribute(t,e){e?this.setAttribute(t,e):this.removeAttribute(t)}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"learningMode"===e&&void 0!==t&&(this.disableSeek=this[e],this.hideTranscript=this[e]);let change=t=>t.includes(e),mediaChange=t=>change(["__loadedTracks","youtubeId","media",t]),i=change(["standAlone","hideTranscript","audioNoThumb","stackedLayout","__cues"]),s=this.media?this.media:this.__loadedTracks;"id"===e&&null===this.id&&(this.id="a11y-media-player"+Date.now()),change(["media","muted"])&&this._handleMuteChanged(),change(["media","volume"])&&this.setVolume(this.volume),change(["media","autoplay"])&&this.autoplay&&this.play(),"__captionsOption"===e&&this._captionsOptionChanged(),change(["cc","captionsTrack"])&&this._captionsChanged(),i&&this._setAttribute("flex-layout",this.flexLayout),(i||"responsiveSize"===e)&&this._setAttribute("full-flex",this.fullFlex),change(["sticky","sticky-corner","__playing"])&&this._setAttribute("sticky-mode",this.stickyMode&&this.__playing),change(["height"])&&(this.style.setProperty("--a11y-media-player-height",this.height?this.height:"unset"),this.style.setProperty("--a11y-media-transcript-max-height",this.height?"146px":"unset")),null!==this.media&&(mediaChange("cc")&&this._setAttribute("cc",this.cc,this.__loadedTracks),mediaChange("isYoutube")&&this.__loadedTracks&&(this.__loadedTracks.hidden,this.isYoutube),mediaChange("mediaLang")&&this._setAttribute("lang",this.mediaLang,s),mediaChange("loop")&&this._setAttribute("loop",this.loop,s),mediaChange("playbackRate")&&this._setAttribute("playbackRate",this.playbackRate,s),mediaChange("isYoutube")&&this._setAttribute("poster",!this.isYoutube&&this.thumbnailSrc,this.__loadedTracks),!change(["isYoutube","poster","media","audioOnly"])||!this.poster||this.isYoutube||this.audioOnly||this.media.poster||(this.media.poster=this.poster)),this.dispatchEvent(new CustomEvent(`${e.replace(/([a-z0-9]|(?=[A-Z]))([A-Z])/g,"$1-$2").toLowerCase()}-changed`,{detail:{value:this[e]}}))}))}_captionsChanged(){let t=-1;Object.keys(this.loadedTracks.textTracks).forEach((e=>{let i=this.cc&&this.loadedTracks.textTracks[e]===this.captionsTrack;this.loadedTracks.textTracks[e].mode=i?"showing":"hidden",i&&(t=e)})),this.__captionsOption=t}_captionsOptionChanged(){this.cc=this.__captionsOption>-1,Object.keys(this.loadedTracks.textTracks).forEach((t=>{let e=parseInt(t)==parseInt(this.__captionsOption);this.loadedTracks.textTracks[t].mode=e?"showing":"hidden",e&&(this.captionsTrack=this.loadedTracks.textTracks[t])}))}_handleMuteChanged(){this.media&&(this.media.muted=this.muted),this.dispatchEvent(new CustomEvent("mute-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}download(){let t=globalThis.document.createElement("a"),e=this.mediaTitle&&""!=this.mediaTitle.trim()?`${this.mediaTitle} (${this._getLocal(this.localization,"transcript","label")})`:this._getLocal(this.localization,"transcript","label"),i=e.replace(/[^\w\d]/g,""),s=this.transcriptTrack.cues,o=Object.keys(s).map((t=>`${this._getHHMMSS(s[t].startTime)} - ${this._getHHMMSS(s[t].endTime)}: \t${s[t].text.replace(/[\n\r\s*]/g," ")}\n`)).join("");t.setAttribute("href","data:text/plain;charset=UTF-8,"+encodeURIComponent(e+"\n"+o)),t.setAttribute("download",i+".txt"),t.style.display="none",globalThis.document.body.appendChild(t),t.click(),globalThis.document.body.removeChild(t),this.dispatchEvent(new CustomEvent("transcript-downloaded",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}goToYoutube(){globalThis.open(`https://www.youtube.com/watch?v=${this.youtubeId}`)}print(){let t=this.transcriptTrack.cues,e=this.mediaTitle&&""!=this.mediaTitle.trim()?`${this.mediaTitle} (${this._getLocal(this.localization,"transcript","label")})`:this._getLocal(this.localization,"transcript","label"),i=globalThis.open("","","left=0,top=0,width=552,height=477,toolbar=0,scrollbars=0,status =0");i.document.body.innerHTML=`\n     <h1>${e}</h1>\n     ${Object.keys(t).map((e=>`<div style="display: table-row;">\n         ${this.hideTimestamps?"":`\n             <span style="display: table-cell;\n               font-size: 80%;\n               padding: 0 16px;\n               white-space: nowrap;\n               font-family: monospace;">\n               ${this._getHHMMSS(t[e].startTime)} - \n               ${this._getHHMMSS(t[e].endTime)}:\n             </span>`}\n         <span style="display: table-cell; line-height: 200%;">\n           ${t[e].text}\n         </span>\n       </div>`)).join("")}\n     `,i.document.close(),i.focus(),i.print(),i.addEventListener("afterprint",(t=>{i.close()})),this.dispatchEvent(new CustomEvent("transcript-printed",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}play(){this.__playing=!0,this.media&&this.media.play&&this.media.play(),this.dispatchEvent(new CustomEvent("play",{bubbles:!0,composed:!0,cancelable:!1,detail:this})),this.dispatchEvent(new CustomEvent("a11y-player-playing",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}pause(){this.__playing=!1,this.media&&this.media.pause&&this.media.pause(),this.dispatchEvent(new CustomEvent("pause",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}stop(){this.pause(),this.seek(0),this.dispatchEvent(new CustomEvent("stop",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}restart(){this.seek(0),this.play(),this.dispatchEvent(new CustomEvent("restart",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}rewind(t){t=void 0!==t?t:this.duration/20,this.seek(this.currentTime-t,0),this.dispatchEvent(new CustomEvent("backward",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}forward(t){t=void 0!==t?t:this.duration/20,this.seek(this.currentTime+t),this.dispatchEvent(new CustomEvent("forward",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}seek(t=0){this.mediaSeekable&&(this.media.seek(Math.max(0,Math.min(t,this.duration))),this._handleTimeUpdate(),this.dispatchEvent(new CustomEvent("seek",{bubbles:!0,composed:!0,cancelable:!1,detail:this})))}selectCaptionByKeyEvent(t){this.selectCaptionByKey(t.detail.value)}selectCaptionByKey(t){(t=parseInt(t))>-1&&(this.captionsTrack=this.loadedTracks.textTracks[t]),this.cc=t>-1}selectTranscriptByKeyEvent(t){this.__playerReady&&this.__settingsOpen&&this.selectTranscriptByKey(t.detail.value)}selectTranscriptByKey(t){(t=parseInt(t))>-1&&(this.transcriptTrack=this.loadedTracks.textTracks[t]),this.hideTranscript=t<0}getloadedTracks(){let t=this.querySelector("audio,video"),e=t?t.getAttribute("crossorigin"):void 0,i=null,s=this.source&&!this.source&&this.source.match(/webm|ogv|mov|mp4$/),o=(this.sources||[]).filter((t=>`${t.type||""}${t.kind||""}`.match(/video|mp4|webm|ogv/))).length>0,l=this.isYoutube||s||o;if(t&&(e||t.setAttribute("crossorigin",this.crossorigin),t.removeAttribute("autoplay"),t.removeAttribute("controls"),t.setAttribute("preload","metadata")),!this.youtubeId){let t=!(!this.querySelector("iframe")||!this.querySelector("iframe"))&&this.querySelector("iframe").src;!!t&&(t.match(/youtube(-\w*)*.com/)||t.src.match(/youtu.be/))&&t&&(this.youtubeId=t.replace(/.*\//g,""),l=!0,this.querySelector("iframe").remove())}return t?i=t:(i=globalThis.document.createElement(this.querySelectorAll('source[type*="audio"]').length>0||!l?"audio":"video"),e||i.setAttribute("crossorigin",this.crossorigin),i.setAttribute("preload","metadata"),this.querySelectorAll("source,track").forEach((t=>{t.parentNode===this&&i.appendChild(t)})),this.appendChild(i)),this.audioOnly="AUDIO"===i.tagName,i.style.width="100%",i.style.maxWidth="100%",(this.tracks||[]).forEach((t=>{let e=globalThis.document.createElement("track");Object.keys(t).forEach((i=>e.setAttribute(i,t[i]))),i.appendChild(e)})),(this.sources||[]).forEach((t=>{let e=globalThis.document.createElement("source");Object.keys(t).forEach((i=>e.setAttribute(i,t[i]))),i.appendChild(e)})),i.seek=t=>i.currentTime=t,this._addSourcesAndTracks(i,i),i}_getTrack(t){if(!t){let t=this.loadedTracks.textTracks.filter((t=>!0===t.default));return t?t[0].track:this.loadedTracks.textTracks[0].track}return t}selectTranscript(t){this.transcriptTrack=this._getTrack(t)}setPlaybackRate(t){t=null!==t?t:1,this.media.playbackRate=null!==t?t:1,globalThis.dispatchEvent(new CustomEvent("playback-rate-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}setVolume(t=70){this.volume=Math.max(0,Math.min(t,100)),this.media&&(this.media.volume=t/100),globalThis.dispatchEvent(new CustomEvent("volume-changed",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}toggleCC(t){this.cc=void 0===t?!this.cc:t,globalThis.dispatchEvent(new CustomEvent("cc-toggle",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}get fullscreenTarget(){return this.shadowRoot&&this.shadowRoot.querySelector("#player-section")?this.shadowRoot.querySelector("#player-section"):this}toggleFullscreen(t){super.toggleFullscreen(t),globalThis.dispatchEvent(new CustomEvent("fullscreen-toggle",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}toggleLoop(t){this.loop=void 0===t?!this.loop:t,this.media.loop=!0===t,globalThis.dispatchEvent(new CustomEvent("loop-toggle",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}togglePlay(){this.__playing?this.pause():this.play(),globalThis.dispatchEvent(new CustomEvent("play-toggle",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}toggleMute(t){this.muted=void 0===t?!this.muted:t,globalThis.dispatchEvent(new CustomEvent("muted-toggle",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}toggleSettings(t){t=void 0===t?!this.__settingsOpen:t,this.__settingsOpen=t,this.dispatchEvent(new CustomEvent("settings-toggled",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}toggleSticky(t){t=void 0===t?!this.sticky:t,this.sticky!==t&&(this.sticky=t,this.dispatchEvent(new CustomEvent("player-sticky",{bubbles:!0,composed:!0,cancelable:!1,detail:this})))}toggleTranscript(t){(t=void 0===t?this.hideTranscript:t)&&!this.selectTranscriptByKey>-1&&this.selectTranscriptByKey(0),this.hideTranscript=!t,this.dispatchEvent(new CustomEvent("transcript-toggle",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}_addSourcesAndTracks(t){t.style.width="100%",t.style.maxWidth="100%",Object.keys(t.textTracks).forEach((e=>this._onAddTrack(t.textTracks[e]))),t.textTracks.onremovetrack=t=>this._onRemoveTrack(t.track),t.textTracks.onaddtrack=t=>this._onAddTrack(t.track);let e=t.querySelector("track[default]")?t.querySelector("track[default]"):t.querySelector("track"),i=Object.keys(t.textTracks).find((i=>e.label===t.textTracks[i].label&&e.kind===t.textTracks[i].kind&&e.srclang===t.textTracks[i].scrlang))||0;this.captionsTrack=t.textTracks[i],this.hideTranscript||(this.transcriptTrack=this.captionsTrack),this._handleTimeUpdate()}_handleCloseLink(){this.shadowRoot.querySelector("#link")&&this.shadowRoot.querySelector("#link").close&&this.shadowRoot.querySelector("#link").close()}_handleCopyLink(){let t=globalThis.document.createElement("textarea");this.pause(),t.value=this.shareLink,globalThis.document.body.appendChild(t),t.select(),globalThis.document.execCommand("copy"),globalThis.document.body.removeChild(t),globalThis.SimpleToast.requestAvailability().showSimpleToast({detail:{duration:3e3,text:`Copied to clipboard: ${this.shareLink}`}})}_handleCueSeek(t){this.standAlone||this.seek(t.startTime)}_handleMediaLoaded(t){this._handleTimeUpdate(),this.youtubeId||this.anchor.target!==this||this.seek(this._getSeconds(this.anchor.params.t||this.anchor.params.start||"0s"))}_handleSearchAdded(t){this.search=t.detail}_handleSpeedChanged(t){var e=l(t)[0];this.setPlaybackRate(e.value)}_handleSliderDragging(t){let e=!!this.shadowRoot&&this.shadowRoot.querySelector("#slider");if(e&&!e.disabled&&e.dragging&&this.__playing&&e.dragging){let t=setInterval((()=>{e.dragging||(this.play(),clearInterval(t))}));this.pause()}}_handleSliderChanged(t){let e=!!this.shadowRoot&&this.shadowRoot.querySelector("#slider");this.playing&&e.immediateValue!=this.__currentTime||this.seek(e.immediateValue)}_handleTimeUpdate(){this.__wait||(this.__currentTime=this.media&&this.media.currentTime&&this.media.currentTime>0?this.media.currentTime:0,this.__wait=!0,setTimeout((()=>{this.__wait=!1}),1e3))}_getTrackId(t){return this.loadedTracks&&Object.keys(this.loadedTracks.textTracks).find((e=>this.loadedTracks.textTracks[e]===t))||-1}_handleVolumeChanged(t){var e=l(t)[0];this.volume=e.value}_onAddTrack(t){null===this.captionsTrack&&(this.captionsTrack=t),t&&(t.mode="hidden");let e=setInterval((()=>{if(t.cues&&t.cues.length>0){clearInterval(e);let i=Object.keys(t.cues).map((e=>t.cues[e]));this._onRemoveTrack(t),this.__cues=this.cues.concat(i).sort(((t,e)=>{let i=t.startTime-e.startTime,s=t.endTime-e.endTime;return 0!==i?i:0!==s?s:t.track-e.track}))}}))}_onRemoveTrack(t){this.loadedTracks&&this.loadedTracks.textTracks&&Object.keys(this.loadedTracks.textTracks).filter((e=>this.loadedTracks.textTracks[e]!==t)),this.__cues=this.cues?this.cues.filter((e=>e.track!==t)):[]}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.style.setProperty("--a11y-media-transcript-max-height",this.height?"146px":"unset"),this.__loadedTracks=this.getloadedTracks(),this._handleMediaLoaded(),this.__loadedTracks.addEventListener("loadedmetadata",(t=>this._handleMediaLoaded(t))),this.__loadedTracks.addEventListener("timeupdate",(t=>{this._handleTimeUpdate(t)})),globalThis.dispatchEvent(new CustomEvent("responsive-element",{detail:{element:this,attribute:"responsive-size",relativeToParent:!0,sm:400,md:700,lg:1e3,xl:1500}})),globalThis.dispatchEvent(new CustomEvent("a11y-player",{bubbles:!0,composed:!0,cancelable:!1,detail:this})),this.__playerReady=!0}_setActiveCue(t){let e=t.detail.element,i=e.parentNode,s=null!=i?i.offsetTop:0;if(!this.disableScroll){let scrollingTo=(t,e,i)=>{if(!(i<=0)){var s=(e-t.scrollTop)/i*10;setTimeout((()=>{t.scrollTop=t.scrollTop+s,t.scrollTop!==e&&scrollingTo(t,e,i-10)}),10)}};scrollingTo(e.parentNode.parentNode,e.offsetTop-s,250)}}_transcriptScroll(t){this.disableScroll=!this.disableScroll}_getHHMMSS(t,e){t=parseFloat(t),e=void 0===e?t:parseFloat(e);let a=t=>t<10?`0${t}`:t,b=(t,i,s)=>e>=i?a(Math.floor(t/i))+":":s;return b(t,3600,"")+b(t%3600,60,"00:")+a(Math.round(t%60))}_getSeconds(t=0){let e=t.replace(/[hm]{1,2}&?/g,":0").replace(/[s]{1,2}$/g,"").split(/:/);return 3600*(e.length>2?parseInt(e[e.length-3]):0)+60*(e.length>1?parseInt(e[e.length-2]):0)+(e.length>0?parseFloat(e[e.length-1]):0)}_getLocal(t,e,i){let s="";return void 0!==t&&void 0!==t[e]&&void 0!==t[e][i]?s=t[e][i]:void 0!==this.localizationDefaults&&void 0!==this.localizationDefaults[e]&&void 0!==this.localizationDefaults[e][i]&&(s=this.localizationDefaults[e][i]),s}}customElements.define(A11yMediaPlayer.tag,A11yMediaPlayer);export{A11yMediaPlayer};