/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as i,css as e}from"../../lit/index.js";import{SchemaBehaviors as o}from"../schema-behaviors/schema-behaviors.js";import{IntersectionObserverMixin as s}from"../intersection-element/lib/IntersectionObserverMixin.js";import{I18NMixin as r}from"../i18n-manager/lib/I18NMixin.js";class A11yGifPlayer extends(r(s(o(t)))){constructor(){super(),this.windowControllers=new AbortController,this.__gifLoaded=!1,this.disabled=!1,this.__playing=!1,this._updateFromSlot(),this.t={toggleAnimation:"Toggle animation"},this.registerLocalization({context:this,basePath:import.meta.url,locales:["es"]})}static get styles(){return[e`
        :host {
          display: block;
        }
        :host([hidden]) {
          display: none;
        }
        .sr-only {
          position: absolute;
          left: -9999999px;
          top: 0;
          width: 0;
          overflow: hidden;
        }
        #container {
          padding: 0;
          margin: 0;
          position: relative;
          border: var(--a11y-gif-player-border, none);
          border-radius: var(--a11y-gif-player-border-radius, 0);
        }
        img {
          width: 100%;
        }
        button {
          position: absolute;
          width: 100%;
          min-height: 100px;
          top: 0;
          left: 0;
          bottom: 0;
          right: 0;
          background-size: contain;
          background-color: var(--a11y-gif-player-button-bg, #cccccc);
        }
        button:active,
        button:focus,
        button:hover {
          border: var(--a11y-gif-player-focus-border, none);
          outline: var(--a11y-gif-player-outline, 3px solid);
        }
        button[disabled] {
          cursor: var(--a11y-gif-player-disabled-cursor, not-allowed);
        }
        button[aria-pressed="true"] {
          opacity: 0;
        }
        svg {
          position: absolute;
          top: 35%;
          left: 35%;
          width: var(--a11y-gif-player-arrow-size, 30%);
          height: var(--a11y-gif-player-arrow-size, 30%);
        }
        g {
          opacity: var(--a11y-gif-player-arrow-opacity, 0.5);
        }
        button:not([disabled]):active g,
        button:not([disabled]):hover g,
        button:not([disabled]):focus g {
          opacity: var(--a11y-gif-player-button-focus-opacity, 0.7);
        }
        polygon {
          fill: var(--a11y-gif-player-button-color, #000000);
          stroke: var(--a11y-gif-player-arrow-border-color, #ffffff);
          stroke-width: var(--a11y-gif-player-arrow-border-width, 15px);
        }
        text {
          fill: var(--a11y-gif-player-button-text-color, #ffffff);
        }
        #longdesc {
          position: absolute;
          left: 2px;
          bottom: 2px;
          width: calc(100% - 2px);
          font-size: 80%;
        }
      `]}__imageLoaded(t){this.__gifLoaded=!0}render(){return i`${this.elementVisible?i`
          <div id="container">
            <slot hidden></slot>
            <img
              id="gif"
              src="${this.__gifLoaded&&this.__playing?this.src:this.srcWithoutAnimation}"
              alt="${this.alt}"
              loading="lazy"
              aria-describedby="${this.longdesc?"longdesc":""} ${(this.describedBy||"").trim()}"
              slot="summary"
            />
            ${this.__playing?i`<img
                  src="${this.src}"
                  alt=""
                  hidden
                  slot="summary"
                  @load="${this.__imageLoaded}"
                />`:""}

            <button
              id="button"
              aria-label="${this.t.toggleAnimation}"
              aria-controls="gif"
              aria-pressed="${this.__playing?"true":"false"}"
              @click="${this.toggle}"
              ?disabled="${this.disabled||!this.src}"
              .style="background-image: url('${this.srcWithoutAnimation}')"
            >
              <svg
                id="svg"
                aria-hidden="true"
                xmlns="http://www.w3.org/2000/svg"
                viewBox="0 0 200 200"
              >
                <g>
                  <polygon points="30,20 30,180 170,100"></polygon>
                  <text x="50" y="115" font-size="40px">GIF</text>
                </g>
              </svg>
            </button>
            <a11y-details
              id="longdesc"
              ?hidden="${!this.src||!this.longdesc}"
              .style="opacity:${this.__playing?0:1}"
            >
              <div slot="summary">info</div>
              <div slot="details">${this.longdesc}</div>
            </a11y-details>
          </div>
        `:""} `}static get tag(){return"a11y-gif-player"}static get properties(){return{...super.properties,alt:{type:String},disabled:{type:Boolean},describedBy:{attribute:"described-by",type:String},longdesc:{type:String,attribute:"longdesc"},src:{type:String},srcWithoutAnimation:{type:String,attribute:"src-without-animation"},__playing:{type:Boolean},__gifLoaded:{type:Boolean}}}updated(t){super.updated(t),t.forEach(((t,i)=>{"elementVisible"===i&&this[i]&&(import("../a11y-details/a11y-details.js"),this.shadowRoot&&!this.srcWithoutAnimation&&this.src&&import("../micro-frontend-registry/micro-frontend-registry.js").then((async()=>{this._automaticStill=!0,this.srcWithoutAnimation=await this.generateStill(this.src)}))),this.shadowRoot&&"src"===i&&this[i]&&this.elementVisible&&this._automaticStill&&setTimeout((async()=>{this.srcWithoutAnimation=await this.generateStill(this.src)}),0)}))}async generateStill(t){const i=globalThis.MicroFrontendRegistry.requestAvailability();return await import("../micro-frontend-registry/lib/microServices.js").then((t=>{i.enableServices(["core"])})),i.url("@core/imgManipulate",{quality:50,src:t})}get observer(){return new MutationObserver((()=>this._updateFromSlot()))}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this.observer.observe(this,{attributes:!1,childList:!0,subtree:!0}),globalThis.addEventListener("beforeprint",(t=>{this.shadowRoot.querySelector("#longdesc").toggleOpen()}),{signal:this.windowControllers.signal}),globalThis.addEventListener("afterprint",(t=>{this.shadowRoot.querySelector("#longdesc").toggleOpen()}),{signal:this.windowControllers.signal})}disconnectedCallback(){this.observer.disconnect(),this.windowControllers.abort(),super.disconnectedCallback&&super.disconnectedCallback()}play(){this.__playing=!0}stop(){this.__playing=!1}toggle(){this.__playing?this.stop():this.play()}toggleAnimation(){this.__playing?this.stop():this.play()}_updateFromSlot(){if(this.querySelector){let t=this.querySelector("img");if(t){let i=t.src||null,e=t.alt||null;i&&(this.srcWithoutAnimation=i),e&&(this.alt=e)}if(t=this.querySelector("simple-img"),t){let i=t.srcconverted||null,e=t.alt||null;i&&(this.srcWithoutAnimation=i),e&&(this.alt=e)}}}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(A11yGifPlayer.tag,A11yGifPlayer);export{A11yGifPlayer};