/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{A11yDetails as i}from"../a11y-details/a11y-details.js";class A11yFigure extends i{static get styles(){return[t`
        :host {
          display: inline-block;
          padding: 5px;
          border: 1px solid #ddd;
        }
        :host([hidden]) {
          display: none;
        }
        figure {
          display: inline-table;
          position: relative;
          margin: 0;
        }
        figcaption {
          display: table-caption;
          caption-side: bottom;
          position: relative;
          margin: var(--a11y-figure-figcaption-margin, 0);
          padding: var(--a11y-figure-figcaption-padding, 0);
          font-size: var(--a11y-figure-figcaption-fontSize, unset);
          background-color: var(--a11y-figure-figcaption-backgroundColor, #fff);
          color: var(--a11y-figure-figcaption-color, #000);
          --a11y-details-left: var(--a11y-figure-details-left, 0);
          --a11y-details-right: var(--a11y-figure-details-right, 0);
          --a11y-details-fontSize: var(--a11y-figure-details-fontSize, 0.8em);
        }
        ::slotted([slot="figcaption"]) {
          margin: 0;
          flex: 1 1 auto;
        }
        img,
        ::slotted([slot="image"]) {
          width: 100%;
        }
        a11y-details:not([hidden]) {
          display: flex;
          justify-content: flex-end;
        }
      `]}render(){return e`
      <figure>
        ${this.imgSrc?e` <img src="${this.imgSrc}" alt="${this.imgAlt}" /> `:""}
        <slot name="image" ?hidden="${this.imgSrc}"></slot>
        <figcaption>
          <slot name="figcaption"></slot>
          <a11y-details
            open-text="${this.openText}"
            close-text="${this.closeText}"
            ?hidden="${!this.__hasDetail}"
          >
            <div slot="summary"><slot name="summary"></slot></div>
            <div slot="details"><slot name="details"></slot></div>
            <slot name="figdetails"></slot>
          </a11y-details>
        </figcaption>
      </figure>
      <slot hidden></slot>
    `}static get haxProperties(){return{canScale:!0,canEditSource:!0,type:"grid",gizmo:{title:"Descriptive Figure",description:"Accessible figure with long description",icon:"hax:figure",color:"grey",tags:["content","figure","a11y","accessibility","image","caption","description"],handles:[{type:"image",source:"imgSrc",alt:"imgAlt",caption:"figcaption"}],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"imgSrc",title:"Image",inputMethod:"haxupload",noVoiceRecord:!0},{property:"imgAlt",title:"Alt Text",inputMethod:"alt",required:!0},{slot:"figcaption",title:"Figure Caption",description:"Figure caption text that is always visible.",inputMethod:"code-editor"},{slot:"details",title:"Decription",description:"Detailed image description that can be hidden or shown",inputMethod:"code-editor"},{slot:"summary",title:"Decription Button",description:'Default for button that shows/hides description text, eg. "info", "medatadata", etc. ',inputMethod:"code-editor"}],advanced:[{property:"openText",title:"Optional summary text when details are open",inputMethod:"textfield",required:!1},{property:"closeText",title:"Optional summary text when details are closed",inputMethod:"textfield",required:!1}]},demoSchema:[{tag:"a11y-figure",properties:{imgSrc:"https://placehold.co/500x300",imgAlt:"",openText:"Show Description",closeText:"Hide Description",style:"max-width:400px"},content:'<h4 slot="figcaption">Random</h4>\n<div slot="summary">Image Description</div>\n<div slot="details">Aenean eget nisl volutpat, molestie purus eget, bibendum metus. Pellentesque magna velit, tincidunt quis pharetra id, gravida placerat erat. Maecenas id dui pretium risus pulvinar feugiat vel nec leo. Praesent non congue tellus. Suspendisse ac tincidunt purus. Donec eu dui a metus vehicula bibendum sed nec tortor. Nunc convallis justo sed nibh consectetur, at pharetra nulla accumsan.</div>'}]}}static get properties(){return{...super.properties,imgSrc:{type:String,attribute:"img-src"},imgAlt:{type:String,attribute:"img-alt"},__hasDetail:{type:Boolean}}}static get tag(){return"a11y-figure"}constructor(){super(),this.tag=A11yFigure.tag}get observer(){return new MutationObserver((e=>this._watchChildren(e)))}get figureObserver(){return new MutationObserver((()=>this._updateElement()))}_updateElement(){let e=this.querySelector("* > figure"),t=e?e.querySelector("* > img"):void 0,i=e?e.querySelector("* > figcaption"):void 0;t&&((this.querySelectorAll("[slot=image]")||[]).forEach((e=>e.remove())),t.cloneNode(),t.slot="image",this.appendChild(t)),this.__hasDetail=!!this.querySelector("summary")||!!this.querySelector("*[slot=summary]"),i&&this._copyAndFilter(i.cloneNode(!0),["figcaption","details","summary"])}_copyAndFilter(e,t=[],i=0){let r=t[i+1],a=e&&r?e.querySelector(`* > ${r}`):void 0;a&&(this._copyAndFilter(a,t,i+1),Object.keys(a||{}).forEach((e=>a[e].remove()))),this._copyToSlot(t[i],e)}_watchChildren(e){this._hasMutations(e)?(this._updateElement(),this.figureObserver.observe(this.querySelector("* > figure"),{childList:!0,subtree:!0,characterData:!0})):this._hasMutations(e,"removedNodes")&&!this.querySelector("* > figureObserver")&&this.detailsObserver.disconnect&&this.detailsObserver.disconnect()}}customElements.define("a11y-figure",A11yFigure);export{A11yFigure};