/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as s}from"../../lit/index.js";class A11yDetails extends e{static get styles(){return[s`
        :host,
        details {
          display: inline-flex;
          overflow: visible;
        }

        :host([hidden]) {
          display: none !important;
        }

        summary {
          cursor: pointer;
          display: flex;
          align-items: center;
          justify-content: space-between;
          font-size: var(--a11y-details-summary-fontSize, 0.8em);
          color: var(--a11y-details-summary-color, #000);
          background-color: var(--a11y-details-summary-backgroundColor, #fff);
          border-color: var(--a11y-details-summary-borderColor, #ddd);
          border-width: var(--a11y-details-summary-borderWidth, 1px);
          border-style: var(--a11y-details-summary-borderStyle, solid);
          border-radius: var(--a11y-details-summary-borderRadius, 3px);
          padding: var(--a11y-details-summary-padding, 0.5em);
        }

        summary:focus {
          outline: var(--a11y-details-summary-focus-outline, 1px solid #006688);
          color: var(
            --a11y-details-summary-focus-color,
            var(--a11y-details-summary-color, #000)
          );
          background-color: var(
            --a11y-details-summary-focus-backgroundColor,
            var(--a11y-details-summary-backgroundColor, #fff)
          );
          border-color: var(
            --a11y-details-summary-focus-borderColor,
            var(--a11y-details-borderColor, #999)
          );
          border-width: var(
            --a11y-details-summary-focus-borderWidth,
            var(--a11y-details-summary-borderWidth, 1px)
          );
          border-style: var(
            --a11y-details-summary-focus-borderStyle,
            var(--a11y-details-summary-borderStyle, dotted)
          );
          border-radius: var(
            --a11y-details-summary-focus-borderRadius,
            var(--a11y-details-summary-borderRadius, 3px)
          );
        }

        #details-inner {
          position: absolute;
          display: none;
          max-height: 0px;
          transition: all 0.7s ease-in-out 0.2s;
          overflow-y: auto;
          padding: 0;
          font-size: var(--a11y-details-fontSize, 0.8em);
          color: var(--a11y-details-color, #000);
          background-color: var(
            --a11y-details-backgroundColor,
            rgba(255, 255, 255, 1)
          );
          border-color: var(--a11y-details-borderColor, #999);
          border-width: var(--a11y-details-borderWidth, 1px);
          border-style: var(--a11y-details-borderStyle, solid);
          border-radius: var(--a11y-details-borderRadius, 3px);
        }

        ::slotted(*:not[slot="summary"]) {
          display: none;
        }

        .close-text,
        details[open] .open-text,
        details:not([open]) .has-open-text,
        details[open] .has-close-text {
          display: none;
        }

        details[open] .close-text {
          display: inline;
        }

        ::slotted([slot="details"]) {
          display: block;
          height: auto;
          max-height: 0;
          overflow: hidden;
          transition: all 0.7s ease-in-out 0.2s;
        }

        details[open] ::slotted([slot="details"]) {
          max-height: var(--a11y-details-maxHeight, 400px);
          transition: all 0.7s ease-in-out 0.2s;
        }

        details[open] #details-inner {
          z-index: 9999999999;
          display: block;
          left: var(--a11y-details-left, unset);
          right: var(--a11y-details-right, unset);
          padding: var(--a11y-details-padding, 0.5em);
          max-height: var(--a11y-details-maxHeight, 400px);
          padding: var(--a11y-details-padding, 0.5em);
          width: calc(auto - 2 * var(--a11y-details-padding, 0.5em));
          transition: all 0.7s ease-in-out 0.2s;
        }
      `]}render(){return t` <details id="details">
        <summary
          @click="${this._handleClick}"
          @keyup="${this._handleKeyup}"
          tabindex="0"
          role="button"
        >
          <span class="open-text">${this.openText}</span>
          <span class="close-text">${this.closeText}</span>
          <slot name="summary" class="${this.summaryClasses}"></slot>
        </summary>
        <div id="details-inner"><slot name="details"></slot></div>
      </details>
      <slot hidden></slot>`}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Accessible Details Button",description:"Accessible progressive disclosure with detail and summary",icon:"icons:arrow-drop-down",color:"grey",tags:["Layout","Details","Summary","Button","Accessible"],handles:[{type:""}],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[{slot:"summary",title:"Button",description:'Summary of the content that if concealed, eg. "info", "medatadata", etc. ',inputMethod:"code-editor"},{slot:"details",title:"Decription",description:"Detailed description that can be hidden or shown",inputMethod:"code-editor"},{slot:"",title:"Decription Button",description:'Default for button that shows/hides description text, eg. "info", "medatadata", etc. ',inputMethod:"code-editor"}],advanced:[{property:"openText",title:"Optional summary text when details are open",inputMethod:"textfield",required:!1},{property:"closeText",title:"Optional summary text when details are closed",inputMethod:"textfield",required:!1}]},demoSchema:[{tag:"a11y-details",properties:{openText:"Show Aenean",closeText:"Hide Aenean"},content:'<div slot="summary">Show Aenean</div>\n<div slot="details">Aenean eget nisl volutpat, molestie purus eget, bibendum metus. Pellentesque magna velit, tincidunt quis pharetra id, gravida placerat erat. Maecenas id dui pretium risus pulvinar feugiat vel nec leo. Praesent non congue tellus. Suspendisse ac tincidunt purus. Donec eu dui a metus vehicula bibendum sed nec tortor. Nunc convallis justo sed nibh consectetur, at pharetra nulla accumsan.\n</div>'}]}}static get properties(){return{...super.properties,closeText:{type:String,attribute:"close-text",reflect:!0},openText:{type:String,attribute:"open-text",reflect:!0}}}static get tag(){return"a11y-details"}constructor(){super(),this.closeText="",this.openText="",this.tag=A11yDetails.tag}disconnectedCallback(){this.observer&&this.observer.disconnect&&this.observer.disconnect(),super.disconnectedCallback()}firstUpdated(){super.firstUpdated&&super.firstUpdated(),this._updateElement(),this.observer.observe(this,{childList:!0,subtree:!0})}get details(){return this&&this.shadowRoot&&this.shadowRoot.querySelector("details")?this.shadowRoot.querySelector("details"):void 0}get summaryClasses(){return[this.openText&&this.openText.trim&&""!==this.openText.trim()?"has-open-text":"",this.closeText&&this.closeText.trim&&""!==this.closeText.trim()?"has-close-text":""].join(" ")}get observer(){return new MutationObserver((e=>this._watchChildren(e)))}get detailsObserver(){return new MutationObserver((()=>this._updateElement()))}_handleClick(e){this.details&&void 0===this.details.open&&(this.toggleOpen(),e.preventDefault(),e.stopPropagation())}_handleKeyup(e){(this.details&&void 0===this.details.open&&13==e.keyCode||32==e.keyCode)&&(this.toggleOpen(),e.preventDefault(),e.stopPropagation())}toggleOpen(){this.details.hasAttribute("open")?(this.details.removeAttribute("open"),this.details.open&&(this.details.open=!1)):(this.details.setAttribute("open",""),this.details.open&&(this.details.open=!0))}_updateElement(){let e=this.querySelector("* > details"),t=e?e.querySelector("* > summary"):void 0;if(t&&this._copyToSlot("summary",t.cloneNode(!0)),e){let t=e.cloneNode(!0),s=t.querySelectorAll("* > summary");Object.keys(s||{}).forEach((e=>s[e].remove())),this._copyToSlot("details",t,"div")}}_watchChildren(e){this._hasMutations(e)?(this._updateElement(),this.detailsObserver.observe(this.querySelector("* > details"),{childList:!0,subtree:!0,characterData:!0})):this._hasMutations(e,"removedNodes")&&!this.querySelector("* > details")&&this.detailsObserver.disconnect&&this.detailsObserver.disconnect()}_hasMutations(e,t="addedNodes"){return Object.keys(e||{}).filter((s=>{let a=e[s][t];return Object.keys(a||{}).filter((e=>"DETAILS"===a[e].tagName)).length>0})).length>0}_copyToSlot(e,t,s="span"){let a=Object.keys(t.childNodes||{}).filter((e=>{let s=t.childNodes[e];return!!s.tagName||s.textContent.trim().length>0})).map((e=>t.childNodes[parseInt(e)]));1===a.length&&a[0].tagName&&(s=(t=a[0]).tagName),this._getSlot(e,s).innerHTML=t.innerHTML,t.remove()}_getSlot(e,t="span"){let s=this.querySelector(`[slot=${e}]`);return s&&s.tagName!==t&&s.remove(),s||(s=globalThis.document.createElement(t),s.slot=e,this.append(s)),s}}customElements.define("a11y-details",A11yDetails);export{A11yDetails};