import{html as e,css as t}from"../../lit/index.js";import{SimpleColors as i}from"../simple-colors/simple-colors.js";class a11yCompareImage extends i{static get styles(){return[super.styles,t`
        :host {
          display: inline-flex;
          margin: 15px 0;
          --simple-range-input-track-height: 4pxsnow;
          --simple-range-input-pin-height: 20px;
          --simple-range-offet: calc(
            var(--simple-range-input-pin-height, 20px) / 2
          );
        }
        :host([hidden]) {
          display: none !important;
        }
        figure {
          margin: 0;
        }
        #container,
        #container > div {
          margin: 0;
          padding: 0;
        }
        #container,
        #input {
          position: relative;
        }
        /* Added background-size: cover to adjust the bottom layer to match top in first example */
        #container {
          background-size: cover;
          background-repeat: no-repeat;
        }

        #layer {
          top: 0;
          left: 0;
          position: absolute;
          height: 100%;
          opacity: var(--a11y-compare-image-opacity, 1);
          width: var(--a11y-compare-image-width, 50%);
          background-size: cover;
          background-position-x: 0%;
          background-repeat: no-repeat;
        }
        #placeholder {
          opacity: 0;
        }

        #bottom {
          width: 100%;
        }
        #slider {
          top: calc(0px - var(--simple-range-offet, 10px));
          left: 0;
          position: absolute;
          width: 100%;
          margin: 0;
        }
        .marker {
          z-index: 1;
          top: calc(0px - var(--simple-range-input-pin-height, 20px) / 2);
          position: absolute;
          width: 1px;
          outline: 1px solid
            var(
              --simple-range-input-bg,
              var(--simple-colors-default-theme-accent-2, grey)
            );
          background-color: var(
            --simple-range-input-color,
            var(--simple-colors-default-theme-accent-8, grey)
          );
          padding-top: var(--simple-range-input-pin-height, 20px);
        }
        #placeholder ::slotted([slot="bottom"]) {
          max-width: 100%;
        }
      `]}constructor(){super(),this.opacity=!1,this.position=50,this.accentColor="blue",this.__markers=[],this.label="Compare images",import("../simple-range-input/simple-range-input.js")}render(){return e` <figure>
      <figcaption>
        <slot name="heading"></slot>
        <div id="description"><slot name="description"></slot></div>
      </figcaption>
      <div id="container" style="background-image: url(${this.__lower})">
        <div>
          <div id="placeholder">
            <slot id="bottom" name="bottom"></slot>
          </div>
          <slot name="top" hidden></slot>
          <div id="layer" style="background-image: url(${this.__upper})"></div>
          <slot></slot>
        </div>
      </div>
      <div id="input">
        ${this.__markers.map((t=>e`
            <div
              class="marker"
              .style="left: ${t}%;"
              ?hidden="${100==t}"
            ></div>
          `))}
        <simple-range-input
          accent-color="${this.accentColor}"
          ?dark="${this.dark}"
          id="slider"
          label="${this.label}"
          @immediate-value-changed="${this._valueChanged}"
          value="${this.position}"
          immediate-value="${this.position}"
        ></simple-range-input>
      </div>
    </figure>`}_valueChanged(e){this.position=e.detail.value}static get tag(){return"a11y-compare-image"}static get properties(){return{...super.properties,activeLayer:{type:Number,attribute:"active-layer",reflect:!0},opacity:{type:Boolean},label:{type:String},position:{type:Number,reflect:!0},__lower:{type:String},__upper:{type:String},__markers:{type:Array}}}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this._slide()}updated(e){super.updated(e),e.forEach(((e,t)=>{"position"===t&&this.position!==e&&this._slide()}))}_slide(){let e=this.shadowRoot.querySelector("#container"),t=this.querySelectorAll("[slot=top],[slot=bottom]"),i=t.length-1,a=100/i,r=Math.floor(this.position/a)||0;this.activeLayer=r+1;let o=a*r;this.position;this.__upper=t[r+1]?t[r+1].src:t[r]?t[r].src:"",this.__lower=t[r]?t[r].src:"",i-1!=this.__markers.length&&this._updateMarkers(i),e&&!1===this.opacity?(e.style.setProperty("--a11y-compare-image-width",this.position+"%"),e.style.setProperty("--a11y-compare-image-opacity",1)):e&&(e.style.setProperty("--a11y-compare-image-width","100%"),e.style.setProperty("--a11y-compare-image-opacity",this.position/100))}_updateMarkers(e){if(this.__markers=[],0!=e){let t=100/e;for(let e=t;e<=100;e+=t)this.__markers.push(e)}}}customElements.define(a11yCompareImage.tag,a11yCompareImage);export{a11yCompareImage};