import{html as e,css as a}from"../../lit/index.js";import{DDD as t}from"../d-d-d/d-d-d.js";import"../simple-icon/lib/simple-icon-button-lite.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import"../simple-tooltip/simple-tooltip.js";class A11yCollapse extends t{static get styles(){return[a`
        :host {
          display: block;
          margin: var(--a11y-collapse-margin, var(--ddd-spacing-4) 0);
          border: var(--a11y-collapse-border, var(--ddd-border-sm));
          border-color: var(
            --a11y-collapse-border-color,
            var(--ddd-theme-default-coalyGray)
          );
          transition: all 0.5s cubic-bezier(0.075, 0.82, 0.165, 1);
        }
        :host([heading-button]) #heading {
          cursor: pointer;
        }
        :host(:not(:first-of-type)) {
          border-top: var(
            --a11y-collapse-border-between,
            var(--a11y-collapse-border, var(--ddd-border-xs))
          );
        }
        :host([disabled]) {
          opacity: 0.5;
        }
        *[aria-controls="content"][disabled] {
          cursor: not-allowed;
        }
        button {
          background: transparent;
          border: 0;
          padding: 0;
          margin: 0;
          width: 100%;
          text-align: left;
          font-size: var(--ddd-theme-body-font-size);
          font-family: var(--ddd-font-primary);
        }
        #heading {
          display: flex;
          justify-content: stretch;
          align-items: center;
          padding: 0
            var(
              --a11y-collapse-padding-right,
              var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
            )
            0
            var(
              --a11y-collapse-padding-left,
              var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
            );
          font-weight: var(
            --a11y-collapse-heading-font-weight,
            var(--ddd-font-weight-bold)
          );
          margin: var(--a11y-collapse-margin);
          color: var(--a11y-collapse-heading-color);

          background-color: var(--a11y-collapse-heading-background-color);
        }
        #text {
          flex-grow: 1;
          overflow: hidden;
        }
        #expand {
          transform: rotate(var(--a11y-collapse-transform-deg,0deg));
          transition: transform 0.75s ease;
        }
        #content {
          padding: var(
              --a11y-collapse-padding-top,
              var(--a11y-collapse-vertical-padding, var(--ddd-spacing-4))
            )
            var(
              --a11y-collapse-padding-right,
              var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
            )
            var(
              --a11y-collapse-padding-bottom,
              var(--a11y-collapse-vertical-padding, var(--ddd-spacing-4))
            )
            var(
              --a11y-collapse-padding-left,
              var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
            );
          border-top: var(--a11y-collapse-border, var(--ddd-border-xs));
          border-color: var(
            --a11y-collapse-border-color,
            var(--ddd-theme-default-coalyGray)
          );
        }
        @media screen {
          #expand.rotated {
            transform: rotate(var(--a11y-collapse-transform-rotated-deg, -90deg));
            transition: transform 0.75s ease;
          }
          :host #content {
            padding: 0
              var(
                --a11y-collapse-padding-right,
                var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
              )
              0
              var(
                --a11y-collapse-padding-left,
                var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
              );
            border-top: none;
            border-color: var(--a11y-collapse-border-color);
            max-height: 0;
            transition:
              visibility var(--a11y-collapse-transition-duration, 0.75s) ease,
              opacity var(--a11y-collapse-transition-duration, 0.75s) ease,
              max-height var(--a11y-collapse-transition-duration, 0.75s) ease;
            overflow-y: hidden;
            opacity: 1;
            visibility: visible;
          }
          :host #content-inner {
            max-height: 0;
            overflow-y: var(--a11y-collapse-overflow-y, hidden);
          }
          :host([expanded]) #content {
            padding: var(
                --a11y-collapse-padding-top,
                var(--a11y-collapse-vertical-padding, var(--ddd-spacing-4))
              )
              var(
                --a11y-collapse-padding-right,
                var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
              )
              var(
                --a11y-collapse-padding-bottom,
                var(--a11y-collapse-vertical-padding, var(--ddd-spacing-4))
              )
              var(
                --a11y-collapse-padding-left,
                var(--a11y-collapse-horizontal-padding, var(--ddd-spacing-4))
              );
            border-top: var(--a11y-collapse-border, var(--ddd-border-xs));
            border-color: var(
              --a11y-collapse-border-color,
              var(--ddd-theme-default-coalyGray)
            );
            max-height: 200000000000vh; /* why is this needed? */
          }
          :host([expanded]) #content-inner {
            max-height: var(--a11y-collapse-max-height, 200000000000vh);
            transition: max-height 0.75s ease;
          }
          :host(:not([expanded])) #content {
            visibility: hidden;
            opacity: 0;
            height: 0;
          }
        }
      `]}render(){return e`
      ${this.headingButton||this.accordion?this._makeHeadingButton():this._makeIconButton()}
      <div
        id="content"
        aria-hidden="${this.expanded?"false":"true"}"
        aria-labelledby="heading"
        aria-live="polite"
      >
        <div id="content-inner">
          ${this.expanded?e`<slot name="content"></slot><slot></slot>`:""}
        </div>
      </div>
    `}static get tag(){return"a11y-collapse"}static get properties(){return{headingButton:{type:Boolean,reflect:!0,attribute:"heading-button"},disabled:{type:Boolean,reflect:!0},hidden:{type:Boolean,reflect:!0},expanded:{type:Boolean,reflect:!0},icon:{type:String},iconExpanded:{type:String,attribute:"icon-expanded"},label:{type:String},heading:{type:String},labelExpanded:{type:String,attribute:"label-expanded"},tooltip:{type:String},tooltipExpanded:{type:String,attribute:"tooltip-expanded"},accordion:{type:Boolean,reflect:!0}}}constructor(){super(),this.headingButton=!1,this.accordion=!1,this.disabled=!1,this.hidden=!1,this.expanded=!1,this.heading=null,this.icon="icons:expand-more",this.label="expand",this.tooltip="expand"}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}connectedCallback(){super.connectedCallback(),setTimeout((()=>{this.dispatchEvent(new CustomEvent("a11y-collapse-attached",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}),0)}disconnectedCallback(){this.dispatchEvent(new CustomEvent("a11y-collapse-detached",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),super.disconnectedCallback()}collapse(){this.toggle(!1)}toggle(e=!this.expanded){this.expanded=e}updated(e){e.forEach(((e,a)=>{"expanded"===a&&this._fireToggleEvents()}))}_fireToggleEvents(){this.dispatchEvent(new CustomEvent("toggle",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),this.dispatchEvent(new CustomEvent("a11y-collapse-toggle",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),this.expanded?(this.dispatchEvent(new CustomEvent("expand",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),this.label="collapse",this.tooltip="collapse"):(this.dispatchEvent(new CustomEvent("collapse",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),this.label="expand",this.tooltip="expand")}_getExpanded(e,a,t){return t&&a?a:e}_makeHeadingButton(){return e`
      <button
        @click="${this._onClick}"
        aria-controls="content"
        aria-expanded="${this.expanded?"true":"false"}"
      >
        <div
          id="heading"
          part="heading-id"
          ?disabled="${this.disabled}"
          .label="${this._getExpanded(this.label,this.labelExpanded,this.expanded)}"
        >
          <div id="text">
            ${this.heading?e`<p part="heading">${this.heading}</p>`:""}<slot name="heading"></slot>
          </div>
          <simple-icon-lite
            id="expand"
            part="icon"
            class="${this.expanded||this.iconExpanded?"":"rotated"}"
            .icon="${this._getExpanded(this.icon||"icons:expand-more",this.iconExpanded,this.expanded)}"
            aria-hidden="true"
          >
          </simple-icon-lite>
        </div>
      </button>
      <simple-tooltip for="heading"
        >${this._getExpanded(this.tooltip,this.tooltipExpanded,this.expanded)}</simple-tooltip
      >
    `}_makeIconButton(){return e`
      <div id="heading" part="heading-id">
        <div id="text">
          ${this.heading?e`<p part="heading">${this.heading}</p>`:""}<slot name="heading"></slot>
        </div>
        <simple-icon-button-lite
          id="expand"
          part="icon"
          class="${this.expanded||this.iconExpanded?"":"rotated"}"
          @click="${this._onClick}"
          ?disabled="${this.disabled}"
          .label="${this._getExpanded(this.label,this.labelExpanded,this.expanded)}"
          .icon="${this._getExpanded(this.icon||"icons:expand-more",this.iconExpanded,this.expanded)}"
          aria-controls="content"
          aria-expanded="${this.expanded?"true":"false"}"
        >
        </simple-icon-button-lite>
        <simple-tooltip for="expand"
          >${this._getExpanded(this.tooltip,this.tooltipExpanded,this.expanded)}</simple-tooltip
        >
      </div>
    `}_onClick(){this.disabled||(this.toggle(),this.shadowRoot.querySelector("simple-tooltip").hide(),this.dispatchEvent(new CustomEvent("a11y-collapse-click",{bubbles:!0,cancelable:!0,composed:!0,detail:this})))}_makeAccordionButton(){this._makeHeadingButton()}}customElements.define(A11yCollapse.tag,A11yCollapse);export{A11yCollapse};