import{LitElement as t,html as e,css as i}from"../../lit/index.js";import{RadioBehaviors as o}from"../radio-behaviors/radio-behaviors.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import"./lib/a11y-carousel-button.js";class a11yCarousel extends(o(t)){static get styles(){return[i`
        :host {
          margin: 15px 0;
          --a11y-carousel-background-image: none;
        }
        ::slotted(figure) {
          margin: 0 auto;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
        }
        :host([hidden]),
        ::slotted(figure:not([active])) {
          display: none !important;
        }
        .sr-only {
          position: absolute;
          left: -99999px;
          width: 0;
          overflow: hidden;
        }
        @media screen {
          #inner {
            margin-bottom: 10px;
            position: relative;
            z-index: 2;
          }
          .buttons {
            display: flex;
            align-items: stretch;
            justify-content: center;
            z-index: 200;
          }
          a11y-carousel-button.prevnext {
            position: absolute;
            margin: 0;
            padding: 0;
            top: 0;
            bottom: 0;
            display: flex;
            flex-direction: column;
            align-items: stretch;
            justify-content: center;
            border: 0px solid transparent;
            width: 50%;
          }
          a11y-carousel-button.prevnext simple-icon-lite {
            opacity: 0;
            --simple-icon-width: 30%;
            --simple-icon-height: 30%;
            transition: 0.5s all ease-in-out;
          }
          a11y-carousel-button.prevnext:focus,
          a11y-carousel-button.prevnext:hover {
            outline: none;
          }
          a11y-carousel-button.prevnext:focus simple-icon-lite,
          a11y-carousel-button.prevnext:hover simple-icon-lite {
            opacity: 1;
            color: var(--a11y-carousel-button-background-color, black);
          }
          a11y-carousel-button[button-type="prev"] {
            left: 0;
            right: 50%;
          }
          a11y-carousel-button[button-type="next"] {
            right: 0;
            left: 50%;
            align-items: flex-end;
          }
          a11y-carousel-button.button {
            flex: 0 0 var(--a11y-carousel-button-width, 40px);
            height: var(--a11y-carousel-button-height, 10px);
            margin: var(--a11y-carousel-button-margin, 5px);
            padding: var(--a11y-carousel-button-padding, 0px);
            background-color: var(
              --a11y-carousel-button-background-color,
              black
            );
            border: var(--a11y-carousel-button-border, 1px solid black);
            border-radius: var(
              --a11y-carousel-button-border-radius,
              1px solid black
            );
          }
        }
      `]}render(){return e`
      <div><slot name="above"></slot></div>
      <div id="inner">
        <slot name="img"></slot>
        <slot></slot>
        ${this.noPrevNext?"":e`
              <a11y-carousel-button
                class="prevnext"
                button-type="prev"
                controls="${this.prev}"
                title="${this.prevLabel}"
              >
                <span class="sr-only">${this.nextLabel}</span>
                <simple-icon-lite icon="icons:chevron-left"></simple-icon-lite>
              </a11y-carousel-button>
              <a11y-carousel-button
                class="prevnext"
                button-type="next"
                controls="${this.next}"
                title="${this.nextLabel}"
              >
                <span class="sr-only">${this.nextLabel}</span>
                <simple-icon-lite icon="icons:chevron-right"></simple-icon-lite>
              </a11y-carousel-button>
            `}
      </div>
      ${this.noButtons?"":e`
            <div class="buttons">
              ${(this.itemData||[]).map((t=>e`
                  <a11y-carousel-button class="button" controls="${t.id}">
                    <span class="sr-only">${t.index+1}</span>
                  </a11y-carousel-button>
                `))}
            </div>
          `}
      <div><slot name="below"></slot></div>
    `}static get properties(){return{...super.properties,nextLabel:{type:String},noPrevNext:{type:Boolean,attribute:"no-prev-next"},noButtons:{type:Boolean,attribute:"no-buttons"},prevLabel:{type:String}}}static get tag(){return"a11y-carousel"}constructor(){super(),this.noButtons=!1,this.noPrevNext=!1,this.prevLabel="previous",this.nextLabel="next"}get __query(){return"figure"}get __selected(){return"active"}get __selectEvent(){return"select-carousel-item"}get first(){return this.itemData&&this.itemData[0]?this.itemData[0].id:void 0}get prev(){return this.itemData&&this.itemData[this.selectedIndex-1]?this.itemData[this.selectedIndex-1].id:this.first}get last(){return this.itemData&&this.itemData[this.itemData.length-1]?this.itemData[this.itemData.length-1].id:void 0}get next(){return this.itemData&&this.itemData[this.selectedIndex+1]?this.itemData[this.selectedIndex+1].id:this.last}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this._handleSelectionChange()}_getImage(){let t=this.querySelector(`figure#${this.selection} > img`)||this.querySelector("figure > img");return t?`url("${t.src}")`:void 0}_handleSelectionChange(){super._handleSelectionChange(),this._updateItemData();let t=this.querySelectorAll("a11y-carousel-button");this.style.setProperty("--a11y-carousel-background-image",this._getImage()),Object.keys(t||{}).forEach((e=>{let i=t[e];"first"===i.buttonType&&(i.controls=this.first),"prev"===i.buttonType&&(i.controls=this.prev),"next"===i.buttonType&&(i.controls=this.next),"last"===i.buttonType&&(i.controls=this.last),i.active=i.controls===this.selection}))}}customElements.define(a11yCarousel.tag,a11yCarousel);export{a11yCarousel};