/*
 * Decompiled with CFR 0.152.
 */
package project;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jfree.ui.tabbedui.VerticalLayout;
import project.MainScreen;
import project.MouseListen;
import project.MyConnection;
import project.SearchedProduct;

public class SearchScreen
extends JFrame {
    String modelNameLower;
    String modelname;
    Connection con = null;
    Statement stmt = null;
    ResultSet rs = null;
    String likeFormat;
    String likeFormatReverse;
    ArrayList<String> arrOfStr_n = new ArrayList();
    ArrayList<SearchedProduct> productList = new ArrayList();
    private JButton jButton1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel no_of_prod;

    public SearchScreen() throws SQLException {
        this.initComponents();
    }

    SearchScreen(String modelName) throws SQLException {
        this.initComponents();
        this.modelname = modelName;
        this.con = MyConnection.connection();
        this.init();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.no_of_prod = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setMinimumSize(new Dimension(492, 402));
        this.jPanel1.setLayout((LayoutManager)new VerticalLayout());
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jPanel2.setBackground(new Color(249, 246, 246));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Searched Products", 2, 0, new Font("Tahoma", 0, 18)));
        this.jButton1.setText("Back");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchScreen.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("No. of products:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 388, Short.MAX_VALUE).addComponent(this.jLabel2).addGap(39, 39, 39).addComponent(this.no_of_prod, -2, 46, -2).addGap(63, 63, 63)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(27, 27, 27).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.no_of_prod, -2, 14, -2).addComponent(this.jButton1)).addContainerGap(34, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 431, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.dispose();
            new MainScreen().setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new SearchScreen().setVisible(true);
                }
                catch (SQLException ex) {
                    Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void init() throws SQLException {
        this.modelNameLower = this.modelname.toLowerCase();
        String[] modelNameToken = this.modelNameLower.split("\\s");
        this.likeFormat = "%";
        this.likeFormatReverse = "%";
        for (String token : modelNameToken) {
            this.likeFormat = this.likeFormat + token + "%";
        }
        System.out.println("modelNameToken len: " + modelNameToken.length);
        for (int i = modelNameToken.length - 1; i >= 0; --i) {
            this.likeFormatReverse = this.likeFormatReverse + modelNameToken[i] + "%";
        }
        this.ini(this.likeFormat, this.likeFormatReverse);
    }

    private void ini(String likeForm, String likeFormReverse) {
        try {
            this.stmt = this.con.createStatement();
            try {
                this.logServerOutput(this.con, () -> this.stmt.executeUpdate("declare begin search_records('" + likeForm + "','" + likeFormReverse + "'); end;"));
                for (int i = 0; i < this.arrOfStr_n.size(); ++i) {
                    String[] recordTokens = this.arrOfStr_n.get(i).split(",");
                    this.productList.add(new SearchedProduct(Integer.parseInt(recordTokens[0]), recordTokens[1], Float.parseFloat(recordTokens[2]), recordTokens[3], recordTokens[4], recordTokens[5], recordTokens[6]));
                    this.jPanel1.add(this.productList.get(i));
                    this.productList.get(i).addMouseListener(new MouseListen(Integer.parseInt(recordTokens[0]), this));
                }
                this.no_of_prod.setText(Integer.toString(this.arrOfStr_n.size() - 1));
            }
            catch (Exception ex) {
                Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SearchScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logServerOutput(Connection conn, WhyUNoCheckedExceptionRunnable runnable) throws Exception {
        try (Statement stmt1 = conn.createStatement();){
            try {
                stmt1.executeUpdate("begin dbms_output.enable(); end;");
                runnable.run();
                try (CallableStatement call = conn.prepareCall("declare   num integer := 1000;begin   dbms_output.get_lines(?, num);end;");){
                    call.registerOutParameter(1, 2003, "DBMSOUTPUT_LINESARRAY");
                    call.execute();
                    Array array = null;
                    try {
                        array = call.getArray(1);
                        int g = (int)Stream.of((Object[])array.getArray()).count();
                        Consumer<Object> ChangeToJDBC = new Consumer<Object>(){

                            @Override
                            public void accept(Object t) {
                                String temp = String.valueOf(t);
                                SearchScreen.this.arrOfStr_n.add(temp);
                            }

                            @Override
                            public Consumer<Object> andThen(Consumer<? super Object> after) {
                                return Consumer.super.andThen(after);
                            }
                        };
                        Stream.of((Object[])array.getArray(1L, g - 1)).forEach(ChangeToJDBC);
                    }
                    finally {
                        if (array != null) {
                            System.out.println("");
                        }
                    }
                }
            }
            finally {
                stmt1.executeUpdate("begin dbms_output.disable(); end;");
            }
        }
    }

    static interface WhyUNoCheckedExceptionRunnable {
        public void run() throws Exception;
    }
}

