/*
 * Decompiled with CFR 0.152.
 */
package project;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.PopupMenu;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import project.CartScreen;
import project.CategoryScreen;
import project.MyConnection;
import project.ProfileScreen;
import project.SearchScreen;

public class MainScreen
extends JFrame {
    Connection con = null;
    Statement stmt = null;
    ArrayList<String> searchedSuggestions = new ArrayList();
    static int userId;
    SearchScreen searchScreen;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList<String> jList2;
    private JPanel jPanel1;
    private JScrollBar jScrollBar1;
    private JScrollPane jScrollPane2;
    private Menu menu1;
    private Menu menu2;
    private MenuBar menuBar1;
    private PopupMenu popupMenu1;
    private JTextField searchTextField;

    public MainScreen() throws SQLException {
        this.initComponents();
        this.con = MyConnection.connection();
        this.searchTextField.requestFocus();
        try {
            this.ini();
        }
        catch (Exception ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    MainScreen(int id) throws SQLException {
        this.initComponents();
        this.con = MyConnection.connection();
        userId = id;
        this.searchTextField.requestFocus();
        try {
            this.ini();
        }
        catch (Exception ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void ini() throws Exception {
        try {
            this.stmt = this.con.createStatement();
            this.logServerOutput(this.con, () -> this.stmt.executeUpdate("declare begin search_suggestions; end;"));
            AutoSuggestor autoSuggestor = new AutoSuggestor(this.searchTextField, (Window)this, null, Color.WHITE.brighter(), Color.BLACK.brighter(), Color.BLACK.brighter(), 0.75f){

                @Override
                boolean wordTyped(String typedWord) {
                    this.setDictionary(MainScreen.this.searchedSuggestions);
                    return super.wordTyped(typedWord);
                }
            };
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jScrollBar1 = new JScrollBar();
        this.menuBar1 = new MenuBar();
        this.menu1 = new Menu();
        this.menu2 = new Menu();
        this.popupMenu1 = new PopupMenu();
        this.jPanel1 = new JPanel();
        this.searchTextField = new JTextField();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jList2.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.menu1.setLabel("File");
        this.menuBar1.add(this.menu1);
        this.menu2.setLabel("Edit");
        this.menuBar1.add(this.menu2);
        this.popupMenu1.setLabel("popupMenu1");
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Main Screen", 2, 0, new Font("Tahoma", 0, 18)));
        this.searchTextField.setToolTipText("Enter Brand name Product name(model name)");
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainScreen.this.searchTextFieldKeyPressed(evt);
            }
        });
        this.jButton2.setText("Your Profile");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Search");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton1.setText("Go to cart");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainScreen.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/project/icons/images.jpg")));
        this.jLabel2.setAlignmentY(0.0f);
        this.jLabel2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel2MouseClicked(evt);
            }
        });
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/project/icons/laptops.jpg")));
        this.jLabel3.setAlignmentY(0.0f);
        this.jLabel3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel3MouseClicked(evt);
            }
        });
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/project/icons/headphones.jpg")));
        this.jLabel4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel4MouseClicked(evt);
            }
        });
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/project/icons/ac.jpg")));
        this.jLabel5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel5MouseClicked(evt);
            }
        });
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/project/icons/tv.jpg")));
        this.jLabel7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel7MouseClicked(evt);
            }
        });
        this.jLabel6.setText("Mobile Phones");
        this.jLabel6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel6MouseClicked(evt);
            }
        });
        this.jLabel8.setText("Laptops");
        this.jLabel8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel8MouseClicked(evt);
            }
        });
        this.jLabel9.setText("Headphones");
        this.jLabel9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel9MouseClicked(evt);
            }
        });
        this.jLabel10.setText("AC");
        this.jLabel10.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel10MouseClicked(evt);
            }
        });
        this.jLabel11.setText("TV");
        this.jLabel11.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainScreen.this.jLabel11MouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(101, 101, 101).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton2).addGap(97, 97, 97).addComponent(this.searchTextField, -2, 302, -2).addGap(52, 52, 52).addComponent(this.jButton3).addGap(38, 38, 38).addComponent(this.jButton1).addGap(0, 94, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(100, 100, 100).addComponent(this.jLabel5)).addGroup(jPanel1Layout.createSequentialGroup().addGap(102, 102, 102).addComponent(this.jLabel6))).addGap(67, 67, 67).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel8).addComponent(this.jLabel7)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2, -2, 266, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 239, -2).addGap(139, 139, 139)))).addGroup(jPanel1Layout.createSequentialGroup().addGap(133, 133, 133).addComponent(this.jLabel9).addGap(248, 248, 248).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel11).addGap(189, 189, 189)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(101, 101, 101).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.jButton3).addComponent(this.jButton2).addComponent(this.jButton1)).addGap(88, 88, 88).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 134, -2).addComponent(this.jLabel3, -2, 134, -2)).addGap(41, 41, 41).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel8)).addGap(94, 94, 94).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 38, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel11)).addGap(32, 32, 32)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            this.setVisible(false);
            this.searchScreen = new SearchScreen(this.searchTextField.getText());
            this.searchScreen.setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void searchTextFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                this.setVisible(false);
                this.searchScreen = new SearchScreen(this.searchTextField.getText());
                this.searchScreen.setVisible(true);
            }
            catch (SQLException ex) {
                Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            this.setVisible(false);
            CartScreen cartScreen = new CartScreen();
            cartScreen.setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            this.dispose();
            new ProfileScreen().setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel2MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("phone").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel3MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("laptop").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel4MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("headphone").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel5MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("ac").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel7MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("tv").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel6MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("phone").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel8MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("laptop").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel9MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("headphone").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel10MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("ac").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jLabel11MouseClicked(MouseEvent evt) {
        try {
            this.setVisible(false);
            new CategoryScreen("tv").setVisible(true);
        }
        catch (SQLException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new MainScreen().setVisible(true);
                }
                catch (SQLException ex) {
                    Logger.getLogger(MainScreen.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logServerOutput(Connection conn, WhyUNoCheckedExceptionRunnable runnable) throws Exception {
        try (Statement stmt1 = conn.createStatement();){
            try {
                stmt1.executeUpdate("begin dbms_output.enable(); end;");
                runnable.run();
                try (CallableStatement call = conn.prepareCall("declare   num integer := 1000;begin   dbms_output.get_lines(?, num);end;");){
                    call.registerOutParameter(1, 2003, "DBMSOUTPUT_LINESARRAY");
                    call.execute();
                    Array array = null;
                    try {
                        array = call.getArray(1);
                        int g = (int)Stream.of((Object[])array.getArray()).count();
                        Consumer<Object> ChangeToJDBC = new Consumer<Object>(){

                            @Override
                            public void accept(Object t) {
                                String[] arrOfStr_n;
                                String temp = String.valueOf(t);
                                for (String records : arrOfStr_n = temp.split("\n")) {
                                    MainScreen.this.searchedSuggestions.add(records);
                                }
                            }

                            @Override
                            public Consumer<Object> andThen(Consumer<? super Object> after) {
                                return Consumer.super.andThen(after);
                            }
                        };
                        Stream.of((Object[])array.getArray(1L, g - 1)).forEach(ChangeToJDBC);
                    }
                    finally {
                        if (array != null) {
                            System.out.println("");
                        }
                    }
                }
            }
            finally {
                stmt1.executeUpdate("begin dbms_output.disable(); end;");
            }
        }
    }

    static interface WhyUNoCheckedExceptionRunnable {
        public void run() throws Exception;
    }

    class SuggestionLabel
    extends JLabel {
        private boolean focused;
        private final JWindow autoSuggestionsPopUpWindow;
        private final JTextField textField;
        private final AutoSuggestor autoSuggestor;
        private Color suggestionsTextColor;
        private Color suggestionBorderColor;

        public SuggestionLabel(String string, Color borderColor, Color suggestionsTextColor, AutoSuggestor autoSuggestor) {
            super(string);
            this.focused = false;
            this.suggestionsTextColor = suggestionsTextColor;
            this.autoSuggestor = autoSuggestor;
            this.textField = autoSuggestor.getTextField();
            this.suggestionBorderColor = borderColor;
            this.autoSuggestionsPopUpWindow = autoSuggestor.getAutoSuggestionPopUpWindow();
            this.initComponent();
        }

        private void initComponent() {
            this.setFocusable(true);
            this.setForeground(this.suggestionsTextColor);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    super.mouseClicked(me);
                    SuggestionLabel.this.replaceWithSuggestedText();
                    SuggestionLabel.this.autoSuggestionsPopUpWindow.setVisible(false);
                }
            });
            this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, true), "Enter released");
            this.getActionMap().put("Enter released", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SuggestionLabel.this.replaceWithSuggestedText();
                    SuggestionLabel.this.autoSuggestionsPopUpWindow.setVisible(false);
                }
            });
        }

        public void setFocused(boolean focused) {
            if (focused) {
                this.setBorder(new LineBorder(this.suggestionBorderColor));
            } else {
                this.setBorder(null);
            }
            this.repaint();
            this.focused = focused;
        }

        public boolean isFocused() {
            return this.focused;
        }

        private void replaceWithSuggestedText() {
            String suggestedWord = this.getText();
            String text = this.textField.getText();
            String typedWord = this.autoSuggestor.getCurrentlyTypedWord();
            String t = text.substring(0, text.lastIndexOf(typedWord));
            String tmp = t + text.substring(text.lastIndexOf(typedWord)).replace(typedWord, suggestedWord);
            this.textField.setText(tmp + " ");
        }
    }

    class AutoSuggestor {
        JTextField textField;
        private final Window container;
        private JPanel suggestionsPanel;
        private JWindow autoSuggestionPopUpWindow;
        private String typedWord;
        private final ArrayList<String> dictionary = new ArrayList();
        private int currentIndexOfSpace;
        private int tW;
        private int tH;
        private DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                AutoSuggestor.this.checkForAndShowSuggestions();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                AutoSuggestor.this.checkForAndShowSuggestions();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                AutoSuggestor.this.checkForAndShowSuggestions();
            }
        };
        private final Color suggestionsTextColor;
        private final Color suggestionFocusedColor;

        public AutoSuggestor(JTextField textField, Window mainWindow, ArrayList<String> words, Color popUpBackground, Color textColor, Color suggestionFocusedColor, float opacity) {
            this.textField = textField;
            this.suggestionsTextColor = textColor;
            this.container = mainWindow;
            this.suggestionFocusedColor = suggestionFocusedColor;
            this.textField.getDocument().addDocumentListener(this.documentListener);
            this.setDictionary(words);
            this.typedWord = "";
            this.currentIndexOfSpace = 0;
            this.tW = 0;
            this.tH = 0;
            this.autoSuggestionPopUpWindow = new JWindow(mainWindow);
            this.autoSuggestionPopUpWindow.setOpacity(opacity);
            this.suggestionsPanel = new JPanel();
            this.suggestionsPanel.setLayout(new GridLayout(0, 1));
            this.suggestionsPanel.setBackground(popUpBackground);
            this.addKeyBindingToRequestFocusInPopUpWindow();
        }

        private void addKeyBindingToRequestFocusInPopUpWindow() {
            this.textField.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0, true), "Down released");
            this.textField.getActionMap().put("Down released", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    for (int i = 0; i < AutoSuggestor.this.suggestionsPanel.getComponentCount(); ++i) {
                        if (!(AutoSuggestor.this.suggestionsPanel.getComponent(i) instanceof SuggestionLabel)) continue;
                        ((SuggestionLabel)AutoSuggestor.this.suggestionsPanel.getComponent(i)).setFocused(true);
                        AutoSuggestor.this.autoSuggestionPopUpWindow.toFront();
                        AutoSuggestor.this.autoSuggestionPopUpWindow.requestFocusInWindow();
                        AutoSuggestor.this.suggestionsPanel.requestFocusInWindow();
                        AutoSuggestor.this.suggestionsPanel.getComponent(i).requestFocusInWindow();
                        break;
                    }
                }
            });
            this.suggestionsPanel.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0, true), "Down released");
            this.suggestionsPanel.getActionMap().put("Down released", new AbstractAction(){
                int lastFocusableIndex = 0;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ArrayList<SuggestionLabel> sls = AutoSuggestor.this.getAddedSuggestionLabels();
                    int max = sls.size();
                    if (max > 1) {
                        for (int i = 0; i < max; ++i) {
                            SuggestionLabel sl = sls.get(i);
                            if (sl.isFocused()) {
                                if (this.lastFocusableIndex == max - 1) {
                                    this.lastFocusableIndex = 0;
                                    sl.setFocused(false);
                                    AutoSuggestor.this.autoSuggestionPopUpWindow.setVisible(false);
                                    AutoSuggestor.this.setFocusToTextField();
                                    AutoSuggestor.this.checkForAndShowSuggestions();
                                    continue;
                                }
                                sl.setFocused(false);
                                this.lastFocusableIndex = i;
                                continue;
                            }
                            if (this.lastFocusableIndex > i || i >= max) continue;
                            sl.setFocused(true);
                            AutoSuggestor.this.autoSuggestionPopUpWindow.toFront();
                            AutoSuggestor.this.autoSuggestionPopUpWindow.requestFocusInWindow();
                            AutoSuggestor.this.suggestionsPanel.requestFocusInWindow();
                            AutoSuggestor.this.suggestionsPanel.getComponent(i).requestFocusInWindow();
                            this.lastFocusableIndex = i;
                            break;
                        }
                    } else {
                        AutoSuggestor.this.autoSuggestionPopUpWindow.setVisible(false);
                        AutoSuggestor.this.setFocusToTextField();
                        AutoSuggestor.this.checkForAndShowSuggestions();
                    }
                }
            });
        }

        private void setFocusToTextField() {
            this.container.toFront();
            this.container.requestFocusInWindow();
            this.textField.requestFocusInWindow();
        }

        public ArrayList<SuggestionLabel> getAddedSuggestionLabels() {
            ArrayList<SuggestionLabel> sls = new ArrayList<SuggestionLabel>();
            for (int i = 0; i < this.suggestionsPanel.getComponentCount(); ++i) {
                if (!(this.suggestionsPanel.getComponent(i) instanceof SuggestionLabel)) continue;
                SuggestionLabel sl = (SuggestionLabel)this.suggestionsPanel.getComponent(i);
                sls.add(sl);
            }
            return sls;
        }

        private void checkForAndShowSuggestions() {
            this.typedWord = this.getCurrentlyTypedWord();
            this.suggestionsPanel.removeAll();
            this.tW = 0;
            this.tH = 0;
            boolean added = this.wordTyped(this.typedWord);
            if (!added) {
                if (this.autoSuggestionPopUpWindow.isVisible()) {
                    this.autoSuggestionPopUpWindow.setVisible(false);
                }
            } else {
                this.showPopUpWindow();
                this.setFocusToTextField();
            }
        }

        protected void addWordToSuggestions(String word) {
            SuggestionLabel suggestionLabel = new SuggestionLabel(word, this.suggestionFocusedColor, this.suggestionsTextColor, this);
            this.calculatePopUpWindowSize(suggestionLabel);
            this.suggestionsPanel.add(suggestionLabel);
        }

        public String getCurrentlyTypedWord() {
            String text = this.textField.getText();
            String wordBeingTyped = "";
            if (text.contains(" ")) {
                int tmp = text.lastIndexOf(" ");
                if (tmp >= this.currentIndexOfSpace) {
                    this.currentIndexOfSpace = tmp;
                    wordBeingTyped = text.substring(text.lastIndexOf(" "));
                }
            } else {
                wordBeingTyped = text;
            }
            return wordBeingTyped.trim();
        }

        private void calculatePopUpWindowSize(JLabel label) {
            if (this.tW < label.getPreferredSize().width) {
                this.tW = label.getPreferredSize().width;
            }
            this.tH += label.getPreferredSize().height;
        }

        private void showPopUpWindow() {
            this.autoSuggestionPopUpWindow.getContentPane().add(this.suggestionsPanel);
            this.autoSuggestionPopUpWindow.setMinimumSize(new Dimension(this.textField.getWidth(), 30));
            this.autoSuggestionPopUpWindow.setSize(this.tW, this.tH);
            this.autoSuggestionPopUpWindow.setVisible(true);
            int windowX = 0;
            int windowY = 0;
            windowX = this.container.getX() + this.textField.getX() + 5;
            windowY = this.suggestionsPanel.getHeight() > this.autoSuggestionPopUpWindow.getMinimumSize().height ? this.container.getY() + this.textField.getY() + this.textField.getHeight() + this.autoSuggestionPopUpWindow.getMinimumSize().height : this.container.getY() + this.textField.getY() + this.textField.getHeight() + this.autoSuggestionPopUpWindow.getHeight();
            this.autoSuggestionPopUpWindow.setLocation(windowX, windowY);
            this.autoSuggestionPopUpWindow.setMinimumSize(new Dimension(this.textField.getWidth(), 30));
            this.autoSuggestionPopUpWindow.revalidate();
            this.autoSuggestionPopUpWindow.repaint();
        }

        public void setDictionary(ArrayList<String> words) {
            this.dictionary.clear();
            if (words == null) {
                return;
            }
            for (String word : words) {
                this.dictionary.add(word);
            }
        }

        public JWindow getAutoSuggestionPopUpWindow() {
            return this.autoSuggestionPopUpWindow;
        }

        public Window getContainer() {
            return this.container;
        }

        public JTextField getTextField() {
            return this.textField;
        }

        public void addToDictionary(String word) {
            this.dictionary.add(word);
        }

        boolean wordTyped(String typedWord) {
            if (typedWord.isEmpty()) {
                return false;
            }
            boolean suggestionAdded = false;
            for (String word : this.dictionary) {
                boolean fullymatches = true;
                for (int i = 0; i < typedWord.length(); ++i) {
                    if (typedWord.toLowerCase().startsWith(String.valueOf(word.toLowerCase().charAt(i)), i)) continue;
                    fullymatches = false;
                    break;
                }
                if (!fullymatches) continue;
                this.addWordToSuggestions(word);
                suggestionAdded = true;
            }
            return suggestionAdded;
        }
    }
}

