/* automatically generated by rust-bindgen 0.70.1 */

#[doc = " hb_bool_t:\n\n Data type for booleans.\n"]
pub type hb_bool_t = ::std::os::raw::c_int;
#[doc = " hb_codepoint_t:\n\n Data type for holding Unicode codepoints. Also\n used to hold glyph IDs.\n"]
pub type hb_codepoint_t = u32;
#[doc = " hb_position_t:\n\n Data type for holding a single coordinate value.\n Contour points and other multi-dimensional data are\n stored as tuples of #hb_position_t's.\n"]
pub type hb_position_t = i32;
#[doc = " hb_mask_t:\n\n Data type for bitmasks.\n"]
pub type hb_mask_t = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _hb_var_int_t {
    pub u32_: u32,
    pub i32_: i32,
    pub u16_: [u16; 2usize],
    pub i16_: [i16; 2usize],
    pub u8_: [u8; 4usize],
    pub i8_: [i8; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _hb_var_int_t"][::std::mem::size_of::<_hb_var_int_t>() - 4usize];
    ["Alignment of _hb_var_int_t"][::std::mem::align_of::<_hb_var_int_t>() - 4usize];
    ["Offset of field: _hb_var_int_t::u32_"][::std::mem::offset_of!(_hb_var_int_t, u32_) - 0usize];
    ["Offset of field: _hb_var_int_t::i32_"][::std::mem::offset_of!(_hb_var_int_t, i32_) - 0usize];
    ["Offset of field: _hb_var_int_t::u16_"][::std::mem::offset_of!(_hb_var_int_t, u16_) - 0usize];
    ["Offset of field: _hb_var_int_t::i16_"][::std::mem::offset_of!(_hb_var_int_t, i16_) - 0usize];
    ["Offset of field: _hb_var_int_t::u8_"][::std::mem::offset_of!(_hb_var_int_t, u8_) - 0usize];
    ["Offset of field: _hb_var_int_t::i8_"][::std::mem::offset_of!(_hb_var_int_t, i8_) - 0usize];
};
pub type hb_var_int_t = _hb_var_int_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _hb_var_num_t {
    pub f: f32,
    pub u32_: u32,
    pub i32_: i32,
    pub u16_: [u16; 2usize],
    pub i16_: [i16; 2usize],
    pub u8_: [u8; 4usize],
    pub i8_: [i8; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _hb_var_num_t"][::std::mem::size_of::<_hb_var_num_t>() - 4usize];
    ["Alignment of _hb_var_num_t"][::std::mem::align_of::<_hb_var_num_t>() - 4usize];
    ["Offset of field: _hb_var_num_t::f"][::std::mem::offset_of!(_hb_var_num_t, f) - 0usize];
    ["Offset of field: _hb_var_num_t::u32_"][::std::mem::offset_of!(_hb_var_num_t, u32_) - 0usize];
    ["Offset of field: _hb_var_num_t::i32_"][::std::mem::offset_of!(_hb_var_num_t, i32_) - 0usize];
    ["Offset of field: _hb_var_num_t::u16_"][::std::mem::offset_of!(_hb_var_num_t, u16_) - 0usize];
    ["Offset of field: _hb_var_num_t::i16_"][::std::mem::offset_of!(_hb_var_num_t, i16_) - 0usize];
    ["Offset of field: _hb_var_num_t::u8_"][::std::mem::offset_of!(_hb_var_num_t, u8_) - 0usize];
    ["Offset of field: _hb_var_num_t::i8_"][::std::mem::offset_of!(_hb_var_num_t, i8_) - 0usize];
};
pub type hb_var_num_t = _hb_var_num_t;
#[doc = " hb_tag_t:\n\n Data type for tag identifiers. Tags are four\n byte integers, each byte representing a character.\n\n Tags are used to identify tables, design-variation axes,\n scripts, languages, font features, and baselines with\n human-readable names.\n"]
pub type hb_tag_t = u32;
extern "C" {
    pub fn hb_tag_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_tag_t;
}
extern "C" {
    pub fn hb_tag_to_string(tag: hb_tag_t, buf: *mut ::std::os::raw::c_char);
}
pub const HB_DIRECTION_INVALID: hb_direction_t = 0;
pub const HB_DIRECTION_LTR: hb_direction_t = 4;
pub const HB_DIRECTION_RTL: hb_direction_t = 5;
pub const HB_DIRECTION_TTB: hb_direction_t = 6;
pub const HB_DIRECTION_BTT: hb_direction_t = 7;
#[doc = " hb_direction_t:\n @HB_DIRECTION_INVALID: Initial, unset direction.\n @HB_DIRECTION_LTR: Text is set horizontally from left to right.\n @HB_DIRECTION_RTL: Text is set horizontally from right to left.\n @HB_DIRECTION_TTB: Text is set vertically from top to bottom.\n @HB_DIRECTION_BTT: Text is set vertically from bottom to top.\n\n The direction of a text segment or buffer.\n\n A segment can also be tested for horizontal or vertical\n orientation (irrespective of specific direction) with\n HB_DIRECTION_IS_HORIZONTAL() or HB_DIRECTION_IS_VERTICAL().\n"]
pub type hb_direction_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_direction_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_direction_t;
}
extern "C" {
    pub fn hb_direction_to_string(direction: hb_direction_t) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_language_impl_t {
    _unused: [u8; 0],
}
#[doc = " hb_language_t:\n\n Data type for languages. Each #hb_language_t corresponds to a BCP 47\n language tag.\n"]
pub type hb_language_t = *const hb_language_impl_t;
extern "C" {
    pub fn hb_language_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_language_t;
}
extern "C" {
    pub fn hb_language_to_string(language: hb_language_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_language_get_default() -> hb_language_t;
}
extern "C" {
    pub fn hb_language_matches(language: hb_language_t, specific: hb_language_t) -> hb_bool_t;
}
pub const HB_SCRIPT_COMMON: hb_script_t = 1517910393;
pub const HB_SCRIPT_INHERITED: hb_script_t = 1516858984;
pub const HB_SCRIPT_UNKNOWN: hb_script_t = 1517976186;
pub const HB_SCRIPT_ARABIC: hb_script_t = 1098015074;
pub const HB_SCRIPT_ARMENIAN: hb_script_t = 1098018158;
pub const HB_SCRIPT_BENGALI: hb_script_t = 1113943655;
pub const HB_SCRIPT_CYRILLIC: hb_script_t = 1132032620;
pub const HB_SCRIPT_DEVANAGARI: hb_script_t = 1147500129;
pub const HB_SCRIPT_GEORGIAN: hb_script_t = 1197830002;
pub const HB_SCRIPT_GREEK: hb_script_t = 1198679403;
pub const HB_SCRIPT_GUJARATI: hb_script_t = 1198877298;
pub const HB_SCRIPT_GURMUKHI: hb_script_t = 1198879349;
pub const HB_SCRIPT_HANGUL: hb_script_t = 1214344807;
pub const HB_SCRIPT_HAN: hb_script_t = 1214344809;
pub const HB_SCRIPT_HEBREW: hb_script_t = 1214603890;
pub const HB_SCRIPT_HIRAGANA: hb_script_t = 1214870113;
pub const HB_SCRIPT_KANNADA: hb_script_t = 1265525857;
pub const HB_SCRIPT_KATAKANA: hb_script_t = 1264676449;
pub const HB_SCRIPT_LAO: hb_script_t = 1281453935;
pub const HB_SCRIPT_LATIN: hb_script_t = 1281455214;
pub const HB_SCRIPT_MALAYALAM: hb_script_t = 1298954605;
pub const HB_SCRIPT_ORIYA: hb_script_t = 1332902241;
pub const HB_SCRIPT_TAMIL: hb_script_t = 1415671148;
pub const HB_SCRIPT_TELUGU: hb_script_t = 1415933045;
pub const HB_SCRIPT_THAI: hb_script_t = 1416126825;
pub const HB_SCRIPT_TIBETAN: hb_script_t = 1416192628;
pub const HB_SCRIPT_BOPOMOFO: hb_script_t = 1114599535;
pub const HB_SCRIPT_BRAILLE: hb_script_t = 1114792297;
pub const HB_SCRIPT_CANADIAN_SYLLABICS: hb_script_t = 1130458739;
pub const HB_SCRIPT_CHEROKEE: hb_script_t = 1130915186;
pub const HB_SCRIPT_ETHIOPIC: hb_script_t = 1165256809;
pub const HB_SCRIPT_KHMER: hb_script_t = 1265134962;
pub const HB_SCRIPT_MONGOLIAN: hb_script_t = 1299148391;
pub const HB_SCRIPT_MYANMAR: hb_script_t = 1299803506;
pub const HB_SCRIPT_OGHAM: hb_script_t = 1332175213;
pub const HB_SCRIPT_RUNIC: hb_script_t = 1383427698;
pub const HB_SCRIPT_SINHALA: hb_script_t = 1399418472;
pub const HB_SCRIPT_SYRIAC: hb_script_t = 1400468067;
pub const HB_SCRIPT_THAANA: hb_script_t = 1416126817;
pub const HB_SCRIPT_YI: hb_script_t = 1500080489;
pub const HB_SCRIPT_DESERET: hb_script_t = 1148416628;
pub const HB_SCRIPT_GOTHIC: hb_script_t = 1198486632;
pub const HB_SCRIPT_OLD_ITALIC: hb_script_t = 1232363884;
pub const HB_SCRIPT_BUHID: hb_script_t = 1114990692;
pub const HB_SCRIPT_HANUNOO: hb_script_t = 1214344815;
pub const HB_SCRIPT_TAGALOG: hb_script_t = 1416064103;
pub const HB_SCRIPT_TAGBANWA: hb_script_t = 1415669602;
pub const HB_SCRIPT_CYPRIOT: hb_script_t = 1131442804;
pub const HB_SCRIPT_LIMBU: hb_script_t = 1281977698;
pub const HB_SCRIPT_LINEAR_B: hb_script_t = 1281977954;
pub const HB_SCRIPT_OSMANYA: hb_script_t = 1332964705;
pub const HB_SCRIPT_SHAVIAN: hb_script_t = 1399349623;
pub const HB_SCRIPT_TAI_LE: hb_script_t = 1415670885;
pub const HB_SCRIPT_UGARITIC: hb_script_t = 1432838514;
pub const HB_SCRIPT_BUGINESE: hb_script_t = 1114990441;
pub const HB_SCRIPT_COPTIC: hb_script_t = 1131376756;
pub const HB_SCRIPT_GLAGOLITIC: hb_script_t = 1198285159;
pub const HB_SCRIPT_KHAROSHTHI: hb_script_t = 1265131890;
pub const HB_SCRIPT_NEW_TAI_LUE: hb_script_t = 1415670901;
pub const HB_SCRIPT_OLD_PERSIAN: hb_script_t = 1483761007;
pub const HB_SCRIPT_SYLOTI_NAGRI: hb_script_t = 1400466543;
pub const HB_SCRIPT_TIFINAGH: hb_script_t = 1415999079;
pub const HB_SCRIPT_BALINESE: hb_script_t = 1113681001;
pub const HB_SCRIPT_CUNEIFORM: hb_script_t = 1483961720;
pub const HB_SCRIPT_NKO: hb_script_t = 1315663727;
pub const HB_SCRIPT_PHAGS_PA: hb_script_t = 1349017959;
pub const HB_SCRIPT_PHOENICIAN: hb_script_t = 1349021304;
pub const HB_SCRIPT_CARIAN: hb_script_t = 1130459753;
pub const HB_SCRIPT_CHAM: hb_script_t = 1130914157;
pub const HB_SCRIPT_KAYAH_LI: hb_script_t = 1264675945;
pub const HB_SCRIPT_LEPCHA: hb_script_t = 1281716323;
pub const HB_SCRIPT_LYCIAN: hb_script_t = 1283023721;
pub const HB_SCRIPT_LYDIAN: hb_script_t = 1283023977;
pub const HB_SCRIPT_OL_CHIKI: hb_script_t = 1332503403;
pub const HB_SCRIPT_REJANG: hb_script_t = 1382706791;
pub const HB_SCRIPT_SAURASHTRA: hb_script_t = 1398895986;
pub const HB_SCRIPT_SUNDANESE: hb_script_t = 1400204900;
pub const HB_SCRIPT_VAI: hb_script_t = 1449224553;
pub const HB_SCRIPT_AVESTAN: hb_script_t = 1098281844;
pub const HB_SCRIPT_BAMUM: hb_script_t = 1113681269;
pub const HB_SCRIPT_EGYPTIAN_HIEROGLYPHS: hb_script_t = 1164409200;
pub const HB_SCRIPT_IMPERIAL_ARAMAIC: hb_script_t = 1098018153;
pub const HB_SCRIPT_INSCRIPTIONAL_PAHLAVI: hb_script_t = 1349020777;
pub const HB_SCRIPT_INSCRIPTIONAL_PARTHIAN: hb_script_t = 1349678185;
pub const HB_SCRIPT_JAVANESE: hb_script_t = 1247901281;
pub const HB_SCRIPT_KAITHI: hb_script_t = 1265920105;
pub const HB_SCRIPT_LISU: hb_script_t = 1281979253;
pub const HB_SCRIPT_MEETEI_MAYEK: hb_script_t = 1299473769;
pub const HB_SCRIPT_OLD_SOUTH_ARABIAN: hb_script_t = 1398895202;
pub const HB_SCRIPT_OLD_TURKIC: hb_script_t = 1332898664;
pub const HB_SCRIPT_SAMARITAN: hb_script_t = 1398893938;
pub const HB_SCRIPT_TAI_THAM: hb_script_t = 1281453665;
pub const HB_SCRIPT_TAI_VIET: hb_script_t = 1415673460;
pub const HB_SCRIPT_BATAK: hb_script_t = 1113683051;
pub const HB_SCRIPT_BRAHMI: hb_script_t = 1114792296;
pub const HB_SCRIPT_MANDAIC: hb_script_t = 1298230884;
pub const HB_SCRIPT_CHAKMA: hb_script_t = 1130457965;
pub const HB_SCRIPT_MEROITIC_CURSIVE: hb_script_t = 1298494051;
pub const HB_SCRIPT_MEROITIC_HIEROGLYPHS: hb_script_t = 1298494063;
pub const HB_SCRIPT_MIAO: hb_script_t = 1349284452;
pub const HB_SCRIPT_SHARADA: hb_script_t = 1399353956;
pub const HB_SCRIPT_SORA_SOMPENG: hb_script_t = 1399812705;
pub const HB_SCRIPT_TAKRI: hb_script_t = 1415670642;
pub const HB_SCRIPT_BASSA_VAH: hb_script_t = 1113682803;
pub const HB_SCRIPT_CAUCASIAN_ALBANIAN: hb_script_t = 1097295970;
pub const HB_SCRIPT_DUPLOYAN: hb_script_t = 1148547180;
pub const HB_SCRIPT_ELBASAN: hb_script_t = 1164730977;
pub const HB_SCRIPT_GRANTHA: hb_script_t = 1198678382;
pub const HB_SCRIPT_KHOJKI: hb_script_t = 1265135466;
pub const HB_SCRIPT_KHUDAWADI: hb_script_t = 1399418468;
pub const HB_SCRIPT_LINEAR_A: hb_script_t = 1281977953;
pub const HB_SCRIPT_MAHAJANI: hb_script_t = 1298229354;
pub const HB_SCRIPT_MANICHAEAN: hb_script_t = 1298230889;
pub const HB_SCRIPT_MENDE_KIKAKUI: hb_script_t = 1298493028;
pub const HB_SCRIPT_MODI: hb_script_t = 1299145833;
pub const HB_SCRIPT_MRO: hb_script_t = 1299345263;
pub const HB_SCRIPT_NABATAEAN: hb_script_t = 1315070324;
pub const HB_SCRIPT_OLD_NORTH_ARABIAN: hb_script_t = 1315009122;
pub const HB_SCRIPT_OLD_PERMIC: hb_script_t = 1348825709;
pub const HB_SCRIPT_PAHAWH_HMONG: hb_script_t = 1215131239;
pub const HB_SCRIPT_PALMYRENE: hb_script_t = 1348562029;
pub const HB_SCRIPT_PAU_CIN_HAU: hb_script_t = 1348564323;
pub const HB_SCRIPT_PSALTER_PAHLAVI: hb_script_t = 1349020784;
pub const HB_SCRIPT_SIDDHAM: hb_script_t = 1399415908;
pub const HB_SCRIPT_TIRHUTA: hb_script_t = 1416196712;
pub const HB_SCRIPT_WARANG_CITI: hb_script_t = 1466004065;
pub const HB_SCRIPT_AHOM: hb_script_t = 1097363309;
pub const HB_SCRIPT_ANATOLIAN_HIEROGLYPHS: hb_script_t = 1215067511;
pub const HB_SCRIPT_HATRAN: hb_script_t = 1214346354;
pub const HB_SCRIPT_MULTANI: hb_script_t = 1299541108;
pub const HB_SCRIPT_OLD_HUNGARIAN: hb_script_t = 1215655527;
pub const HB_SCRIPT_SIGNWRITING: hb_script_t = 1399287415;
pub const HB_SCRIPT_ADLAM: hb_script_t = 1097100397;
pub const HB_SCRIPT_BHAIKSUKI: hb_script_t = 1114139507;
pub const HB_SCRIPT_MARCHEN: hb_script_t = 1298231907;
pub const HB_SCRIPT_OSAGE: hb_script_t = 1332963173;
pub const HB_SCRIPT_TANGUT: hb_script_t = 1415671399;
pub const HB_SCRIPT_NEWA: hb_script_t = 1315272545;
pub const HB_SCRIPT_MASARAM_GONDI: hb_script_t = 1198485101;
pub const HB_SCRIPT_NUSHU: hb_script_t = 1316186229;
pub const HB_SCRIPT_SOYOMBO: hb_script_t = 1399814511;
pub const HB_SCRIPT_ZANABAZAR_SQUARE: hb_script_t = 1516334690;
pub const HB_SCRIPT_DOGRA: hb_script_t = 1148151666;
pub const HB_SCRIPT_GUNJALA_GONDI: hb_script_t = 1198485095;
pub const HB_SCRIPT_HANIFI_ROHINGYA: hb_script_t = 1383032935;
pub const HB_SCRIPT_MAKASAR: hb_script_t = 1298230113;
pub const HB_SCRIPT_MEDEFAIDRIN: hb_script_t = 1298490470;
pub const HB_SCRIPT_OLD_SOGDIAN: hb_script_t = 1399809903;
pub const HB_SCRIPT_SOGDIAN: hb_script_t = 1399809892;
pub const HB_SCRIPT_ELYMAIC: hb_script_t = 1164736877;
pub const HB_SCRIPT_NANDINAGARI: hb_script_t = 1315008100;
pub const HB_SCRIPT_NYIAKENG_PUACHUE_HMONG: hb_script_t = 1215131248;
pub const HB_SCRIPT_WANCHO: hb_script_t = 1466132591;
pub const HB_SCRIPT_CHORASMIAN: hb_script_t = 1130918515;
pub const HB_SCRIPT_DIVES_AKURU: hb_script_t = 1147756907;
pub const HB_SCRIPT_KHITAN_SMALL_SCRIPT: hb_script_t = 1265202291;
pub const HB_SCRIPT_YEZIDI: hb_script_t = 1499822697;
pub const HB_SCRIPT_CYPRO_MINOAN: hb_script_t = 1131441518;
pub const HB_SCRIPT_OLD_UYGHUR: hb_script_t = 1333094258;
pub const HB_SCRIPT_TANGSA: hb_script_t = 1416524641;
pub const HB_SCRIPT_TOTO: hb_script_t = 1416590447;
pub const HB_SCRIPT_VITHKUQI: hb_script_t = 1449751656;
pub const HB_SCRIPT_MATH: hb_script_t = 1517122664;
pub const HB_SCRIPT_KAWI: hb_script_t = 1264678761;
pub const HB_SCRIPT_NAG_MUNDARI: hb_script_t = 1315006317;
pub const HB_SCRIPT_GARAY: hb_script_t = 1197568609;
pub const HB_SCRIPT_GURUNG_KHEMA: hb_script_t = 1198877544;
pub const HB_SCRIPT_KIRAT_RAI: hb_script_t = 1265787241;
pub const HB_SCRIPT_OL_ONAL: hb_script_t = 1332633967;
pub const HB_SCRIPT_SUNUWAR: hb_script_t = 1400204917;
pub const HB_SCRIPT_TODHRI: hb_script_t = 1416586354;
pub const HB_SCRIPT_TULU_TIGALARI: hb_script_t = 1416983655;
pub const HB_SCRIPT_INVALID: hb_script_t = 0;
pub const _HB_SCRIPT_MAX_VALUE: hb_script_t = 2147483647;
pub const _HB_SCRIPT_MAX_VALUE_SIGNED: hb_script_t = 2147483647;
#[doc = " hb_script_t:\n @HB_SCRIPT_COMMON: `Zyyy`\n @HB_SCRIPT_INHERITED: `Zinh`\n @HB_SCRIPT_UNKNOWN: `Zzzz`\n @HB_SCRIPT_ARABIC: `Arab`\n @HB_SCRIPT_ARMENIAN: `Armn`\n @HB_SCRIPT_BENGALI: `Beng`\n @HB_SCRIPT_CYRILLIC: `Cyrl`\n @HB_SCRIPT_DEVANAGARI: `Deva`\n @HB_SCRIPT_GEORGIAN: `Geor`\n @HB_SCRIPT_GREEK: `Grek`\n @HB_SCRIPT_GUJARATI: `Gujr`\n @HB_SCRIPT_GURMUKHI: `Guru`\n @HB_SCRIPT_HANGUL: `Hang`\n @HB_SCRIPT_HAN: `Hani`\n @HB_SCRIPT_HEBREW: `Hebr`\n @HB_SCRIPT_HIRAGANA: `Hira`\n @HB_SCRIPT_KANNADA: `Knda`\n @HB_SCRIPT_KATAKANA: `Kana`\n @HB_SCRIPT_LAO: `Laoo`\n @HB_SCRIPT_LATIN: `Latn`\n @HB_SCRIPT_MALAYALAM: `Mlym`\n @HB_SCRIPT_ORIYA: `Orya`\n @HB_SCRIPT_TAMIL: `Taml`\n @HB_SCRIPT_TELUGU: `Telu`\n @HB_SCRIPT_THAI: `Thai`\n @HB_SCRIPT_TIBETAN: `Tibt`\n @HB_SCRIPT_BOPOMOFO: `Bopo`\n @HB_SCRIPT_BRAILLE: `Brai`\n @HB_SCRIPT_CANADIAN_SYLLABICS: `Cans`\n @HB_SCRIPT_CHEROKEE: `Cher`\n @HB_SCRIPT_ETHIOPIC: `Ethi`\n @HB_SCRIPT_KHMER: `Khmr`\n @HB_SCRIPT_MONGOLIAN: `Mong`\n @HB_SCRIPT_MYANMAR: `Mymr`\n @HB_SCRIPT_OGHAM: `Ogam`\n @HB_SCRIPT_RUNIC: `Runr`\n @HB_SCRIPT_SINHALA: `Sinh`\n @HB_SCRIPT_SYRIAC: `Syrc`\n @HB_SCRIPT_THAANA: `Thaa`\n @HB_SCRIPT_YI: `Yiii`\n @HB_SCRIPT_DESERET: `Dsrt`\n @HB_SCRIPT_GOTHIC: `Goth`\n @HB_SCRIPT_OLD_ITALIC: `Ital`\n @HB_SCRIPT_BUHID: `Buhd`\n @HB_SCRIPT_HANUNOO: `Hano`\n @HB_SCRIPT_TAGALOG: `Tglg`\n @HB_SCRIPT_TAGBANWA: `Tagb`\n @HB_SCRIPT_CYPRIOT: `Cprt`\n @HB_SCRIPT_LIMBU: `Limb`\n @HB_SCRIPT_LINEAR_B: `Linb`\n @HB_SCRIPT_OSMANYA: `Osma`\n @HB_SCRIPT_SHAVIAN: `Shaw`\n @HB_SCRIPT_TAI_LE: `Tale`\n @HB_SCRIPT_UGARITIC: `Ugar`\n @HB_SCRIPT_BUGINESE: `Bugi`\n @HB_SCRIPT_COPTIC: `Copt`\n @HB_SCRIPT_GLAGOLITIC: `Glag`\n @HB_SCRIPT_KHAROSHTHI: `Khar`\n @HB_SCRIPT_NEW_TAI_LUE: `Talu`\n @HB_SCRIPT_OLD_PERSIAN: `Xpeo`\n @HB_SCRIPT_SYLOTI_NAGRI: `Sylo`\n @HB_SCRIPT_TIFINAGH: `Tfng`\n @HB_SCRIPT_BALINESE: `Bali`\n @HB_SCRIPT_CUNEIFORM: `Xsux`\n @HB_SCRIPT_NKO: `Nkoo`\n @HB_SCRIPT_PHAGS_PA: `Phag`\n @HB_SCRIPT_PHOENICIAN: `Phnx`\n @HB_SCRIPT_CARIAN: `Cari`\n @HB_SCRIPT_CHAM: `Cham`\n @HB_SCRIPT_KAYAH_LI: `Kali`\n @HB_SCRIPT_LEPCHA: `Lepc`\n @HB_SCRIPT_LYCIAN: `Lyci`\n @HB_SCRIPT_LYDIAN: `Lydi`\n @HB_SCRIPT_OL_CHIKI: `Olck`\n @HB_SCRIPT_REJANG: `Rjng`\n @HB_SCRIPT_SAURASHTRA: `Saur`\n @HB_SCRIPT_SUNDANESE: `Sund`\n @HB_SCRIPT_VAI: `Vaii`\n @HB_SCRIPT_AVESTAN: `Avst`\n @HB_SCRIPT_BAMUM: `Bamu`\n @HB_SCRIPT_EGYPTIAN_HIEROGLYPHS: `Egyp`\n @HB_SCRIPT_IMPERIAL_ARAMAIC: `Armi`\n @HB_SCRIPT_INSCRIPTIONAL_PAHLAVI: `Phli`\n @HB_SCRIPT_INSCRIPTIONAL_PARTHIAN: `Prti`\n @HB_SCRIPT_JAVANESE: `Java`\n @HB_SCRIPT_KAITHI: `Kthi`\n @HB_SCRIPT_LISU: `Lisu`\n @HB_SCRIPT_MEETEI_MAYEK: `Mtei`\n @HB_SCRIPT_OLD_SOUTH_ARABIAN: `Sarb`\n @HB_SCRIPT_OLD_TURKIC: `Orkh`\n @HB_SCRIPT_SAMARITAN: `Samr`\n @HB_SCRIPT_TAI_THAM: `Lana`\n @HB_SCRIPT_TAI_VIET: `Tavt`\n @HB_SCRIPT_BATAK: `Batk`\n @HB_SCRIPT_BRAHMI: `Brah`\n @HB_SCRIPT_MANDAIC: `Mand`\n @HB_SCRIPT_CHAKMA: `Cakm`\n @HB_SCRIPT_MEROITIC_CURSIVE: `Merc`\n @HB_SCRIPT_MEROITIC_HIEROGLYPHS: `Mero`\n @HB_SCRIPT_MIAO: `Plrd`\n @HB_SCRIPT_SHARADA: `Shrd`\n @HB_SCRIPT_SORA_SOMPENG: `Sora`\n @HB_SCRIPT_TAKRI: `Takr`\n @HB_SCRIPT_BASSA_VAH: `Bass`, Since: 0.9.30\n @HB_SCRIPT_CAUCASIAN_ALBANIAN: `Aghb`, Since: 0.9.30\n @HB_SCRIPT_DUPLOYAN: `Dupl`, Since: 0.9.30\n @HB_SCRIPT_ELBASAN: `Elba`, Since: 0.9.30\n @HB_SCRIPT_GRANTHA: `Gran`, Since: 0.9.30\n @HB_SCRIPT_KHOJKI: `Khoj`, Since: 0.9.30\n @HB_SCRIPT_KHUDAWADI: `Sind`, Since: 0.9.30\n @HB_SCRIPT_LINEAR_A: `Lina`, Since: 0.9.30\n @HB_SCRIPT_MAHAJANI: `Mahj`, Since: 0.9.30\n @HB_SCRIPT_MANICHAEAN: `Mani`, Since: 0.9.30\n @HB_SCRIPT_MENDE_KIKAKUI: `Mend`, Since: 0.9.30\n @HB_SCRIPT_MODI: `Modi`, Since: 0.9.30\n @HB_SCRIPT_MRO: `Mroo`, Since: 0.9.30\n @HB_SCRIPT_NABATAEAN: `Nbat`, Since: 0.9.30\n @HB_SCRIPT_OLD_NORTH_ARABIAN: `Narb`, Since: 0.9.30\n @HB_SCRIPT_OLD_PERMIC: `Perm`, Since: 0.9.30\n @HB_SCRIPT_PAHAWH_HMONG: `Hmng`, Since: 0.9.30\n @HB_SCRIPT_PALMYRENE: `Palm`, Since: 0.9.30\n @HB_SCRIPT_PAU_CIN_HAU: `Pauc`, Since: 0.9.30\n @HB_SCRIPT_PSALTER_PAHLAVI: `Phlp`, Since: 0.9.30\n @HB_SCRIPT_SIDDHAM: `Sidd`, Since: 0.9.30\n @HB_SCRIPT_TIRHUTA: `Tirh`, Since: 0.9.30\n @HB_SCRIPT_WARANG_CITI: `Wara`, Since: 0.9.30\n @HB_SCRIPT_AHOM: `Ahom`, Since: 0.9.30\n @HB_SCRIPT_ANATOLIAN_HIEROGLYPHS: `Hluw`, Since: 0.9.30\n @HB_SCRIPT_HATRAN: `Hatr`, Since: 0.9.30\n @HB_SCRIPT_MULTANI: `Mult`, Since: 0.9.30\n @HB_SCRIPT_OLD_HUNGARIAN: `Hung`, Since: 0.9.30\n @HB_SCRIPT_SIGNWRITING: `Sgnw`, Since: 0.9.30\n @HB_SCRIPT_ADLAM: `Adlm`, Since: 1.3.0\n @HB_SCRIPT_BHAIKSUKI: `Bhks`, Since: 1.3.0\n @HB_SCRIPT_MARCHEN: `Marc`, Since: 1.3.0\n @HB_SCRIPT_OSAGE: `Osge`, Since: 1.3.0\n @HB_SCRIPT_TANGUT: `Tang`, Since: 1.3.0\n @HB_SCRIPT_NEWA: `Newa`, Since: 1.3.0\n @HB_SCRIPT_MASARAM_GONDI: `Gonm`, Since: 1.6.0\n @HB_SCRIPT_NUSHU: `Nshu`, Since: 1.6.0\n @HB_SCRIPT_SOYOMBO: `Soyo`, Since: 1.6.0\n @HB_SCRIPT_ZANABAZAR_SQUARE: `Zanb`, Since: 1.6.0\n @HB_SCRIPT_DOGRA: `Dogr`, Since: 1.8.0\n @HB_SCRIPT_GUNJALA_GONDI: `Gong`, Since: 1.8.0\n @HB_SCRIPT_HANIFI_ROHINGYA: `Rohg`, Since: 1.8.0\n @HB_SCRIPT_MAKASAR: `Maka`, Since: 1.8.0\n @HB_SCRIPT_MEDEFAIDRIN: `Medf`, Since: 1.8.0\n @HB_SCRIPT_OLD_SOGDIAN: `Sogo`, Since: 1.8.0\n @HB_SCRIPT_SOGDIAN: `Sogd`, Since: 1.8.0\n @HB_SCRIPT_ELYMAIC: `Elym`, Since: 2.4.0\n @HB_SCRIPT_NANDINAGARI: `Nand`, Since: 2.4.0\n @HB_SCRIPT_NYIAKENG_PUACHUE_HMONG: `Hmnp`, Since: 2.4.0\n @HB_SCRIPT_WANCHO: `Wcho`, Since: 2.4.0\n @HB_SCRIPT_CHORASMIAN: `Chrs`, Since: 2.6.7\n @HB_SCRIPT_DIVES_AKURU: `Diak`, Since: 2.6.7\n @HB_SCRIPT_KHITAN_SMALL_SCRIPT: `Kits`, Since: 2.6.7\n @HB_SCRIPT_YEZIDI: `Yezi`, Since: 2.6.7\n @HB_SCRIPT_CYPRO_MINOAN: `Cpmn`, Since: 3.0.0\n @HB_SCRIPT_OLD_UYGHUR: `Ougr`, Since: 3.0.0\n @HB_SCRIPT_TANGSA: `Tnsa`, Since: 3.0.0\n @HB_SCRIPT_TOTO: `Toto`, Since: 3.0.0\n @HB_SCRIPT_VITHKUQI: `Vith`, Since: 3.0.0\n @HB_SCRIPT_MATH: `Zmth`, Since: 3.4.0\n @HB_SCRIPT_KAWI: `Kawi`, Since: 5.2.0\n @HB_SCRIPT_NAG_MUNDARI: `Nagm`, Since: 5.2.0\n @HB_SCRIPT_GARAY: `Gara`, Since: 10.0.0\n @HB_SCRIPT_GURUNG_KHEMA: `Gukh`, Since: 10.0.0\n @HB_SCRIPT_KIRAT_RAI: `Krai`, Since: 10.0.0\n @HB_SCRIPT_OL_ONAL: `Onao`, Since: 10.0.0\n @HB_SCRIPT_SUNUWAR: `Sunu`, Since: 10.0.0\n @HB_SCRIPT_TODHRI: `Todr`, Since: 10.0.0\n @HB_SCRIPT_TULU_TIGALARI: `Tutg`, Since: 10.0.0\n @HB_SCRIPT_INVALID: No script set\n\n Data type for scripts. Each #hb_script_t's value is an #hb_tag_t corresponding\n to the four-letter values defined by [ISO 15924](https://unicode.org/iso15924/).\n\n See also the Script (sc) property of the Unicode Character Database.\n"]
pub type hb_script_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_script_from_iso15924_tag(tag: hb_tag_t) -> hb_script_t;
}
extern "C" {
    pub fn hb_script_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_script_t;
}
extern "C" {
    pub fn hb_script_to_iso15924_tag(script: hb_script_t) -> hb_tag_t;
}
extern "C" {
    pub fn hb_script_get_horizontal_direction(script: hb_script_t) -> hb_direction_t;
}
#[doc = " hb_user_data_key_t:\n\n Data structure for holding user-data keys.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_user_data_key_t {
    pub unused: ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_user_data_key_t"][::std::mem::size_of::<hb_user_data_key_t>() - 1usize];
    ["Alignment of hb_user_data_key_t"][::std::mem::align_of::<hb_user_data_key_t>() - 1usize];
    ["Offset of field: hb_user_data_key_t::unused"]
        [::std::mem::offset_of!(hb_user_data_key_t, unused) - 0usize];
};
#[doc = " hb_destroy_func_t:\n @user_data: the data to be destroyed\n\n A virtual method for destroy user-data callbacks.\n"]
pub type hb_destroy_func_t =
    ::std::option::Option<unsafe extern "C" fn(user_data: *mut ::std::os::raw::c_void)>;
#[doc = " hb_feature_t:\n @tag: The #hb_tag_t tag of the feature\n @value: The value of the feature. 0 disables the feature, non-zero (usually\n 1) enables the feature.  For features implemented as lookup type 3 (like\n 'salt') the @value is a one based index into the alternates.\n @start: the cluster to start applying this feature setting (inclusive).\n @end: the cluster to end applying this feature setting (exclusive).\n\n The #hb_feature_t is the structure that holds information about requested\n feature application. The feature will be applied with the given value to all\n glyphs which are in clusters between @start (inclusive) and @end (exclusive).\n Setting start to #HB_FEATURE_GLOBAL_START and end to #HB_FEATURE_GLOBAL_END\n specifies that the feature always applies to the entire buffer."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_feature_t {
    pub tag: hb_tag_t,
    pub value: u32,
    pub start: ::std::os::raw::c_uint,
    pub end: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_feature_t"][::std::mem::size_of::<hb_feature_t>() - 16usize];
    ["Alignment of hb_feature_t"][::std::mem::align_of::<hb_feature_t>() - 4usize];
    ["Offset of field: hb_feature_t::tag"][::std::mem::offset_of!(hb_feature_t, tag) - 0usize];
    ["Offset of field: hb_feature_t::value"][::std::mem::offset_of!(hb_feature_t, value) - 4usize];
    ["Offset of field: hb_feature_t::start"][::std::mem::offset_of!(hb_feature_t, start) - 8usize];
    ["Offset of field: hb_feature_t::end"][::std::mem::offset_of!(hb_feature_t, end) - 12usize];
};
extern "C" {
    pub fn hb_feature_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        feature: *mut hb_feature_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_feature_to_string(
        feature: *mut hb_feature_t,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
#[doc = " hb_variation_t:\n @tag: The #hb_tag_t tag of the variation-axis name\n @value: The value of the variation axis\n\n Data type for holding variation data. Registered OpenType\n variation-axis tags are listed in\n [OpenType Axis Tag Registry](https://docs.microsoft.com/en-us/typography/opentype/spec/dvaraxisreg).\n\n Since: 1.4.2"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_variation_t {
    pub tag: hb_tag_t,
    pub value: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_variation_t"][::std::mem::size_of::<hb_variation_t>() - 8usize];
    ["Alignment of hb_variation_t"][::std::mem::align_of::<hb_variation_t>() - 4usize];
    ["Offset of field: hb_variation_t::tag"][::std::mem::offset_of!(hb_variation_t, tag) - 0usize];
    ["Offset of field: hb_variation_t::value"]
        [::std::mem::offset_of!(hb_variation_t, value) - 4usize];
};
extern "C" {
    pub fn hb_variation_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        variation: *mut hb_variation_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_variation_to_string(
        variation: *mut hb_variation_t,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
#[doc = " hb_color_t:\n\n Data type for holding color values. Colors are eight bits per\n channel RGB plus alpha transparency.\n\n Since: 2.1.0"]
pub type hb_color_t = u32;
extern "C" {
    pub fn hb_color_get_alpha(color: hb_color_t) -> u8;
}
extern "C" {
    pub fn hb_color_get_red(color: hb_color_t) -> u8;
}
extern "C" {
    pub fn hb_color_get_green(color: hb_color_t) -> u8;
}
extern "C" {
    pub fn hb_color_get_blue(color: hb_color_t) -> u8;
}
#[doc = " hb_glyph_extents_t:\n @x_bearing: Distance from the x-origin to the left extremum of the glyph.\n @y_bearing: Distance from the top extremum of the glyph to the y-origin.\n @width: Distance from the left extremum of the glyph to the right extremum.\n @height: Distance from the top extremum of the glyph to the bottom extremum.\n\n Glyph extent values, measured in font units.\n\n Note that @height is negative, in coordinate systems that grow up."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_glyph_extents_t {
    pub x_bearing: hb_position_t,
    pub y_bearing: hb_position_t,
    pub width: hb_position_t,
    pub height: hb_position_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_glyph_extents_t"][::std::mem::size_of::<hb_glyph_extents_t>() - 16usize];
    ["Alignment of hb_glyph_extents_t"][::std::mem::align_of::<hb_glyph_extents_t>() - 4usize];
    ["Offset of field: hb_glyph_extents_t::x_bearing"]
        [::std::mem::offset_of!(hb_glyph_extents_t, x_bearing) - 0usize];
    ["Offset of field: hb_glyph_extents_t::y_bearing"]
        [::std::mem::offset_of!(hb_glyph_extents_t, y_bearing) - 4usize];
    ["Offset of field: hb_glyph_extents_t::width"]
        [::std::mem::offset_of!(hb_glyph_extents_t, width) - 8usize];
    ["Offset of field: hb_glyph_extents_t::height"]
        [::std::mem::offset_of!(hb_glyph_extents_t, height) - 12usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_t {
    _unused: [u8; 0],
}
pub const HB_MEMORY_MODE_DUPLICATE: hb_memory_mode_t = 0;
pub const HB_MEMORY_MODE_READONLY: hb_memory_mode_t = 1;
pub const HB_MEMORY_MODE_WRITABLE: hb_memory_mode_t = 2;
pub const HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE: hb_memory_mode_t = 3;
#[doc = " hb_memory_mode_t:\n @HB_MEMORY_MODE_DUPLICATE: HarfBuzz immediately makes a copy of the data.\n @HB_MEMORY_MODE_READONLY: HarfBuzz client will never modify the data,\n     and HarfBuzz will never modify the data.\n @HB_MEMORY_MODE_WRITABLE: HarfBuzz client made a copy of the data solely\n     for HarfBuzz, so HarfBuzz may modify the data.\n @HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE: See above\n\n Data type holding the memory modes available to\n client programs.\n\n Regarding these various memory-modes:\n\n - In no case shall the HarfBuzz client modify memory\n   that is passed to HarfBuzz in a blob.  If there is\n   any such possibility, @HB_MEMORY_MODE_DUPLICATE should be used\n   such that HarfBuzz makes a copy immediately,\n\n - Use @HB_MEMORY_MODE_READONLY otherwise, unless you really really\n   really know what you are doing,\n\n - @HB_MEMORY_MODE_WRITABLE is appropriate if you really made a\n   copy of data solely for the purpose of passing to\n   HarfBuzz and doing that just once (no reuse!),\n\n - If the font is mmap()ed, it's okay to use\n   @HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE, however, using that mode\n   correctly is very tricky.  Use @HB_MEMORY_MODE_READONLY instead."]
pub type hb_memory_mode_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_blob_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_blob_create(
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_uint,
        mode: hb_memory_mode_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_create_or_fail(
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_uint,
        mode: hb_memory_mode_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_create_from_file(file_name: *const ::std::os::raw::c_char) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_create_from_file_or_fail(
        file_name: *const ::std::os::raw::c_char,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_create_sub_blob(
        parent: *mut hb_blob_t,
        offset: ::std::os::raw::c_uint,
        length: ::std::os::raw::c_uint,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_copy_writable_or_fail(blob: *mut hb_blob_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_get_empty() -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_reference(blob: *mut hb_blob_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_destroy(blob: *mut hb_blob_t);
}
extern "C" {
    pub fn hb_blob_set_user_data(
        blob: *mut hb_blob_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_blob_get_user_data(
        blob: *const hb_blob_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_blob_make_immutable(blob: *mut hb_blob_t);
}
extern "C" {
    pub fn hb_blob_is_immutable(blob: *mut hb_blob_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_blob_get_length(blob: *mut hb_blob_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_blob_get_data(
        blob: *mut hb_blob_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_blob_get_data_writable(
        blob: *mut hb_blob_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
pub const HB_UNICODE_GENERAL_CATEGORY_CONTROL: hb_unicode_general_category_t = 0;
pub const HB_UNICODE_GENERAL_CATEGORY_FORMAT: hb_unicode_general_category_t = 1;
pub const HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED: hb_unicode_general_category_t = 2;
pub const HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE: hb_unicode_general_category_t = 3;
pub const HB_UNICODE_GENERAL_CATEGORY_SURROGATE: hb_unicode_general_category_t = 4;
pub const HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER: hb_unicode_general_category_t = 5;
pub const HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER: hb_unicode_general_category_t = 6;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER: hb_unicode_general_category_t = 7;
pub const HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER: hb_unicode_general_category_t = 8;
pub const HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER: hb_unicode_general_category_t = 9;
pub const HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK: hb_unicode_general_category_t = 10;
pub const HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK: hb_unicode_general_category_t = 11;
pub const HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK: hb_unicode_general_category_t = 12;
pub const HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER: hb_unicode_general_category_t = 13;
pub const HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER: hb_unicode_general_category_t = 14;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER: hb_unicode_general_category_t = 15;
pub const HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION: hb_unicode_general_category_t = 16;
pub const HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION: hb_unicode_general_category_t = 17;
pub const HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION: hb_unicode_general_category_t = 18;
pub const HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION: hb_unicode_general_category_t = 19;
pub const HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION: hb_unicode_general_category_t = 20;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION: hb_unicode_general_category_t = 21;
pub const HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION: hb_unicode_general_category_t = 22;
pub const HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL: hb_unicode_general_category_t = 23;
pub const HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL: hb_unicode_general_category_t = 24;
pub const HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL: hb_unicode_general_category_t = 25;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL: hb_unicode_general_category_t = 26;
pub const HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR: hb_unicode_general_category_t = 27;
pub const HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR: hb_unicode_general_category_t = 28;
pub const HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR: hb_unicode_general_category_t = 29;
#[doc = " hb_unicode_general_category_t:\n @HB_UNICODE_GENERAL_CATEGORY_CONTROL:              [Cc]\n @HB_UNICODE_GENERAL_CATEGORY_FORMAT:\t\t      [Cf]\n @HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED:\t      [Cn]\n @HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE:\t      [Co]\n @HB_UNICODE_GENERAL_CATEGORY_SURROGATE:\t      [Cs]\n @HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER:     [Ll]\n @HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER:      [Lm]\n @HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER:\t      [Lo]\n @HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER:     [Lt]\n @HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER:     [Lu]\n @HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK:\t      [Mc]\n @HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK:\t      [Me]\n @HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK:     [Mn]\n @HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER:\t      [Nd]\n @HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER:\t      [Nl]\n @HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER:\t      [No]\n @HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION:  [Pc]\n @HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION:     [Pd]\n @HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION:    [Pe]\n @HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION:    [Pf]\n @HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION:  [Pi]\n @HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION:    [Po]\n @HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION:     [Ps]\n @HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL:      [Sc]\n @HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL:      [Sk]\n @HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL:\t      [Sm]\n @HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL:\t      [So]\n @HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR:\t      [Zl]\n @HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR:  [Zp]\n @HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR:      [Zs]\n\n Data type for the \"General_Category\" (gc) property from\n the Unicode Character Database."]
pub type hb_unicode_general_category_t = ::std::os::raw::c_uint;
pub const HB_UNICODE_COMBINING_CLASS_NOT_REORDERED: hb_unicode_combining_class_t = 0;
pub const HB_UNICODE_COMBINING_CLASS_OVERLAY: hb_unicode_combining_class_t = 1;
pub const HB_UNICODE_COMBINING_CLASS_NUKTA: hb_unicode_combining_class_t = 7;
pub const HB_UNICODE_COMBINING_CLASS_KANA_VOICING: hb_unicode_combining_class_t = 8;
pub const HB_UNICODE_COMBINING_CLASS_VIRAMA: hb_unicode_combining_class_t = 9;
pub const HB_UNICODE_COMBINING_CLASS_CCC10: hb_unicode_combining_class_t = 10;
pub const HB_UNICODE_COMBINING_CLASS_CCC11: hb_unicode_combining_class_t = 11;
pub const HB_UNICODE_COMBINING_CLASS_CCC12: hb_unicode_combining_class_t = 12;
pub const HB_UNICODE_COMBINING_CLASS_CCC13: hb_unicode_combining_class_t = 13;
pub const HB_UNICODE_COMBINING_CLASS_CCC14: hb_unicode_combining_class_t = 14;
pub const HB_UNICODE_COMBINING_CLASS_CCC15: hb_unicode_combining_class_t = 15;
pub const HB_UNICODE_COMBINING_CLASS_CCC16: hb_unicode_combining_class_t = 16;
pub const HB_UNICODE_COMBINING_CLASS_CCC17: hb_unicode_combining_class_t = 17;
pub const HB_UNICODE_COMBINING_CLASS_CCC18: hb_unicode_combining_class_t = 18;
pub const HB_UNICODE_COMBINING_CLASS_CCC19: hb_unicode_combining_class_t = 19;
pub const HB_UNICODE_COMBINING_CLASS_CCC20: hb_unicode_combining_class_t = 20;
pub const HB_UNICODE_COMBINING_CLASS_CCC21: hb_unicode_combining_class_t = 21;
pub const HB_UNICODE_COMBINING_CLASS_CCC22: hb_unicode_combining_class_t = 22;
pub const HB_UNICODE_COMBINING_CLASS_CCC23: hb_unicode_combining_class_t = 23;
pub const HB_UNICODE_COMBINING_CLASS_CCC24: hb_unicode_combining_class_t = 24;
pub const HB_UNICODE_COMBINING_CLASS_CCC25: hb_unicode_combining_class_t = 25;
pub const HB_UNICODE_COMBINING_CLASS_CCC26: hb_unicode_combining_class_t = 26;
pub const HB_UNICODE_COMBINING_CLASS_CCC27: hb_unicode_combining_class_t = 27;
pub const HB_UNICODE_COMBINING_CLASS_CCC28: hb_unicode_combining_class_t = 28;
pub const HB_UNICODE_COMBINING_CLASS_CCC29: hb_unicode_combining_class_t = 29;
pub const HB_UNICODE_COMBINING_CLASS_CCC30: hb_unicode_combining_class_t = 30;
pub const HB_UNICODE_COMBINING_CLASS_CCC31: hb_unicode_combining_class_t = 31;
pub const HB_UNICODE_COMBINING_CLASS_CCC32: hb_unicode_combining_class_t = 32;
pub const HB_UNICODE_COMBINING_CLASS_CCC33: hb_unicode_combining_class_t = 33;
pub const HB_UNICODE_COMBINING_CLASS_CCC34: hb_unicode_combining_class_t = 34;
pub const HB_UNICODE_COMBINING_CLASS_CCC35: hb_unicode_combining_class_t = 35;
pub const HB_UNICODE_COMBINING_CLASS_CCC36: hb_unicode_combining_class_t = 36;
pub const HB_UNICODE_COMBINING_CLASS_CCC84: hb_unicode_combining_class_t = 84;
pub const HB_UNICODE_COMBINING_CLASS_CCC91: hb_unicode_combining_class_t = 91;
pub const HB_UNICODE_COMBINING_CLASS_CCC103: hb_unicode_combining_class_t = 103;
pub const HB_UNICODE_COMBINING_CLASS_CCC107: hb_unicode_combining_class_t = 107;
pub const HB_UNICODE_COMBINING_CLASS_CCC118: hb_unicode_combining_class_t = 118;
pub const HB_UNICODE_COMBINING_CLASS_CCC122: hb_unicode_combining_class_t = 122;
pub const HB_UNICODE_COMBINING_CLASS_CCC129: hb_unicode_combining_class_t = 129;
pub const HB_UNICODE_COMBINING_CLASS_CCC130: hb_unicode_combining_class_t = 130;
pub const HB_UNICODE_COMBINING_CLASS_CCC132: hb_unicode_combining_class_t = 132;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT: hb_unicode_combining_class_t = 200;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW: hb_unicode_combining_class_t = 202;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE: hb_unicode_combining_class_t = 214;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT: hb_unicode_combining_class_t = 216;
pub const HB_UNICODE_COMBINING_CLASS_BELOW_LEFT: hb_unicode_combining_class_t = 218;
pub const HB_UNICODE_COMBINING_CLASS_BELOW: hb_unicode_combining_class_t = 220;
pub const HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT: hb_unicode_combining_class_t = 222;
pub const HB_UNICODE_COMBINING_CLASS_LEFT: hb_unicode_combining_class_t = 224;
pub const HB_UNICODE_COMBINING_CLASS_RIGHT: hb_unicode_combining_class_t = 226;
pub const HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT: hb_unicode_combining_class_t = 228;
pub const HB_UNICODE_COMBINING_CLASS_ABOVE: hb_unicode_combining_class_t = 230;
pub const HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT: hb_unicode_combining_class_t = 232;
pub const HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW: hb_unicode_combining_class_t = 233;
pub const HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE: hb_unicode_combining_class_t = 234;
pub const HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT: hb_unicode_combining_class_t = 240;
pub const HB_UNICODE_COMBINING_CLASS_INVALID: hb_unicode_combining_class_t = 255;
#[doc = " hb_unicode_combining_class_t:\n @HB_UNICODE_COMBINING_CLASS_NOT_REORDERED: Spacing and enclosing marks; also many vowel and consonant signs, even if nonspacing\n @HB_UNICODE_COMBINING_CLASS_OVERLAY: Marks which overlay a base letter or symbol\n @HB_UNICODE_COMBINING_CLASS_NUKTA: Diacritic nukta marks in Brahmi-derived scripts\n @HB_UNICODE_COMBINING_CLASS_KANA_VOICING: Hiragana/Katakana voicing marks\n @HB_UNICODE_COMBINING_CLASS_VIRAMA: Viramas\n @HB_UNICODE_COMBINING_CLASS_CCC10: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC11: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC12: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC13: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC14: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC15: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC16: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC17: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC18: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC19: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC20: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC21: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC22: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC23: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC24: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC25: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC26: [Hebrew]\n @HB_UNICODE_COMBINING_CLASS_CCC27: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC28: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC29: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC30: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC31: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC32: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC33: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC34: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC35: [Arabic]\n @HB_UNICODE_COMBINING_CLASS_CCC36: [Syriac]\n @HB_UNICODE_COMBINING_CLASS_CCC84: [Telugu]\n @HB_UNICODE_COMBINING_CLASS_CCC91: [Telugu]\n @HB_UNICODE_COMBINING_CLASS_CCC103: [Thai]\n @HB_UNICODE_COMBINING_CLASS_CCC107: [Thai]\n @HB_UNICODE_COMBINING_CLASS_CCC118: [Lao]\n @HB_UNICODE_COMBINING_CLASS_CCC122: [Lao]\n @HB_UNICODE_COMBINING_CLASS_CCC129: [Tibetan]\n @HB_UNICODE_COMBINING_CLASS_CCC130: [Tibetan]\n @HB_UNICODE_COMBINING_CLASS_CCC132: [Tibetan] Since: 7.2.0\n @HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT: Marks attached at the bottom left\n @HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW: Marks attached directly below\n @HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE: Marks attached directly above\n @HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT: Marks attached at the top right\n @HB_UNICODE_COMBINING_CLASS_BELOW_LEFT: Distinct marks at the bottom left\n @HB_UNICODE_COMBINING_CLASS_BELOW: Distinct marks directly below\n @HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT: Distinct marks at the bottom right\n @HB_UNICODE_COMBINING_CLASS_LEFT: Distinct marks to the left\n @HB_UNICODE_COMBINING_CLASS_RIGHT: Distinct marks to the right\n @HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT: Distinct marks at the top left\n @HB_UNICODE_COMBINING_CLASS_ABOVE: Distinct marks directly above\n @HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT: Distinct marks at the top right\n @HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW: Distinct marks subtending two bases\n @HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE: Distinct marks extending above two bases\n @HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT: Greek iota subscript only\n @HB_UNICODE_COMBINING_CLASS_INVALID: Invalid combining class\n\n Data type for the Canonical_Combining_Class (ccc) property\n from the Unicode Character Database.\n\n <note>Note: newer versions of Unicode may add new values.\n Client programs should be ready to handle any value in the 0..254 range\n being returned from hb_unicode_combining_class().</note>\n"]
pub type hb_unicode_combining_class_t = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_unicode_funcs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_unicode_funcs_get_default() -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_create(parent: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_get_empty() -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_reference(ufuncs: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_destroy(ufuncs: *mut hb_unicode_funcs_t);
}
extern "C" {
    pub fn hb_unicode_funcs_set_user_data(
        ufuncs: *mut hb_unicode_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_unicode_funcs_get_user_data(
        ufuncs: *const hb_unicode_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_unicode_funcs_make_immutable(ufuncs: *mut hb_unicode_funcs_t);
}
extern "C" {
    pub fn hb_unicode_funcs_is_immutable(ufuncs: *mut hb_unicode_funcs_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_unicode_funcs_get_parent(ufuncs: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
#[doc = " hb_unicode_combining_class_func_t:\n @ufuncs: A Unicode-functions structure\n @unicode: The code point to query\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n This method should retrieve the Canonical Combining Class (ccc)\n property for a specified Unicode code point.\n\n Return value: The #hb_unicode_combining_class_t of @unicode\n"]
pub type hb_unicode_combining_class_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_unicode_combining_class_t,
>;
#[doc = " hb_unicode_general_category_func_t:\n @ufuncs: A Unicode-functions structure\n @unicode: The code point to query\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n This method should retrieve the General Category property for\n a specified Unicode code point.\n\n Return value: The #hb_unicode_general_category_t of @unicode\n"]
pub type hb_unicode_general_category_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_unicode_general_category_t,
>;
#[doc = " hb_unicode_mirroring_func_t:\n @ufuncs: A Unicode-functions structure\n @unicode: The code point to query\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n This method should retrieve the Bi-Directional Mirroring Glyph\n code point for a specified Unicode code point.\n\n <note>Note: If a code point does not have a specified\n Bi-Directional Mirroring Glyph defined, the method should\n return the original code point.</note>\n\n Return value: The #hb_codepoint_t of the Mirroring Glyph for @unicode\n"]
pub type hb_unicode_mirroring_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_codepoint_t,
>;
#[doc = " hb_unicode_script_func_t:\n @ufuncs: A Unicode-functions structure\n @unicode: The code point to query\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n This method should retrieve the Script property for a\n specified Unicode code point.\n\n Return value: The #hb_script_t of @unicode\n"]
pub type hb_unicode_script_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_script_t,
>;
#[doc = " hb_unicode_compose_func_t:\n @ufuncs: A Unicode-functions structure\n @a: The first code point to compose\n @b: The second code point to compose\n @ab: (out): The composed code point\n @user_data: user data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n This method should compose a sequence of two input Unicode code\n points by canonical equivalence, returning the composed code\n point in a #hb_codepoint_t output parameter (if successful).\n The method must return an #hb_bool_t indicating the success\n of the composition.\n\n Return value: `true` is @a,@b composed, `false` otherwise\n"]
pub type hb_unicode_compose_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        a: hb_codepoint_t,
        b: hb_codepoint_t,
        ab: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_unicode_decompose_func_t:\n @ufuncs: A Unicode-functions structure\n @ab: The code point to decompose\n @a: (out): The first decomposed code point\n @b: (out): The second decomposed code point\n @user_data: user data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n This method should decompose an input Unicode code point,\n returning the two decomposed code points in #hb_codepoint_t\n output parameters (if successful). The method must return an\n #hb_bool_t indicating the success of the composition.\n\n Return value: `true` if @ab decomposed, `false` otherwise\n"]
pub type hb_unicode_decompose_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        ab: hb_codepoint_t,
        a: *mut hb_codepoint_t,
        b: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    #[doc = " hb_unicode_funcs_set_combining_class_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_combining_class_func_t.\n\n Since: 0.9.2"]
    pub fn hb_unicode_funcs_set_combining_class_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_combining_class_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_funcs_set_general_category_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_general_category_func_t.\n\n Since: 0.9.2"]
    pub fn hb_unicode_funcs_set_general_category_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_general_category_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_funcs_set_mirroring_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_mirroring_func_t.\n\n Since: 0.9.2"]
    pub fn hb_unicode_funcs_set_mirroring_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_mirroring_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_funcs_set_script_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_script_func_t.\n\n Since: 0.9.2"]
    pub fn hb_unicode_funcs_set_script_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_script_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_funcs_set_compose_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_compose_func_t.\n\n Since: 0.9.2"]
    pub fn hb_unicode_funcs_set_compose_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_compose_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_funcs_set_decompose_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_decompose_func_t.\n\n Since: 0.9.2"]
    pub fn hb_unicode_funcs_set_decompose_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_decompose_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_combining_class:\n @ufuncs: The Unicode-functions structure\n @unicode: The code point to query\n\n Retrieves the Canonical Combining Class (ccc) property\n of code point @unicode.\n\n Return value: The #hb_unicode_combining_class_t of @unicode\n\n Since: 0.9.2"]
    pub fn hb_unicode_combining_class(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_unicode_combining_class_t;
}
extern "C" {
    #[doc = " hb_unicode_general_category:\n @ufuncs: The Unicode-functions structure\n @unicode: The code point to query\n\n Retrieves the General Category (gc) property\n of code point @unicode.\n\n Return value: The #hb_unicode_general_category_t of @unicode\n\n Since: 0.9.2"]
    pub fn hb_unicode_general_category(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_unicode_general_category_t;
}
extern "C" {
    #[doc = " hb_unicode_mirroring:\n @ufuncs: The Unicode-functions structure\n @unicode: The code point to query\n\n Retrieves the Bi-directional Mirroring Glyph code\n point defined for code point @unicode.\n\n Return value: The #hb_codepoint_t of the Mirroring Glyph for @unicode\n\n Since: 0.9.2"]
    pub fn hb_unicode_mirroring(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_codepoint_t;
}
extern "C" {
    #[doc = " hb_unicode_script:\n @ufuncs: The Unicode-functions structure\n @unicode: The code point to query\n\n Retrieves the #hb_script_t script to which code\n point @unicode belongs.\n\n Return value: The #hb_script_t of @unicode\n\n Since: 0.9.2"]
    pub fn hb_unicode_script(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_script_t;
}
extern "C" {
    pub fn hb_unicode_compose(
        ufuncs: *mut hb_unicode_funcs_t,
        a: hb_codepoint_t,
        b: hb_codepoint_t,
        ab: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_unicode_decompose(
        ufuncs: *mut hb_unicode_funcs_t,
        ab: hb_codepoint_t,
        a: *mut hb_codepoint_t,
        b: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_set_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_set_create() -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_get_empty() -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_reference(set: *mut hb_set_t) -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_destroy(set: *mut hb_set_t);
}
extern "C" {
    pub fn hb_set_set_user_data(
        set: *mut hb_set_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_get_user_data(
        set: *const hb_set_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_set_allocation_successful(set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_copy(set: *const hb_set_t) -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_clear(set: *mut hb_set_t);
}
extern "C" {
    pub fn hb_set_is_empty(set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_invert(set: *mut hb_set_t);
}
extern "C" {
    pub fn hb_set_is_inverted(set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_has(set: *const hb_set_t, codepoint: hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_add(set: *mut hb_set_t, codepoint: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_add_range(set: *mut hb_set_t, first: hb_codepoint_t, last: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_add_sorted_array(
        set: *mut hb_set_t,
        sorted_codepoints: *const hb_codepoint_t,
        num_codepoints: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_set_del(set: *mut hb_set_t, codepoint: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_del_range(set: *mut hb_set_t, first: hb_codepoint_t, last: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_is_equal(set: *const hb_set_t, other: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_hash(set: *const hb_set_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_set_is_subset(set: *const hb_set_t, larger_set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_set(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_union(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_intersect(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_subtract(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_symmetric_difference(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_get_population(set: *const hb_set_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_set_get_min(set: *const hb_set_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_set_get_max(set: *const hb_set_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_set_next(set: *const hb_set_t, codepoint: *mut hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_previous(set: *const hb_set_t, codepoint: *mut hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_next_range(
        set: *const hb_set_t,
        first: *mut hb_codepoint_t,
        last: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_previous_range(
        set: *const hb_set_t,
        first: *mut hb_codepoint_t,
        last: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_next_many(
        set: *const hb_set_t,
        codepoint: hb_codepoint_t,
        out: *mut hb_codepoint_t,
        size: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_map_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_map_create() -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_get_empty() -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_reference(map: *mut hb_map_t) -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_destroy(map: *mut hb_map_t);
}
extern "C" {
    pub fn hb_map_set_user_data(
        map: *mut hb_map_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_get_user_data(
        map: *const hb_map_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_map_allocation_successful(map: *const hb_map_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_copy(map: *const hb_map_t) -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_clear(map: *mut hb_map_t);
}
extern "C" {
    pub fn hb_map_is_empty(map: *const hb_map_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_get_population(map: *const hb_map_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_map_is_equal(map: *const hb_map_t, other: *const hb_map_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_hash(map: *const hb_map_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_map_set(map: *mut hb_map_t, key: hb_codepoint_t, value: hb_codepoint_t);
}
extern "C" {
    pub fn hb_map_get(map: *const hb_map_t, key: hb_codepoint_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_map_del(map: *mut hb_map_t, key: hb_codepoint_t);
}
extern "C" {
    pub fn hb_map_has(map: *const hb_map_t, key: hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_update(map: *mut hb_map_t, other: *const hb_map_t);
}
extern "C" {
    pub fn hb_map_next(
        map: *const hb_map_t,
        idx: *mut ::std::os::raw::c_int,
        key: *mut hb_codepoint_t,
        value: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_keys(map: *const hb_map_t, keys: *mut hb_set_t);
}
extern "C" {
    pub fn hb_map_values(map: *const hb_map_t, values: *mut hb_set_t);
}
extern "C" {
    pub fn hb_face_count(blob: *mut hb_blob_t) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_face_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_face_create(blob: *mut hb_blob_t, index: ::std::os::raw::c_uint) -> *mut hb_face_t;
}
#[doc = " hb_reference_table_func_t:\n @face: an #hb_face_t to reference table for\n @tag: the tag of the table to reference\n @user_data: User data pointer passed by the caller\n\n Callback function for hb_face_create_for_tables().\n\n Return value: (transfer full): A pointer to the @tag table within @face\n\n Since: 0.9.2"]
pub type hb_reference_table_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        face: *mut hb_face_t,
        tag: hb_tag_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> *mut hb_blob_t,
>;
extern "C" {
    pub fn hb_face_create_for_tables(
        reference_table_func: hb_reference_table_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_get_empty() -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_reference(face: *mut hb_face_t) -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_destroy(face: *mut hb_face_t);
}
extern "C" {
    pub fn hb_face_set_user_data(
        face: *mut hb_face_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_face_get_user_data(
        face: *const hb_face_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_face_make_immutable(face: *mut hb_face_t);
}
extern "C" {
    pub fn hb_face_is_immutable(face: *const hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_face_reference_table(face: *const hb_face_t, tag: hb_tag_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_face_reference_blob(face: *mut hb_face_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_face_set_index(face: *mut hb_face_t, index: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_face_get_index(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_set_upem(face: *mut hb_face_t, upem: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_face_get_upem(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_set_glyph_count(face: *mut hb_face_t, glyph_count: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_face_get_glyph_count(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
#[doc = " hb_get_table_tags_func_t:\n @face: A face object\n @start_offset: The index of first table tag to retrieve\n @table_count: (inout): Input = the maximum number of table tags to return;\n                Output = the actual number of table tags returned (may be zero)\n @table_tags: (out) (array length=table_count): The array of table tags found\n @user_data: User data pointer passed by the caller\n\n Callback function for hb_face_get_table_tags().\n\n Return value: Total number of tables, or zero if it is not possible to list\n\n Since: 10.0.0"]
pub type hb_get_table_tags_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        face: *const hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        table_count: *mut ::std::os::raw::c_uint,
        table_tags: *mut hb_tag_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
extern "C" {
    pub fn hb_face_set_get_table_tags_func(
        face: *mut hb_face_t,
        func: hb_get_table_tags_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_face_get_table_tags(
        face: *const hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        table_count: *mut ::std::os::raw::c_uint,
        table_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_collect_unicodes(face: *mut hb_face_t, out: *mut hb_set_t);
}
extern "C" {
    pub fn hb_face_collect_nominal_glyph_mapping(
        face: *mut hb_face_t,
        mapping: *mut hb_map_t,
        unicodes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_face_collect_variation_selectors(face: *mut hb_face_t, out: *mut hb_set_t);
}
extern "C" {
    pub fn hb_face_collect_variation_unicodes(
        face: *mut hb_face_t,
        variation_selector: hb_codepoint_t,
        out: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_face_builder_create() -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_builder_add_table(
        face: *mut hb_face_t,
        tag: hb_tag_t,
        blob: *mut hb_blob_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_face_builder_sort_tables(face: *mut hb_face_t, tags: *const hb_tag_t);
}
#[doc = " hb_draw_state_t\n @path_open: Whether there is an open path\n @path_start_x: X component of the start of current path\n @path_start_y: Y component of the start of current path\n @current_x: X component of current point\n @current_y: Y component of current point\n\n Current drawing state.\n\n Since: 4.0.0"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_draw_state_t {
    pub path_open: hb_bool_t,
    pub path_start_x: f32,
    pub path_start_y: f32,
    pub current_x: f32,
    pub current_y: f32,
    pub reserved1: hb_var_num_t,
    pub reserved2: hb_var_num_t,
    pub reserved3: hb_var_num_t,
    pub reserved4: hb_var_num_t,
    pub reserved5: hb_var_num_t,
    pub reserved6: hb_var_num_t,
    pub reserved7: hb_var_num_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_draw_state_t"][::std::mem::size_of::<hb_draw_state_t>() - 48usize];
    ["Alignment of hb_draw_state_t"][::std::mem::align_of::<hb_draw_state_t>() - 4usize];
    ["Offset of field: hb_draw_state_t::path_open"]
        [::std::mem::offset_of!(hb_draw_state_t, path_open) - 0usize];
    ["Offset of field: hb_draw_state_t::path_start_x"]
        [::std::mem::offset_of!(hb_draw_state_t, path_start_x) - 4usize];
    ["Offset of field: hb_draw_state_t::path_start_y"]
        [::std::mem::offset_of!(hb_draw_state_t, path_start_y) - 8usize];
    ["Offset of field: hb_draw_state_t::current_x"]
        [::std::mem::offset_of!(hb_draw_state_t, current_x) - 12usize];
    ["Offset of field: hb_draw_state_t::current_y"]
        [::std::mem::offset_of!(hb_draw_state_t, current_y) - 16usize];
    ["Offset of field: hb_draw_state_t::reserved1"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved1) - 20usize];
    ["Offset of field: hb_draw_state_t::reserved2"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved2) - 24usize];
    ["Offset of field: hb_draw_state_t::reserved3"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved3) - 28usize];
    ["Offset of field: hb_draw_state_t::reserved4"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved4) - 32usize];
    ["Offset of field: hb_draw_state_t::reserved5"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved5) - 36usize];
    ["Offset of field: hb_draw_state_t::reserved6"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved6) - 40usize];
    ["Offset of field: hb_draw_state_t::reserved7"]
        [::std::mem::offset_of!(hb_draw_state_t, reserved7) - 44usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_draw_funcs_t {
    _unused: [u8; 0],
}
#[doc = " hb_draw_move_to_func_t:\n @dfuncs: draw functions object\n @draw_data: The data accompanying the draw functions in hb_font_draw_glyph()\n @st: current draw state\n @to_x: X component of target point\n @to_y: Y component of target point\n @user_data: User data pointer passed to hb_draw_funcs_set_move_to_func()\n\n A virtual method for the #hb_draw_funcs_t to perform a \"move-to\" draw\n operation.\n\n Since: 4.0.0\n"]
pub type hb_draw_move_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_draw_line_to_func_t:\n @dfuncs: draw functions object\n @draw_data: The data accompanying the draw functions in hb_font_draw_glyph()\n @st: current draw state\n @to_x: X component of target point\n @to_y: Y component of target point\n @user_data: User data pointer passed to hb_draw_funcs_set_line_to_func()\n\n A virtual method for the #hb_draw_funcs_t to perform a \"line-to\" draw\n operation.\n\n Since: 4.0.0\n"]
pub type hb_draw_line_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_draw_quadratic_to_func_t:\n @dfuncs: draw functions object\n @draw_data: The data accompanying the draw functions in hb_font_draw_glyph()\n @st: current draw state\n @control_x: X component of control point\n @control_y: Y component of control point\n @to_x: X component of target point\n @to_y: Y component of target point\n @user_data: User data pointer passed to hb_draw_funcs_set_quadratic_to_func()\n\n A virtual method for the #hb_draw_funcs_t to perform a \"quadratic-to\" draw\n operation.\n\n Since: 4.0.0\n"]
pub type hb_draw_quadratic_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control_x: f32,
        control_y: f32,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_draw_cubic_to_func_t:\n @dfuncs: draw functions object\n @draw_data: The data accompanying the draw functions in hb_font_draw_glyph()\n @st: current draw state\n @control1_x: X component of first control point\n @control1_y: Y component of first control point\n @control2_x: X component of second control point\n @control2_y: Y component of second control point\n @to_x: X component of target point\n @to_y: Y component of target point\n @user_data: User data pointer passed to hb_draw_funcs_set_cubic_to_func()\n\n A virtual method for the #hb_draw_funcs_t to perform a \"cubic-to\" draw\n operation.\n\n Since: 4.0.0\n"]
pub type hb_draw_cubic_to_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control1_x: f32,
        control1_y: f32,
        control2_x: f32,
        control2_y: f32,
        to_x: f32,
        to_y: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_draw_close_path_func_t:\n @dfuncs: draw functions object\n @draw_data: The data accompanying the draw functions in hb_font_draw_glyph()\n @st: current draw state\n @user_data: User data pointer passed to hb_draw_funcs_set_close_path_func()\n\n A virtual method for the #hb_draw_funcs_t to perform a \"close-path\" draw\n operation.\n\n Since: 4.0.0\n"]
pub type hb_draw_close_path_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    #[doc = " hb_draw_funcs_set_move_to_func:\n @dfuncs: draw functions object\n @func: (closure user_data) (destroy destroy) (scope notified): move-to callback\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets move-to callback to the draw functions object.\n\n Since: 4.0.0"]
    pub fn hb_draw_funcs_set_move_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_move_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_draw_funcs_set_line_to_func:\n @dfuncs: draw functions object\n @func: (closure user_data) (destroy destroy) (scope notified): line-to callback\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets line-to callback to the draw functions object.\n\n Since: 4.0.0"]
    pub fn hb_draw_funcs_set_line_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_line_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_draw_funcs_set_quadratic_to_func:\n @dfuncs: draw functions object\n @func: (closure user_data) (destroy destroy) (scope notified): quadratic-to callback\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets quadratic-to callback to the draw functions object.\n\n Since: 4.0.0"]
    pub fn hb_draw_funcs_set_quadratic_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_quadratic_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_draw_funcs_set_cubic_to_func:\n @dfuncs: draw functions\n @func: (closure user_data) (destroy destroy) (scope notified): cubic-to callback\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets cubic-to callback to the draw functions object.\n\n Since: 4.0.0"]
    pub fn hb_draw_funcs_set_cubic_to_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_cubic_to_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_draw_funcs_set_close_path_func:\n @dfuncs: draw functions object\n @func: (closure user_data) (destroy destroy) (scope notified): close-path callback\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets close-path callback to the draw functions object.\n\n Since: 4.0.0"]
    pub fn hb_draw_funcs_set_close_path_func(
        dfuncs: *mut hb_draw_funcs_t,
        func: hb_draw_close_path_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_draw_funcs_create() -> *mut hb_draw_funcs_t;
}
extern "C" {
    pub fn hb_draw_funcs_get_empty() -> *mut hb_draw_funcs_t;
}
extern "C" {
    pub fn hb_draw_funcs_reference(dfuncs: *mut hb_draw_funcs_t) -> *mut hb_draw_funcs_t;
}
extern "C" {
    pub fn hb_draw_funcs_destroy(dfuncs: *mut hb_draw_funcs_t);
}
extern "C" {
    pub fn hb_draw_funcs_set_user_data(
        dfuncs: *mut hb_draw_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_draw_funcs_get_user_data(
        dfuncs: *const hb_draw_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_draw_funcs_make_immutable(dfuncs: *mut hb_draw_funcs_t);
}
extern "C" {
    pub fn hb_draw_funcs_is_immutable(dfuncs: *mut hb_draw_funcs_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_draw_move_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
    );
}
extern "C" {
    pub fn hb_draw_line_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        to_x: f32,
        to_y: f32,
    );
}
extern "C" {
    pub fn hb_draw_quadratic_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control_x: f32,
        control_y: f32,
        to_x: f32,
        to_y: f32,
    );
}
extern "C" {
    pub fn hb_draw_cubic_to(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
        control1_x: f32,
        control1_y: f32,
        control2_x: f32,
        control2_y: f32,
        to_x: f32,
        to_y: f32,
    );
}
extern "C" {
    pub fn hb_draw_close_path(
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        st: *mut hb_draw_state_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_paint_funcs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_paint_funcs_create() -> *mut hb_paint_funcs_t;
}
extern "C" {
    pub fn hb_paint_funcs_get_empty() -> *mut hb_paint_funcs_t;
}
extern "C" {
    pub fn hb_paint_funcs_reference(funcs: *mut hb_paint_funcs_t) -> *mut hb_paint_funcs_t;
}
extern "C" {
    pub fn hb_paint_funcs_destroy(funcs: *mut hb_paint_funcs_t);
}
extern "C" {
    pub fn hb_paint_funcs_set_user_data(
        funcs: *mut hb_paint_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_paint_funcs_get_user_data(
        funcs: *const hb_paint_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_paint_funcs_make_immutable(funcs: *mut hb_paint_funcs_t);
}
extern "C" {
    pub fn hb_paint_funcs_is_immutable(funcs: *mut hb_paint_funcs_t) -> hb_bool_t;
}
#[doc = " hb_paint_push_transform_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @xx: xx component of the transform matrix\n @yx: yx component of the transform matrix\n @xy: xy component of the transform matrix\n @yy: yy component of the transform matrix\n @dx: dx component of the transform matrix\n @dy: dy component of the transform matrix\n @user_data: User data pointer passed to hb_paint_funcs_set_push_transform_func()\n\n A virtual method for the #hb_paint_funcs_t to apply\n a transform to subsequent paint calls.\n\n This transform is applied after the current transform,\n and remains in effect until a matching call to\n the #hb_paint_funcs_pop_transform_func_t vfunc.\n\n Since: 7.0.0"]
pub type hb_paint_push_transform_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xx: f32,
        yx: f32,
        xy: f32,
        yy: f32,
        dx: f32,
        dy: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_pop_transform_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @user_data: User data pointer passed to hb_paint_funcs_set_pop_transform_func()\n\n A virtual method for the #hb_paint_funcs_t to undo\n the effect of a prior call to the #hb_paint_funcs_push_transform_func_t\n vfunc.\n\n Since: 7.0.0"]
pub type hb_paint_pop_transform_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_color_glyph_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @glyph: the glyph ID\n @font: the font\n @user_data: User data pointer passed to hb_paint_funcs_set_color_glyph_func()\n\n A virtual method for the #hb_paint_funcs_t to render a color glyph by glyph index.\n\n Return value: %true if the glyph was painted, %false otherwise.\n\n Since: 8.2.0"]
pub type hb_paint_color_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_paint_push_clip_glyph_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @glyph: the glyph ID\n @font: the font\n @user_data: User data pointer passed to hb_paint_funcs_set_push_clip_glyph_func()\n\n A virtual method for the #hb_paint_funcs_t to clip\n subsequent paint calls to the outline of a glyph.\n\n The coordinates of the glyph outline are interpreted according\n to the current transform.\n\n This clip is applied in addition to the current clip,\n and remains in effect until a matching call to\n the #hb_paint_funcs_pop_clip_func_t vfunc.\n\n Since: 7.0.0"]
pub type hb_paint_push_clip_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_push_clip_rectangle_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @xmin: min X for the rectangle\n @ymin: min Y for the rectangle\n @xmax: max X for the rectangle\n @ymax: max Y for the rectangle\n @user_data: User data pointer passed to hb_paint_funcs_set_push_clip_rectangle_func()\n\n A virtual method for the #hb_paint_funcs_t to clip\n subsequent paint calls to a rectangle.\n\n The coordinates of the rectangle are interpreted according\n to the current transform.\n\n This clip is applied in addition to the current clip,\n and remains in effect until a matching call to\n the #hb_paint_funcs_pop_clip_func_t vfunc.\n\n Since: 7.0.0"]
pub type hb_paint_push_clip_rectangle_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xmin: f32,
        ymin: f32,
        xmax: f32,
        ymax: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_pop_clip_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @user_data: User data pointer passed to hb_paint_funcs_set_pop_clip_func()\n\n A virtual method for the #hb_paint_funcs_t to undo\n the effect of a prior call to the #hb_paint_funcs_push_clip_glyph_func_t\n or #hb_paint_funcs_push_clip_rectangle_func_t vfuncs.\n\n Since: 7.0.0"]
pub type hb_paint_pop_clip_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_color_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @is_foreground: whether the color is the foreground\n @color: The color to use, unpremultiplied\n @user_data: User data pointer passed to hb_paint_funcs_set_color_func()\n\n A virtual method for the #hb_paint_funcs_t to paint a\n color everywhere within the current clip.\n\n Since: 7.0.0"]
pub type hb_paint_color_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        is_foreground: hb_bool_t,
        color: hb_color_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_image_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @image: the image data\n @width: width of the raster image in pixels, or 0\n @height: height of the raster image in pixels, or 0\n @format: the image format as a tag\n @slant: the synthetic slant ratio to be applied to the image during rendering\n @extents: (nullable): glyph extents for desired rendering\n @user_data: User data pointer passed to hb_paint_funcs_set_image_func()\n\n A virtual method for the #hb_paint_funcs_t to paint a glyph image.\n\n This method is called for glyphs with image blobs in the CBDT,\n sbix or SVG tables. The @format identifies the kind of data that\n is contained in @image. Possible values include #HB_PAINT_IMAGE_FORMAT_PNG,\n #HB_PAINT_IMAGE_FORMAT_SVG and #HB_PAINT_IMAGE_FORMAT_BGRA.\n\n The image dimensions and glyph extents are provided if available,\n and should be used to size and position the image.\n\n Return value: Whether the operation was successful.\n\n Since: 7.0.0"]
pub type hb_paint_image_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        image: *mut hb_blob_t,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        format: hb_tag_t,
        slant: f32,
        extents: *mut hb_glyph_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_color_stop_t:\n @offset: the offset of the color stop\n @is_foreground: whether the color is the foreground\n @color: the color, unpremultiplied\n\n Information about a color stop on a color line.\n\n Color lines typically have offsets ranging between 0 and 1,\n but that is not required.\n\n Note: despite @color being unpremultiplied here, interpolation in\n gradients shall happen in premultiplied space. See the OpenType spec\n [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\n section for details.\n\n Since: 7.0.0"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_color_stop_t {
    pub offset: f32,
    pub is_foreground: hb_bool_t,
    pub color: hb_color_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_color_stop_t"][::std::mem::size_of::<hb_color_stop_t>() - 12usize];
    ["Alignment of hb_color_stop_t"][::std::mem::align_of::<hb_color_stop_t>() - 4usize];
    ["Offset of field: hb_color_stop_t::offset"]
        [::std::mem::offset_of!(hb_color_stop_t, offset) - 0usize];
    ["Offset of field: hb_color_stop_t::is_foreground"]
        [::std::mem::offset_of!(hb_color_stop_t, is_foreground) - 4usize];
    ["Offset of field: hb_color_stop_t::color"]
        [::std::mem::offset_of!(hb_color_stop_t, color) - 8usize];
};
pub const HB_PAINT_EXTEND_PAD: hb_paint_extend_t = 0;
pub const HB_PAINT_EXTEND_REPEAT: hb_paint_extend_t = 1;
pub const HB_PAINT_EXTEND_REFLECT: hb_paint_extend_t = 2;
#[doc = " hb_paint_extend_t:\n @HB_PAINT_EXTEND_PAD: Outside the defined interval,\n   the color of the closest color stop is used.\n @HB_PAINT_EXTEND_REPEAT: The color line is repeated over\n   repeated multiples of the defined interval\n @HB_PAINT_EXTEND_REFLECT: The color line is repeated over\n      repeated intervals, as for the repeat mode.\n      However, in each repeated interval, the ordering of\n      color stops is the reverse of the adjacent interval.\n\n The values of this enumeration determine how color values\n outside the minimum and maximum defined offset on a #hb_color_line_t\n are determined.\n\n See the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\n section for details.\n\n Since: 7.0.0"]
pub type hb_paint_extend_t = ::std::os::raw::c_uint;
#[doc = " hb_color_line_get_color_stops_func_t:\n @color_line: a #hb_color_line_t object\n @color_line_data: the data accompanying @color_line\n @start: the index of the first color stop to return\n @count: (inout) (optional): Input = the maximum number of feature tags to return;\n     Output = the actual number of feature tags returned (may be zero)\n @color_stops: (out) (array length=count) (optional): Array of #hb_color_stop_t to populate\n @user_data: the data accompanying this method\n\n A virtual method for the #hb_color_line_t to fetch color stops.\n\n Return value: the total number of color stops in @color_line\n\n Since: 7.0.0"]
pub type hb_color_line_get_color_stops_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        color_line: *mut hb_color_line_t,
        color_line_data: *mut ::std::os::raw::c_void,
        start: ::std::os::raw::c_uint,
        count: *mut ::std::os::raw::c_uint,
        color_stops: *mut hb_color_stop_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
#[doc = " hb_color_line_get_extend_func_t:\n @color_line: a #hb_color_line_t object\n @color_line_data: the data accompanying @color_line\n @user_data: the data accompanying this method\n\n A virtual method for the @hb_color_line_t to fetches the extend mode.\n\n Return value: the extend mode of @color_line\n\n Since: 7.0.0"]
pub type hb_color_line_get_extend_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        color_line: *mut hb_color_line_t,
        color_line_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_paint_extend_t,
>;
#[doc = " hb_color_line_t:\n\n A struct containing color information for a gradient.\n\n Since: 7.0.0"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_color_line_t {
    pub data: *mut ::std::os::raw::c_void,
    pub get_color_stops: hb_color_line_get_color_stops_func_t,
    pub get_color_stops_user_data: *mut ::std::os::raw::c_void,
    pub get_extend: hb_color_line_get_extend_func_t,
    pub get_extend_user_data: *mut ::std::os::raw::c_void,
    pub reserved0: *mut ::std::os::raw::c_void,
    pub reserved1: *mut ::std::os::raw::c_void,
    pub reserved2: *mut ::std::os::raw::c_void,
    pub reserved3: *mut ::std::os::raw::c_void,
    pub reserved5: *mut ::std::os::raw::c_void,
    pub reserved6: *mut ::std::os::raw::c_void,
    pub reserved7: *mut ::std::os::raw::c_void,
    pub reserved8: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_color_line_t"][::std::mem::size_of::<hb_color_line_t>() - 104usize];
    ["Alignment of hb_color_line_t"][::std::mem::align_of::<hb_color_line_t>() - 8usize];
    ["Offset of field: hb_color_line_t::data"]
        [::std::mem::offset_of!(hb_color_line_t, data) - 0usize];
    ["Offset of field: hb_color_line_t::get_color_stops"]
        [::std::mem::offset_of!(hb_color_line_t, get_color_stops) - 8usize];
    ["Offset of field: hb_color_line_t::get_color_stops_user_data"]
        [::std::mem::offset_of!(hb_color_line_t, get_color_stops_user_data) - 16usize];
    ["Offset of field: hb_color_line_t::get_extend"]
        [::std::mem::offset_of!(hb_color_line_t, get_extend) - 24usize];
    ["Offset of field: hb_color_line_t::get_extend_user_data"]
        [::std::mem::offset_of!(hb_color_line_t, get_extend_user_data) - 32usize];
    ["Offset of field: hb_color_line_t::reserved0"]
        [::std::mem::offset_of!(hb_color_line_t, reserved0) - 40usize];
    ["Offset of field: hb_color_line_t::reserved1"]
        [::std::mem::offset_of!(hb_color_line_t, reserved1) - 48usize];
    ["Offset of field: hb_color_line_t::reserved2"]
        [::std::mem::offset_of!(hb_color_line_t, reserved2) - 56usize];
    ["Offset of field: hb_color_line_t::reserved3"]
        [::std::mem::offset_of!(hb_color_line_t, reserved3) - 64usize];
    ["Offset of field: hb_color_line_t::reserved5"]
        [::std::mem::offset_of!(hb_color_line_t, reserved5) - 72usize];
    ["Offset of field: hb_color_line_t::reserved6"]
        [::std::mem::offset_of!(hb_color_line_t, reserved6) - 80usize];
    ["Offset of field: hb_color_line_t::reserved7"]
        [::std::mem::offset_of!(hb_color_line_t, reserved7) - 88usize];
    ["Offset of field: hb_color_line_t::reserved8"]
        [::std::mem::offset_of!(hb_color_line_t, reserved8) - 96usize];
};
extern "C" {
    pub fn hb_color_line_get_color_stops(
        color_line: *mut hb_color_line_t,
        start: ::std::os::raw::c_uint,
        count: *mut ::std::os::raw::c_uint,
        color_stops: *mut hb_color_stop_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_color_line_get_extend(color_line: *mut hb_color_line_t) -> hb_paint_extend_t;
}
#[doc = " hb_paint_linear_gradient_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @color_line: Color information for the gradient\n @x0: X coordinate of the first point\n @y0: Y coordinate of the first point\n @x1: X coordinate of the second point\n @y1: Y coordinate of the second point\n @x2: X coordinate of the third point\n @y2: Y coordinate of the third point\n @user_data: User data pointer passed to hb_paint_funcs_set_linear_gradient_func()\n\n A virtual method for the #hb_paint_funcs_t to paint a linear\n gradient everywhere within the current clip.\n\n The @color_line object contains information about the colors of the gradients.\n It is only valid for the duration of the callback, you cannot keep it around.\n\n The coordinates of the points are interpreted according\n to the current transform.\n\n See the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\n section for details on how the points define the direction\n of the gradient, and how to interpret the @color_line.\n\n Since: 7.0.0"]
pub type hb_paint_linear_gradient_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        x1: f32,
        y1: f32,
        x2: f32,
        y2: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_radial_gradient_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @color_line: Color information for the gradient\n @x0: X coordinate of the first circle's center\n @y0: Y coordinate of the first circle's center\n @r0: radius of the first circle\n @x1: X coordinate of the second circle's center\n @y1: Y coordinate of the second circle's center\n @r1: radius of the second circle\n @user_data: User data pointer passed to hb_paint_funcs_set_radial_gradient_func()\n\n A virtual method for the #hb_paint_funcs_t to paint a radial\n gradient everywhere within the current clip.\n\n The @color_line object contains information about the colors of the gradients.\n It is only valid for the duration of the callback, you cannot keep it around.\n\n The coordinates of the points are interpreted according\n to the current transform.\n\n See the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\n section for details on how the points define the direction\n of the gradient, and how to interpret the @color_line.\n\n Since: 7.0.0"]
pub type hb_paint_radial_gradient_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        r0: f32,
        x1: f32,
        y1: f32,
        r1: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_sweep_gradient_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @color_line: Color information for the gradient\n @x0: X coordinate of the circle's center\n @y0: Y coordinate of the circle's center\n @start_angle: the start angle, in radians\n @end_angle: the end angle, in radians\n @user_data: User data pointer passed to hb_paint_funcs_set_sweep_gradient_func()\n\n A virtual method for the #hb_paint_funcs_t to paint a sweep\n gradient everywhere within the current clip.\n\n The @color_line object contains information about the colors of the gradients.\n It is only valid for the duration of the callback, you cannot keep it around.\n\n The coordinates of the points are interpreted according\n to the current transform.\n\n See the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\n section for details on how the points define the direction\n of the gradient, and how to interpret the @color_line.\n\n Since: 7.0.0"]
pub type hb_paint_sweep_gradient_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        start_angle: f32,
        end_angle: f32,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub const HB_PAINT_COMPOSITE_MODE_CLEAR: hb_paint_composite_mode_t = 0;
pub const HB_PAINT_COMPOSITE_MODE_SRC: hb_paint_composite_mode_t = 1;
pub const HB_PAINT_COMPOSITE_MODE_DEST: hb_paint_composite_mode_t = 2;
pub const HB_PAINT_COMPOSITE_MODE_SRC_OVER: hb_paint_composite_mode_t = 3;
pub const HB_PAINT_COMPOSITE_MODE_DEST_OVER: hb_paint_composite_mode_t = 4;
pub const HB_PAINT_COMPOSITE_MODE_SRC_IN: hb_paint_composite_mode_t = 5;
pub const HB_PAINT_COMPOSITE_MODE_DEST_IN: hb_paint_composite_mode_t = 6;
pub const HB_PAINT_COMPOSITE_MODE_SRC_OUT: hb_paint_composite_mode_t = 7;
pub const HB_PAINT_COMPOSITE_MODE_DEST_OUT: hb_paint_composite_mode_t = 8;
pub const HB_PAINT_COMPOSITE_MODE_SRC_ATOP: hb_paint_composite_mode_t = 9;
pub const HB_PAINT_COMPOSITE_MODE_DEST_ATOP: hb_paint_composite_mode_t = 10;
pub const HB_PAINT_COMPOSITE_MODE_XOR: hb_paint_composite_mode_t = 11;
pub const HB_PAINT_COMPOSITE_MODE_PLUS: hb_paint_composite_mode_t = 12;
pub const HB_PAINT_COMPOSITE_MODE_SCREEN: hb_paint_composite_mode_t = 13;
pub const HB_PAINT_COMPOSITE_MODE_OVERLAY: hb_paint_composite_mode_t = 14;
pub const HB_PAINT_COMPOSITE_MODE_DARKEN: hb_paint_composite_mode_t = 15;
pub const HB_PAINT_COMPOSITE_MODE_LIGHTEN: hb_paint_composite_mode_t = 16;
pub const HB_PAINT_COMPOSITE_MODE_COLOR_DODGE: hb_paint_composite_mode_t = 17;
pub const HB_PAINT_COMPOSITE_MODE_COLOR_BURN: hb_paint_composite_mode_t = 18;
pub const HB_PAINT_COMPOSITE_MODE_HARD_LIGHT: hb_paint_composite_mode_t = 19;
pub const HB_PAINT_COMPOSITE_MODE_SOFT_LIGHT: hb_paint_composite_mode_t = 20;
pub const HB_PAINT_COMPOSITE_MODE_DIFFERENCE: hb_paint_composite_mode_t = 21;
pub const HB_PAINT_COMPOSITE_MODE_EXCLUSION: hb_paint_composite_mode_t = 22;
pub const HB_PAINT_COMPOSITE_MODE_MULTIPLY: hb_paint_composite_mode_t = 23;
pub const HB_PAINT_COMPOSITE_MODE_HSL_HUE: hb_paint_composite_mode_t = 24;
pub const HB_PAINT_COMPOSITE_MODE_HSL_SATURATION: hb_paint_composite_mode_t = 25;
pub const HB_PAINT_COMPOSITE_MODE_HSL_COLOR: hb_paint_composite_mode_t = 26;
pub const HB_PAINT_COMPOSITE_MODE_HSL_LUMINOSITY: hb_paint_composite_mode_t = 27;
#[doc = " hb_paint_composite_mode_t:\n @HB_PAINT_COMPOSITE_MODE_CLEAR: clear destination layer (bounded)\n @HB_PAINT_COMPOSITE_MODE_SRC: replace destination layer (bounded)\n @HB_PAINT_COMPOSITE_MODE_SRC_OVER: draw source layer on top of destination layer\n (bounded)\n @HB_PAINT_COMPOSITE_MODE_SRC_IN: draw source where there was destination content\n (unbounded)\n @HB_PAINT_COMPOSITE_MODE_SRC_OUT: draw source where there was no destination\n content (unbounded)\n @HB_PAINT_COMPOSITE_MODE_SRC_ATOP: draw source on top of destination content and\n only there\n @HB_PAINT_COMPOSITE_MODE_DEST: ignore the source\n @HB_PAINT_COMPOSITE_MODE_DEST_OVER: draw destination on top of source\n @HB_PAINT_COMPOSITE_MODE_DEST_IN: leave destination only where there was\n source content (unbounded)\n @HB_PAINT_COMPOSITE_MODE_DEST_OUT: leave destination only where there was no\n source content\n @HB_PAINT_COMPOSITE_MODE_DEST_ATOP: leave destination on top of source content\n and only there (unbounded)\n @HB_PAINT_COMPOSITE_MODE_XOR: source and destination are shown where there is only\n one of them\n @HB_PAINT_COMPOSITE_MODE_PLUS: source and destination layers are accumulated\n @HB_PAINT_COMPOSITE_MODE_MULTIPLY: source and destination layers are multiplied.\n This causes the result to be at least as dark as the darker inputs.\n @HB_PAINT_COMPOSITE_MODE_SCREEN: source and destination are complemented and\n multiplied. This causes the result to be at least as light as the lighter\n inputs.\n @HB_PAINT_COMPOSITE_MODE_OVERLAY: multiplies or screens, depending on the\n lightness of the destination color.\n @HB_PAINT_COMPOSITE_MODE_DARKEN: replaces the destination with the source if it\n is darker, otherwise keeps the source.\n @HB_PAINT_COMPOSITE_MODE_LIGHTEN: replaces the destination with the source if it\n is lighter, otherwise keeps the source.\n @HB_PAINT_COMPOSITE_MODE_COLOR_DODGE: brightens the destination color to reflect\n the source color.\n @HB_PAINT_COMPOSITE_MODE_COLOR_BURN: darkens the destination color to reflect\n the source color.\n @HB_PAINT_COMPOSITE_MODE_HARD_LIGHT: Multiplies or screens, dependent on source\n color.\n @HB_PAINT_COMPOSITE_MODE_SOFT_LIGHT: Darkens or lightens, dependent on source\n color.\n @HB_PAINT_COMPOSITE_MODE_DIFFERENCE: Takes the difference of the source and\n destination color.\n @HB_PAINT_COMPOSITE_MODE_EXCLUSION: Produces an effect similar to difference, but\n with lower contrast.\n @HB_PAINT_COMPOSITE_MODE_HSL_HUE: Creates a color with the hue of the source\n and the saturation and luminosity of the target.\n @HB_PAINT_COMPOSITE_MODE_HSL_SATURATION: Creates a color with the saturation\n of the source and the hue and luminosity of the target. Painting with\n this mode onto a gray area produces no change.\n @HB_PAINT_COMPOSITE_MODE_HSL_COLOR: Creates a color with the hue and saturation\n of the source and the luminosity of the target. This preserves the gray\n levels of the target and is useful for coloring monochrome images or\n tinting color images.\n @HB_PAINT_COMPOSITE_MODE_HSL_LUMINOSITY: Creates a color with the luminosity of\n the source and the hue and saturation of the target. This produces an\n inverse effect to @HB_PAINT_COMPOSITE_MODE_HSL_COLOR.\n\n The values of this enumeration describe the compositing modes\n that can be used when combining temporary redirected drawing\n with the backdrop.\n\n See the OpenType spec [COLR](https://learn.microsoft.com/en-us/typography/opentype/spec/colr)\n section for details.\n\n Since: 7.0.0"]
pub type hb_paint_composite_mode_t = ::std::os::raw::c_uint;
#[doc = " hb_paint_push_group_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @user_data: User data pointer passed to hb_paint_funcs_set_push_group_func()\n\n A virtual method for the #hb_paint_funcs_t to use\n an intermediate surface for subsequent paint calls.\n\n The drawing will be redirected to an intermediate surface\n until a matching call to the #hb_paint_funcs_pop_group_func_t\n vfunc.\n\n Since: 7.0.0"]
pub type hb_paint_push_group_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_pop_group_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @mode: the compositing mode to use\n @user_data: User data pointer passed to hb_paint_funcs_set_pop_group_func()\n\n A virtual method for the #hb_paint_funcs_t to undo\n the effect of a prior call to the #hb_paint_funcs_push_group_func_t\n vfunc.\n\n This call stops the redirection to the intermediate surface,\n and then composites it on the previous surface, using the\n compositing mode passed to this call.\n\n Since: 7.0.0"]
pub type hb_paint_pop_group_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        mode: hb_paint_composite_mode_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_paint_custom_palette_color_func_t:\n @funcs: paint functions object\n @paint_data: The data accompanying the paint functions in hb_font_paint_glyph()\n @color_index: the color index\n @color: (out): fetched color\n @user_data: User data pointer passed to hb_paint_funcs_set_pop_group_func()\n\n A virtual method for the #hb_paint_funcs_t to fetch a color from the custom\n color palette.\n\n Custom palette colors override the colors from the fonts selected color\n palette. It is not necessary to override all palette entries; for entries\n that should be taken from the font palette, return `false`.\n\n This function might get called multiple times, but the custom palette is\n expected to remain unchanged for duration of a hb_font_paint_glyph() call.\n\n Return value: `true` if found, `false` otherwise\n\n Since: 7.0.0"]
pub type hb_paint_custom_palette_color_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_index: ::std::os::raw::c_uint,
        color: *mut hb_color_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    #[doc = " hb_paint_funcs_set_push_transform_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The push-transform callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the push-transform callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_push_transform_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_transform_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_pop_transform_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The pop-transform callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the pop-transform callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_pop_transform_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_pop_transform_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_color_glyph_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The color-glyph callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the color-glyph callback on the paint functions struct.\n\n Since: 8.2.0"]
    pub fn hb_paint_funcs_set_color_glyph_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_color_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_push_clip_glyph_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The push-clip-glyph callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the push-clip-glyph callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_push_clip_glyph_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_clip_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_push_clip_rectangle_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The push-clip-rectangle callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the push-clip-rect callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_push_clip_rectangle_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_clip_rectangle_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_pop_clip_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The pop-clip callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the pop-clip callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_pop_clip_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_pop_clip_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_color_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The paint-color callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the paint-color callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_color_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_color_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_image_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The paint-image callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the paint-image callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_image_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_image_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_linear_gradient_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The linear-gradient callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the linear-gradient callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_linear_gradient_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_linear_gradient_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_radial_gradient_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The radial-gradient callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the radial-gradient callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_radial_gradient_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_radial_gradient_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_sweep_gradient_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The sweep-gradient callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the sweep-gradient callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_sweep_gradient_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_sweep_gradient_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_push_group_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The push-group callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the push-group callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_push_group_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_push_group_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_pop_group_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The pop-group callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the pop-group callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_pop_group_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_pop_group_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_paint_funcs_set_custom_palette_color_func:\n @funcs: A paint functions struct\n @func: (closure user_data) (destroy destroy) (scope notified): The custom-palette-color callback\n @user_data: Data to pass to @func\n @destroy: (nullable): Function to call when @user_data is no longer needed\n\n Sets the custom-palette-color callback on the paint functions struct.\n\n Since: 7.0.0"]
    pub fn hb_paint_funcs_set_custom_palette_color_func(
        funcs: *mut hb_paint_funcs_t,
        func: hb_paint_custom_palette_color_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_paint_push_transform(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xx: f32,
        yx: f32,
        xy: f32,
        yy: f32,
        dx: f32,
        dy: f32,
    );
}
extern "C" {
    pub fn hb_paint_pop_transform(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn hb_paint_color_glyph(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_paint_push_clip_glyph(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        font: *mut hb_font_t,
    );
}
extern "C" {
    pub fn hb_paint_push_clip_rectangle(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        xmin: f32,
        ymin: f32,
        xmax: f32,
        ymax: f32,
    );
}
extern "C" {
    pub fn hb_paint_pop_clip(funcs: *mut hb_paint_funcs_t, paint_data: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn hb_paint_color(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        is_foreground: hb_bool_t,
        color: hb_color_t,
    );
}
extern "C" {
    pub fn hb_paint_image(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        image: *mut hb_blob_t,
        width: ::std::os::raw::c_uint,
        height: ::std::os::raw::c_uint,
        format: hb_tag_t,
        slant: f32,
        extents: *mut hb_glyph_extents_t,
    );
}
extern "C" {
    pub fn hb_paint_linear_gradient(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        x1: f32,
        y1: f32,
        x2: f32,
        y2: f32,
    );
}
extern "C" {
    pub fn hb_paint_radial_gradient(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        r0: f32,
        x1: f32,
        y1: f32,
        r1: f32,
    );
}
extern "C" {
    pub fn hb_paint_sweep_gradient(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_line: *mut hb_color_line_t,
        x0: f32,
        y0: f32,
        start_angle: f32,
        end_angle: f32,
    );
}
extern "C" {
    pub fn hb_paint_push_group(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn hb_paint_pop_group(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        mode: hb_paint_composite_mode_t,
    );
}
extern "C" {
    pub fn hb_paint_custom_palette_color(
        funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        color_index: ::std::os::raw::c_uint,
        color: *mut hb_color_t,
    ) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_funcs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_font_funcs_create() -> *mut hb_font_funcs_t;
}
extern "C" {
    pub fn hb_font_funcs_get_empty() -> *mut hb_font_funcs_t;
}
extern "C" {
    pub fn hb_font_funcs_reference(ffuncs: *mut hb_font_funcs_t) -> *mut hb_font_funcs_t;
}
extern "C" {
    pub fn hb_font_funcs_destroy(ffuncs: *mut hb_font_funcs_t);
}
extern "C" {
    pub fn hb_font_funcs_set_user_data(
        ffuncs: *mut hb_font_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_funcs_get_user_data(
        ffuncs: *const hb_font_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_font_funcs_make_immutable(ffuncs: *mut hb_font_funcs_t);
}
extern "C" {
    pub fn hb_font_funcs_is_immutable(ffuncs: *mut hb_font_funcs_t) -> hb_bool_t;
}
#[doc = " hb_font_extents_t:\n @ascender: The height of typographic ascenders.\n @descender: The depth of typographic descenders.\n @line_gap: The suggested line-spacing gap.\n\n Font-wide extent values, measured in font units.\n\n Note that typically @ascender is positive and @descender\n negative, in coordinate systems that grow up."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_extents_t {
    pub ascender: hb_position_t,
    pub descender: hb_position_t,
    pub line_gap: hb_position_t,
    pub reserved9: hb_position_t,
    pub reserved8: hb_position_t,
    pub reserved7: hb_position_t,
    pub reserved6: hb_position_t,
    pub reserved5: hb_position_t,
    pub reserved4: hb_position_t,
    pub reserved3: hb_position_t,
    pub reserved2: hb_position_t,
    pub reserved1: hb_position_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_font_extents_t"][::std::mem::size_of::<hb_font_extents_t>() - 48usize];
    ["Alignment of hb_font_extents_t"][::std::mem::align_of::<hb_font_extents_t>() - 4usize];
    ["Offset of field: hb_font_extents_t::ascender"]
        [::std::mem::offset_of!(hb_font_extents_t, ascender) - 0usize];
    ["Offset of field: hb_font_extents_t::descender"]
        [::std::mem::offset_of!(hb_font_extents_t, descender) - 4usize];
    ["Offset of field: hb_font_extents_t::line_gap"]
        [::std::mem::offset_of!(hb_font_extents_t, line_gap) - 8usize];
    ["Offset of field: hb_font_extents_t::reserved9"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved9) - 12usize];
    ["Offset of field: hb_font_extents_t::reserved8"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved8) - 16usize];
    ["Offset of field: hb_font_extents_t::reserved7"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved7) - 20usize];
    ["Offset of field: hb_font_extents_t::reserved6"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved6) - 24usize];
    ["Offset of field: hb_font_extents_t::reserved5"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved5) - 28usize];
    ["Offset of field: hb_font_extents_t::reserved4"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved4) - 32usize];
    ["Offset of field: hb_font_extents_t::reserved3"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved3) - 36usize];
    ["Offset of field: hb_font_extents_t::reserved2"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved2) - 40usize];
    ["Offset of field: hb_font_extents_t::reserved1"]
        [::std::mem::offset_of!(hb_font_extents_t, reserved1) - 44usize];
};
#[doc = " hb_font_get_font_extents_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @extents: (out): The font extents retrieved\n @user_data: User data pointer passed by the caller\n\n This method should retrieve the extents for a font.\n"]
pub type hb_font_get_font_extents_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        extents: *mut hb_font_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_font_h_extents_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the extents for a font, for horizontal-direction\n text segments. Extents must be returned in an #hb_glyph_extents output\n parameter.\n"]
pub type hb_font_get_font_h_extents_func_t = hb_font_get_font_extents_func_t;
#[doc = " hb_font_get_font_v_extents_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the extents for a font, for vertical-direction\n text segments. Extents must be returned in an #hb_glyph_extents output\n parameter.\n"]
pub type hb_font_get_font_v_extents_func_t = hb_font_get_font_extents_func_t;
#[doc = " hb_font_get_nominal_glyph_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @unicode: The Unicode code point to query\n @glyph: (out): The glyph ID retrieved\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the nominal glyph ID for a specified Unicode code\n point. Glyph IDs must be returned in a #hb_codepoint_t output parameter.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_nominal_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_variation_glyph_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @unicode: The Unicode code point to query\n @variation_selector: The  variation-selector code point to query\n @glyph: (out): The glyph ID retrieved\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the glyph ID for a specified Unicode code point\n followed by a specified Variation Selector code point. Glyph IDs must be\n returned in a #hb_codepoint_t output parameter.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_variation_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_nominal_glyphs_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @count: number of code points to query\n @first_unicode: The first Unicode code point to query\n @unicode_stride: The stride between successive code points\n @first_glyph: (out): The first glyph ID retrieved\n @glyph_stride: The stride between successive glyph IDs\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the nominal glyph IDs for a sequence of\n Unicode code points. Glyph IDs must be returned in a #hb_codepoint_t\n output parameter.\n\n Return value: the number of code points processed\n"]
pub type hb_font_get_nominal_glyphs_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        count: ::std::os::raw::c_uint,
        first_unicode: *const hb_codepoint_t,
        unicode_stride: ::std::os::raw::c_uint,
        first_glyph: *mut hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
#[doc = " hb_font_get_glyph_advance_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the advance for a specified glyph. The\n method must return an #hb_position_t.\n\n Return value: The advance of @glyph within @font\n"]
pub type hb_font_get_glyph_advance_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_position_t,
>;
#[doc = " hb_font_get_glyph_h_advance_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the advance for a specified glyph, in\n horizontal-direction text segments. Advances must be returned in\n an #hb_position_t output parameter.\n"]
pub type hb_font_get_glyph_h_advance_func_t = hb_font_get_glyph_advance_func_t;
#[doc = " hb_font_get_glyph_v_advance_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the advance for a specified glyph, in\n vertical-direction text segments. Advances must be returned in\n an #hb_position_t output parameter.\n"]
pub type hb_font_get_glyph_v_advance_func_t = hb_font_get_glyph_advance_func_t;
#[doc = " hb_font_get_glyph_advances_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @count: The number of glyph IDs in the sequence queried\n @first_glyph: The first glyph ID to query\n @glyph_stride: The stride between successive glyph IDs\n @first_advance: (out): The first advance retrieved\n @advance_stride: The stride between successive advances\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the advances for a sequence of glyphs.\n"]
pub type hb_font_get_glyph_advances_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_font_get_glyph_h_advances_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the advances for a sequence of glyphs, in\n horizontal-direction text segments.\n"]
pub type hb_font_get_glyph_h_advances_func_t = hb_font_get_glyph_advances_func_t;
#[doc = " hb_font_get_glyph_v_advances_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the advances for a sequence of glyphs, in\n vertical-direction text segments.\n"]
pub type hb_font_get_glyph_v_advances_func_t = hb_font_get_glyph_advances_func_t;
#[doc = " hb_font_get_glyph_origin_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @x: (out): The X coordinate of the origin\n @y: (out): The Y coordinate of the origin\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the (X,Y) coordinates (in font units) of the\n origin for a glyph. Each coordinate must be returned in an #hb_position_t\n output parameter.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_glyph_origin_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_glyph_h_origin_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the (X,Y) coordinates (in font units) of the\n origin for a glyph, for horizontal-direction text segments. Each\n coordinate must be returned in an #hb_position_t output parameter.\n"]
pub type hb_font_get_glyph_h_origin_func_t = hb_font_get_glyph_origin_func_t;
#[doc = " hb_font_get_glyph_v_origin_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the (X,Y) coordinates (in font units) of the\n origin for a glyph, for vertical-direction text segments. Each coordinate\n must be returned in an #hb_position_t output parameter.\n"]
pub type hb_font_get_glyph_v_origin_func_t = hb_font_get_glyph_origin_func_t;
#[doc = " hb_font_get_glyph_kerning_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @first_glyph: The glyph ID of the first glyph in the glyph pair\n @second_glyph: The glyph ID of the second glyph in the glyph pair\n @user_data: User data pointer passed by the caller\n\n This method should retrieve the kerning-adjustment value for a glyph-pair in\n the specified font, for horizontal text segments.\n"]
pub type hb_font_get_glyph_kerning_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        first_glyph: hb_codepoint_t,
        second_glyph: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_position_t,
>;
#[doc = " hb_font_get_glyph_h_kerning_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the kerning-adjustment value for a glyph-pair in\n the specified font, for horizontal text segments.\n"]
pub type hb_font_get_glyph_h_kerning_func_t = hb_font_get_glyph_kerning_func_t;
#[doc = " hb_font_get_glyph_extents_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @extents: (out): The #hb_glyph_extents_t retrieved\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the extents for a specified glyph. Extents must be\n returned in an #hb_glyph_extents output parameter.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_glyph_extents_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        extents: *mut hb_glyph_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_glyph_contour_point_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @point_index: The contour-point index to query\n @x: (out): The X value retrieved for the contour point\n @y: (out): The Y value retrieved for the contour point\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the (X,Y) coordinates (in font units) for a\n specified contour point in a glyph. Each coordinate must be returned as\n an #hb_position_t output parameter.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_glyph_contour_point_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_glyph_name_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @name: (out) (array length=size): Name string retrieved for the glyph ID\n @size: Length of the glyph-name string retrieved\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the glyph name that corresponds to a\n glyph ID. The name should be returned in a string output parameter.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_glyph_name_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        name: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_get_glyph_from_name_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @name: (array length=len): The name string to query\n @len: The length of the name queried\n @glyph: (out): The glyph ID retrieved\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the glyph ID that corresponds to a glyph-name\n string.\n\n Return value: `true` if data found, `false` otherwise\n"]
pub type hb_font_get_glyph_from_name_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
#[doc = " hb_font_draw_glyph_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @draw_funcs: The draw functions to send the shape data to\n @draw_data: The data accompanying the draw functions\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n Since: 7.0.0\n"]
pub type hb_font_draw_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        draw_funcs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " hb_font_paint_glyph_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @paint_funcs: The paint functions to use\n @paint_data: The data accompanying the paint functions\n @palette_index: The color palette to use\n @foreground: The foreground color\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n Since: 7.0.0"]
pub type hb_font_paint_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        paint_funcs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        palette_index: ::std::os::raw::c_uint,
        foreground: hb_color_t,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    #[doc = " hb_font_funcs_set_font_h_extents_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_font_h_extents_func_t.\n\n Since: 1.1.2"]
    pub fn hb_font_funcs_set_font_h_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_font_h_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_font_v_extents_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_font_v_extents_func_t.\n\n Since: 1.1.2"]
    pub fn hb_font_funcs_set_font_v_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_font_v_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_nominal_glyph_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_nominal_glyph_func_t.\n\n Since: 1.2.3"]
    pub fn hb_font_funcs_set_nominal_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_nominal_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_nominal_glyphs_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_nominal_glyphs_func_t.\n\n Since: 2.0.0"]
    pub fn hb_font_funcs_set_nominal_glyphs_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_nominal_glyphs_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_variation_glyph_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_variation_glyph_func_t.\n\n Since: 1.2.3"]
    pub fn hb_font_funcs_set_variation_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_variation_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_h_advance_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_h_advance_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_h_advance_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_advance_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_v_advance_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_v_advance_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_v_advance_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_advance_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_h_advances_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_h_advances_func_t.\n\n Since: 1.8.6"]
    pub fn hb_font_funcs_set_glyph_h_advances_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_advances_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_v_advances_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_v_advances_func_t.\n\n Since: 1.8.6"]
    pub fn hb_font_funcs_set_glyph_v_advances_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_advances_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_h_origin_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_h_origin_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_h_origin_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_origin_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_v_origin_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_v_origin_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_v_origin_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_origin_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_h_kerning_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_h_kerning_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_h_kerning_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_kerning_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_extents_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_extents_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_contour_point_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_contour_point_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_contour_point_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_contour_point_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_name_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_name_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_name_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_name_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_from_name_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_from_name_func_t.\n\n Since: 0.9.2"]
    pub fn hb_font_funcs_set_glyph_from_name_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_from_name_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_draw_glyph_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_draw_glyph_func_t.\n\n Since: 7.0.0"]
    pub fn hb_font_funcs_set_draw_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_draw_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_font_funcs_set_paint_glyph_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is no longer needed\n\n Sets the implementation function for #hb_font_paint_glyph_func_t.\n\n Since: 7.0.0"]
    pub fn hb_font_funcs_set_paint_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_paint_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_get_h_extents(
        font: *mut hb_font_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_v_extents(
        font: *mut hb_font_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_nominal_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_variation_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_nominal_glyphs(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_unicode: *const hb_codepoint_t,
        unicode_stride: ::std::os::raw::c_uint,
        first_glyph: *mut hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_font_get_glyph_h_advance(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_font_get_glyph_v_advance(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_font_get_glyph_h_advances(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_v_advances(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_h_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_v_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_h_kerning(
        font: *mut hb_font_t,
        left_glyph: hb_codepoint_t,
        right_glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_font_get_glyph_extents(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        extents: *mut hb_glyph_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_contour_point(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_name(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        name: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_from_name(
        font: *mut hb_font_t,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_draw_glyph(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn hb_font_paint_glyph(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        pfuncs: *mut hb_paint_funcs_t,
        paint_data: *mut ::std::os::raw::c_void,
        palette_index: ::std::os::raw::c_uint,
        foreground: hb_color_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_extents_for_direction(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        extents: *mut hb_font_extents_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_advance_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_advances_for_direction(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_add_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_subtract_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_kerning_for_direction(
        font: *mut hb_font_t,
        first_glyph: hb_codepoint_t,
        second_glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_extents_for_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        extents: *mut hb_glyph_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_contour_point_for_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_glyph_to_string(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        s: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_glyph_from_string(
        font: *mut hb_font_t,
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_create(face: *mut hb_face_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_create_sub_font(parent: *mut hb_font_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_get_empty() -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_reference(font: *mut hb_font_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_destroy(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_set_user_data(
        font: *mut hb_font_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_user_data(
        font: *const hb_font_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_font_make_immutable(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_is_immutable(font: *mut hb_font_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_serial(font: *mut hb_font_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_font_changed(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_set_parent(font: *mut hb_font_t, parent: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_get_parent(font: *mut hb_font_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_set_face(font: *mut hb_font_t, face: *mut hb_face_t);
}
extern "C" {
    pub fn hb_font_get_face(font: *mut hb_font_t) -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_font_set_funcs(
        font: *mut hb_font_t,
        klass: *mut hb_font_funcs_t,
        font_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_set_funcs_data(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_set_scale(
        font: *mut hb_font_t,
        x_scale: ::std::os::raw::c_int,
        y_scale: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_font_get_scale(
        font: *mut hb_font_t,
        x_scale: *mut ::std::os::raw::c_int,
        y_scale: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_font_set_ppem(
        font: *mut hb_font_t,
        x_ppem: ::std::os::raw::c_uint,
        y_ppem: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_ppem(
        font: *mut hb_font_t,
        x_ppem: *mut ::std::os::raw::c_uint,
        y_ppem: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_set_ptem(font: *mut hb_font_t, ptem: f32);
}
extern "C" {
    pub fn hb_font_get_ptem(font: *mut hb_font_t) -> f32;
}
extern "C" {
    pub fn hb_font_set_synthetic_bold(
        font: *mut hb_font_t,
        x_embolden: f32,
        y_embolden: f32,
        in_place: hb_bool_t,
    );
}
extern "C" {
    pub fn hb_font_get_synthetic_bold(
        font: *mut hb_font_t,
        x_embolden: *mut f32,
        y_embolden: *mut f32,
        in_place: *mut hb_bool_t,
    );
}
extern "C" {
    pub fn hb_font_set_synthetic_slant(font: *mut hb_font_t, slant: f32);
}
extern "C" {
    pub fn hb_font_get_synthetic_slant(font: *mut hb_font_t) -> f32;
}
extern "C" {
    pub fn hb_font_set_variations(
        font: *mut hb_font_t,
        variations: *const hb_variation_t,
        variations_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_set_variation(font: *mut hb_font_t, tag: hb_tag_t, value: f32);
}
extern "C" {
    pub fn hb_font_set_var_coords_design(
        font: *mut hb_font_t,
        coords: *const f32,
        coords_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_var_coords_design(
        font: *mut hb_font_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const f32;
}
extern "C" {
    pub fn hb_font_set_var_coords_normalized(
        font: *mut hb_font_t,
        coords: *const ::std::os::raw::c_int,
        coords_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_var_coords_normalized(
        font: *mut hb_font_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn hb_font_set_var_named_instance(
        font: *mut hb_font_t,
        instance_index: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_var_named_instance(font: *mut hb_font_t) -> ::std::os::raw::c_uint;
}
#[doc = " hb_glyph_info_t:\n @codepoint: either a Unicode code point (before shaping) or a glyph index\n             (after shaping).\n @cluster: the index of the character in the original text that corresponds\n           to this #hb_glyph_info_t, or whatever the client passes to\n           hb_buffer_add(). More than one #hb_glyph_info_t can have the same\n           @cluster value, if they resulted from the same character (e.g. one\n           to many glyph substitution), and when more than one character gets\n           merged in the same glyph (e.g. many to one glyph substitution) the\n           #hb_glyph_info_t will have the smallest cluster value of them.\n           By default some characters are merged into the same cluster\n           (e.g. combining marks have the same cluster as their bases)\n           even if they are separate glyphs, hb_buffer_set_cluster_level()\n           allow selecting more fine-grained cluster handling.\n\n The #hb_glyph_info_t is the structure that holds information about the\n glyphs and their relation to input text."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_glyph_info_t {
    pub codepoint: hb_codepoint_t,
    pub mask: hb_mask_t,
    pub cluster: u32,
    pub var1: hb_var_int_t,
    pub var2: hb_var_int_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_glyph_info_t"][::std::mem::size_of::<hb_glyph_info_t>() - 20usize];
    ["Alignment of hb_glyph_info_t"][::std::mem::align_of::<hb_glyph_info_t>() - 4usize];
    ["Offset of field: hb_glyph_info_t::codepoint"]
        [::std::mem::offset_of!(hb_glyph_info_t, codepoint) - 0usize];
    ["Offset of field: hb_glyph_info_t::mask"]
        [::std::mem::offset_of!(hb_glyph_info_t, mask) - 4usize];
    ["Offset of field: hb_glyph_info_t::cluster"]
        [::std::mem::offset_of!(hb_glyph_info_t, cluster) - 8usize];
    ["Offset of field: hb_glyph_info_t::var1"]
        [::std::mem::offset_of!(hb_glyph_info_t, var1) - 12usize];
    ["Offset of field: hb_glyph_info_t::var2"]
        [::std::mem::offset_of!(hb_glyph_info_t, var2) - 16usize];
};
pub const HB_GLYPH_FLAG_UNSAFE_TO_BREAK: hb_glyph_flags_t = 1;
pub const HB_GLYPH_FLAG_UNSAFE_TO_CONCAT: hb_glyph_flags_t = 2;
pub const HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL: hb_glyph_flags_t = 4;
pub const HB_GLYPH_FLAG_DEFINED: hb_glyph_flags_t = 7;
#[doc = " hb_glyph_flags_t:\n @HB_GLYPH_FLAG_UNSAFE_TO_BREAK: Indicates that if input text is broken at the\n \t\t\t\t   beginning of the cluster this glyph is part of,\n \t\t\t\t   then both sides need to be re-shaped, as the\n \t\t\t\t   result might be different.\n \t\t\t\t   On the flip side, it means that when this\n \t\t\t\t   flag is not present, then it is safe to break\n \t\t\t\t   the glyph-run at the beginning of this\n \t\t\t\t   cluster, and the two sides will represent the\n \t\t\t\t   exact same result one would get if breaking\n \t\t\t\t   input text at the beginning of this cluster\n \t\t\t\t   and shaping the two sides separately.\n \t\t\t\t   This can be used to optimize paragraph\n \t\t\t\t   layout, by avoiding re-shaping of each line\n \t\t\t\t   after line-breaking.\n @HB_GLYPH_FLAG_UNSAFE_TO_CONCAT: Indicates that if input text is changed on one\n \t\t\t\t   side of the beginning of the cluster this glyph\n \t\t\t\t   is part of, then the shaping results for the\n \t\t\t\t   other side might change.\n \t\t\t\t   Note that the absence of this flag will NOT by\n \t\t\t\t   itself mean that it IS safe to concat text.\n \t\t\t\t   Only two pieces of text both of which clear of\n \t\t\t\t   this flag can be concatenated safely.\n \t\t\t\t   This can be used to optimize paragraph\n \t\t\t\t   layout, by avoiding re-shaping of each line\n \t\t\t\t   after line-breaking, by limiting the\n \t\t\t\t   reshaping to a small piece around the\n \t\t\t\t   breaking position only, even if the breaking\n \t\t\t\t   position carries the\n \t\t\t\t   #HB_GLYPH_FLAG_UNSAFE_TO_BREAK or when\n \t\t\t\t   hyphenation or other text transformation\n \t\t\t\t   happens at line-break position, in the following\n \t\t\t\t   way:\n \t\t\t\t   1. Iterate back from the line-break position\n \t\t\t\t   until the first cluster start position that is\n \t\t\t\t   NOT unsafe-to-concat, 2. shape the segment from\n \t\t\t\t   there till the end of line, 3. check whether the\n \t\t\t\t   resulting glyph-run also is clear of the\n \t\t\t\t   unsafe-to-concat at its start-of-text position;\n \t\t\t\t   if it is, just splice it into place and the line\n \t\t\t\t   is shaped; If not, move on to a position further\n \t\t\t\t   back that is clear of unsafe-to-concat and retry\n \t\t\t\t   from there, and repeat.\n \t\t\t\t   At the start of next line a similar algorithm can\n \t\t\t\t   be implemented. That is: 1. Iterate forward from\n \t\t\t\t   the line-break position until the first cluster\n \t\t\t\t   start position that is NOT unsafe-to-concat, 2.\n \t\t\t\t   shape the segment from beginning of the line to\n \t\t\t\t   that position, 3. check whether the resulting\n \t\t\t\t   glyph-run also is clear of the unsafe-to-concat\n \t\t\t\t   at its end-of-text position; if it is, just splice\n \t\t\t\t   it into place and the beginning is shaped; If not,\n \t\t\t\t   move on to a position further forward that is clear\n \t\t\t\t   of unsafe-to-concat and retry up to there, and repeat.\n \t\t\t\t   A slight complication will arise in the\n \t\t\t\t   implementation of the algorithm above,\n \t\t\t\t   because while our buffer API has a way to\n \t\t\t\t   return flags for position corresponding to\n \t\t\t\t   start-of-text, there is currently no position\n \t\t\t\t   corresponding to end-of-text.  This limitation\n \t\t\t\t   can be alleviated by shaping more text than needed\n \t\t\t\t   and looking for unsafe-to-concat flag within text\n \t\t\t\t   clusters.\n \t\t\t\t   The #HB_GLYPH_FLAG_UNSAFE_TO_BREAK flag will\n \t\t\t\t   always imply this flag.\n\t\t\t\t   To use this flag, you must enable the buffer flag\n\t\t\t\t   @HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT during\n\t\t\t\t   shaping, otherwise the buffer flag will not be\n\t\t\t\t   reliably produced.\n \t\t\t\t   Since: 4.0.0\n @HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL: In scripts that use elongation (Arabic,\nMongolian, Syriac, etc.), this flag signifies\nthat it is safe to insert a U+0640 TATWEEL\ncharacter before this cluster for elongation.\nThis flag does not determine the\nscript-specific elongation places, but only\nwhen it is safe to do the elongation without\ninterrupting text shaping.\nSince: 5.1.0\n @HB_GLYPH_FLAG_DEFINED: All the currently defined flags.\n\n Flags for #hb_glyph_info_t.\n\n Since: 1.5.0"]
pub type hb_glyph_flags_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_glyph_info_get_glyph_flags(info: *const hb_glyph_info_t) -> hb_glyph_flags_t;
}
#[doc = " hb_glyph_position_t:\n @x_advance: how much the line advances after drawing this glyph when setting\n             text in horizontal direction.\n @y_advance: how much the line advances after drawing this glyph when setting\n             text in vertical direction.\n @x_offset: how much the glyph moves on the X-axis before drawing it, this\n            should not affect how much the line advances.\n @y_offset: how much the glyph moves on the Y-axis before drawing it, this\n            should not affect how much the line advances.\n\n The #hb_glyph_position_t is the structure that holds the positions of the\n glyph in both horizontal and vertical directions. All positions in\n #hb_glyph_position_t are relative to the current point.\n"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_glyph_position_t {
    pub x_advance: hb_position_t,
    pub y_advance: hb_position_t,
    pub x_offset: hb_position_t,
    pub y_offset: hb_position_t,
    pub var: hb_var_int_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_glyph_position_t"][::std::mem::size_of::<hb_glyph_position_t>() - 20usize];
    ["Alignment of hb_glyph_position_t"][::std::mem::align_of::<hb_glyph_position_t>() - 4usize];
    ["Offset of field: hb_glyph_position_t::x_advance"]
        [::std::mem::offset_of!(hb_glyph_position_t, x_advance) - 0usize];
    ["Offset of field: hb_glyph_position_t::y_advance"]
        [::std::mem::offset_of!(hb_glyph_position_t, y_advance) - 4usize];
    ["Offset of field: hb_glyph_position_t::x_offset"]
        [::std::mem::offset_of!(hb_glyph_position_t, x_offset) - 8usize];
    ["Offset of field: hb_glyph_position_t::y_offset"]
        [::std::mem::offset_of!(hb_glyph_position_t, y_offset) - 12usize];
    ["Offset of field: hb_glyph_position_t::var"]
        [::std::mem::offset_of!(hb_glyph_position_t, var) - 16usize];
};
#[doc = " hb_segment_properties_t:\n @direction: the #hb_direction_t of the buffer, see hb_buffer_set_direction().\n @script: the #hb_script_t of the buffer, see hb_buffer_set_script().\n @language: the #hb_language_t of the buffer, see hb_buffer_set_language().\n\n The structure that holds various text properties of an #hb_buffer_t. Can be\n set and retrieved using hb_buffer_set_segment_properties() and\n hb_buffer_get_segment_properties(), respectively."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_segment_properties_t {
    pub direction: hb_direction_t,
    pub script: hb_script_t,
    pub language: hb_language_t,
    pub reserved1: *mut ::std::os::raw::c_void,
    pub reserved2: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_segment_properties_t"][::std::mem::size_of::<hb_segment_properties_t>() - 32usize];
    ["Alignment of hb_segment_properties_t"]
        [::std::mem::align_of::<hb_segment_properties_t>() - 8usize];
    ["Offset of field: hb_segment_properties_t::direction"]
        [::std::mem::offset_of!(hb_segment_properties_t, direction) - 0usize];
    ["Offset of field: hb_segment_properties_t::script"]
        [::std::mem::offset_of!(hb_segment_properties_t, script) - 4usize];
    ["Offset of field: hb_segment_properties_t::language"]
        [::std::mem::offset_of!(hb_segment_properties_t, language) - 8usize];
    ["Offset of field: hb_segment_properties_t::reserved1"]
        [::std::mem::offset_of!(hb_segment_properties_t, reserved1) - 16usize];
    ["Offset of field: hb_segment_properties_t::reserved2"]
        [::std::mem::offset_of!(hb_segment_properties_t, reserved2) - 24usize];
};
extern "C" {
    pub fn hb_segment_properties_equal(
        a: *const hb_segment_properties_t,
        b: *const hb_segment_properties_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_segment_properties_hash(p: *const hb_segment_properties_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_segment_properties_overlay(
        p: *mut hb_segment_properties_t,
        src: *const hb_segment_properties_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_buffer_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_buffer_create() -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_create_similar(src: *const hb_buffer_t) -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_reset(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_get_empty() -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_reference(buffer: *mut hb_buffer_t) -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_destroy(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_set_user_data(
        buffer: *mut hb_buffer_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_get_user_data(
        buffer: *const hb_buffer_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
pub const HB_BUFFER_CONTENT_TYPE_INVALID: hb_buffer_content_type_t = 0;
pub const HB_BUFFER_CONTENT_TYPE_UNICODE: hb_buffer_content_type_t = 1;
pub const HB_BUFFER_CONTENT_TYPE_GLYPHS: hb_buffer_content_type_t = 2;
#[doc = " hb_buffer_content_type_t:\n @HB_BUFFER_CONTENT_TYPE_INVALID: Initial value for new buffer.\n @HB_BUFFER_CONTENT_TYPE_UNICODE: The buffer contains input characters (before shaping).\n @HB_BUFFER_CONTENT_TYPE_GLYPHS: The buffer contains output glyphs (after shaping).\n\n The type of #hb_buffer_t contents."]
pub type hb_buffer_content_type_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_buffer_set_content_type(
        buffer: *mut hb_buffer_t,
        content_type: hb_buffer_content_type_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_content_type(buffer: *const hb_buffer_t) -> hb_buffer_content_type_t;
}
extern "C" {
    pub fn hb_buffer_set_unicode_funcs(
        buffer: *mut hb_buffer_t,
        unicode_funcs: *mut hb_unicode_funcs_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_unicode_funcs(buffer: *const hb_buffer_t) -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_buffer_set_direction(buffer: *mut hb_buffer_t, direction: hb_direction_t);
}
extern "C" {
    pub fn hb_buffer_get_direction(buffer: *const hb_buffer_t) -> hb_direction_t;
}
extern "C" {
    pub fn hb_buffer_set_script(buffer: *mut hb_buffer_t, script: hb_script_t);
}
extern "C" {
    pub fn hb_buffer_get_script(buffer: *const hb_buffer_t) -> hb_script_t;
}
extern "C" {
    pub fn hb_buffer_set_language(buffer: *mut hb_buffer_t, language: hb_language_t);
}
extern "C" {
    pub fn hb_buffer_get_language(buffer: *const hb_buffer_t) -> hb_language_t;
}
extern "C" {
    pub fn hb_buffer_set_segment_properties(
        buffer: *mut hb_buffer_t,
        props: *const hb_segment_properties_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_segment_properties(
        buffer: *const hb_buffer_t,
        props: *mut hb_segment_properties_t,
    );
}
extern "C" {
    pub fn hb_buffer_guess_segment_properties(buffer: *mut hb_buffer_t);
}
pub const HB_BUFFER_FLAG_DEFAULT: hb_buffer_flags_t = 0;
pub const HB_BUFFER_FLAG_BOT: hb_buffer_flags_t = 1;
pub const HB_BUFFER_FLAG_EOT: hb_buffer_flags_t = 2;
pub const HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES: hb_buffer_flags_t = 4;
pub const HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES: hb_buffer_flags_t = 8;
pub const HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE: hb_buffer_flags_t = 16;
pub const HB_BUFFER_FLAG_VERIFY: hb_buffer_flags_t = 32;
pub const HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT: hb_buffer_flags_t = 64;
pub const HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL: hb_buffer_flags_t = 128;
pub const HB_BUFFER_FLAG_DEFINED: hb_buffer_flags_t = 255;
#[doc = " hb_buffer_flags_t:\n @HB_BUFFER_FLAG_DEFAULT: the default buffer flag.\n @HB_BUFFER_FLAG_BOT: flag indicating that special handling of the beginning\n                      of text paragraph can be applied to this buffer. Should usually\n                      be set, unless you are passing to the buffer only part\n                      of the text without the full context.\n @HB_BUFFER_FLAG_EOT: flag indicating that special handling of the end of text\n                      paragraph can be applied to this buffer, similar to\n                      @HB_BUFFER_FLAG_BOT.\n @HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES:\n                      flag indication that character with Default_Ignorable\n                      Unicode property should use the corresponding glyph\n                      from the font, instead of hiding them (done by\n                      replacing them with the space glyph and zeroing the\n                      advance width.)  This flag takes precedence over\n                      @HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES.\n @HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES:\n                      flag indication that character with Default_Ignorable\n                      Unicode property should be removed from glyph string\n                      instead of hiding them (done by replacing them with the\n                      space glyph and zeroing the advance width.)\n                      @HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES takes\n                      precedence over this flag. Since: 1.8.0\n @HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE:\n                      flag indicating that a dotted circle should\n                      not be inserted in the rendering of incorrect\n                      character sequences (such at <0905 093E>). Since: 2.4.0\n @HB_BUFFER_FLAG_VERIFY:\n                      flag indicating that the hb_shape() call and its variants\n                      should perform various verification processes on the results\n                      of the shaping operation on the buffer.  If the verification\n                      fails, then either a buffer message is sent, if a message\n                      handler is installed on the buffer, or a message is written\n                      to standard error.  In either case, the shaping result might\n                      be modified to show the failed output. Since: 3.4.0\n @HB_BUFFER_FLAG_PRODUCE_UNSAFE_TO_CONCAT:\n                      flag indicating that the @HB_GLYPH_FLAG_UNSAFE_TO_CONCAT\n                      glyph-flag should be produced by the shaper. By default\n                      it will not be produced since it incurs a cost. Since: 4.0.0\n @HB_BUFFER_FLAG_PRODUCE_SAFE_TO_INSERT_TATWEEL:\n                      flag indicating that the @HB_GLYPH_FLAG_SAFE_TO_INSERT_TATWEEL\n                      glyph-flag should be produced by the shaper. By default\n                      it will not be produced. Since: 5.1.0\n @HB_BUFFER_FLAG_DEFINED: All currently defined flags: Since: 4.4.0\n\n Flags for #hb_buffer_t.\n\n Since: 0.9.20"]
pub type hb_buffer_flags_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_buffer_set_flags(buffer: *mut hb_buffer_t, flags: hb_buffer_flags_t);
}
extern "C" {
    pub fn hb_buffer_get_flags(buffer: *const hb_buffer_t) -> hb_buffer_flags_t;
}
pub const HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES: hb_buffer_cluster_level_t = 0;
pub const HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS: hb_buffer_cluster_level_t = 1;
pub const HB_BUFFER_CLUSTER_LEVEL_CHARACTERS: hb_buffer_cluster_level_t = 2;
pub const HB_BUFFER_CLUSTER_LEVEL_DEFAULT: hb_buffer_cluster_level_t = 0;
#[doc = " hb_buffer_cluster_level_t:\n @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES: Return cluster values grouped by graphemes into\n   monotone order.\n @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS: Return cluster values grouped into monotone order.\n @HB_BUFFER_CLUSTER_LEVEL_CHARACTERS: Don't group cluster values.\n @HB_BUFFER_CLUSTER_LEVEL_DEFAULT: Default cluster level,\n   equal to @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES.\n\n Data type for holding HarfBuzz's clustering behavior options. The cluster level\n dictates one aspect of how HarfBuzz will treat non-base characters\n during shaping.\n\n In @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES, non-base\n characters are merged into the cluster of the base character that precedes them.\n\n In @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS, non-base characters are initially\n assigned their own cluster values, which are not merged into preceding base\n clusters. This allows HarfBuzz to perform additional operations like reorder\n sequences of adjacent marks.\n\n @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES is the default, because it maintains\n backward compatibility with older versions of HarfBuzz. New client programs that\n do not need to maintain such backward compatibility are recommended to use\n @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS instead of the default.\n\n Since: 0.9.42"]
pub type hb_buffer_cluster_level_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_buffer_set_cluster_level(
        buffer: *mut hb_buffer_t,
        cluster_level: hb_buffer_cluster_level_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_cluster_level(buffer: *const hb_buffer_t) -> hb_buffer_cluster_level_t;
}
extern "C" {
    pub fn hb_buffer_set_replacement_codepoint(
        buffer: *mut hb_buffer_t,
        replacement: hb_codepoint_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_replacement_codepoint(buffer: *const hb_buffer_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_buffer_set_invisible_glyph(buffer: *mut hb_buffer_t, invisible: hb_codepoint_t);
}
extern "C" {
    pub fn hb_buffer_get_invisible_glyph(buffer: *const hb_buffer_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_buffer_set_not_found_glyph(buffer: *mut hb_buffer_t, not_found: hb_codepoint_t);
}
extern "C" {
    pub fn hb_buffer_get_not_found_glyph(buffer: *const hb_buffer_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_buffer_set_not_found_variation_selector_glyph(
        buffer: *mut hb_buffer_t,
        not_found_variation_selector: hb_codepoint_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_not_found_variation_selector_glyph(
        buffer: *const hb_buffer_t,
    ) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_buffer_set_random_state(buffer: *mut hb_buffer_t, state: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_buffer_get_random_state(buffer: *const hb_buffer_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_clear_contents(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_pre_allocate(
        buffer: *mut hb_buffer_t,
        size: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_allocation_successful(buffer: *mut hb_buffer_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_reverse(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_reverse_range(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_buffer_reverse_clusters(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_add(
        buffer: *mut hb_buffer_t,
        codepoint: hb_codepoint_t,
        cluster: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_buffer_add_utf8(
        buffer: *mut hb_buffer_t,
        text: *const ::std::os::raw::c_char,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_utf16(
        buffer: *mut hb_buffer_t,
        text: *const u16,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_utf32(
        buffer: *mut hb_buffer_t,
        text: *const u32,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_latin1(
        buffer: *mut hb_buffer_t,
        text: *const u8,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_codepoints(
        buffer: *mut hb_buffer_t,
        text: *const hb_codepoint_t,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_append(
        buffer: *mut hb_buffer_t,
        source: *const hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_buffer_set_length(
        buffer: *mut hb_buffer_t,
        length: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_get_length(buffer: *const hb_buffer_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_get_glyph_infos(
        buffer: *mut hb_buffer_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut hb_glyph_info_t;
}
extern "C" {
    pub fn hb_buffer_get_glyph_positions(
        buffer: *mut hb_buffer_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut hb_glyph_position_t;
}
extern "C" {
    pub fn hb_buffer_has_positions(buffer: *mut hb_buffer_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_normalize_glyphs(buffer: *mut hb_buffer_t);
}
pub const HB_BUFFER_SERIALIZE_FLAG_DEFAULT: hb_buffer_serialize_flags_t = 0;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS: hb_buffer_serialize_flags_t = 1;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS: hb_buffer_serialize_flags_t = 2;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES: hb_buffer_serialize_flags_t = 4;
pub const HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS: hb_buffer_serialize_flags_t = 8;
pub const HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS: hb_buffer_serialize_flags_t = 16;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES: hb_buffer_serialize_flags_t = 32;
pub const HB_BUFFER_SERIALIZE_FLAG_DEFINED: hb_buffer_serialize_flags_t = 63;
#[doc = " hb_buffer_serialize_flags_t:\n @HB_BUFFER_SERIALIZE_FLAG_DEFAULT: serialize glyph names, clusters and positions.\n @HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS: do not serialize glyph cluster.\n @HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS: do not serialize glyph position information.\n @HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES: do no serialize glyph name.\n @HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS: serialize glyph extents.\n @HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS: serialize glyph flags. Since: 1.5.0\n @HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES: do not serialize glyph advances,\n  glyph offsets will reflect absolute glyph positions. Since: 1.8.0\n @HB_BUFFER_SERIALIZE_FLAG_DEFINED: All currently defined flags. Since: 4.4.0\n\n Flags that control what glyph information are serialized in hb_buffer_serialize_glyphs().\n\n Since: 0.9.20"]
pub type hb_buffer_serialize_flags_t = ::std::os::raw::c_uint;
pub const HB_BUFFER_SERIALIZE_FORMAT_TEXT: hb_buffer_serialize_format_t = 1413830740;
pub const HB_BUFFER_SERIALIZE_FORMAT_JSON: hb_buffer_serialize_format_t = 1246973774;
pub const HB_BUFFER_SERIALIZE_FORMAT_INVALID: hb_buffer_serialize_format_t = 0;
#[doc = " hb_buffer_serialize_format_t:\n @HB_BUFFER_SERIALIZE_FORMAT_TEXT: a human-readable, plain text format.\n @HB_BUFFER_SERIALIZE_FORMAT_JSON: a machine-readable JSON format.\n @HB_BUFFER_SERIALIZE_FORMAT_INVALID: invalid format.\n\n The buffer serialization and de-serialization format used in\n hb_buffer_serialize_glyphs() and hb_buffer_deserialize_glyphs().\n\n Since: 0.9.2"]
pub type hb_buffer_serialize_format_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_buffer_serialize_format_from_string(
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_buffer_serialize_format_t;
}
extern "C" {
    pub fn hb_buffer_serialize_format_to_string(
        format: hb_buffer_serialize_format_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_buffer_serialize_list_formats() -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_buffer_serialize_glyphs(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_serialize_unicode(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_serialize(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_deserialize_glyphs(
        buffer: *mut hb_buffer_t,
        buf: *const ::std::os::raw::c_char,
        buf_len: ::std::os::raw::c_int,
        end_ptr: *mut *const ::std::os::raw::c_char,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_deserialize_unicode(
        buffer: *mut hb_buffer_t,
        buf: *const ::std::os::raw::c_char,
        buf_len: ::std::os::raw::c_int,
        end_ptr: *mut *const ::std::os::raw::c_char,
        format: hb_buffer_serialize_format_t,
    ) -> hb_bool_t;
}
pub const HB_BUFFER_DIFF_FLAG_EQUAL: hb_buffer_diff_flags_t = 0;
pub const HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH: hb_buffer_diff_flags_t = 1;
pub const HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH: hb_buffer_diff_flags_t = 2;
pub const HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT: hb_buffer_diff_flags_t = 4;
pub const HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT: hb_buffer_diff_flags_t = 8;
pub const HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH: hb_buffer_diff_flags_t = 16;
pub const HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH: hb_buffer_diff_flags_t = 32;
pub const HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH: hb_buffer_diff_flags_t = 64;
pub const HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH: hb_buffer_diff_flags_t = 128;
#[doc = " hb_buffer_diff_flags_t:\n @HB_BUFFER_DIFF_FLAG_EQUAL: equal buffers.\n @HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH: buffers with different\n     #hb_buffer_content_type_t.\n @HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH: buffers with differing length.\n @HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT: `.notdef` glyph is present in the\n     reference buffer.\n @HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT: dotted circle glyph is present\n     in the reference buffer.\n @HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH: difference in #hb_glyph_info_t.codepoint\n @HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH: difference in #hb_glyph_info_t.cluster\n @HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH: difference in #hb_glyph_flags_t.\n @HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH: difference in #hb_glyph_position_t.\n\n Flags from comparing two #hb_buffer_t's.\n\n Buffer with different #hb_buffer_content_type_t cannot be meaningfully\n compared in any further detail.\n\n For buffers with differing length, the per-glyph comparison is not\n attempted, though we do still scan reference buffer for dotted circle and\n `.notdef` glyphs.\n\n If the buffers have the same length, we compare them glyph-by-glyph and\n report which aspect(s) of the glyph info/position are different.\n\n Since: 1.5.0"]
pub type hb_buffer_diff_flags_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_buffer_diff(
        buffer: *mut hb_buffer_t,
        reference: *mut hb_buffer_t,
        dottedcircle_glyph: hb_codepoint_t,
        position_fuzz: ::std::os::raw::c_uint,
    ) -> hb_buffer_diff_flags_t;
}
#[doc = " hb_buffer_message_func_t:\n @buffer: An #hb_buffer_t to work upon\n @font: The #hb_font_t the @buffer is shaped with\n @message: `NULL`-terminated message passed to the function\n @user_data: User data pointer passed by the caller\n\n A callback method for #hb_buffer_t. The method gets called with the\n #hb_buffer_t it was set on, the #hb_font_t the buffer is shaped with and a\n message describing what step of the shaping process will be performed.\n Returning `false` from this method will skip this shaping step and move to\n the next one.\n\n Return value: `true` to perform the shaping step, `false` to skip it.\n\n Since: 1.1.3"]
pub type hb_buffer_message_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        buffer: *mut hb_buffer_t,
        font: *mut hb_font_t,
        message: *const ::std::os::raw::c_char,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    pub fn hb_buffer_set_message_func(
        buffer: *mut hb_buffer_t,
        func: hb_buffer_message_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
#[doc = " hb_font_get_glyph_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @unicode: The Unicode code point to query\n @variation_selector: The  variation-selector code point to query\n @glyph: (out): The glyph ID retrieved\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the glyph ID for a specified Unicode code point\n font, with an optional variation selector.\n\n Return value: `true` if data found, `false` otherwise\n Deprecated: 1.2.3\n"]
pub type hb_font_get_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    pub fn hb_font_funcs_set_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
#[doc = " hb_unicode_eastasian_width_func_t:\n @ufuncs: A Unicode-functions structure\n @unicode: The code point to query\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_unicode_funcs_t structure.\n\n Deprecated: 2.0.0"]
pub type hb_unicode_eastasian_width_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
extern "C" {
    #[doc = " hb_unicode_funcs_set_eastasian_width_func:\n @ufuncs: a Unicode-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_eastasian_width_func_t.\n\n Since: 0.9.2\n Deprecated: 2.0.0"]
    pub fn hb_unicode_funcs_set_eastasian_width_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_eastasian_width_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    #[doc = " hb_unicode_eastasian_width:\n @ufuncs: a Unicode-function structure\n @unicode: The code point to query\n\n Don't use. Not used by HarfBuzz.\n\n Since: 0.9.2\n Deprecated: 2.0.0"]
    pub fn hb_unicode_eastasian_width(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
#[doc = " hb_unicode_decompose_compatibility_func_t:\n @ufuncs: a Unicode function structure\n @u: codepoint to decompose\n @decomposed: address of codepoint array (of length #HB_UNICODE_MAX_DECOMPOSITION_LEN) to write decomposition into\n @user_data: user data pointer as passed to hb_unicode_funcs_set_decompose_compatibility_func()\n\n Fully decompose @u to its Unicode compatibility decomposition. The codepoints of the decomposition will be written to @decomposed.\n The complete length of the decomposition will be returned.\n\n If @u has no compatibility decomposition, zero should be returned.\n\n The Unicode standard guarantees that a buffer of length #HB_UNICODE_MAX_DECOMPOSITION_LEN codepoints will always be sufficient for any\n compatibility decomposition plus an terminating value of 0.  Consequently, @decompose must be allocated by the caller to be at least this length.  Implementations\n of this function type must ensure that they do not write past the provided array.\n\n Return value: number of codepoints in the full compatibility decomposition of @u, or 0 if no decomposition available.\n\n Deprecated: 2.0.0"]
pub type hb_unicode_decompose_compatibility_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        u: hb_codepoint_t,
        decomposed: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
extern "C" {
    #[doc = " hb_unicode_funcs_set_decompose_compatibility_func:\n @ufuncs: A Unicode-functions structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_unicode_decompose_compatibility_func_t.\n\n\n\n Since: 0.9.2\n Deprecated: 2.0.0"]
    pub fn hb_unicode_funcs_set_decompose_compatibility_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_decompose_compatibility_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_unicode_decompose_compatibility(
        ufuncs: *mut hb_unicode_funcs_t,
        u: hb_codepoint_t,
        decomposed: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
#[doc = " hb_font_get_glyph_v_kerning_func_t:\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n This method should retrieve the kerning-adjustment value for a glyph-pair in\n the specified font, for vertical text segments.\n"]
pub type hb_font_get_glyph_v_kerning_func_t = hb_font_get_glyph_kerning_func_t;
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_v_kerning_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_v_kerning_func_t.\n\n Since: 0.9.2\n Deprecated: 2.0.0"]
    pub fn hb_font_funcs_set_glyph_v_kerning_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_kerning_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_v_kerning(
        font: *mut hb_font_t,
        top_glyph: hb_codepoint_t,
        bottom_glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
#[doc = " hb_font_get_glyph_shape_func_t:\n @font: #hb_font_t to work upon\n @font_data: @font user data pointer\n @glyph: The glyph ID to query\n @draw_funcs: The draw functions to send the shape data to\n @draw_data: The data accompanying the draw functions\n @user_data: User data pointer passed by the caller\n\n A virtual method for the #hb_font_funcs_t of an #hb_font_t object.\n\n Since: 4.0.0\n Deprecated: 7.0.0: Use #hb_font_draw_glyph_func_t instead"]
pub type hb_font_get_glyph_shape_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        draw_funcs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    #[doc = " hb_font_funcs_set_glyph_shape_func:\n @ffuncs: A font-function structure\n @func: (closure user_data) (destroy destroy) (scope notified): The callback function to assign\n @user_data: Data to pass to @func\n @destroy: (nullable): The function to call when @user_data is not needed anymore\n\n Sets the implementation function for #hb_font_get_glyph_shape_func_t,\n which is the same as #hb_font_draw_glyph_func_t.\n\n Since: 4.0.0\n Deprecated: 7.0.0: Use hb_font_funcs_set_draw_glyph_func() instead"]
    pub fn hb_font_funcs_set_glyph_shape_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_shape_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_shape(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        dfuncs: *mut hb_draw_funcs_t,
        draw_data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn hb_shape(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_shape_full(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_justify(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
        min_target_advance: f32,
        max_target_advance: f32,
        advance: *mut f32,
        var_tag: *mut hb_tag_t,
        var_value: *mut f32,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_list_shapers() -> *mut *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_shape_plan_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_shape_plan_create(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_create_cached(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_create2(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_create_cached2(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_get_empty() -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_reference(shape_plan: *mut hb_shape_plan_t) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_destroy(shape_plan: *mut hb_shape_plan_t);
}
extern "C" {
    pub fn hb_shape_plan_set_user_data(
        shape_plan: *mut hb_shape_plan_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_plan_get_user_data(
        shape_plan: *const hb_shape_plan_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_shape_plan_execute(
        shape_plan: *mut hb_shape_plan_t,
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_plan_get_shaper(
        shape_plan: *mut hb_shape_plan_t,
    ) -> *const ::std::os::raw::c_char;
}
pub const HB_STYLE_TAG_ITALIC: hb_style_tag_t = 1769234796;
pub const HB_STYLE_TAG_OPTICAL_SIZE: hb_style_tag_t = 1869640570;
pub const HB_STYLE_TAG_SLANT_ANGLE: hb_style_tag_t = 1936486004;
pub const HB_STYLE_TAG_SLANT_RATIO: hb_style_tag_t = 1399615092;
pub const HB_STYLE_TAG_WIDTH: hb_style_tag_t = 2003072104;
pub const HB_STYLE_TAG_WEIGHT: hb_style_tag_t = 2003265652;
pub const _HB_STYLE_TAG_MAX_VALUE: hb_style_tag_t = 2147483647;
#[doc = " hb_style_tag_t:\n @HB_STYLE_TAG_ITALIC: Used to vary between non-italic and italic.\n A value of 0 can be interpreted as \"Roman\" (non-italic); a value of 1 can\n be interpreted as (fully) italic.\n @HB_STYLE_TAG_OPTICAL_SIZE: Used to vary design to suit different text sizes.\n Non-zero. Values can be interpreted as text size, in points.\n @HB_STYLE_TAG_SLANT_ANGLE: Used to vary between upright and slanted text. Values\n must be greater than -90 and less than +90. Values can be interpreted as\n the angle, in counter-clockwise degrees, of oblique slant from whatever the\n designer considers to be upright for that font design. Typical right-leaning\n Italic fonts have a negative slant angle (typically around -12)\n @HB_STYLE_TAG_SLANT_RATIO: same as @HB_STYLE_TAG_SLANT_ANGLE expression as ratio.\n Typical right-leaning Italic fonts have a positive slant ratio (typically around 0.2)\n @HB_STYLE_TAG_WIDTH: Used to vary width of text from narrower to wider.\n Non-zero. Values can be interpreted as a percentage of whatever the font\n designer considers “normal width” for that font design.\n @HB_STYLE_TAG_WEIGHT: Used to vary stroke thicknesses or other design details\n to give variation from lighter to blacker. Values can be interpreted in direct\n comparison to values for usWeightClass in the OS/2 table,\n or the CSS font-weight property.\n\n Defined by [OpenType Design-Variation Axis Tag Registry](https://docs.microsoft.com/en-us/typography/opentype/spec/dvaraxisreg).\n\n Since: 3.0.0"]
pub type hb_style_tag_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_style_get_value(font: *mut hb_font_t, style_tag: hb_style_tag_t) -> f32;
}
extern "C" {
    pub fn hb_version(
        major: *mut ::std::os::raw::c_uint,
        minor: *mut ::std::os::raw::c_uint,
        micro: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_version_string() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_version_atleast(
        major: ::std::os::raw::c_uint,
        minor: ::std::os::raw::c_uint,
        micro: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
pub const HB_OT_NAME_ID_COPYRIGHT: hb_ot_name_id_predefined_t = 0;
pub const HB_OT_NAME_ID_FONT_FAMILY: hb_ot_name_id_predefined_t = 1;
pub const HB_OT_NAME_ID_FONT_SUBFAMILY: hb_ot_name_id_predefined_t = 2;
pub const HB_OT_NAME_ID_UNIQUE_ID: hb_ot_name_id_predefined_t = 3;
pub const HB_OT_NAME_ID_FULL_NAME: hb_ot_name_id_predefined_t = 4;
pub const HB_OT_NAME_ID_VERSION_STRING: hb_ot_name_id_predefined_t = 5;
pub const HB_OT_NAME_ID_POSTSCRIPT_NAME: hb_ot_name_id_predefined_t = 6;
pub const HB_OT_NAME_ID_TRADEMARK: hb_ot_name_id_predefined_t = 7;
pub const HB_OT_NAME_ID_MANUFACTURER: hb_ot_name_id_predefined_t = 8;
pub const HB_OT_NAME_ID_DESIGNER: hb_ot_name_id_predefined_t = 9;
pub const HB_OT_NAME_ID_DESCRIPTION: hb_ot_name_id_predefined_t = 10;
pub const HB_OT_NAME_ID_VENDOR_URL: hb_ot_name_id_predefined_t = 11;
pub const HB_OT_NAME_ID_DESIGNER_URL: hb_ot_name_id_predefined_t = 12;
pub const HB_OT_NAME_ID_LICENSE: hb_ot_name_id_predefined_t = 13;
pub const HB_OT_NAME_ID_LICENSE_URL: hb_ot_name_id_predefined_t = 14;
pub const HB_OT_NAME_ID_TYPOGRAPHIC_FAMILY: hb_ot_name_id_predefined_t = 16;
pub const HB_OT_NAME_ID_TYPOGRAPHIC_SUBFAMILY: hb_ot_name_id_predefined_t = 17;
pub const HB_OT_NAME_ID_MAC_FULL_NAME: hb_ot_name_id_predefined_t = 18;
pub const HB_OT_NAME_ID_SAMPLE_TEXT: hb_ot_name_id_predefined_t = 19;
pub const HB_OT_NAME_ID_CID_FINDFONT_NAME: hb_ot_name_id_predefined_t = 20;
pub const HB_OT_NAME_ID_WWS_FAMILY: hb_ot_name_id_predefined_t = 21;
pub const HB_OT_NAME_ID_WWS_SUBFAMILY: hb_ot_name_id_predefined_t = 22;
pub const HB_OT_NAME_ID_LIGHT_BACKGROUND: hb_ot_name_id_predefined_t = 23;
pub const HB_OT_NAME_ID_DARK_BACKGROUND: hb_ot_name_id_predefined_t = 24;
pub const HB_OT_NAME_ID_VARIATIONS_PS_PREFIX: hb_ot_name_id_predefined_t = 25;
pub const HB_OT_NAME_ID_INVALID: hb_ot_name_id_predefined_t = 65535;
#[doc = " hb_ot_name_id_predefined_t:\n @HB_OT_NAME_ID_COPYRIGHT: Copyright notice\n @HB_OT_NAME_ID_FONT_FAMILY: Font Family name\n @HB_OT_NAME_ID_FONT_SUBFAMILY: Font Subfamily name\n @HB_OT_NAME_ID_UNIQUE_ID: Unique font identifier\n @HB_OT_NAME_ID_FULL_NAME: Full font name that reflects\n all family and relevant subfamily descriptors\n @HB_OT_NAME_ID_VERSION_STRING: Version string\n @HB_OT_NAME_ID_POSTSCRIPT_NAME: PostScript name for the font\n @HB_OT_NAME_ID_TRADEMARK: Trademark\n @HB_OT_NAME_ID_MANUFACTURER: Manufacturer Name\n @HB_OT_NAME_ID_DESIGNER: Designer\n @HB_OT_NAME_ID_DESCRIPTION: Description\n @HB_OT_NAME_ID_VENDOR_URL: URL of font vendor\n @HB_OT_NAME_ID_DESIGNER_URL: URL of typeface designer\n @HB_OT_NAME_ID_LICENSE: License Description\n @HB_OT_NAME_ID_LICENSE_URL: URL where additional licensing\n information can be found\n @HB_OT_NAME_ID_TYPOGRAPHIC_FAMILY: Typographic Family name\n @HB_OT_NAME_ID_TYPOGRAPHIC_SUBFAMILY: Typographic Subfamily name\n @HB_OT_NAME_ID_MAC_FULL_NAME: Compatible Full Name for MacOS\n @HB_OT_NAME_ID_SAMPLE_TEXT: Sample text\n @HB_OT_NAME_ID_CID_FINDFONT_NAME: PostScript CID findfont name\n @HB_OT_NAME_ID_WWS_FAMILY: WWS Family Name\n @HB_OT_NAME_ID_WWS_SUBFAMILY: WWS Subfamily Name\n @HB_OT_NAME_ID_LIGHT_BACKGROUND: Light Background Palette\n @HB_OT_NAME_ID_DARK_BACKGROUND: Dark Background Palette\n @HB_OT_NAME_ID_VARIATIONS_PS_PREFIX: Variations PostScript Name Prefix\n @HB_OT_NAME_ID_INVALID: Value to represent a nonexistent name ID.\n\n An enum type representing the pre-defined name IDs.\n\n For more information on these fields, see the\n [OpenType spec](https://docs.microsoft.com/en-us/typography/opentype/spec/name#name-ids).\n\n Since: 7.0.0"]
pub type hb_ot_name_id_predefined_t = ::std::os::raw::c_uint;
#[doc = " hb_ot_name_id_t:\n\n An integral type representing an OpenType 'name' table name identifier.\n There are predefined name IDs, as well as name IDs return from other\n API.  These can be used to fetch name strings from a font face.\n\n Since: 2.0.0"]
pub type hb_ot_name_id_t = ::std::os::raw::c_uint;
#[doc = " hb_ot_name_entry_t:\n @name_id: name ID\n @language: language\n\n Structure representing a name ID in a particular language.\n\n Since: 2.1.0"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_ot_name_entry_t {
    pub name_id: hb_ot_name_id_t,
    pub var: hb_var_int_t,
    pub language: hb_language_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_name_entry_t"][::std::mem::size_of::<hb_ot_name_entry_t>() - 16usize];
    ["Alignment of hb_ot_name_entry_t"][::std::mem::align_of::<hb_ot_name_entry_t>() - 8usize];
    ["Offset of field: hb_ot_name_entry_t::name_id"]
        [::std::mem::offset_of!(hb_ot_name_entry_t, name_id) - 0usize];
    ["Offset of field: hb_ot_name_entry_t::var"]
        [::std::mem::offset_of!(hb_ot_name_entry_t, var) - 4usize];
    ["Offset of field: hb_ot_name_entry_t::language"]
        [::std::mem::offset_of!(hb_ot_name_entry_t, language) - 8usize];
};
extern "C" {
    pub fn hb_ot_name_list_names(
        face: *mut hb_face_t,
        num_entries: *mut ::std::os::raw::c_uint,
    ) -> *const hb_ot_name_entry_t;
}
extern "C" {
    pub fn hb_ot_name_get_utf8(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_name_get_utf16(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut u16,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_name_get_utf32(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut u32,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_has_palettes(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_palette_get_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_palette_get_name_id(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
extern "C" {
    pub fn hb_ot_color_palette_color_get_name_id(
        face: *mut hb_face_t,
        color_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
pub const HB_OT_COLOR_PALETTE_FLAG_DEFAULT: hb_ot_color_palette_flags_t = 0;
pub const HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND: hb_ot_color_palette_flags_t = 1;
pub const HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND: hb_ot_color_palette_flags_t = 2;
#[doc = " hb_ot_color_palette_flags_t:\n @HB_OT_COLOR_PALETTE_FLAG_DEFAULT: Default indicating that there is nothing special\n   to note about a color palette.\n @HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND: Flag indicating that the color\n   palette is appropriate to use when displaying the font on a light background such as white.\n @HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND: Flag indicating that the color\n   palette is appropriate to use when displaying the font on a dark background such as black.\n\n Flags that describe the properties of color palette.\n\n Since: 2.1.0"]
pub type hb_ot_color_palette_flags_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_ot_color_palette_get_flags(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
    ) -> hb_ot_color_palette_flags_t;
}
extern "C" {
    pub fn hb_ot_color_palette_get_colors(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        color_count: *mut ::std::os::raw::c_uint,
        colors: *mut hb_color_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_has_layers(face: *mut hb_face_t) -> hb_bool_t;
}
#[doc = " hb_ot_color_layer_t:\n @glyph: the glyph ID of the layer\n @color_index: the palette color index of the layer\n\n Pairs of glyph and color index.\n\n A color index of 0xFFFF does not refer to a palette\n color, but indicates that the foreground color should\n be used.\n\n Since: 2.1.0"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_color_layer_t {
    pub glyph: hb_codepoint_t,
    pub color_index: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_color_layer_t"][::std::mem::size_of::<hb_ot_color_layer_t>() - 8usize];
    ["Alignment of hb_ot_color_layer_t"][::std::mem::align_of::<hb_ot_color_layer_t>() - 4usize];
    ["Offset of field: hb_ot_color_layer_t::glyph"]
        [::std::mem::offset_of!(hb_ot_color_layer_t, glyph) - 0usize];
    ["Offset of field: hb_ot_color_layer_t::color_index"]
        [::std::mem::offset_of!(hb_ot_color_layer_t, color_index) - 4usize];
};
extern "C" {
    pub fn hb_ot_color_glyph_get_layers(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        layer_count: *mut ::std::os::raw::c_uint,
        layers: *mut hb_ot_color_layer_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_has_paint(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_glyph_has_paint(face: *mut hb_face_t, glyph: hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_has_svg(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_glyph_reference_svg(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_ot_color_has_png(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_glyph_reference_png(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_ot_layout_table_choose_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_tags: *const hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
        chosen_script: *mut hb_tag_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_script_find_language(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_tag: hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_tags_from_script(
        script: hb_script_t,
        script_tag_1: *mut hb_tag_t,
        script_tag_2: *mut hb_tag_t,
    );
}
extern "C" {
    pub fn hb_ot_tag_from_language(language: hb_language_t) -> hb_tag_t;
}
#[doc = " hb_ot_var_axis_t:\n @tag: axis tag\n @name_id: axis name identifier\n @min_value: minimum value of the axis\n @default_value: default value of the axis\n @max_value: maximum value of the axis\n\n Use #hb_ot_var_axis_info_t instead.\n\n Since: 1.4.2\n Deprecated: 2.2.0"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_var_axis_t {
    pub tag: hb_tag_t,
    pub name_id: hb_ot_name_id_t,
    pub min_value: f32,
    pub default_value: f32,
    pub max_value: f32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_var_axis_t"][::std::mem::size_of::<hb_ot_var_axis_t>() - 20usize];
    ["Alignment of hb_ot_var_axis_t"][::std::mem::align_of::<hb_ot_var_axis_t>() - 4usize];
    ["Offset of field: hb_ot_var_axis_t::tag"]
        [::std::mem::offset_of!(hb_ot_var_axis_t, tag) - 0usize];
    ["Offset of field: hb_ot_var_axis_t::name_id"]
        [::std::mem::offset_of!(hb_ot_var_axis_t, name_id) - 4usize];
    ["Offset of field: hb_ot_var_axis_t::min_value"]
        [::std::mem::offset_of!(hb_ot_var_axis_t, min_value) - 8usize];
    ["Offset of field: hb_ot_var_axis_t::default_value"]
        [::std::mem::offset_of!(hb_ot_var_axis_t, default_value) - 12usize];
    ["Offset of field: hb_ot_var_axis_t::max_value"]
        [::std::mem::offset_of!(hb_ot_var_axis_t, max_value) - 16usize];
};
extern "C" {
    pub fn hb_ot_var_get_axes(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        axes_count: *mut ::std::os::raw::c_uint,
        axes_array: *mut hb_ot_var_axis_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_find_axis(
        face: *mut hb_face_t,
        axis_tag: hb_tag_t,
        axis_index: *mut ::std::os::raw::c_uint,
        axis_info: *mut hb_ot_var_axis_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_font_set_funcs(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_ot_tags_from_script_and_language(
        script: hb_script_t,
        language: hb_language_t,
        script_count: *mut ::std::os::raw::c_uint,
        script_tags: *mut hb_tag_t,
        language_count: *mut ::std::os::raw::c_uint,
        language_tags: *mut hb_tag_t,
    );
}
extern "C" {
    pub fn hb_ot_tag_to_script(tag: hb_tag_t) -> hb_script_t;
}
extern "C" {
    pub fn hb_ot_tag_to_language(tag: hb_tag_t) -> hb_language_t;
}
extern "C" {
    pub fn hb_ot_tags_to_script_and_language(
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        script: *mut hb_script_t,
        language: *mut hb_language_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_has_glyph_classes(face: *mut hb_face_t) -> hb_bool_t;
}
pub const HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED: hb_ot_layout_glyph_class_t = 0;
pub const HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH: hb_ot_layout_glyph_class_t = 1;
pub const HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE: hb_ot_layout_glyph_class_t = 2;
pub const HB_OT_LAYOUT_GLYPH_CLASS_MARK: hb_ot_layout_glyph_class_t = 3;
pub const HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT: hb_ot_layout_glyph_class_t = 4;
#[doc = " hb_ot_layout_glyph_class_t:\n @HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED: Glyphs not matching the other classifications\n @HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH: Spacing, single characters, capable of accepting marks\n @HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE: Glyphs that represent ligation of multiple characters\n @HB_OT_LAYOUT_GLYPH_CLASS_MARK: Non-spacing, combining glyphs that represent marks\n @HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT: Spacing glyphs that represent part of a single character\n\n The GDEF classes defined for glyphs.\n"]
pub type hb_ot_layout_glyph_class_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_ot_layout_get_glyph_class(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> hb_ot_layout_glyph_class_t;
}
extern "C" {
    pub fn hb_ot_layout_get_glyphs_in_class(
        face: *mut hb_face_t,
        klass: hb_ot_layout_glyph_class_t,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_get_attach_points(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        point_count: *mut ::std::os::raw::c_uint,
        point_array: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_get_ligature_carets(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        caret_count: *mut ::std::os::raw::c_uint,
        caret_array: *mut hb_position_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_table_get_script_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        start_offset: ::std::os::raw::c_uint,
        script_count: *mut ::std::os::raw::c_uint,
        script_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_table_find_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_tag: hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_table_select_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_count: ::std::os::raw::c_uint,
        script_tags: *const hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
        chosen_script: *mut hb_tag_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_table_get_feature_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_script_get_language_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        language_count: *mut ::std::os::raw::c_uint,
        language_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_script_select_language(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_count: ::std::os::raw::c_uint,
        language_tags: *const hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_script_select_language2(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_count: ::std::os::raw::c_uint,
        language_tags: *const hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
        chosen_language: *mut hb_tag_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_language_get_required_feature_index(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_language_get_required_feature(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_index: *mut ::std::os::raw::c_uint,
        feature_tag: *mut hb_tag_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_language_get_feature_indexes(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_language_get_feature_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_language_find_feature(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_tag: hb_tag_t,
        feature_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_get_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        lookup_count: *mut ::std::os::raw::c_uint,
        lookup_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_table_get_lookup_count(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_collect_features(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        scripts: *const hb_tag_t,
        languages: *const hb_tag_t,
        features: *const hb_tag_t,
        feature_indexes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_collect_features_map(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_map: *mut hb_map_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_collect_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        scripts: *const hb_tag_t,
        languages: *const hb_tag_t,
        features: *const hb_tag_t,
        lookup_indexes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_lookup_collect_glyphs(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs_before: *mut hb_set_t,
        glyphs_input: *mut hb_set_t,
        glyphs_after: *mut hb_set_t,
        glyphs_output: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_table_find_feature_variations(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        variations_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_with_variations_get_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        variations_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        lookup_count: *mut ::std::os::raw::c_uint,
        lookup_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_has_substitution(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_lookup_get_glyph_alternates(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        alternate_count: *mut ::std::os::raw::c_uint,
        alternate_glyphs: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_lookup_would_substitute(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs: *const hb_codepoint_t,
        glyphs_length: ::std::os::raw::c_uint,
        zero_context: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_lookup_substitute_closure(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_lookups_substitute_closure(
        face: *mut hb_face_t,
        lookups: *const hb_set_t,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_has_positioning(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_get_size_params(
        face: *mut hb_face_t,
        design_size: *mut ::std::os::raw::c_uint,
        subfamily_id: *mut ::std::os::raw::c_uint,
        subfamily_name_id: *mut hb_ot_name_id_t,
        range_start: *mut ::std::os::raw::c_uint,
        range_end: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_lookup_get_optical_bound(
        font: *mut hb_font_t,
        lookup_index: ::std::os::raw::c_uint,
        direction: hb_direction_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_get_name_ids(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        label_id: *mut hb_ot_name_id_t,
        tooltip_id: *mut hb_ot_name_id_t,
        sample_id: *mut hb_ot_name_id_t,
        num_named_parameters: *mut ::std::os::raw::c_uint,
        first_param_id: *mut hb_ot_name_id_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_get_characters(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        char_count: *mut ::std::os::raw::c_uint,
        characters: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_get_font_extents(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_get_font_extents2(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        script: hb_script_t,
        language: hb_language_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
pub const HB_OT_LAYOUT_BASELINE_TAG_ROMAN: hb_ot_layout_baseline_tag_t = 1919905134;
pub const HB_OT_LAYOUT_BASELINE_TAG_HANGING: hb_ot_layout_baseline_tag_t = 1751215719;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT: hb_ot_layout_baseline_tag_t =
    1768121954;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT: hb_ot_layout_baseline_tag_t =
    1768121972;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_CENTRAL: hb_ot_layout_baseline_tag_t = 1231251043;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT: hb_ot_layout_baseline_tag_t =
    1768187247;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT: hb_ot_layout_baseline_tag_t =
    1768191088;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_CENTRAL: hb_ot_layout_baseline_tag_t = 1231315813;
pub const HB_OT_LAYOUT_BASELINE_TAG_MATH: hb_ot_layout_baseline_tag_t = 1835103336;
pub const _HB_OT_LAYOUT_BASELINE_TAG_MAX_VALUE: hb_ot_layout_baseline_tag_t = 2147483647;
#[doc = " hb_ot_layout_baseline_tag_t:\n @HB_OT_LAYOUT_BASELINE_TAG_ROMAN: The baseline used by alphabetic scripts such as Latin, Cyrillic and Greek.\n In vertical writing mode, the alphabetic baseline for characters rotated 90 degrees clockwise.\n (This would not apply to alphabetic characters that remain upright in vertical writing mode, since these\n characters are not rotated.)\n @HB_OT_LAYOUT_BASELINE_TAG_HANGING: The hanging baseline. In horizontal direction, this is the horizontal\n line from which syllables seem, to hang in Tibetan and other similar scripts. In vertical writing mode,\n for Tibetan (or some other similar script) characters rotated 90 degrees clockwise.\n @HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT: Ideographic character face bottom or left edge,\n if the direction is horizontal or vertical, respectively.\n @HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT: Ideographic character face top or right edge,\n if the direction is horizontal or vertical, respectively.\n @HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_CENTRAL: The center of the ideographic character face. Since: 4.0.0\n @HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT: Ideographic em-box bottom or left edge,\n if the direction is horizontal or vertical, respectively.\n @HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT: Ideographic em-box top or right edge baseline,\n @HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_CENTRAL: The center of the ideographic em-box. Since: 4.0.0\n if the direction is horizontal or vertical, respectively.\n @HB_OT_LAYOUT_BASELINE_TAG_MATH: The baseline about which mathematical characters are centered.\n In vertical writing mode when mathematical characters rotated 90 degrees clockwise, are centered.\n\n Baseline tags from [Baseline Tags](https://docs.microsoft.com/en-us/typography/opentype/spec/baselinetags) registry.\n\n Since: 2.6.0"]
pub type hb_ot_layout_baseline_tag_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_ot_layout_get_horizontal_baseline_tag_for_script(
        script: hb_script_t,
    ) -> hb_ot_layout_baseline_tag_t;
}
extern "C" {
    pub fn hb_ot_layout_get_baseline(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        coord: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_get_baseline2(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script: hb_script_t,
        language: hb_language_t,
        coord: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_get_baseline_with_fallback(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        coord: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_get_baseline_with_fallback2(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script: hb_script_t,
        language: hb_language_t,
        coord: *mut hb_position_t,
    );
}
pub const HB_OT_MATH_CONSTANT_SCRIPT_PERCENT_SCALE_DOWN: hb_ot_math_constant_t = 0;
pub const HB_OT_MATH_CONSTANT_SCRIPT_SCRIPT_PERCENT_SCALE_DOWN: hb_ot_math_constant_t = 1;
pub const HB_OT_MATH_CONSTANT_DELIMITED_SUB_FORMULA_MIN_HEIGHT: hb_ot_math_constant_t = 2;
pub const HB_OT_MATH_CONSTANT_DISPLAY_OPERATOR_MIN_HEIGHT: hb_ot_math_constant_t = 3;
pub const HB_OT_MATH_CONSTANT_MATH_LEADING: hb_ot_math_constant_t = 4;
pub const HB_OT_MATH_CONSTANT_AXIS_HEIGHT: hb_ot_math_constant_t = 5;
pub const HB_OT_MATH_CONSTANT_ACCENT_BASE_HEIGHT: hb_ot_math_constant_t = 6;
pub const HB_OT_MATH_CONSTANT_FLATTENED_ACCENT_BASE_HEIGHT: hb_ot_math_constant_t = 7;
pub const HB_OT_MATH_CONSTANT_SUBSCRIPT_SHIFT_DOWN: hb_ot_math_constant_t = 8;
pub const HB_OT_MATH_CONSTANT_SUBSCRIPT_TOP_MAX: hb_ot_math_constant_t = 9;
pub const HB_OT_MATH_CONSTANT_SUBSCRIPT_BASELINE_DROP_MIN: hb_ot_math_constant_t = 10;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP: hb_ot_math_constant_t = 11;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP_CRAMPED: hb_ot_math_constant_t = 12;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MIN: hb_ot_math_constant_t = 13;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_BASELINE_DROP_MAX: hb_ot_math_constant_t = 14;
pub const HB_OT_MATH_CONSTANT_SUB_SUPERSCRIPT_GAP_MIN: hb_ot_math_constant_t = 15;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MAX_WITH_SUBSCRIPT: hb_ot_math_constant_t = 16;
pub const HB_OT_MATH_CONSTANT_SPACE_AFTER_SCRIPT: hb_ot_math_constant_t = 17;
pub const HB_OT_MATH_CONSTANT_UPPER_LIMIT_GAP_MIN: hb_ot_math_constant_t = 18;
pub const HB_OT_MATH_CONSTANT_UPPER_LIMIT_BASELINE_RISE_MIN: hb_ot_math_constant_t = 19;
pub const HB_OT_MATH_CONSTANT_LOWER_LIMIT_GAP_MIN: hb_ot_math_constant_t = 20;
pub const HB_OT_MATH_CONSTANT_LOWER_LIMIT_BASELINE_DROP_MIN: hb_ot_math_constant_t = 21;
pub const HB_OT_MATH_CONSTANT_STACK_TOP_SHIFT_UP: hb_ot_math_constant_t = 22;
pub const HB_OT_MATH_CONSTANT_STACK_TOP_DISPLAY_STYLE_SHIFT_UP: hb_ot_math_constant_t = 23;
pub const HB_OT_MATH_CONSTANT_STACK_BOTTOM_SHIFT_DOWN: hb_ot_math_constant_t = 24;
pub const HB_OT_MATH_CONSTANT_STACK_BOTTOM_DISPLAY_STYLE_SHIFT_DOWN: hb_ot_math_constant_t = 25;
pub const HB_OT_MATH_CONSTANT_STACK_GAP_MIN: hb_ot_math_constant_t = 26;
pub const HB_OT_MATH_CONSTANT_STACK_DISPLAY_STYLE_GAP_MIN: hb_ot_math_constant_t = 27;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_TOP_SHIFT_UP: hb_ot_math_constant_t = 28;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_BOTTOM_SHIFT_DOWN: hb_ot_math_constant_t = 29;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_ABOVE_MIN: hb_ot_math_constant_t = 30;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_BELOW_MIN: hb_ot_math_constant_t = 31;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_SHIFT_UP: hb_ot_math_constant_t = 32;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_DISPLAY_STYLE_SHIFT_UP: hb_ot_math_constant_t = 33;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_SHIFT_DOWN: hb_ot_math_constant_t = 34;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_DISPLAY_STYLE_SHIFT_DOWN: hb_ot_math_constant_t =
    35;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_GAP_MIN: hb_ot_math_constant_t = 36;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUM_DISPLAY_STYLE_GAP_MIN: hb_ot_math_constant_t = 37;
pub const HB_OT_MATH_CONSTANT_FRACTION_RULE_THICKNESS: hb_ot_math_constant_t = 38;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_GAP_MIN: hb_ot_math_constant_t = 39;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOM_DISPLAY_STYLE_GAP_MIN: hb_ot_math_constant_t = 40;
pub const HB_OT_MATH_CONSTANT_SKEWED_FRACTION_HORIZONTAL_GAP: hb_ot_math_constant_t = 41;
pub const HB_OT_MATH_CONSTANT_SKEWED_FRACTION_VERTICAL_GAP: hb_ot_math_constant_t = 42;
pub const HB_OT_MATH_CONSTANT_OVERBAR_VERTICAL_GAP: hb_ot_math_constant_t = 43;
pub const HB_OT_MATH_CONSTANT_OVERBAR_RULE_THICKNESS: hb_ot_math_constant_t = 44;
pub const HB_OT_MATH_CONSTANT_OVERBAR_EXTRA_ASCENDER: hb_ot_math_constant_t = 45;
pub const HB_OT_MATH_CONSTANT_UNDERBAR_VERTICAL_GAP: hb_ot_math_constant_t = 46;
pub const HB_OT_MATH_CONSTANT_UNDERBAR_RULE_THICKNESS: hb_ot_math_constant_t = 47;
pub const HB_OT_MATH_CONSTANT_UNDERBAR_EXTRA_DESCENDER: hb_ot_math_constant_t = 48;
pub const HB_OT_MATH_CONSTANT_RADICAL_VERTICAL_GAP: hb_ot_math_constant_t = 49;
pub const HB_OT_MATH_CONSTANT_RADICAL_DISPLAY_STYLE_VERTICAL_GAP: hb_ot_math_constant_t = 50;
pub const HB_OT_MATH_CONSTANT_RADICAL_RULE_THICKNESS: hb_ot_math_constant_t = 51;
pub const HB_OT_MATH_CONSTANT_RADICAL_EXTRA_ASCENDER: hb_ot_math_constant_t = 52;
pub const HB_OT_MATH_CONSTANT_RADICAL_KERN_BEFORE_DEGREE: hb_ot_math_constant_t = 53;
pub const HB_OT_MATH_CONSTANT_RADICAL_KERN_AFTER_DEGREE: hb_ot_math_constant_t = 54;
pub const HB_OT_MATH_CONSTANT_RADICAL_DEGREE_BOTTOM_RAISE_PERCENT: hb_ot_math_constant_t = 55;
#[doc = " hb_ot_math_constant_t:\n @HB_OT_MATH_CONSTANT_SCRIPT_PERCENT_SCALE_DOWN: scriptPercentScaleDown\n @HB_OT_MATH_CONSTANT_SCRIPT_SCRIPT_PERCENT_SCALE_DOWN: scriptScriptPercentScaleDown\n @HB_OT_MATH_CONSTANT_DELIMITED_SUB_FORMULA_MIN_HEIGHT: delimitedSubFormulaMinHeight\n @HB_OT_MATH_CONSTANT_DISPLAY_OPERATOR_MIN_HEIGHT: displayOperatorMinHeight\n @HB_OT_MATH_CONSTANT_MATH_LEADING: mathLeading\n @HB_OT_MATH_CONSTANT_AXIS_HEIGHT: axisHeight\n @HB_OT_MATH_CONSTANT_ACCENT_BASE_HEIGHT: accentBaseHeight\n @HB_OT_MATH_CONSTANT_FLATTENED_ACCENT_BASE_HEIGHT: flattenedAccentBaseHeight\n @HB_OT_MATH_CONSTANT_SUBSCRIPT_SHIFT_DOWN: subscriptShiftDown\n @HB_OT_MATH_CONSTANT_SUBSCRIPT_TOP_MAX: subscriptTopMax\n @HB_OT_MATH_CONSTANT_SUBSCRIPT_BASELINE_DROP_MIN: subscriptBaselineDropMin\n @HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP: superscriptShiftUp\n @HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP_CRAMPED: superscriptShiftUpCramped\n @HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MIN: superscriptBottomMin\n @HB_OT_MATH_CONSTANT_SUPERSCRIPT_BASELINE_DROP_MAX: superscriptBaselineDropMax\n @HB_OT_MATH_CONSTANT_SUB_SUPERSCRIPT_GAP_MIN: subSuperscriptGapMin\n @HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MAX_WITH_SUBSCRIPT: superscriptBottomMaxWithSubscript\n @HB_OT_MATH_CONSTANT_SPACE_AFTER_SCRIPT: spaceAfterScript\n @HB_OT_MATH_CONSTANT_UPPER_LIMIT_GAP_MIN: upperLimitGapMin\n @HB_OT_MATH_CONSTANT_UPPER_LIMIT_BASELINE_RISE_MIN: upperLimitBaselineRiseMin\n @HB_OT_MATH_CONSTANT_LOWER_LIMIT_GAP_MIN: lowerLimitGapMin\n @HB_OT_MATH_CONSTANT_LOWER_LIMIT_BASELINE_DROP_MIN: lowerLimitBaselineDropMin\n @HB_OT_MATH_CONSTANT_STACK_TOP_SHIFT_UP: stackTopShiftUp\n @HB_OT_MATH_CONSTANT_STACK_TOP_DISPLAY_STYLE_SHIFT_UP: stackTopDisplayStyleShiftUp\n @HB_OT_MATH_CONSTANT_STACK_BOTTOM_SHIFT_DOWN: stackBottomShiftDown\n @HB_OT_MATH_CONSTANT_STACK_BOTTOM_DISPLAY_STYLE_SHIFT_DOWN: stackBottomDisplayStyleShiftDown\n @HB_OT_MATH_CONSTANT_STACK_GAP_MIN: stackGapMin\n @HB_OT_MATH_CONSTANT_STACK_DISPLAY_STYLE_GAP_MIN: stackDisplayStyleGapMin\n @HB_OT_MATH_CONSTANT_STRETCH_STACK_TOP_SHIFT_UP: stretchStackTopShiftUp\n @HB_OT_MATH_CONSTANT_STRETCH_STACK_BOTTOM_SHIFT_DOWN: stretchStackBottomShiftDown\n @HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_ABOVE_MIN: stretchStackGapAboveMin\n @HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_BELOW_MIN: stretchStackGapBelowMin\n @HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_SHIFT_UP: fractionNumeratorShiftUp\n @HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_DISPLAY_STYLE_SHIFT_UP: fractionNumeratorDisplayStyleShiftUp\n @HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_SHIFT_DOWN: fractionDenominatorShiftDown\n @HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_DISPLAY_STYLE_SHIFT_DOWN: fractionDenominatorDisplayStyleShiftDown\n @HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_GAP_MIN: fractionNumeratorGapMin\n @HB_OT_MATH_CONSTANT_FRACTION_NUM_DISPLAY_STYLE_GAP_MIN: fractionNumDisplayStyleGapMin\n @HB_OT_MATH_CONSTANT_FRACTION_RULE_THICKNESS: fractionRuleThickness\n @HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_GAP_MIN: fractionDenominatorGapMin\n @HB_OT_MATH_CONSTANT_FRACTION_DENOM_DISPLAY_STYLE_GAP_MIN: fractionDenomDisplayStyleGapMin\n @HB_OT_MATH_CONSTANT_SKEWED_FRACTION_HORIZONTAL_GAP: skewedFractionHorizontalGap\n @HB_OT_MATH_CONSTANT_SKEWED_FRACTION_VERTICAL_GAP: skewedFractionVerticalGap\n @HB_OT_MATH_CONSTANT_OVERBAR_VERTICAL_GAP: overbarVerticalGap\n @HB_OT_MATH_CONSTANT_OVERBAR_RULE_THICKNESS: overbarRuleThickness\n @HB_OT_MATH_CONSTANT_OVERBAR_EXTRA_ASCENDER: overbarExtraAscender\n @HB_OT_MATH_CONSTANT_UNDERBAR_VERTICAL_GAP: underbarVerticalGap\n @HB_OT_MATH_CONSTANT_UNDERBAR_RULE_THICKNESS: underbarRuleThickness\n @HB_OT_MATH_CONSTANT_UNDERBAR_EXTRA_DESCENDER: underbarExtraDescender\n @HB_OT_MATH_CONSTANT_RADICAL_VERTICAL_GAP: radicalVerticalGap\n @HB_OT_MATH_CONSTANT_RADICAL_DISPLAY_STYLE_VERTICAL_GAP: radicalDisplayStyleVerticalGap\n @HB_OT_MATH_CONSTANT_RADICAL_RULE_THICKNESS: radicalRuleThickness\n @HB_OT_MATH_CONSTANT_RADICAL_EXTRA_ASCENDER: radicalExtraAscender\n @HB_OT_MATH_CONSTANT_RADICAL_KERN_BEFORE_DEGREE: radicalKernBeforeDegree\n @HB_OT_MATH_CONSTANT_RADICAL_KERN_AFTER_DEGREE: radicalKernAfterDegree\n @HB_OT_MATH_CONSTANT_RADICAL_DEGREE_BOTTOM_RAISE_PERCENT: radicalDegreeBottomRaisePercent\n\n The 'MATH' table constants, refer to\n [OpenType documentation](https://docs.microsoft.com/en-us/typography/opentype/spec/math#mathconstants-table)\n For more explanations.\n\n Since: 1.3.3"]
pub type hb_ot_math_constant_t = ::std::os::raw::c_uint;
pub const HB_OT_MATH_KERN_TOP_RIGHT: hb_ot_math_kern_t = 0;
pub const HB_OT_MATH_KERN_TOP_LEFT: hb_ot_math_kern_t = 1;
pub const HB_OT_MATH_KERN_BOTTOM_RIGHT: hb_ot_math_kern_t = 2;
pub const HB_OT_MATH_KERN_BOTTOM_LEFT: hb_ot_math_kern_t = 3;
#[doc = " hb_ot_math_kern_t:\n @HB_OT_MATH_KERN_TOP_RIGHT: The top right corner of the glyph.\n @HB_OT_MATH_KERN_TOP_LEFT: The top left corner of the glyph.\n @HB_OT_MATH_KERN_BOTTOM_RIGHT: The bottom right corner of the glyph.\n @HB_OT_MATH_KERN_BOTTOM_LEFT: The bottom left corner of the glyph.\n\n The math kerning-table types defined for the four corners\n of a glyph.\n\n Since: 1.3.3"]
pub type hb_ot_math_kern_t = ::std::os::raw::c_uint;
#[doc = " hb_ot_math_kern_entry_t:\n @max_correction_height: The maximum height at which this entry should be used\n @kern_value: The kern value of the entry\n\n Data type to hold math kerning (cut-in) information for a glyph.\n\n Since: 3.4.0"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_kern_entry_t {
    pub max_correction_height: hb_position_t,
    pub kern_value: hb_position_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_math_kern_entry_t"][::std::mem::size_of::<hb_ot_math_kern_entry_t>() - 8usize];
    ["Alignment of hb_ot_math_kern_entry_t"]
        [::std::mem::align_of::<hb_ot_math_kern_entry_t>() - 4usize];
    ["Offset of field: hb_ot_math_kern_entry_t::max_correction_height"]
        [::std::mem::offset_of!(hb_ot_math_kern_entry_t, max_correction_height) - 0usize];
    ["Offset of field: hb_ot_math_kern_entry_t::kern_value"]
        [::std::mem::offset_of!(hb_ot_math_kern_entry_t, kern_value) - 4usize];
};
#[doc = " hb_ot_math_glyph_variant_t:\n @glyph: The glyph index of the variant\n @advance: The advance width of the variant\n\n Data type to hold math-variant information for a glyph.\n\n Since: 1.3.3"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_glyph_variant_t {
    pub glyph: hb_codepoint_t,
    pub advance: hb_position_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_math_glyph_variant_t"]
        [::std::mem::size_of::<hb_ot_math_glyph_variant_t>() - 8usize];
    ["Alignment of hb_ot_math_glyph_variant_t"]
        [::std::mem::align_of::<hb_ot_math_glyph_variant_t>() - 4usize];
    ["Offset of field: hb_ot_math_glyph_variant_t::glyph"]
        [::std::mem::offset_of!(hb_ot_math_glyph_variant_t, glyph) - 0usize];
    ["Offset of field: hb_ot_math_glyph_variant_t::advance"]
        [::std::mem::offset_of!(hb_ot_math_glyph_variant_t, advance) - 4usize];
};
pub const HB_OT_MATH_GLYPH_PART_FLAG_EXTENDER: hb_ot_math_glyph_part_flags_t = 1;
#[doc = " hb_ot_math_glyph_part_flags_t:\n @HB_OT_MATH_GLYPH_PART_FLAG_EXTENDER: This is an extender glyph part that\n can be repeated to reach the desired length.\n\n Flags for math glyph parts.\n\n Since: 1.3.3"]
pub type hb_ot_math_glyph_part_flags_t = ::std::os::raw::c_uint;
#[doc = " hb_ot_math_glyph_part_t:\n @glyph: The glyph index of the variant part\n @start_connector_length: The length of the connector on the starting side of the variant part\n @end_connector_length: The length of the connector on the ending side of the variant part\n @full_advance: The total advance of the part\n @flags: #hb_ot_math_glyph_part_flags_t flags for the part\n\n Data type to hold information for a \"part\" component of a math-variant glyph.\n Large variants for stretchable math glyphs (such as parentheses) can be constructed\n on the fly from parts.\n\n Since: 1.3.3"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_glyph_part_t {
    pub glyph: hb_codepoint_t,
    pub start_connector_length: hb_position_t,
    pub end_connector_length: hb_position_t,
    pub full_advance: hb_position_t,
    pub flags: hb_ot_math_glyph_part_flags_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_math_glyph_part_t"][::std::mem::size_of::<hb_ot_math_glyph_part_t>() - 20usize];
    ["Alignment of hb_ot_math_glyph_part_t"]
        [::std::mem::align_of::<hb_ot_math_glyph_part_t>() - 4usize];
    ["Offset of field: hb_ot_math_glyph_part_t::glyph"]
        [::std::mem::offset_of!(hb_ot_math_glyph_part_t, glyph) - 0usize];
    ["Offset of field: hb_ot_math_glyph_part_t::start_connector_length"]
        [::std::mem::offset_of!(hb_ot_math_glyph_part_t, start_connector_length) - 4usize];
    ["Offset of field: hb_ot_math_glyph_part_t::end_connector_length"]
        [::std::mem::offset_of!(hb_ot_math_glyph_part_t, end_connector_length) - 8usize];
    ["Offset of field: hb_ot_math_glyph_part_t::full_advance"]
        [::std::mem::offset_of!(hb_ot_math_glyph_part_t, full_advance) - 12usize];
    ["Offset of field: hb_ot_math_glyph_part_t::flags"]
        [::std::mem::offset_of!(hb_ot_math_glyph_part_t, flags) - 16usize];
};
extern "C" {
    pub fn hb_ot_math_has_data(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_math_get_constant(
        font: *mut hb_font_t,
        constant: hb_ot_math_constant_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_italics_correction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_top_accent_attachment(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_is_glyph_extended_shape(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_kerning(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        kern: hb_ot_math_kern_t,
        correction_height: hb_position_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_kernings(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        kern: hb_ot_math_kern_t,
        start_offset: ::std::os::raw::c_uint,
        entries_count: *mut ::std::os::raw::c_uint,
        kern_entries: *mut hb_ot_math_kern_entry_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_variants(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        start_offset: ::std::os::raw::c_uint,
        variants_count: *mut ::std::os::raw::c_uint,
        variants: *mut hb_ot_math_glyph_variant_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_math_get_min_connector_overlap(
        font: *mut hb_font_t,
        direction: hb_direction_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_assembly(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        start_offset: ::std::os::raw::c_uint,
        parts_count: *mut ::std::os::raw::c_uint,
        parts: *mut hb_ot_math_glyph_part_t,
        italics_correction: *mut hb_position_t,
    ) -> ::std::os::raw::c_uint;
}
pub const HB_OT_META_TAG_DESIGN_LANGUAGES: hb_ot_meta_tag_t = 1684827751;
pub const HB_OT_META_TAG_SUPPORTED_LANGUAGES: hb_ot_meta_tag_t = 1936485991;
pub const _HB_OT_META_TAG_MAX_VALUE: hb_ot_meta_tag_t = 2147483647;
#[doc = " hb_ot_meta_tag_t:\n @HB_OT_META_TAG_DESIGN_LANGUAGES: Design languages. Text, using only\n Basic Latin (ASCII) characters. Indicates languages and/or scripts\n for the user audiences that the font was primarily designed for.\n @HB_OT_META_TAG_SUPPORTED_LANGUAGES: Supported languages. Text, using\n only Basic Latin (ASCII) characters. Indicates languages and/or scripts\n that the font is declared to be capable of supporting.\n\n Known metadata tags from https://docs.microsoft.com/en-us/typography/opentype/spec/meta\n\n Since: 2.6.0"]
pub type hb_ot_meta_tag_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_ot_meta_get_entry_tags(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        entries_count: *mut ::std::os::raw::c_uint,
        entries: *mut hb_ot_meta_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_meta_reference_entry(
        face: *mut hb_face_t,
        meta_tag: hb_ot_meta_tag_t,
    ) -> *mut hb_blob_t;
}
pub const HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER: hb_ot_metrics_tag_t = 1751216995;
pub const HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER: hb_ot_metrics_tag_t = 1751413603;
pub const HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP: hb_ot_metrics_tag_t = 1751934832;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT: hb_ot_metrics_tag_t = 1751346273;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT: hb_ot_metrics_tag_t = 1751346276;
pub const HB_OT_METRICS_TAG_VERTICAL_ASCENDER: hb_ot_metrics_tag_t = 1986098019;
pub const HB_OT_METRICS_TAG_VERTICAL_DESCENDER: hb_ot_metrics_tag_t = 1986294627;
pub const HB_OT_METRICS_TAG_VERTICAL_LINE_GAP: hb_ot_metrics_tag_t = 1986815856;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE: hb_ot_metrics_tag_t = 1751347827;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN: hb_ot_metrics_tag_t = 1751347822;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET: hb_ot_metrics_tag_t = 1751347046;
pub const HB_OT_METRICS_TAG_VERTICAL_CARET_RISE: hb_ot_metrics_tag_t = 1986228851;
pub const HB_OT_METRICS_TAG_VERTICAL_CARET_RUN: hb_ot_metrics_tag_t = 1986228846;
pub const HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET: hb_ot_metrics_tag_t = 1986228070;
pub const HB_OT_METRICS_TAG_X_HEIGHT: hb_ot_metrics_tag_t = 2020108148;
pub const HB_OT_METRICS_TAG_CAP_HEIGHT: hb_ot_metrics_tag_t = 1668311156;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE: hb_ot_metrics_tag_t = 1935833203;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE: hb_ot_metrics_tag_t = 1935833459;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET: hb_ot_metrics_tag_t = 1935833199;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET: hb_ot_metrics_tag_t = 1935833455;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE: hb_ot_metrics_tag_t = 1936750707;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE: hb_ot_metrics_tag_t = 1936750963;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET: hb_ot_metrics_tag_t = 1936750703;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET: hb_ot_metrics_tag_t = 1936750959;
pub const HB_OT_METRICS_TAG_STRIKEOUT_SIZE: hb_ot_metrics_tag_t = 1937011315;
pub const HB_OT_METRICS_TAG_STRIKEOUT_OFFSET: hb_ot_metrics_tag_t = 1937011311;
pub const HB_OT_METRICS_TAG_UNDERLINE_SIZE: hb_ot_metrics_tag_t = 1970168947;
pub const HB_OT_METRICS_TAG_UNDERLINE_OFFSET: hb_ot_metrics_tag_t = 1970168943;
pub const _HB_OT_METRICS_TAG_MAX_VALUE: hb_ot_metrics_tag_t = 2147483647;
#[doc = " hb_ot_metrics_tag_t:\n @HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER: horizontal ascender.\n @HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER: horizontal descender.\n @HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP: horizontal line gap.\n @HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT: horizontal clipping ascent.\n @HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT: horizontal clipping descent.\n @HB_OT_METRICS_TAG_VERTICAL_ASCENDER: vertical ascender.\n @HB_OT_METRICS_TAG_VERTICAL_DESCENDER: vertical descender.\n @HB_OT_METRICS_TAG_VERTICAL_LINE_GAP: vertical line gap.\n @HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE: horizontal caret rise.\n @HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN: horizontal caret run.\n @HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET: horizontal caret offset.\n @HB_OT_METRICS_TAG_VERTICAL_CARET_RISE: vertical caret rise.\n @HB_OT_METRICS_TAG_VERTICAL_CARET_RUN: vertical caret run.\n @HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET: vertical caret offset.\n @HB_OT_METRICS_TAG_X_HEIGHT: x height.\n @HB_OT_METRICS_TAG_CAP_HEIGHT: cap height.\n @HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE: subscript em x size.\n @HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE: subscript em y size.\n @HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET: subscript em x offset.\n @HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET: subscript em y offset.\n @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE: superscript em x size.\n @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE: superscript em y size.\n @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET: superscript em x offset.\n @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET: superscript em y offset.\n @HB_OT_METRICS_TAG_STRIKEOUT_SIZE: strikeout size.\n @HB_OT_METRICS_TAG_STRIKEOUT_OFFSET: strikeout offset.\n @HB_OT_METRICS_TAG_UNDERLINE_SIZE: underline size.\n @HB_OT_METRICS_TAG_UNDERLINE_OFFSET: underline offset.\n\n Metric tags corresponding to [MVAR Value\n Tags](https://docs.microsoft.com/en-us/typography/opentype/spec/mvar#value-tags)\n\n Since: 2.6.0"]
pub type hb_ot_metrics_tag_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_ot_metrics_get_position(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
        position: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_metrics_get_position_with_fallback(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
        position: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_ot_metrics_get_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> f32;
}
extern "C" {
    pub fn hb_ot_metrics_get_x_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_metrics_get_y_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_shape_glyphs_closure(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_shape_plan_collect_lookups(
        shape_plan: *mut hb_shape_plan_t,
        table_tag: hb_tag_t,
        lookup_indexes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_var_has_data(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_var_get_axis_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
pub const HB_OT_VAR_AXIS_FLAG_HIDDEN: hb_ot_var_axis_flags_t = 1;
pub const _HB_OT_VAR_AXIS_FLAG_MAX_VALUE: hb_ot_var_axis_flags_t = 2147483647;
#[doc = " hb_ot_var_axis_flags_t:\n @HB_OT_VAR_AXIS_FLAG_HIDDEN: The axis should not be exposed directly in user interfaces.\n\n Flags for #hb_ot_var_axis_info_t.\n\n Since: 2.2.0"]
pub type hb_ot_var_axis_flags_t = ::std::os::raw::c_uint;
#[doc = " hb_ot_var_axis_info_t:\n @axis_index: Index of the axis in the variation-axis array\n @tag: The #hb_tag_t tag identifying the design variation of the axis\n @name_id: The `name` table Name ID that provides display names for the axis\n @flags: The #hb_ot_var_axis_flags_t flags for the axis\n @min_value: The minimum value on the variation axis that the font covers\n @default_value: The position on the variation axis corresponding to the font's defaults\n @max_value: The maximum value on the variation axis that the font covers\n\n Data type for holding variation-axis values.\n\n The minimum, default, and maximum values are in un-normalized, user scales.\n\n <note>Note: at present, the only flag defined for @flags is\n #HB_OT_VAR_AXIS_FLAG_HIDDEN.</note>\n\n Since: 2.2.0"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_var_axis_info_t {
    pub axis_index: ::std::os::raw::c_uint,
    pub tag: hb_tag_t,
    pub name_id: hb_ot_name_id_t,
    pub flags: hb_ot_var_axis_flags_t,
    pub min_value: f32,
    pub default_value: f32,
    pub max_value: f32,
    pub reserved: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_ot_var_axis_info_t"][::std::mem::size_of::<hb_ot_var_axis_info_t>() - 32usize];
    ["Alignment of hb_ot_var_axis_info_t"]
        [::std::mem::align_of::<hb_ot_var_axis_info_t>() - 4usize];
    ["Offset of field: hb_ot_var_axis_info_t::axis_index"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, axis_index) - 0usize];
    ["Offset of field: hb_ot_var_axis_info_t::tag"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, tag) - 4usize];
    ["Offset of field: hb_ot_var_axis_info_t::name_id"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, name_id) - 8usize];
    ["Offset of field: hb_ot_var_axis_info_t::flags"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, flags) - 12usize];
    ["Offset of field: hb_ot_var_axis_info_t::min_value"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, min_value) - 16usize];
    ["Offset of field: hb_ot_var_axis_info_t::default_value"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, default_value) - 20usize];
    ["Offset of field: hb_ot_var_axis_info_t::max_value"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, max_value) - 24usize];
    ["Offset of field: hb_ot_var_axis_info_t::reserved"]
        [::std::mem::offset_of!(hb_ot_var_axis_info_t, reserved) - 28usize];
};
extern "C" {
    pub fn hb_ot_var_get_axis_infos(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        axes_count: *mut ::std::os::raw::c_uint,
        axes_array: *mut hb_ot_var_axis_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_find_axis_info(
        face: *mut hb_face_t,
        axis_tag: hb_tag_t,
        axis_info: *mut hb_ot_var_axis_info_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_var_get_named_instance_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_named_instance_get_subfamily_name_id(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
extern "C" {
    pub fn hb_ot_var_named_instance_get_postscript_name_id(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
extern "C" {
    pub fn hb_ot_var_named_instance_get_design_coords(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
        coords_length: *mut ::std::os::raw::c_uint,
        coords: *mut f32,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_normalize_variations(
        face: *mut hb_face_t,
        variations: *const hb_variation_t,
        variations_length: ::std::os::raw::c_uint,
        coords: *mut ::std::os::raw::c_int,
        coords_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_ot_var_normalize_coords(
        face: *mut hb_face_t,
        coords_length: ::std::os::raw::c_uint,
        design_coords: *const f32,
        normalized_coords: *mut ::std::os::raw::c_int,
    );
}
pub const HB_AAT_LAYOUT_FEATURE_TYPE_INVALID: hb_aat_layout_feature_type_t = 65535;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC: hb_aat_layout_feature_type_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES: hb_aat_layout_feature_type_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CURSIVE_CONNECTION: hb_aat_layout_feature_type_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LETTER_CASE: hb_aat_layout_feature_type_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION: hb_aat_layout_feature_type_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT: hb_aat_layout_feature_type_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING: hb_aat_layout_feature_type_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE: hb_aat_layout_feature_type_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE: hb_aat_layout_feature_type_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION: hb_aat_layout_feature_type_t = 10;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS: hb_aat_layout_feature_type_t = 11;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE: hb_aat_layout_feature_type_t = 13;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS: hb_aat_layout_feature_type_t = 14;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS: hb_aat_layout_feature_type_t = 15;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE: hb_aat_layout_feature_type_t = 16;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES: hb_aat_layout_feature_type_t = 17;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE: hb_aat_layout_feature_type_t = 18;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS: hb_aat_layout_feature_type_t = 19;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE: hb_aat_layout_feature_type_t = 20;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE: hb_aat_layout_feature_type_t = 21;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING: hb_aat_layout_feature_type_t = 22;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION: hb_aat_layout_feature_type_t = 23;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE: hb_aat_layout_feature_type_t = 24;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE: hb_aat_layout_feature_type_t = 25;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE: hb_aat_layout_feature_type_t = 26;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE: hb_aat_layout_feature_type_t = 27;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA: hb_aat_layout_feature_type_t = 28;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE: hb_aat_layout_feature_type_t =
    29;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE: hb_aat_layout_feature_type_t =
    30;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE:
    hb_aat_layout_feature_type_t = 31;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN: hb_aat_layout_feature_type_t = 32;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT: hb_aat_layout_feature_type_t = 33;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA: hb_aat_layout_feature_type_t = 34;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES: hb_aat_layout_feature_type_t = 35;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES: hb_aat_layout_feature_type_t = 36;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE: hb_aat_layout_feature_type_t = 37;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE: hb_aat_layout_feature_type_t = 38;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE: hb_aat_layout_feature_type_t = 39;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE: hb_aat_layout_feature_type_t = 103;
pub const _HB_AAT_LAYOUT_FEATURE_TYPE_MAX_VALUE: hb_aat_layout_feature_type_t = 2147483647;
#[doc = " hb_aat_layout_feature_type_t:\n @HB_AAT_LAYOUT_FEATURE_TYPE_INVALID: Initial, unset feature type\n @HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC: [All Typographic Features](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type0)\n @HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES: [Ligatures](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type1)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CURSIVE_CONNECTION: [Cursive Connection](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type2)\n @HB_AAT_LAYOUT_FEATURE_TYPE_LETTER_CASE: [Letter Case](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type3)\n @HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION: [Vertical Substitution](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type4)\n @HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT: [Linguistic Rearrangement](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type5)\n @HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING: [Number Spacing](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type6)\n @HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE: [Smart Swash](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type8)\n @HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE: [Diacritics](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type9)\n @HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION: [Vertical Position](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type10)\n @HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS: [Fractions](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type11)\n @HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE: [Overlapping Characters](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type13)\n @HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS: [Typographic Extras](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type14)\n @HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS: [Mathematical Extras](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type15)\n @HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE: [Ornament Sets](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type16)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES: [Character Alternatives](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type17)\n @HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE: [Design Complexity](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type18)\n @HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS: [Style Options](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type19)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE: [Character Shape](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type20)\n @HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE: [Number Case](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type21)\n @HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING: [Text Spacing](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type22)\n @HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION: [Transliteration](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type23)\n @HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE: [Annotation](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type24)\n @HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE: [Kana Spacing](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type25)\n @HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE: [Ideographic Spacing](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type26)\n @HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE: [Unicode Decomposition](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type27)\n @HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA: [Ruby Kana](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type28)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE: [CJK Symbol Alternatives](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type29)\n @HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE: [Ideographic Alternatives](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type30)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE: [CJK Vertical Roman Placement](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type31)\n @HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN: [Italic CJK Roman](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type32)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT: [Case Sensitive Layout](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type33)\n @HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA: [Alternate Kana](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type34)\n @HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES: [Stylistic Alternatives](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type35)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES: [Contextual Alternatives](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type36)\n @HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE: [Lower Case](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type37)\n @HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE: [Upper Case](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type38)\n @HB_AAT_LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE: [Language Tag](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type39)\n @HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE: [CJK Roman Spacing](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html#Type103)\n\n The possible feature types defined for AAT shaping, from Apple [Font Feature Registry](https://developer.apple.com/fonts/TrueType-Reference-Manual/RM09/AppendixF.html).\n\n Since: 2.2.0"]
pub type hb_aat_layout_feature_type_t = ::std::os::raw::c_uint;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVALID: hb_aat_layout_feature_selector_t = 65535;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF: hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    12;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    13;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON:
    hb_aat_layout_feature_selector_t = 14;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 15;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON: hb_aat_layout_feature_selector_t = 16;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    17;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    18;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 19;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    20;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 21;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CURSIVE: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF: hb_aat_layout_feature_selector_t =
    9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SUPERIORS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INFERIORS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ORDINALS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF: hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF:
    hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DINGBATS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FLEURONS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS: hb_aat_layout_feature_selector_t = 10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS: hb_aat_layout_feature_selector_t = 11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS: hb_aat_layout_feature_selector_t = 12;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS: hb_aat_layout_feature_selector_t = 13;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS:
    hb_aat_layout_feature_selector_t = 14;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA:
    hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO: hb_aat_layout_feature_selector_t =
    8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE:
    hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION:
    hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION:
    hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION: hb_aat_layout_feature_selector_t =
    9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION:
    hb_aat_layout_feature_selector_t = 10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON:
    hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF:
    hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON:
    hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON:
    hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF:
    hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON: hb_aat_layout_feature_selector_t =
    6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON: hb_aat_layout_feature_selector_t =
    8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF: hb_aat_layout_feature_selector_t =
    9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON: hb_aat_layout_feature_selector_t =
    12;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF: hb_aat_layout_feature_selector_t =
    13;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON: hb_aat_layout_feature_selector_t =
    14;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF: hb_aat_layout_feature_selector_t =
    15;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON: hb_aat_layout_feature_selector_t =
    16;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF: hb_aat_layout_feature_selector_t =
    17;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON: hb_aat_layout_feature_selector_t =
    18;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF: hb_aat_layout_feature_selector_t =
    19;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON: hb_aat_layout_feature_selector_t =
    20;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF: hb_aat_layout_feature_selector_t =
    21;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON: hb_aat_layout_feature_selector_t =
    22;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF:
    hb_aat_layout_feature_selector_t = 23;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON: hb_aat_layout_feature_selector_t =
    24;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF:
    hb_aat_layout_feature_selector_t = 25;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON:
    hb_aat_layout_feature_selector_t = 26;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF:
    hb_aat_layout_feature_selector_t = 27;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON:
    hb_aat_layout_feature_selector_t = 28;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF:
    hb_aat_layout_feature_selector_t = 29;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON:
    hb_aat_layout_feature_selector_t = 30;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF:
    hb_aat_layout_feature_selector_t = 31;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON:
    hb_aat_layout_feature_selector_t = 32;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF:
    hb_aat_layout_feature_selector_t = 33;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON:
    hb_aat_layout_feature_selector_t = 34;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF:
    hb_aat_layout_feature_selector_t = 35;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON:
    hb_aat_layout_feature_selector_t = 36;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF:
    hb_aat_layout_feature_selector_t = 37;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON:
    hb_aat_layout_feature_selector_t = 38;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF:
    hb_aat_layout_feature_selector_t = 39;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON: hb_aat_layout_feature_selector_t =
    40;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF:
    hb_aat_layout_feature_selector_t = 41;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON:
    hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN: hb_aat_layout_feature_selector_t = 3;
pub const _HB_AAT_LAYOUT_FEATURE_SELECTOR_MAX_VALUE: hb_aat_layout_feature_selector_t = 2147483647;
#[doc = " hb_aat_layout_feature_selector_t:\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INVALID: Initial, unset feature selector\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CURSIVE: for #HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE: Deprecated\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS: Deprecated\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE: Deprecated\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS: Deprecated\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS: Deprecated\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS: Deprecated\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS: for #HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS: for #HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS: for #HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SUPERIORS: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INFERIORS: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ORDINALS: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS: for #HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS: for #HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS: for #HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS: for #HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DINGBATS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_FLEURONS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS: for #HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1: for #HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2: for #HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3: for #HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4: for #HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5: for #HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS: for #HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT: for #HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE: for #HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION: for #HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA: for #HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA: for #HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA: Deprecated; use #HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF instead\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA: Deprecated; use #HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON instead\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE: for #HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN: Deprecated; use #HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF instead\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN: Deprecated; use #HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON instead\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON: for #HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF: for #HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE: for #HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE: for #HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS: for #HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE\n @HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN: for #HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE\n\n The selectors defined for specifying AAT feature settings.\n\n Since: 2.2.0"]
pub type hb_aat_layout_feature_selector_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn hb_aat_layout_get_feature_types(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        features: *mut hb_aat_layout_feature_type_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_aat_layout_feature_type_get_name_id(
        face: *mut hb_face_t,
        feature_type: hb_aat_layout_feature_type_t,
    ) -> hb_ot_name_id_t;
}
#[doc = " hb_aat_layout_feature_selector_info_t:\n @name_id: The selector's name identifier\n @enable: The value to turn the selector on\n @disable: The value to turn the selector off\n\n Structure representing a setting for an #hb_aat_layout_feature_type_t."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_aat_layout_feature_selector_info_t {
    pub name_id: hb_ot_name_id_t,
    pub enable: hb_aat_layout_feature_selector_t,
    pub disable: hb_aat_layout_feature_selector_t,
    pub reserved: ::std::os::raw::c_uint,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of hb_aat_layout_feature_selector_info_t"]
        [::std::mem::size_of::<hb_aat_layout_feature_selector_info_t>() - 16usize];
    ["Alignment of hb_aat_layout_feature_selector_info_t"]
        [::std::mem::align_of::<hb_aat_layout_feature_selector_info_t>() - 4usize];
    ["Offset of field: hb_aat_layout_feature_selector_info_t::name_id"]
        [::std::mem::offset_of!(hb_aat_layout_feature_selector_info_t, name_id) - 0usize];
    ["Offset of field: hb_aat_layout_feature_selector_info_t::enable"]
        [::std::mem::offset_of!(hb_aat_layout_feature_selector_info_t, enable) - 4usize];
    ["Offset of field: hb_aat_layout_feature_selector_info_t::disable"]
        [::std::mem::offset_of!(hb_aat_layout_feature_selector_info_t, disable) - 8usize];
    ["Offset of field: hb_aat_layout_feature_selector_info_t::reserved"]
        [::std::mem::offset_of!(hb_aat_layout_feature_selector_info_t, reserved) - 12usize];
};
extern "C" {
    pub fn hb_aat_layout_feature_type_get_selector_infos(
        face: *mut hb_face_t,
        feature_type: hb_aat_layout_feature_type_t,
        start_offset: ::std::os::raw::c_uint,
        selector_count: *mut ::std::os::raw::c_uint,
        selectors: *mut hb_aat_layout_feature_selector_info_t,
        default_index: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_aat_layout_has_substitution(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_aat_layout_has_positioning(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_aat_layout_has_tracking(face: *mut hb_face_t) -> hb_bool_t;
}
