/**
 * Copyright (C) 2018 Andriy Se Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.examples.movies.presentation.viewmodel

import androidx.lifecycle.MutableLiveData
import com.examples.core.interactor.UseCase.None
import com.examples.core.platform.BaseViewModel
import com.examples.movies.domain.interactor.GetMovies
import com.examples.movies.domain.model.Movie
import com.examples.movies.presentation.viewstate.MovieView
import javax.inject.Inject


class MoviesViewModel
@Inject constructor(
    private val getMovies: GetMovies
) : BaseViewModel() {

  var movies: MutableLiveData<List<MovieView>> = MutableLiveData()

  fun loadMovies() = getMovies(None()) { it.either(::handleFailure, ::handleMovieList) }

  private fun handleMovieList(movies: List<Movie>) {
    this.movies.value = movies.map {
      MovieView(it.id, it.poster)
    }
  }

  override fun cancelRequest() {
    getMovies.cancel()
  }

}