/**
 * Copyright (C) 2018 Andriy Se Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.examples.movies.presentation.view

import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.examples.core.extension.inflate
import com.examples.core.extension.loadFromUrl
import com.examples.movies.presentation.R
import com.examples.movies.presentation.viewstate.MovieView
import com.examples.presentation.navigation.Navigator
import kotlinx.android.synthetic.main.row_movie.view.*
import javax.inject.Inject
import kotlin.properties.Delegates


class MoviesAdapter
@Inject constructor() : RecyclerView.Adapter<MoviesAdapter.ViewHolder>() {

  internal var collection: List<MovieView> by Delegates.observable(emptyList()) { _, _, _ ->
    notifyDataSetChanged()
  }

  internal var clickListener: (MovieView, Navigator.Extras) -> Unit = { _, _ -> }

  override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) =
      ViewHolder(
          parent.inflate(R.layout.row_movie))

  override fun onBindViewHolder(viewHolder: ViewHolder, position: Int) =
      viewHolder.bind(collection[position], clickListener)

  override fun getItemCount() = collection.size

  class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
    fun bind(movieView: MovieView, clickListener: (MovieView, Navigator.Extras) -> Unit) {
      itemView.moviePoster.loadFromUrl(movieView.poster)
      itemView.setOnClickListener {
        clickListener(movieView, Navigator.Extras(itemView.moviePoster))
      }
    }
  }
}
