/**
 * Copyright (C) 2018 Andriy Se Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.examples.core.interactor

import com.examples.core.AndroidTest
import com.examples.core.exception.Failure
import com.examples.core.functional.Either
import com.examples.core.functional.Either.Right
import kotlinx.coroutines.runBlocking
import org.amshove.kluent.shouldEqual
import org.junit.Test

class UseCaseTest : AndroidTest() {

  private val TYPE_TEST = "Test"
  private val TYPE_PARAM = "ParamTest"

  private val useCase = MyUseCase()

  @Test
  fun `running use case should return 'Either' of use case type`() {
    val params = MyParams(TYPE_PARAM)
    val result = runBlocking { useCase.run(params) }

    result shouldEqual Right(
        MyType(TYPE_TEST))
  }

  @Test
  fun `should return correct data when executing use case`() {
    var result: Either<Failure, MyType>? = null

    val params = MyParams("TestParam")
    val onResult = { myResult: Either<Failure, MyType> -> result = myResult }

    runBlocking { useCase(params, onResult) }

    result shouldEqual Right(
        MyType(TYPE_TEST))
  }

  data class MyType(val name: String)
  data class MyParams(val name: String)

  private inner class MyUseCase : UseCase<MyType, MyParams>() {
    override suspend fun run(params: MyParams) = Right(
        MyType(TYPE_TEST))
  }
}
