/**
 * Copyright (C) 2018 Andriy Se Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.examples.core.functional

import com.example.core.test.UnitTest
import com.examples.core.functional.Either.Left
import com.examples.core.functional.Either.Right
import org.amshove.kluent.shouldBe
import org.amshove.kluent.shouldBeInstanceOf
import org.amshove.kluent.shouldEqualTo
import org.junit.Test

class EitherTest : UnitTest() {

  @Test
  fun `Either Right should return correct type`() {
    val result = Right("ironman")

    result shouldBeInstanceOf Either::class.java
    result.isRight shouldBe true
    result.isLeft shouldBe false
    result.either({},
        { right ->
          right shouldBeInstanceOf String::class.java
          right shouldEqualTo "ironman"
        })
  }

  @Test
  fun `Either Left should return correct type`() {
    val result = Left("ironman")

    result shouldBeInstanceOf Either::class.java
    result.isLeft shouldBe true
    result.isRight shouldBe false
    result.either(
        { left ->
          left shouldBeInstanceOf String::class.java
          left shouldEqualTo "ironman"
        }, {})
  }
}