/**
 * Copyright (C) 2018 Andriy Se Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.examples.core

import android.app.Application
import android.content.Context
import androidx.appcompat.app.AppCompatActivity
import com.example.core.test.InjectMocksRule
import org.junit.Rule
import org.junit.runner.RunWith
import org.mockito.Mockito.mock
import org.robolectric.RobolectricTestRunner
import org.robolectric.RuntimeEnvironment
import org.robolectric.annotation.Config

/**
 * Base class for Android tests. Inherit from it to create test cases which contain android
 * framework dependencies or components.
 *
 * @see UnitTest
 */
@RunWith(RobolectricTestRunner::class)
@Config(//constants = BuildConfig::class,
    application = AndroidTest.ApplicationStub::class,
    sdk = [21])
abstract class AndroidTest {

  @Suppress("LeakingThis")
  @Rule
  @JvmField
  val injectMocks = InjectMocksRule.create(
      this@AndroidTest)

  fun context(): Context = RuntimeEnvironment.application

  fun activityContext(): Context = mock(
      AppCompatActivity::class.java)

  internal class ApplicationStub : Application()
}
