/**
 * Copyright (C) 2018 Andriy Se Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
@file:JvmName("AndroidAssertions")
@file:JvmMultifileClass

package com.examples

import androidx.appcompat.app.AppCompatActivity
import org.amshove.kluent.shouldEqual
import org.robolectric.Robolectric
import org.robolectric.Shadows
import kotlin.reflect.KClass

infix fun KClass<out AppCompatActivity>.`shouldNavigateTo`(
    nextActivity: KClass<out AppCompatActivity>) = {
  val originActivity = Robolectric.buildActivity(this.java).get()
  val shadowActivity = Shadows.shadowOf(originActivity)
  val nextIntent = shadowActivity.peekNextStartedActivity()

  nextIntent.component?.className shouldEqual nextActivity.java.canonicalName
}
