# awesome-python-ast
Python tools, libraries and resources about AST (as in Abstract Syntax Trees)


## Online resources

- [brown-water-python](https://www.asmeurer.com/brown-water-python/)

    _"extended documentation for effectively working with the tokenize module"_

    Project of [Aaron Meurer](https://twitter.com/asmeurer) |
    [Repo](https://github.com/asmeurer/brown-water-python)

- [greentreesnakes](https://greentreesnakes.readthedocs.io/)

    _"the missing Python AST docs"_

    Project of [Thomas Kluyver](https://twitter.com/takluyver) |
    [Repo](https://bitbucket.org/takluyver/greentreesnakes).


## Tools

- [astmonkey](https://github.com/mutpy/astmonkey) - Set of tools to play with Python AST
- [astor](https://github.com/berkerpeksag/astor) - AST read/write
- [astpath](https://github.com/hchasestevens/astpath) - A command-line search utility for Python ASTs using XPath syntax.
- [astpretty](https://github.com/asottile/astpretty) - Pretty print the output of python stdlib `ast.parse`.
- [astroid](https://github.com/PyCQA/astroid) - A common base representation of python source code for pylint and other projects
- [astsearch](https://github.com/takluyver/astsearch) - Search through ASTs using XPath syntax
- [astunparse](https://github.com/simonpercivall/astunparse) - a factored out version of unparse found in the Python source distribution
- [baron](https://github.com/PyCQA/baron) - a Full Syntax Tree (FST) library
- [parso](https://github.com/davidhalter/parso) - parser that supports error recovery and round-trip parsing
- [redbaron](https://github.com/PyCQA/redbaron) - Bottom-up approach to refactoring in python
- [show_ast](https://github.com/hchasestevens/show_ast) - An IPython notebook plugin for visualizing ASTs.
- [tokenize-rt](https://github.com/asottile/tokenize-rt) - A wrapper around the stdlib `tokenize` which roundtrips.


## Unused code detection
- [dead](https://github.com/asottile/dead)
- [vulture](https://github.com/jendrikseipp/vulture)


## Formatters
- [autopep8](https://github.com/hhatto/autopep8) - A tool that automatically formats Python code to conform to the PEP 8 style guide
- [black](https://github.com/python/black) - The uncompromising Python code formatter | [Online demo](https://black.now.sh)
- [yapf](https://github.com/google/yapf) - configurable formatter from Google | [Online demo](https://yapf.now.sh/)


## Linters
- [flake8](https://gitlab.com/pycqa/flake8) - glues together pycodestyle, pyflakes, mccabe, and third-party plugins to check the style and quality of code 
- [mccabe](https://github.com/PyCQA/mccabe) - McCabe complexity checker
- [pycodestyle](https://github.com/PyCQA/pycodestyle) - former `pep8`. Check your Python code against some of the style conventions in PEP 8.
- [pydocstyle](https://github.com/PyCQA/pydocstyle) - docstring style checker 
- [pyflakes](https://github.com/PyCQA/pyflakes) - A simple program which checks Python source files for errors.
- [pylint](https://github.com/PyCQA/pylint) - code analysis tool which looks for programming errors, helps enforcing a coding standard, sniffs for code smells and offers simple refactoring suggestions.

## Import sorters
- [isort](https://github.com/timothycrosley/isort) - sort imports alphabetically, and automatically separated into sections
- [reorder_python_imports](https://github.com/asottile/reorder_python_imports) - reordering python imports


## Other
- [add-trailing-comma](https://github.com/asottile/add-trailing-comma) - A tool (and pre-commit hook) to automatically add trailing commas to calls and literals.
- [pyupgrade](https://github.com/asottile/pyupgrade) - A tool (and pre-commit hook) to automatically upgrade syntax for newer versions of the language.
- [yesqa](https://github.com/asottile/yesqa) - A tool (and pre-commit hook) to automatically remove unnecessary # noqa comments


## Online tools
- [python-ast-explorer](https://github.com/maligree/python-ast-explorer)



## Articles
2010-02-22: [Instrumenting the AST](http://www.dalkescientific.com/writings/diary/archive/2010/02/22/instrumenting_the_ast.html)


## Code examples


## TODOs
- common dependencies
- "getting into" howto
- static/dynamic code analysis
- pluggable or not
