# A curated list of beginner resources in Natural Language Processing

## Maintainer 
[Dibya Chakravorty](https://github.com/gutfeeling)

## Contributions

Feel free to send [pull requests](https://github.com/gutfeeling/beginner_nlp/pulls), or email me (dibyachakravorty@gmail.com)

## How this list got started

On November 10, 2016, a Hacker News (HN) user aarohmankad asked the HN community for suggestions on beginner NLP resources. This [Ask HN thread](https://news.ycombinator.com/item?id=12916498) became popular and stayed in the front page for some time. In this time, it gathered plenty of community generated suggestions about beginner NLP resources. This list is an attempt to summarize this discussion into a coherent list of resources. I also wrote a [blog post](https://medium.com/ask-hn-summaries/how-to-get-into-natural-language-processing-2011bf9f4cfe#.szm4ljj93) on this.

## Table of Contents
 - [Books](#books)
 - [MOOCs](#moocs)
 - [YouTube Videos](#youtube-videos)
 - [Online University Courses](#online-university-courses)
 - [Packages to Play With](#packages-to-play-with)
 - [Academic Papers](#academic-papers)
 - [Learning by Doing](#learning-by-doing)
  - [Open Source Projects](#open-source-projects)
  - [Fun Ideas](#fun-ideas)
 - [APIs](#apis)
 - [User Groups](#user-groups)
 - [Other Guides](#other-guides)
 
## Books

* [Speech and Language Processing](http://amzn.to/2jr4nSQ) : Classic and Standard textbook in NLP. Pre publication draft of 3rd edition available [here](https://web.stanford.edu/~jurafsky/slp3/).
* [Natural Language Processing with Python](http://amzn.to/2icxF6G) : Application oriented book. Examples are in Python (NLTK). Free online version [here](http://nltk.org/book).
* [Taming Text](http://amzn.to/2jr2shd) : Application oriented book. Examples are in JAVA.
* [Foundations of Statistical Natural Language Processing](http://amzn.to/2jqSSuG) : Classic text on Statistical NLP. Goes deep into the implementation of parsers, taggers etc.
* [Handbook of Natural Language Processing](http://amzn.to/2j1wOda) : A complete treatment of NLP that starts from the historical roots and ends with the modern methods of NLP.
* [Statistical Machine Translation](http://amzn.to/2jzFLvh) : Learn how to make a service like Google Translate
* [Introduction to Information Retrieval](http://amzn.to/2i9MCLO) : Learn the nuts and bolts of services like Google Search and Google News (search, text classification, clustering etc.)
* [Prolog and Natural Language Analysis](http://amzn.to/2j4rvdh) : Implement NLP algortihms in Prolog.

## MOOCs

* [Coursera course offered by University of Michigan](https://www.coursera.org/learn/natural-language-processing) : Introductory course that covers all prerequisite materials. Favored programming language is Python.
* [Dicontinued Coursera course offered by Comlumbia University, available on Academic torrents](http://academictorrents.com/details/f99e7184fca947ee8f77901679e171fcadbf82e7) : Theory and concept oriented course. Only the course materials are available at this point.

## YouTube Videos

* [Video series by Jurafsky and Martin](https://www.youtube.com/watch?v=nfoudtpBV68&list=PL6397E4B26D00A269) : Jurafsky and Martin are both professors at Stanford, and they have written multiple classic textbooks on NLP. 
* [Stanford CS224D : Deep Learning in NLP](https://www.youtube.com/playlist?list=PLIiVRB6G_w0i-uOoS6cDh_5nkUyxy_hxe) : Applicatin of Deep Learning in NLP
* [NLP with Python and NLTK](https://www.youtube.com/playlist?list=PLQVvvaa0QuDf2JswnfiGkliBInZnIC4HL) : Application oriented video series using Python and NLTK.

## Online University Courses

* [Machine Translation course at the University of Pennsylvania](http://mt-class.org/penn/)

## Packages to Play With

* [NLTK](http://www.nltk.org/) : Most popular NLP library in Python. Excellent documentation in the form of a [book](http://amzn.to/2fdaYie)/[free online version](http://nltk.org/book). Powerful and extensible.
* [Stanford CoreNLP](http://stanfordnlp.github.io/CoreNLP/) : Fast and feature rich NLP library, written in JAVA. An online demo is available [here](http://corenlp.run).
* [Spacy](https://spacy.io/) : Another emerging NLP library in Python. Fast and state of the art. Tries to maintain an uniform API while implementing state of the art algorithms. They have a [blog](http://explosion.ai) and an [online demo](https://demos.explosion.ai/displacy/).
* [Apache Tika](https://tika.apache.org/) : Offers an unified interface for extracting text data and meta data from many different file formats (PPT, PDF etc.) and analysis.

## Academic Papers

* [Deep Learning in NLP](https://github.com/andrewt3000/dl4nlp) : A GitHub repo that collects papers on Deep Learning in NLP.

## Learning by Doing

Often the best way to learn is to contribute to an existing open source NLP project or implementing a fun idea. 

### Open Source Projects

* [Betty](https://github.com/pickhardt/betty) : Betty is a open source project with both real-life use and practical NLP considerations, and is looking for new maintainers.

### Fun Ideas

* [Interactive Fiction/Parser Based Fiction](http://iftechfoundation.org/frequently-asked-questions/) : A video game where the player's interactions primarily involve text. Listen to this illuminating [FLOSS podcast](https://www.youtube.com/watch?v=tSr4okYxwjk) on the topic.

## APIs

* [IBM Watson Cloud](https://www.ibm.com/watson/developercloud/) : From the makers of [IBM Watson](https://en.wikipedia.org/wiki/Watson_(computer)). It lets you integrate NLP functionality in your app via an API. There's a free tier/free trial.

## User Groups

* [ACM Special Interest Group in AI](https://sigai.acm.org/index.html) : If you are craving for some face to face human contact.

## Other Guides

* [Quora question on how to get into NLP](https://www.quora.com/How-do-I-learn-Natural-Language-Processing)
* [awesome-nlp on GitHub](https://github.com/keonkim/awesome-nlp) : A GitHub repo containing a curated list of NLP resources.





 
