package cn.jianwoo.openai.chatgptapi.bo;

import com.alibaba.fastjson2.annotation.JSONField;
import lombok.Builder;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author gulihua
 * @Description
 * @date 2023-03-02 22:13
 */
@Data
@ToString
@Builder
public class MessageReq implements Serializable
{
    private static final long serialVersionUID = 7342715261030858658L;
    /** The role of the messages author. One of system, user, assistant, or function. */
    private String role;
    /**
     * The contents of the message. content is required for all messages except assistant messages with function calls.
     */
    private String content;
    /**
     * The name of the author of this message. name is required if role is function, and it should be the name of the
     * function whose response is in the content. May contain a-z, A-Z, 0-9, and underscores, with a maximum length of
     * 64 characters.
     */
    private String name;

    /** The name and arguments of a function that should be called, as generated by the model. */
    @JSONField(name = "function_call")
    private FunctionCall functionCall;

    public MessageReq(String role, String content, String name, FunctionCall functionCall)
    {
        this.role = role;
        this.content = content;
        this.name = name;
        this.functionCall = functionCall;
    }


    public MessageReq(String role, String content)
    {
        this.role = role;
        this.content = content;
    }


    public MessageReq(String role)
    {
        this.role = role;
    }
}
