# Contributing to Guess.js

Please contribute to this repository if any of the following is true:

- You are interested in improving the Guess.js source, docs or one of our related projects
- You have expertise in community development, communication, or education
- You want open source communities to be more collaborative and inclusive
- You want to help lower the burden to first time contributors

# How to contribute to our source code

Prerequisites:

- familiarity with [GitHub PRs](https://help.github.com/articles/using-pull-requests) (pull requests) and issues
- knowledge of JavaScript and some [TypeScript](https://www.typescriptlang.org/)

## Submitting a Pull Request

All submissions, including submissions by project members, require review. We use Github pull requests for this purpose. See our [developer guide](DEVELOPING.md) for instructions on building the project.

Pull requests (fixes, new features, tests) are a great way to contribute to
the project and help us make it better. Ideally, try to keep your PRs as
focused as possible and keep your commits atomic and readable.

To avoid disappointment when working on a PR, please ask us first in case
someone else is already working on a PR for a change you wished to make. It's always a good idea to file an issue before starting work on a PR unless
it's for something minor (such as a typo fix).

We greatly appreciate any attention to tests. These help us validate that
new work continues to function as expected over time.

# How to contribute to our README or docs

Prerequisites:

- familiarity with [GitHub PRs](https://help.github.com/articles/using-pull-requests) (pull requests) and issues
- knowledge of Markdown for editing `.md` documents

In particular, this community seeks the following types of contributions:

- ideas: participate in an Issues thread or start your own to have your voice
heard
- resources: submit a PR to add to our README with links to related content
- outline sections: help us ensure that this repository is comprehensive. If
there is a topic that is overlooked, please add it, even if it is just a stub
in the form of a header and single sentence. Initially, most things fall into
this category
- write: contribute your expertise in an area by helping us expand the included
content
- copy editing: fix typos, clarify language, and generally improve the quality
of the content
- formatting: help keep content easy to read with consistent formatting
- code: Fix issues or contribute new features to this or any related projects

This contribution guide was inspired by others including contributing to
Google open-source, React, Gulp and Babel.