/*
SQLyog Ultimate v13.1.1 (64 bit)
MySQL - 5.7.18-log : Database - bus_manager
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`bus_manager` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `bus_manager`;

/*Table structure for table `bus_car` */

DROP TABLE IF EXISTS `bus_car`;

CREATE TABLE `bus_car` (
  `carnumber` varchar(255) NOT NULL,
  `cartype` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `price` double(10,2) DEFAULT NULL,
  `rentprice` double(10,2) DEFAULT NULL,
  `deposit` double DEFAULT NULL,
  `isrenting` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `carimg` varchar(255) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  PRIMARY KEY (`carnumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bus_car` */

insert  into `bus_car`(`carnumber`,`cartype`,`color`,`price`,`rentprice`,`deposit`,`isrenting`,`description`,`carimg`,`createtime`) values 
('222','2221','221',22221.00,2221.00,221,0,'22221','../upload/2019-03-20/20190320095428400_8503.png','2019-05-07 14:52:15'),
('鄂A66666','SUV','白色',280000.00,500.00,5000,0,'宝马X1','../upload/001.png','2019-05-07 14:52:15'),
('鄂A77777','SUV','白色',350000.00,1500.00,12000,0,'宝马X3','../upload/002.png','2019-05-07 14:52:15'),
('鄂A88888','轿车','黑色',880000.00,1000.00,10000,0,'保时捷 卡宴','../upload/003.png','2019-05-07 14:52:15');

/*Table structure for table `bus_checks` */

DROP TABLE IF EXISTS `bus_checks`;

CREATE TABLE `bus_checks` (
  `checkid` varchar(255) NOT NULL,
  `checkdate` datetime DEFAULT NULL,
  `checkdesc` varchar(255) DEFAULT NULL,
  `problem` varchar(255) DEFAULT NULL,
  `paymoney` double(255,0) DEFAULT NULL,
  `opername` varchar(255) DEFAULT NULL,
  `rentid` varchar(255) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  PRIMARY KEY (`checkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bus_checks` */

insert  into `bus_checks`(`checkid`,`checkdate`,`checkdesc`,`problem`,`paymoney`,`opername`,`rentid`,`createtime`) values 
('JC_20180612_170407_0385_63960','2018-06-12 00:00:00','在G50高速超速','超速',500,'习大大','CZ_20180611_171304_0732_57330','2019-05-07 14:55:30'),
('JC_20180612_172559_0323_71959','2018-06-13 00:00:00','无','无',0,'习大大','CZ_20180612_164747_0573_26177','2019-05-07 14:55:30'),
('JC_20180718_091454_0191_93480','2018-07-18 00:00:00','无','无',0,'习大大','CZ_20180718_091206_0365_62161','2019-05-07 14:55:30'),
('JC_20181024_170206_355_7589','2018-10-24 17:02:06','无','无',0,'超级管理员','CZ_20181024_102327_735_9111','2019-05-07 14:55:30'),
('JC_20181201_105333_218_89516','2018-12-02 00:00:00','1231321','111122',200,'超级管理员','CZ_20180612_164808_0385_37625','2019-05-07 14:55:30'),
('JC_20181201_111951_947_77152','2018-12-03 00:00:00','无','无',0,'超级管理员','CZ_20181201_111936_383_31565','2019-05-07 14:55:30'),
('JC_2018_0901_175053_57325085','2018-09-01 00:00:00','在G50  1127-1130段超速20%未达50%','有违章未处理',500,'超级管理员','CZ_2018_0901_175000_97637709','2019-05-07 14:55:30'),
('JC_20190322_142814_147_8624','2019-03-22 14:28:14','222','11',100,'超级管理员','CZ_20190320_141553_303_8141','2019-05-07 14:55:30');

/*Table structure for table `bus_customer` */

DROP TABLE IF EXISTS `bus_customer`;

CREATE TABLE `bus_customer` (
  `identity` varchar(255) NOT NULL COMMENT '身份证',
  `custname` varchar(255) DEFAULT NULL COMMENT '姓名',
  `sex` int(255) DEFAULT NULL COMMENT '性别',
  `address` varchar(255) DEFAULT NULL COMMENT '地址',
  `phone` varchar(255) DEFAULT NULL COMMENT '电话',
  `career` varchar(255) DEFAULT NULL COMMENT '职位',
  `createtime` datetime DEFAULT NULL,
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bus_customer` */

insert  into `bus_customer`(`identity`,`custname`,`sex`,`address`,`phone`,`career`,`createtime`) values 
('421087133414144412','张小明',1,'武昌','13456788987','程序员','2019-05-07 14:52:24'),
('43131334113331131','习大大',1,'武昌','13888888888','国家最高领导人','2019-05-07 14:52:24'),
('431321199291331131','张三',1,'武昌','13431334113','程序员','2019-05-07 14:52:24'),
('431321199291331132','孙中山',1,'汉口','134131314131','总统','2019-05-07 14:52:24'),
('431341134191311311','李四',0,'汉阳','13451313113','CEO','2019-05-07 14:52:24'),
('431341134191311314','王小明',1,'汉口','13413131113','CEO','2019-05-07 14:52:24');

/*Table structure for table `bus_rent` */

DROP TABLE IF EXISTS `bus_rent`;

CREATE TABLE `bus_rent` (
  `rentid` varchar(255) NOT NULL,
  `price` double(10,2) DEFAULT NULL,
  `begindate` datetime DEFAULT NULL,
  `returndate` datetime DEFAULT NULL,
  `rentflag` int(11) DEFAULT NULL,
  `identity` varchar(255) DEFAULT NULL,
  `carnumber` varchar(255) DEFAULT NULL,
  `opername` varchar(255) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  PRIMARY KEY (`rentid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `bus_rent` */

insert  into `bus_rent`(`rentid`,`price`,`begindate`,`returndate`,`rentflag`,`identity`,`carnumber`,`opername`,`createtime`) values 
('CZ_20180611_171304_0732_57330',1600.00,'2017-01-01 00:00:00','2017-06-18 00:00:00',1,'421087133414144412','鄂A77777','李四','2017-01-01 00:00:00'),
('CZ_20180612_164747_0573_26177',500.00,'2018-01-13 00:00:00','2018-06-23 00:00:00',1,'431321199291331131','鄂A66666','李四','2018-01-13 00:00:00'),
('CZ_20180612_164808_0385_37625',1000.00,'2018-03-13 00:00:00','2018-06-15 00:00:00',1,'421087133414144412','鄂A88888','王五','2018-03-13 00:00:00'),
('CZ_20180718_091206_0365_62161',500.00,'2018-05-18 00:00:00','2018-07-21 00:00:00',1,'421087133414144412','鄂A66666','张三','2018-05-18 00:00:00'),
('CZ_20181024_102327_735_9111',500.00,'2018-07-23 10:23:27','2018-10-31 10:23:29',1,'421087133414144412','鄂A66666','李四','2018-07-23 10:23:27'),
('CZ_20181201_111936_383_31565',1500.00,'2018-09-01 00:00:00','2018-12-29 00:00:00',1,'43131334113331131','鄂A77777','王五','2018-09-01 00:00:00'),
('CZ_2018_0901_175000_97637709',500.00,'2018-12-01 00:00:00','2018-09-10 00:00:00',1,'431321199291331131','鄂A66666','李四','2018-12-01 00:00:00'),
('CZ_20190320_141553_303_8141',1500.00,'2019-03-20 14:15:53','2019-03-22 14:15:56',1,'43131334113331131','鄂A77777','超级管理员','2019-03-20 14:15:53');

/*Table structure for table `sys_log_login` */

DROP TABLE IF EXISTS `sys_log_login`;

CREATE TABLE `sys_log_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `loginname` varchar(255) DEFAULT NULL,
  `loginip` varchar(255) DEFAULT NULL,
  `logintime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=427 DEFAULT CHARSET=utf8;

/*Data for the table `sys_log_login` */

insert  into `sys_log_login`(`id`,`loginname`,`loginip`,`logintime`) values 
(1,'admin-超级管理员','127.0.0.1','2018-10-27 09:01:21'),
(2,'admin-超级管理员','127.0.0.1','2018-10-27 09:25:31'),
(3,'admin-超级管理员','127.0.0.1','2018-10-27 09:25:43'),
(4,'admin-超级管理员','127.0.0.1','2018-10-27 09:36:02'),
(5,'admin-超级管理员','127.0.0.1','2018-10-27 10:14:36'),
(9,'admin-超级管理员','127.0.0.1','2018-10-27 10:29:20'),
(10,'admin-超级管理员','127.0.0.1','2018-10-27 10:30:21'),
(11,'admin-超级管理员','127.0.0.1','2018-10-27 10:40:02'),
(12,'admin-超级管理员','127.0.0.1','2018-10-27 10:47:19'),
(13,'zhangsan-张三','127.0.0.1','2018-10-27 10:47:42'),
(14,'zhangsan-张三','127.0.0.1','2018-10-27 10:48:19'),
(15,'zhangsan-张三','127.0.0.1','2018-10-27 10:48:33'),
(16,'ls-李四','127.0.0.1','2018-10-27 10:48:55'),
(17,'admin-超级管理员','127.0.0.1','2018-10-27 10:49:12'),
(18,'ls-李四','127.0.0.1','2018-10-27 10:49:36'),
(19,'ww-王五','127.0.0.1','2018-10-27 10:49:46'),
(20,'xm-小明','127.0.0.1','2018-10-27 10:49:58'),
(21,'admin-超级管理员','127.0.0.1','2018-10-27 10:50:37'),
(22,'admin-超级管理员','127.0.0.1','2018-10-27 10:52:23'),
(23,'ls-李四','127.0.0.1','2018-10-27 10:52:42'),
(24,'ww-王五','127.0.0.1','2018-10-27 10:52:48'),
(25,'xm-小明','127.0.0.1','2018-10-27 10:52:54'),
(26,'admin-超级管理员','127.0.0.1','2018-10-27 10:54:07'),
(27,'admin-超级管理员','127.0.0.1','2018-10-27 17:09:12'),
(28,'admin-超级管理员','127.0.0.1','2018-10-27 17:24:04'),
(29,'admin-超级管理员','127.0.0.1','2018-10-27 17:25:29'),
(30,'admin-超级管理员','127.0.0.1','2018-10-29 09:06:47'),
(31,'admin-超级管理员','127.0.0.1','2018-10-29 09:30:42'),
(32,'admin-超级管理员','127.0.0.1','2018-10-29 09:34:28'),
(33,'admin-超级管理员','127.0.0.1','2018-10-29 09:36:59'),
(34,'admin-超级管理员','127.0.0.1','2018-10-29 09:38:51'),
(35,'admin-超级管理员','127.0.0.1','2018-10-29 09:51:10'),
(36,'admin-超级管理员','127.0.0.1','2018-10-29 09:54:40'),
(37,'admin-超级管理员','127.0.0.1','2018-10-29 09:55:52'),
(38,'admin-超级管理员','127.0.0.1','2018-10-29 10:38:00'),
(39,'admin-超级管理员','127.0.0.1','2018-10-29 11:01:35'),
(40,'admin-超级管理员','127.0.0.1','2018-10-29 11:08:17'),
(41,'admin-超级管理员','127.0.0.1','2018-10-29 11:23:44'),
(42,'admin-超级管理员','127.0.0.1','2018-10-29 11:24:07'),
(43,'admin-超级管理员','127.0.0.1','2018-10-29 11:27:20'),
(44,'admin-超级管理员','127.0.0.1','2018-10-29 11:39:16'),
(45,'admin-超级管理员','127.0.0.1','2018-10-29 17:58:09'),
(46,'admin-超级管理员','127.0.0.1','2018-10-29 18:02:55'),
(47,'admin-超级管理员','127.0.0.1','2018-10-30 14:28:02'),
(48,'admin-超级管理员','127.0.0.1','2018-10-30 16:47:20'),
(49,'admin-超级管理员','127.0.0.1','2018-10-30 18:00:36'),
(52,'admin-超级管理员','127.0.0.1','2018-11-28 10:06:11'),
(53,'admin-超级管理员','127.0.0.1','2018-11-28 10:07:12'),
(54,'admin-超级管理员','127.0.0.1','2018-11-28 10:07:45'),
(55,'admin-超级管理员','127.0.0.1','2018-11-28 10:08:54'),
(56,'admin-超级管理员','127.0.0.1','2018-11-28 10:09:35'),
(57,'admin-超级管理员','127.0.0.1','2018-11-28 10:09:45'),
(58,'admin-超级管理员','127.0.0.1','2018-11-28 10:09:52'),
(59,'admin-超级管理员','192.168.2.126','2018-11-28 10:32:19'),
(60,'admin-超级管理员','192.168.2.126','2018-11-28 14:05:43'),
(61,'admin-超级管理员','192.168.2.126','2018-11-28 14:06:19'),
(62,'admin-超级管理员','192.168.2.126','2018-11-28 14:07:16'),
(63,'admin-超级管理员','127.0.0.1','2018-11-28 14:36:41'),
(64,'admin-超级管理员','127.0.0.1','2018-11-28 14:45:23'),
(65,'admin-超级管理员','127.0.0.1','2018-11-28 14:46:02'),
(66,'admin-超级管理员','127.0.0.1','2018-11-28 14:55:55'),
(67,'admin-超级管理员','127.0.0.1','2018-11-28 14:59:21'),
(68,'admin-超级管理员','127.0.0.1','2018-11-28 16:17:40'),
(69,'admin-超级管理员','127.0.0.1','2018-11-28 16:19:07'),
(70,'admin-超级管理员','127.0.0.1','2018-11-28 16:48:08'),
(71,'admin-超级管理员','127.0.0.1','2018-11-28 16:48:12'),
(72,'admin-超级管理员','127.0.0.1','2018-11-28 16:55:21'),
(73,'admin-超级管理员','127.0.0.1','2018-11-28 17:35:45'),
(74,'admin-超级管理员','127.0.0.1','2018-11-28 17:45:42'),
(75,'admin-超级管理员','127.0.0.1','2018-11-30 08:56:02'),
(76,'admin-超级管理员','127.0.0.1','2018-11-30 08:56:39'),
(77,'admin-超级管理员','127.0.0.1','2018-11-30 08:57:22'),
(78,'admin-超级管理员','127.0.0.1','2018-11-30 09:42:51'),
(79,'admin-超级管理员','127.0.0.1','2018-11-30 09:46:34'),
(80,'admin-超级管理员','127.0.0.1','2018-11-30 10:22:02'),
(81,'admin-超级管理员','127.0.0.1','2018-11-30 10:23:44'),
(82,'admin-超级管理员','127.0.0.1','2018-11-30 10:27:58'),
(83,'admin-超级管理员','127.0.0.1','2018-11-30 11:17:47'),
(84,'admin-超级管理员','127.0.0.1','2018-11-30 11:25:13'),
(85,'admin-超级管理员','127.0.0.1','2018-11-30 15:05:38'),
(86,'admin-超级管理员','127.0.0.1','2018-11-30 15:15:19'),
(87,'admin-超级管理员','127.0.0.1','2018-11-30 15:22:51'),
(88,'admin-超级管理员','127.0.0.1','2018-12-01 09:08:25'),
(89,'admin-超级管理员','127.0.0.1','2018-12-01 09:18:13'),
(90,'admin-超级管理员','127.0.0.1','2018-12-01 09:46:43'),
(91,'admin-超级管理员','127.0.0.1','2018-12-01 09:57:30'),
(92,'admin-超级管理员','127.0.0.1','2018-12-01 10:11:37'),
(93,'admin-超级管理员','127.0.0.1','2018-12-01 10:53:10'),
(94,'admin-超级管理员','127.0.0.1','2018-12-01 11:08:28'),
(95,'admin-超级管理员','127.0.0.1','2018-12-01 11:17:04'),
(96,'admin-超级管理员','127.0.0.1','2018-12-01 14:05:16'),
(97,'admin-超级管理员','127.0.0.1','2018-12-01 15:03:31'),
(98,'admin-超级管理员','127.0.0.1','2018-12-01 15:03:47'),
(99,'admin-超级管理员','127.0.0.1','2018-12-01 15:04:09'),
(100,'admin-超级管理员','127.0.0.1','2018-12-01 15:06:33'),
(101,'admin-超级管理员','127.0.0.1','2018-12-01 15:09:55'),
(102,'admin-超级管理员','127.0.0.1','2018-12-01 15:18:06'),
(103,'admin-超级管理员','127.0.0.1','2018-12-01 15:27:02'),
(104,'admin-超级管理员','127.0.0.1','2018-12-01 16:59:12'),
(105,'admin-超级管理员','127.0.0.1','2018-12-01 17:11:52'),
(106,'admin-超级管理员','127.0.0.1','2018-12-01 17:13:26'),
(107,'admin-超级管理员','127.0.0.1','2018-12-01 17:16:27'),
(108,'admin-超级管理员','127.0.0.1','2018-12-01 17:20:55'),
(109,'admin-超级管理员','127.0.0.1','2018-12-01 17:22:27'),
(110,'admin-超级管理员','127.0.0.1','2018-12-01 17:23:59'),
(111,'admin-超级管理员','127.0.0.1','2018-12-01 17:42:40'),
(112,'admin-超级管理员','127.0.0.1','2018-12-03 08:55:39'),
(113,'admin-超级管理员','127.0.0.1','2018-12-03 09:19:18'),
(114,'admin-超级管理员','127.0.0.1','2018-12-03 10:01:03'),
(115,'admin-超级管理员','127.0.0.1','2018-12-03 10:19:54'),
(116,'admin-超级管理员','127.0.0.1','2018-12-03 10:32:01'),
(117,'admin-超级管理员','127.0.0.1','2018-12-03 10:38:32'),
(118,'admin-超级管理员','127.0.0.1','2018-12-03 11:11:58'),
(119,'admin-超级管理员','127.0.0.1','2018-12-03 11:12:01'),
(120,'admin-超级管理员','127.0.0.1','2018-12-03 11:13:48'),
(121,'admin-超级管理员','127.0.0.1','2018-12-03 11:14:06'),
(122,'admin-超级管理员','127.0.0.1','2018-12-03 11:14:47'),
(123,'admin-超级管理员','127.0.0.1','2018-12-03 11:16:42'),
(124,'admin-超级管理员','127.0.0.1','2018-12-03 11:20:20'),
(125,'admin-超级管理员','127.0.0.1','2018-12-03 14:09:44'),
(126,'admin-超级管理员','127.0.0.1','2018-12-03 14:12:44'),
(127,'admin-超级管理员','127.0.0.1','2018-12-03 14:29:06'),
(128,'admin-超级管理员','127.0.0.1','2018-12-03 14:40:11'),
(129,'admin-超级管理员','127.0.0.1','2018-12-03 14:55:44'),
(130,'admin-超级管理员','127.0.0.1','2018-12-03 15:01:56'),
(131,'admin-超级管理员','127.0.0.1','2018-12-03 16:21:34'),
(132,'admin-超级管理员','127.0.0.1','2018-12-03 16:34:33'),
(133,'admin-超级管理员','127.0.0.1','2018-12-03 16:35:54'),
(134,'admin-超级管理员','127.0.0.1','2018-12-03 16:36:23'),
(135,'admin-超级管理员','127.0.0.1','2018-12-03 16:49:16'),
(136,'admin-超级管理员','127.0.0.1','2018-12-03 16:50:51'),
(137,'admin-超级管理员','127.0.0.1','2018-12-03 16:52:15'),
(138,'admin-超级管理员','127.0.0.1','2018-12-03 16:52:57'),
(139,'admin-超级管理员','127.0.0.1','2018-12-03 16:55:23'),
(140,'admin-超级管理员','127.0.0.1','2018-12-03 16:56:37'),
(141,'admin-超级管理员','127.0.0.1','2018-12-03 17:02:07'),
(142,'admin-超级管理员','127.0.0.1','2018-12-03 17:04:40'),
(143,'admin-超级管理员','127.0.0.1','2018-12-03 17:06:30'),
(144,'admin-超级管理员','127.0.0.1','2018-12-03 17:08:41'),
(145,'admin-超级管理员','127.0.0.1','2018-12-03 17:19:05'),
(146,'admin-超级管理员','127.0.0.1','2018-12-03 17:20:51'),
(147,'admin-超级管理员','127.0.0.1','2018-12-03 17:23:40'),
(148,'admin-超级管理员','127.0.0.1','2018-12-03 17:25:29'),
(149,'admin-超级管理员','127.0.0.1','2018-12-03 17:29:18'),
(150,'admin-超级管理员','127.0.0.1','2018-12-03 17:37:07'),
(151,'admin-超级管理员','127.0.0.1','2018-12-03 17:47:30'),
(152,'zhangsan-张三','127.0.0.1','2018-12-03 17:47:38'),
(153,'ls-李四','127.0.0.1','2018-12-03 17:47:58'),
(154,'ww-王五','127.0.0.1','2018-12-03 17:48:11'),
(155,'xm-小明','127.0.0.1','2018-12-03 17:48:20'),
(156,'admin-超级管理员','127.0.0.1','2018-12-03 17:48:28'),
(157,'admin-超级管理员','127.0.0.1','2018-12-04 09:05:35'),
(158,'admin-超级管理员','127.0.0.1','2018-12-04 09:06:47'),
(159,'admin-超级管理员','127.0.0.1','2018-12-04 09:22:11'),
(160,'admin-超级管理员','127.0.0.1','2018-12-04 09:22:35'),
(161,'admin-超级管理员','127.0.0.1','2018-12-04 09:23:33'),
(162,'admin-超级管理员','127.0.0.1','2018-12-04 09:28:21'),
(163,'admin-超级管理员','127.0.0.1','2018-12-04 09:31:50'),
(164,'admin-超级管理员','127.0.0.1','2018-12-04 09:42:20'),
(165,'admin-超级管理员','127.0.0.1','2018-12-04 09:44:08'),
(166,'admin-超级管理员','127.0.0.1','2018-12-04 09:51:16'),
(167,'admin-超级管理员','127.0.0.1','2018-12-04 09:52:23'),
(168,'admin-超级管理员','127.0.0.1','2018-12-04 09:52:47'),
(169,'admin-超级管理员','127.0.0.1','2018-12-04 09:54:36'),
(170,'admin-超级管理员','127.0.0.1','2018-12-04 09:55:39'),
(171,'admin-超级管理员','127.0.0.1','2018-12-04 09:59:56'),
(172,'admin-超级管理员','127.0.0.1','2018-12-04 10:02:54'),
(173,'admin-超级管理员','127.0.0.1','2018-12-04 10:09:15'),
(174,'admin-超级管理员','127.0.0.1','2018-12-04 10:09:32'),
(175,'admin-超级管理员','127.0.0.1','2018-12-04 10:10:27'),
(176,'admin-超级管理员','127.0.0.1','2018-12-04 10:17:16'),
(177,'admin-超级管理员','127.0.0.1','2018-12-04 10:18:05'),
(178,'admin-超级管理员','127.0.0.1','2018-12-04 10:19:25'),
(179,'admin-超级管理员','127.0.0.1','2018-12-04 16:48:28'),
(180,'admin-超级管理员','127.0.0.1','2018-12-04 16:55:42'),
(181,'admin-超级管理员','127.0.0.1','2018-12-04 17:19:57'),
(182,'admin-超级管理员','127.0.0.1','2018-12-04 17:23:41'),
(183,'admin-超级管理员','127.0.0.1','2018-12-04 17:33:53'),
(184,'admin-超级管理员','127.0.0.1','2018-12-04 17:35:39'),
(185,'admin-超级管理员','127.0.0.1','2018-12-04 17:38:41'),
(186,'admin-超级管理员','127.0.0.1','2018-12-04 23:04:38'),
(187,'admin-超级管理员','127.0.0.1','2018-12-05 09:54:07'),
(188,'admin-超级管理员','127.0.0.1','2018-12-05 10:04:31'),
(189,'admin-超级管理员','127.0.0.1','2018-12-05 10:28:33'),
(190,'admin-超级管理员','127.0.0.1','2018-12-05 10:29:39'),
(191,'admin-超级管理员','127.0.0.1','2018-12-05 10:29:56'),
(192,'admin-超级管理员','127.0.0.1','2018-12-05 10:43:30'),
(193,'admin-超级管理员','127.0.0.1','2018-12-05 10:43:47'),
(194,'admin-超级管理员','127.0.0.1','2018-12-05 10:57:16'),
(195,'admin-超级管理员','127.0.0.1','2018-12-05 10:57:36'),
(196,'admin-超级管理员','127.0.0.1','2018-12-05 10:58:02'),
(197,'admin-超级管理员','127.0.0.1','2018-12-05 11:04:51'),
(198,'admin-超级管理员','127.0.0.1','2018-12-05 14:10:58'),
(199,'admin-超级管理员','127.0.0.1','2018-12-05 14:12:01'),
(200,'admin-超级管理员','127.0.0.1','2018-12-05 14:40:27'),
(201,'admin-超级管理员','127.0.0.1','2018-12-05 14:50:21'),
(202,'admin-超级管理员','127.0.0.1','2018-12-05 14:50:52'),
(203,'admin-超级管理员','127.0.0.1','2018-12-05 14:51:21'),
(204,'admin-超级管理员','127.0.0.1','2018-12-05 15:11:37'),
(205,'admin-超级管理员','127.0.0.1','2018-12-05 15:21:30'),
(206,'admin-超级管理员','127.0.0.1','2018-12-05 15:22:23'),
(207,'admin-超级管理员','127.0.0.1','2018-12-05 16:03:01'),
(208,'admin-超级管理员','127.0.0.1','2018-12-05 16:03:25'),
(209,'admin-超级管理员','127.0.0.1','2018-12-05 16:17:15'),
(210,'admin-超级管理员','127.0.0.1','2018-12-05 16:20:11'),
(211,'admin-超级管理员','127.0.0.1','2018-12-05 16:28:50'),
(212,'admin-超级管理员','127.0.0.1','2018-12-05 16:38:42'),
(213,'admin-超级管理员','127.0.0.1','2018-12-05 16:40:30'),
(214,'admin-超级管理员','127.0.0.1','2018-12-07 08:48:11'),
(218,'admin-超级管理员','127.0.0.1','2019-03-19 10:59:00'),
(219,'admin-超级管理员','127.0.0.1','2019-03-19 11:28:40'),
(220,'admin-超级管理员','127.0.0.1','2019-03-19 14:08:38'),
(221,'admin-超级管理员','127.0.0.1','2019-03-19 14:09:54'),
(222,'admin-超级管理员','127.0.0.1','2019-03-19 14:32:33'),
(223,'admin-超级管理员','127.0.0.1','2019-03-19 14:37:29'),
(224,'admin-超级管理员','127.0.0.1','2019-03-19 14:51:13'),
(225,'admin-超级管理员','127.0.0.1','2019-03-20 09:12:25'),
(226,'admin-超级管理员','127.0.0.1','2019-03-20 09:50:47'),
(227,'admin-超级管理员','192.168.3.129','2019-03-20 10:13:26'),
(228,'admin-超级管理员','127.0.0.1','2019-03-20 11:05:19'),
(229,'admin-超级管理员','127.0.0.1','2019-03-20 11:17:00'),
(230,'admin-超级管理员','127.0.0.1','2019-03-20 11:42:35'),
(231,'zhangsan-张三','192.168.3.105','2019-03-20 13:04:59'),
(232,'admin-超级管理员','127.0.0.1','2019-03-20 14:01:07'),
(233,'admin-超级管理员','127.0.0.1','2019-03-20 14:14:12'),
(234,'admin-超级管理员','127.0.0.1','2019-03-20 14:15:40'),
(235,'admin-超级管理员','127.0.0.1','2019-03-20 14:19:43'),
(236,'admin-超级管理员','192.168.3.129','2019-03-20 14:52:20'),
(237,'admin-超级管理员','192.168.3.129','2019-03-20 14:54:56'),
(238,'admin-超级管理员','192.168.3.129','2019-03-20 14:55:15'),
(239,'admin-超级管理员','192.168.3.119','2019-03-20 15:08:23'),
(240,'admin-超级管理员','192.168.3.119','2019-03-20 15:10:04'),
(241,'admin-超级管理员','192.168.3.107','2019-03-20 15:28:05'),
(242,'admin-超级管理员','192.168.3.119','2019-03-20 15:28:47'),
(243,'admin-超级管理员','127.0.0.1','2019-03-20 15:58:07'),
(244,'admin-超级管理员','127.0.0.1','2019-03-20 15:58:49'),
(245,'admin-超级管理员','127.0.0.1','2019-03-20 16:08:28'),
(246,'admin-超级管理员','127.0.0.1','2019-03-20 16:17:58'),
(247,'admin-超级管理员','192.168.3.119','2019-03-20 16:22:50'),
(248,'admin-超级管理员','127.0.0.1','2019-03-22 09:11:25'),
(249,'admin-超级管理员','127.0.0.1','2019-03-22 09:17:30'),
(250,'admin-超级管理员','127.0.0.1','2019-03-22 09:17:58'),
(251,'admin-超级管理员','127.0.0.1','2019-03-22 09:44:09'),
(252,'admin-超级管理员','127.0.0.1','2019-03-22 10:17:07'),
(253,'admin-超级管理员','127.0.0.1','2019-03-22 10:17:11'),
(254,'admin-超级管理员','127.0.0.1','2019-03-22 10:26:36'),
(255,'admin-超级管理员','192.168.3.106','2019-03-22 11:26:45'),
(256,'admin-超级管理员','127.0.0.1','2019-03-22 11:44:05'),
(257,'admin-超级管理员','192.168.3.106','2019-03-22 14:07:13'),
(258,'admin-超级管理员','127.0.0.1','2019-03-22 14:18:31'),
(259,'admin-超级管理员','127.0.0.1','2019-03-22 14:23:29'),
(260,'admin-超级管理员','127.0.0.1','2019-03-22 14:27:50'),
(261,'admin-超级管理员','127.0.0.1','2019-03-22 14:44:43'),
(262,'admin-超级管理员','127.0.0.1','2019-03-22 14:46:21'),
(263,'admin-超级管理员','127.0.0.1','2019-03-22 14:52:27'),
(264,'admin-超级管理员','127.0.0.1','2019-03-22 15:56:43'),
(265,'admin-超级管理员','127.0.0.1','2019-03-22 16:05:45'),
(266,'admin-超级管理员','127.0.0.1','2019-03-22 16:37:45'),
(267,'admin-超级管理员','127.0.0.1','2019-03-22 16:53:27'),
(268,'admin-超级管理员','127.0.0.1','2019-03-22 16:57:48'),
(269,'zhangsan-张三','192.168.3.103','2019-03-22 17:01:46'),
(270,'admin-超级管理员','127.0.0.1','2019-03-22 17:02:48'),
(271,'admin-超级管理员','127.0.0.1','2019-03-22 17:05:40'),
(272,'admin-超级管理员','127.0.0.1','2019-03-22 17:59:41'),
(273,'admin-超级管理员','127.0.0.1','2019-03-22 18:01:22'),
(274,'admin-超级管理员','127.0.0.1','2019-03-22 18:04:57'),
(275,'admin-超级管理员','127.0.0.1','2019-03-22 18:10:33'),
(276,'admin-超级管理员','127.0.0.1','2019-03-23 09:05:56'),
(277,'admin-超级管理员','127.0.0.1','2019-03-23 09:27:27'),
(278,'admin-超级管理员','127.0.0.1','2019-03-23 09:29:52'),
(279,'admin-超级管理员','127.0.0.1','2019-03-23 09:49:02'),
(280,'admin-超级管理员','127.0.0.1','2019-03-23 10:45:47'),
(281,'admin-超级管理员','127.0.0.1','2019-03-23 10:53:42'),
(282,'admin-超级管理员','127.0.0.1','2019-03-23 11:11:01'),
(283,'admin-超级管理员','127.0.0.1','2019-03-23 11:15:27'),
(284,'admin-超级管理员','127.0.0.1','2019-03-23 11:22:56'),
(285,'admin-超级管理员','127.0.0.1','2019-03-23 11:23:51'),
(286,'admin-超级管理员','127.0.0.1','2019-03-23 11:26:41'),
(287,'admin-超级管理员','192.168.3.106','2019-03-23 11:41:05'),
(288,'admin-超级管理员','192.168.3.106','2019-03-23 14:22:28'),
(289,'admin-超级管理员','127.0.0.1','2019-03-23 14:26:54'),
(290,'admin-超级管理员','127.0.0.1','2019-03-23 14:52:03'),
(291,'admin-超级管理员','127.0.0.1','2019-03-23 14:53:21'),
(292,'admin-超级管理员','127.0.0.1','2019-03-23 14:58:54'),
(293,'admin-超级管理员','127.0.0.1','2019-03-23 15:42:01'),
(294,'admin-超级管理员','127.0.0.1','2019-03-23 15:54:16'),
(295,'admin-超级管理员','127.0.0.1','2019-03-23 15:55:29'),
(296,'admin-超级管理员','127.0.0.1','2019-03-23 15:57:03'),
(297,'admin-超级管理员','127.0.0.1','2019-03-23 16:13:55'),
(298,'admin-超级管理员','127.0.0.1','2019-03-23 16:14:34'),
(299,'admin-超级管理员','127.0.0.1','2019-03-23 16:24:22'),
(300,'zhangsan-张三','127.0.0.1','2019-03-23 16:24:37'),
(301,'ls-李四','127.0.0.1','2019-03-23 16:24:47'),
(302,'ww-王五','127.0.0.1','2019-03-23 16:24:56'),
(303,'xm-小明','127.0.0.1','2019-03-23 16:25:14'),
(304,'admin-超级管理员','127.0.0.1','2019-03-23 16:25:35'),
(305,'xm-小明','127.0.0.1','2019-03-23 16:25:57'),
(306,'xm-小明','127.0.0.1','2019-03-23 16:27:19'),
(307,'xm-小明','127.0.0.1','2019-03-23 16:27:29'),
(308,'admin-超级管理员','127.0.0.1','2019-03-23 16:27:40'),
(309,'zhangsan-张三','192.168.3.124','2019-03-23 16:29:30'),
(310,'admin-超级管理员','127.0.0.1','2019-03-25 09:26:39'),
(311,'admin-超级管理员','127.0.0.1','2019-03-25 10:10:14'),
(312,'admin-超级管理员','127.0.0.1','2019-03-25 10:10:37'),
(313,'admin-超级管理员','127.0.0.1','2019-03-25 10:22:09'),
(314,'admin-超级管理员','127.0.0.1','2019-03-25 10:51:05'),
(315,'admin-超级管理员','127.0.0.1','2019-03-25 11:09:35'),
(316,'admin-超级管理员','127.0.0.1','2019-03-25 11:37:22'),
(317,'admin-超级管理员','127.0.0.1','2019-03-25 11:37:40'),
(318,'admin-超级管理员','127.0.0.1','2019-03-25 11:45:10'),
(319,'admin-超级管理员','127.0.0.1','2019-03-25 14:11:35'),
(320,'admin-超级管理员','127.0.0.1','2019-03-25 14:16:14'),
(321,'admin-超级管理员','127.0.0.1','2019-03-25 14:51:51'),
(322,'admin-超级管理员','127.0.0.1','2019-03-25 14:52:04'),
(323,'admin-超级管理员','127.0.0.1','2019-03-25 14:55:50'),
(324,'admin-超级管理员','192.168.3.103','2019-03-25 15:21:19'),
(325,'admin-超级管理员','192.168.3.103','2019-03-25 15:38:28'),
(326,'admin-超级管理员','127.0.0.1','2019-03-26 14:39:48'),
(327,'admin-超级管理员','127.0.0.1','2019-03-26 14:59:26'),
(331,'admin-超级管理员','127.0.0.1','2019-03-26 16:13:19'),
(332,'admin-超级管理员','127.0.0.1','2019-03-26 16:14:11'),
(333,'admin-超级管理员','127.0.0.1','2019-03-26 16:16:16'),
(334,'admin-超级管理员','192.168.3.103','2019-03-26 16:36:15'),
(335,'admin-超级管理员','127.0.0.1','2019-03-27 09:23:09'),
(341,'admin-超级管理员','127.0.0.1','2020-07-02 17:13:51'),
(342,'admin-超级管理员','127.0.0.1','2020-07-02 17:15:51'),
(343,'admin-超级管理员','127.0.0.1','2020-07-02 20:26:15'),
(344,'admin-超级管理员','127.0.0.1','2020-07-02 20:26:55'),
(345,'admin-超级管理员','127.0.0.1','2020-07-02 20:27:16'),
(346,'admin-超级管理员','127.0.0.1','2020-07-02 21:20:06'),
(347,'admin-超级管理员','127.0.0.1','2020-07-02 21:22:34'),
(348,'admin-超级管理员','127.0.0.1','2020-07-02 21:34:52'),
(349,'admin-超级管理员','127.0.0.1','2020-07-02 21:39:29'),
(350,'admin-超级管理员','127.0.0.1','2020-07-02 21:40:02'),
(351,'admin-超级管理员','127.0.0.1','2020-07-02 21:54:30'),
(352,'admin-超级管理员','127.0.0.1','2020-07-02 21:55:46'),
(353,'admin-超级管理员','127.0.0.1','2020-07-02 21:56:35'),
(354,'admin-超级管理员','127.0.0.1','2020-07-02 21:57:04'),
(355,'admin-超级管理员','127.0.0.1','2020-07-02 21:59:11'),
(356,'admin-超级管理员','127.0.0.1','2020-07-02 22:05:26'),
(357,'admin-超级管理员','127.0.0.1','2020-07-02 22:06:24'),
(358,'admin-超级管理员','127.0.0.1','2020-07-02 22:09:12'),
(359,'admin-超级管理员','127.0.0.1','2020-07-02 22:10:04'),
(360,'admin-超级管理员','127.0.0.1','2020-07-02 22:14:25'),
(361,'admin-超级管理员','127.0.0.1','2020-07-02 22:15:59'),
(362,'admin-超级管理员','127.0.0.1','2020-07-02 22:22:17'),
(363,'admin-超级管理员','127.0.0.1','2020-07-02 22:33:12'),
(364,'admin-超级管理员','127.0.0.1','2020-07-02 22:35:29'),
(365,'admin-超级管理员','127.0.0.1','2020-07-02 22:38:24'),
(366,'admin-超级管理员','127.0.0.1','2020-07-02 22:39:51'),
(367,'admin-超级管理员','127.0.0.1','2020-07-02 22:41:00'),
(368,'admin-超级管理员','127.0.0.1','2020-07-02 22:43:40'),
(369,'admin-超级管理员','127.0.0.1','2020-07-02 22:46:38'),
(370,'admin-超级管理员','127.0.0.1','2020-07-02 22:50:27'),
(371,'admin-超级管理员','127.0.0.1','2020-07-02 22:52:56'),
(372,'admin-超级管理员','127.0.0.1','2020-07-02 22:53:12'),
(373,'admin-超级管理员','127.0.0.1','2020-07-02 22:53:38'),
(374,'admin-超级管理员','127.0.0.1','2020-07-02 22:55:05'),
(375,'admin-超级管理员','127.0.0.1','2020-07-02 22:56:28'),
(376,'admin-超级管理员','127.0.0.1','2020-07-02 22:56:38'),
(377,'admin-超级管理员','127.0.0.1','2020-07-02 22:57:02'),
(378,'admin-超级管理员','127.0.0.1','2020-07-02 22:59:17'),
(379,'admin-超级管理员','127.0.0.1','2020-07-02 23:04:30'),
(380,'admin-超级管理员','127.0.0.1','2020-07-02 23:05:57'),
(381,'admin-超级管理员','127.0.0.1','2020-07-02 23:07:00'),
(382,'admin-超级管理员','127.0.0.1','2020-07-02 23:07:45'),
(383,'admin-超级管理员','127.0.0.1','2020-07-02 23:08:45'),
(384,'admin-超级管理员','127.0.0.1','2020-07-02 23:15:41'),
(385,'admin-超级管理员','127.0.0.1','2020-07-02 23:16:32'),
(386,'admin-超级管理员','127.0.0.1','2020-07-02 23:17:05'),
(387,'admin-超级管理员','127.0.0.1','2020-07-02 23:19:14'),
(388,'admin-超级管理员','127.0.0.1','2020-07-02 23:19:22'),
(389,'admin-超级管理员','127.0.0.1','2020-07-02 23:20:51'),
(390,'admin-超级管理员','127.0.0.1','2020-07-02 23:22:19'),
(391,'admin-超级管理员','127.0.0.1','2020-07-02 23:23:24'),
(392,'admin-超级管理员','127.0.0.1','2020-07-02 23:23:29'),
(393,'admin-超级管理员','127.0.0.1','2020-07-02 23:24:32'),
(394,'admin-超级管理员','127.0.0.1','2020-07-02 23:24:58'),
(395,'admin-超级管理员','127.0.0.1','2020-07-02 23:26:32'),
(396,'admin-超级管理员','127.0.0.1','2020-07-02 23:27:23'),
(397,'admin-超级管理员','127.0.0.1','2020-07-02 23:27:48'),
(398,'admin-超级管理员','127.0.0.1','2020-07-02 23:28:51'),
(399,'admin-超级管理员','127.0.0.1','2020-07-02 23:34:22'),
(400,'admin-超级管理员','127.0.0.1','2020-07-02 23:35:01'),
(401,'admin-超级管理员','127.0.0.1','2020-07-02 23:35:32'),
(402,'admin-超级管理员','127.0.0.1','2020-07-02 23:36:44'),
(403,'admin-超级管理员','127.0.0.1','2020-07-02 23:36:46'),
(404,'admin-超级管理员','127.0.0.1','2020-07-02 23:40:10'),
(405,'admin-超级管理员','127.0.0.1','2020-07-02 23:45:18'),
(406,'admin-超级管理员','127.0.0.1','2020-07-02 23:45:39'),
(407,'admin-超级管理员','127.0.0.1','2020-07-02 23:46:01'),
(408,'admin-超级管理员','127.0.0.1','2020-07-02 23:46:37'),
(409,'admin-超级管理员','127.0.0.1','2020-07-02 23:49:26'),
(410,'admin-超级管理员','127.0.0.1','2020-07-03 00:04:13'),
(411,'admin-超级管理员','127.0.0.1','2020-07-03 00:05:22'),
(412,'admin-超级管理员','127.0.0.1','2020-07-03 00:05:43'),
(413,'admin-超级管理员','127.0.0.1','2020-07-03 13:42:15'),
(414,'admin-超级管理员','127.0.0.1','2020-07-03 13:43:03'),
(415,'admin-超级管理员','127.0.0.1','2020-07-03 13:43:19'),
(416,'admin-超级管理员','127.0.0.1','2020-07-03 13:43:35'),
(417,'admin-超级管理员','127.0.0.1','2020-07-03 13:45:00'),
(418,'admin-超级管理员','127.0.0.1','2020-07-03 13:45:33'),
(419,'admin-超级管理员','127.0.0.1','2020-07-03 13:45:40'),
(420,'admin-超级管理员','127.0.0.1','2020-07-03 13:46:33'),
(421,'admin-超级管理员','127.0.0.1','2020-07-03 13:47:20'),
(422,'admin-超级管理员','127.0.0.1','2020-07-03 13:52:40'),
(423,'admin-超级管理员','127.0.0.1','2020-07-03 13:54:36'),
(424,'admin-超级管理员','127.0.0.1','2020-07-03 13:56:48'),
(425,'admin-超级管理员','127.0.0.1','2020-07-03 14:03:44'),
(426,'admin-超级管理员','127.0.0.1','2020-07-03 14:04:21');

/*Table structure for table `sys_menu` */

DROP TABLE IF EXISTS `sys_menu`;

CREATE TABLE `sys_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `href` varchar(255) DEFAULT NULL,
  `spread` int(255) DEFAULT NULL COMMENT '0不打1打开',
  `target` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `available` int(255) DEFAULT NULL COMMENT '0不可用1可用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

/*Data for the table `sys_menu` */

insert  into `sys_menu`(`id`,`pid`,`title`,`href`,`spread`,`target`,`icon`,`available`) values 
(1,0,'汽车出租系统',NULL,1,NULL,'&#xe68e',1),
(2,1,'基础管理',NULL,1,NULL,'&#xe653;',1),
(3,1,'业务管理',NULL,0,NULL,'&#xe663;',1),
(4,1,'系统管理','',1,'','&#xe716;',1),
(5,1,'统计分析',NULL,0,NULL,'&#xe629;',1),
(6,2,'客户管理',NULL,0,NULL,'&#xe770;',1),
(7,2,'车辆管理',NULL,0,NULL,'&#xe657;',1),
(8,3,'汽车出租',NULL,0,NULL,'&#xe65b;',1),
(9,3,'出租单管理',NULL,0,NULL,'&#xe6b2;',1),
(10,3,'汽车入库',NULL,0,NULL,'&#xe65a;',1),
(11,3,'检查单管理',NULL,0,NULL,'&#xe705;',1),
(12,4,'菜单管理','../sys/toMenuManagerPage',0,NULL,'&#xe60f;',1),
(13,4,'角色管理','../sys/toRoleManagerPage',0,NULL,'&#xe66f;',1),
(14,4,'用户管理','../sys/toUserManagerPage',0,'','&#xe770;',1),
(15,4,'日志管理','../sys/toLogInfoPage',0,'','&#xe655;',1),
(16,4,'公告管理','../sys/toNewsPage',0,'','&#xe645;',1),
(17,4,'数据源监控',NULL,0,NULL,'&#xe857;',1),
(18,5,'客户地区统计',NULL,0,NULL,'&#xe63c;',1),
(19,5,'公司年度月份销售额',NULL,0,NULL,'&#xe62c;',1),
(20,5,'业务员年度销售额1','',0,'','&#xe62d;',1);

/*Table structure for table `sys_news` */

DROP TABLE IF EXISTS `sys_news`;

CREATE TABLE `sys_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `content` varchar(4000) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `opername` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

/*Data for the table `sys_news` */

insert  into `sys_news`(`id`,`title`,`content`,`createtime`,`opername`) values 
(5,'关系系统升级公告','<p>关系系统升级公告关系系统升级公告关系系统升级公告关系系统升级公告关系系统升级公告关系系统升级公告			</p>','2018-06-14 18:05:22','习大大'),
(6,'4444','<p><img src=\"http://127.0.0.1:8080/bjsxt/resources/umeditor/jsp/upload/20190319/99511552975805893.jpg\"/></p>','2019-03-19 14:10:11','超级管理员'),
(10,'你好','','2020-07-02 22:07:50','超级管理员'),
(11,'111','222','2020-07-02 22:15:23','超级管理员');

/*Table structure for table `sys_role` */

DROP TABLE IF EXISTS `sys_role`;

CREATE TABLE `sys_role` (
  `roleid` int(11) NOT NULL AUTO_INCREMENT,
  `rolename` varchar(255) DEFAULT NULL,
  `roledesc` varchar(255) DEFAULT NULL,
  `available` int(11) DEFAULT NULL,
  PRIMARY KEY (`roleid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

/*Data for the table `sys_role` */

insert  into `sys_role`(`roleid`,`rolename`,`roledesc`,`available`) values 
(1,'超级管理员','拥有所有菜单权限',1),
(2,'业务管理员','拥有所以业务菜单',1),
(3,'系统管理员','管理系统',1),
(4,'数据统计管理员','数据统计管理员',1),
(6,'221','222',1);

/*Table structure for table `sys_role_menu` */

DROP TABLE IF EXISTS `sys_role_menu`;

CREATE TABLE `sys_role_menu` (
  `rid` int(11) NOT NULL,
  `mid` int(11) NOT NULL,
  PRIMARY KEY (`rid`,`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_role_menu` */

insert  into `sys_role_menu`(`rid`,`mid`) values 
(1,1),
(1,2),
(1,3),
(1,4),
(1,5),
(1,6),
(1,7),
(1,8),
(1,9),
(1,10),
(1,11),
(1,12),
(1,13),
(1,14),
(1,15),
(1,16),
(1,17),
(1,18),
(1,21),
(1,22),
(2,1),
(2,4),
(2,12),
(2,13),
(2,14),
(2,15),
(2,16),
(4,1),
(4,4),
(4,12),
(4,13),
(4,14),
(4,15),
(4,16),
(4,17);

/*Table structure for table `sys_role_user` */

DROP TABLE IF EXISTS `sys_role_user`;

CREATE TABLE `sys_role_user` (
  `uid` int(11) NOT NULL,
  `rid` int(11) NOT NULL,
  PRIMARY KEY (`uid`,`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*Data for the table `sys_role_user` */

insert  into `sys_role_user`(`uid`,`rid`) values 
(1,1),
(1,2),
(1,3),
(1,4),
(3,1),
(3,2),
(3,3),
(4,2),
(5,2),
(5,3),
(5,4),
(6,2),
(6,4);

/*Table structure for table `sys_user` */

DROP TABLE IF EXISTS `sys_user`;

CREATE TABLE `sys_user` (
  `userid` int(11) NOT NULL AUTO_INCREMENT,
  `loginname` varchar(255) DEFAULT NULL,
  `identity` varchar(255) DEFAULT NULL,
  `realname` varchar(255) DEFAULT NULL,
  `sex` int(255) DEFAULT NULL COMMENT '0女1男',
  `address` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `pwd` varchar(255) DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `type` int(255) DEFAULT '2' COMMENT '1，超级管理员,2，系统用户',
  `available` int(255) DEFAULT NULL,
  PRIMARY KEY (`userid`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

/*Data for the table `sys_user` */

insert  into `sys_user`(`userid`,`loginname`,`identity`,`realname`,`sex`,`address`,`phone`,`pwd`,`position`,`type`,`available`) values 
(1,'admin','4313341334413','超级管理员',1,'武汉','134441331311','01d7f40760960e7bd9443513f22ab9af','CEO',1,1),
(3,'zhangsan','3413334134131131','张三',1,'武汉','134131313111','01d7f40760960e7bd9443513f22ab9af','BA',2,1),
(4,'ls','43311341311314341','李四',1,'武汉','1341314113131','e10adc3949ba59abbe56e057f20f883e','扫地的',2,1),
(5,'ww','4313133131331312','王五',1,'武汉','13413131131','e10adc3949ba59abbe56e057f20f883e','领导',2,1),
(6,'xm','45113141331131131','小明',1,'武昌','13451333131','e10adc3949ba59abbe56e057f20f883e','扫地工',2,1),
(8,'zhangsan1','379783900495832334','zhangsan111',0,'北京','18273849586','e10adc3949ba59abbe56e057f20f883e','职员',2,1),
(9,'aaa','11111111111111','aaa',0,'上海','11111111111',NULL,'员工',2,1),
(10,'qqq','11111111111111','bbb',1,'北京','11111111111',NULL,'员工',2,1),
(11,'www','22222222222222','www',0,'北京','11111111111',NULL,'扫地工',2,1);

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
