import styles from "./RefundText.module.css";


export default function RefundPage(){
    return(
        <article id="5c462313-e15a-4191-9a04-c728d2123c16" className={[styles.page, styles.sans].join(" ")}>
            <header>
                <h1 className={styles.pageTitle}>
                    <strong>Donation Refund Policy</strong>
                </h1>
                <p className={styles.pageDescription}></p>
            </header>
            <div className={styles.pageBody}>
                <p id="e8d81c9f-7007-4138-ae6e-22e4f962f791">
                    At Mulearn Foundation, we are dedicated to maintaining
                    transparency and integrity in all our interactions,
                    including donation processing. We deeply value the support
                    of our donors and are committed to handling all donations
                    with care and accountability. While we do not typically
                    offer refunds on donations, we understand that circumstances
                    may arise where a donor may request a refund.
                </p>
                <h2 className={styles.heading2} id="95b9be19-b97b-4376-bb6c-0fabaf498d2b">
                    <strong>Receipt Issuance and Verification</strong>
                </h2>
                <ol
                    type="1"
                    id="4a16632e-f9d0-4c76-bee2-3700f3ef72e2"
                    className={styles.numberedList}
                    start={1}
                >
                    <li>
                        Receipts: Upon making a donation, donors will receive a
                        receipt from Mulearn Foundation acknowledging their
                        contribution. This receipt serves as proof of donation.
                    </li>
                </ol>
                <ol
                    type="1"
                    id="1c216c4e-0d03-4e5b-a51b-0fe82ff174ec"
                    className={styles.numberedList}
                    start={2}
                >
                    <li>
                        Verification: In the event of a refund request, donors
                        must provide the receipt received at the time of
                        donation for verification purposes.
                    </li>
                </ol>
                <h2 className={styles.heading2} id="7faed5eb-26a3-4156-97f7-bfc5f739aa17">
                    <strong>Refund Eligibility</strong>
                </h2>
                <ol
                    type="1"
                    id="0c814ce7-97f9-45d2-a3f6-3dd047f12826"
                    className={styles.numberedList}
                    start={1}
                >
                    <li>
                        Notification Period: Donors seeking a refund must
                        contact Mulearn Foundation within 7 days of the donation
                        date to initiate the refund process. Refund requests
                        made after this period may not be considered.
                    </li>
                </ol>
                <ol
                    type="1"
                    id="100e4008-cf49-4892-9fee-6b8b27577952"
                    className={styles.numberedList}
                    start={2}
                >
                    <li>
                        Valid Reasons: Refunds may be considered under the
                        following circumstances:
                    </li>
                </ol>
                <p id="b92a3394-ecb4-43d7-96c8-5fff85eb6e85">
                    - Unauthorized transactions or fraudulent activity.
                </p>
                <p id="736ca98c-8ce8-4f8e-9eb1-5660f3d8e26b">
                    - Errors in the donation amount.
                </p>
                <p id="6c8b7402-d019-48ba-899f-a0c1d1074b72">
                    - Dissatisfaction with the services provided under a
                    subscription-based donation (see below for
                    subscription-based donations policy).
                </p>
                <h2 className={styles.heading2} id="abde7fa0-e02d-4ca1-87b4-226aaf1be01e">
                    <strong>Subscription-Based Donations</strong>
                </h2>
                <ol
                    type="1"
                    id="63c461df-ebde-4bb9-9031-68185b880873"
                    className={styles.numberedList}
                    start={1}
                >
                    <li>
                        Subscription Terms: Mulearn Foundation offers
                        subscription-based donation options where donors commit
                        to regular contributions over a specified period.
                    </li>
                </ol>
                <ol
                    type="1"
                    id="bd007a54-78a8-4cc5-90e5-b7a9258df731"
                    className={styles.numberedList}
                    start={2}
                >
                    <li>
                        Cancellation: Donors subscribed to recurring donations
                        have the option to cancel their subscription at any
                        time. Upon cancellation, future donations will be
                        discontinued, but previous donations are generally
                        non-refundable.
                    </li>
                </ol>
                <h2 className={styles.heading2} id="5ef42403-f10d-4410-9163-4acd02e85dac">
                    <strong>Refund Process</strong>
                </h2>
                <ol
                    type="1"
                    id="2eba47cf-c08c-4125-9c6f-97c1f313e772"
                    className={styles.numberedList}
                    start={1}
                >
                    <li>
                        Request Submission: Donors must submit their refund
                        request to Mulearn Foundation via refunds@mulearn.org,
                        providing details of the donation, the reason for the
                        refund request, and a copy of the donation receipt.
                    </li>
                </ol>
                <ol
                    type="1"
                    id="a05170c6-aa28-4c1d-bf9f-408d4a92d091"
                    className={styles.numberedList}
                    start={2}
                >
                    <li>
                        Review and Approval: Mulearn Foundation will review the
                        refund request and may require additional information
                        for verification purposes. Refunds will be approved at
                        the discretion of the Foundation.
                    </li>
                </ol>
                <ol
                    type="1"
                    id="fc7c02c9-b5a0-45ba-a7b5-fdda9cc84b3d"
                    className={styles.numberedList}
                    start={3}
                >
                    <li>
                        Refund Issuance: Upon approval, refunds will be
                        processed using the original payment method, unless
                        otherwise specified by the donor.
                    </li>
                </ol>
                <h2 className={styles.heading2} id="f1777bc2-ccbf-49dd-8c99-a8497e99917f">
                    <strong>Contact Information</strong>
                </h2>
                <p id="ca78dd35-7554-423b-9d4e-e5ab30c0a505">
                    For any inquiries or refund requests, please contact us at:
                </p>
                <p id="30aadaa4-cef4-4c03-b254-2fda12a74589">
                    Mulearn Foundation
                </p>
                <p id="5b1f44a0-c96a-4345-a778-bd56a181d8a1">
                    GTech Nila Building,
                </p>
                <p id="c56cae10-c261-418f-a9ff-ff04c993e3c9">
                    Phase 1, Technopark,
                </p>
                <p id="98d09a7f-4a43-4940-8ef7-fd132921fb74">
                    Karyavattom, Trivandrum
                </p>
                <h2 className={styles.heading2} id="4ad3ba19-4ee8-45ec-b29e-01cedc6c6b79">
                    <strong>Policy Revision</strong>
                </h2>
                <p id="f9251d08-8b1c-4c2a-a086-3481a238c063">
                    Mulearn Foundation reserves the right to modify or update
                    this donation refund policy at any time without prior
                    notice. Any revisions will be effective immediately upon
                    posting on our website or other communication channels.
                </p>
                <p id="c48aaeed-1004-4c57-abe9-ded8660dcbcb">
                    Last Updated: 15 May 2024
                </p>
            </div>
        </article>
    )
};