import React from "react";

type Props = {};

const Planet3 = (props: Props) => {
    return (
        <svg
            width="30"
            height="30"
            viewBox="0 0 20 20"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20 9.99997C20 12.8903 18.7763 15.4852 16.8143 17.3207C15.886 18.1857 14.7679 18.8819 13.5442 19.346C12.4472 19.768 11.2447 20 9.99993 20C9.5569 20 9.11386 19.9789 8.69191 19.9156C6.77208 19.6625 4.99993 18.8608 3.58643 17.6582C2.55268 16.7933 1.6877 15.7173 1.07589 14.5148C0.696144 13.7553 0.400789 12.9325 0.210919 12.0675C0.0632422 11.3924 -4.61789e-05 10.7173 -4.30821e-05 9.99997C-3.45203e-05 8.01683 0.569594 6.18138 1.56116 4.64129C1.98311 3.98728 2.46835 3.37546 3.03797 2.84803C4.83123 1.09697 7.29959 0.0210114 10 0.0210114C10.211 0.0210114 10.4431 0.0210118 10.654 0.042109C11.7933 0.1054 12.8692 0.379663 13.8819 0.801606C14.0507 0.864898 14.2194 0.949286 14.3882 1.03367C15.3587 1.49781 16.2447 2.13073 17.0042 2.89023C18.8608 4.68348 20 7.21514 20 9.99997Z"
                fill="url(#paint0_radial_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.72588 16.6245C3.88199 16.6245 2.34191 15.4009 1.60352 13.8397C0.696351 11.8776 0.675263 9.81011 1.1183 9.43036C1.24489 9.32487 1.41366 9.26158 1.62463 9.26158C1.75122 9.26158 1.91999 9.28268 2.06767 9.32487C3.12253 9.64133 4.59932 11.097 5.23222 12.5738C5.84403 14.0084 5.67525 15.1477 5.48537 15.8439C5.35879 16.4979 5.00014 16.6245 4.72588 16.6245Z"
                fill="url(#paint1_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.35852 15.8017C5.25303 16.2025 5.06316 16.4557 4.72561 16.4557C4.00831 16.4557 2.48932 15.3164 1.77202 13.7552C0.843761 11.7932 0.907061 9.85227 1.24462 9.55691C1.41339 9.40923 1.70875 9.38813 2.04631 9.49362C3.12226 9.81007 4.74673 11.1814 5.08427 12.616C5.40072 13.8185 5.5484 15.0844 5.35852 15.8017Z"
                fill="url(#paint2_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M1.89837 8.60759C1.79289 8.60759 1.6874 8.56539 1.62411 8.481C1.34985 8.16455 1.7507 7.04639 1.91948 6.64555C2.19374 6.01263 2.4891 5.67508 2.74227 5.67508C2.84775 5.67508 2.93214 5.71727 3.01653 5.78057L3.05873 5.82276C3.35408 6.11812 3.50176 6.81433 3.22749 7.36285C3.01652 7.7637 2.4047 8.45991 1.98276 8.56539C1.98276 8.60759 1.94057 8.60759 1.89837 8.60759Z"
                fill="url(#paint3_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3.16448 7.32065C2.97461 7.7004 2.34169 8.3966 1.96195 8.50209C1.85646 8.52319 1.77207 8.52319 1.72988 8.45989C1.45562 8.12234 2.25732 5.82275 2.80584 5.80165C2.89023 5.80165 2.97462 5.84385 3.03791 5.90714C3.26998 6.13921 3.41765 6.79322 3.16448 7.32065Z"
                fill="url(#paint4_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.0335 16.3713C15.696 16.3713 15.4428 16.2448 15.3373 15.9916C15.1263 15.5275 15.2318 13.8186 15.907 12.3207C16.8985 10.0844 18.2909 9.49367 18.8606 9.49367C18.9028 9.49367 18.945 9.49367 18.966 9.49367C18.9871 9.49367 19.0082 9.49367 19.0293 9.51477C19.177 9.55696 19.3247 9.68354 19.4091 9.87342C19.8099 10.6962 19.5779 12.7215 18.9238 14.135C18.3542 15.4642 16.9407 16.3713 16.0335 16.3713Z"
                fill="url(#paint5_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.7974 14.0928C17.9957 15.8227 15.8649 16.6877 15.5063 15.9282C15.3164 15.5485 15.4008 13.924 16.0759 12.405C17.0886 10.1476 18.481 9.62017 18.9662 9.68347L18.9873 9.68347C19.6835 9.87334 19.578 12.3839 18.7974 14.0928Z"
                fill="url(#paint6_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.6499 9.36705C18.5655 9.36705 18.5022 9.34595 18.4389 9.30376C18.017 9.05059 17.7427 7.42611 18.0381 6.91978C18.1225 6.7721 18.228 6.7299 18.2913 6.7299C18.3124 6.7299 18.3545 6.7299 18.3967 6.7299C18.8609 6.7299 19.325 7.27843 19.4938 7.99573C19.5993 8.50207 19.3883 8.92401 19.1351 9.13498C18.9874 9.28266 18.8187 9.36705 18.6499 9.36705Z"
                fill="url(#paint7_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.0296 9.00837C18.8609 9.17714 18.671 9.24043 18.5444 9.15605C18.2068 8.96617 17.9537 7.44718 18.2068 7.00414C18.249 6.94084 18.2912 6.89865 18.3334 6.89865C18.671 6.83536 19.1562 7.2784 19.325 8.0379C19.4094 8.43874 19.2406 8.79739 19.0296 9.00837Z"
                fill="url(#paint8_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.6331 19.8734C10.5698 19.8734 10.5065 19.8734 10.4432 19.8734C9.40948 19.8523 8.62889 19.4093 8.50231 19.0295C8.46011 18.8819 8.48121 18.7342 8.5867 18.6498C8.90315 18.3755 10.2323 18.3544 10.5065 18.3544C11.3715 18.3544 12.4264 18.4388 12.5108 18.8397C12.5318 18.9452 12.5318 19.0928 12.3631 19.2827C12.131 19.5148 11.8145 19.8734 10.6331 19.8734Z"
                fill="url(#paint9_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M12.2359 19.135C11.9827 19.4093 11.6874 19.7258 10.4426 19.7047C9.2401 19.6625 8.39622 19.0295 8.69158 18.7764C9.09243 18.4388 12.2148 18.4177 12.3203 18.8819C12.3625 18.9452 12.3414 19.0506 12.2359 19.135Z"
                fill="url(#paint10_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.4856 10.1478C14.8105 10.1478 14.3042 9.83131 14.0299 9.26169C13.397 7.86927 13.397 5.16884 13.8612 4.09288C13.9878 3.81862 14.1144 3.64984 14.2831 3.58655C14.4519 3.52326 14.6207 3.48106 14.8106 3.48106C15.4013 3.48106 16.0131 3.88191 16.5827 4.62031C17.511 5.84395 18.165 7.82708 17.9118 8.71316C17.8274 8.98742 17.5953 9.30388 17.2156 9.55705C16.6882 9.9157 16.0553 10.1478 15.4856 10.1478Z"
                fill="url(#paint11_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.7427 8.64971C17.6794 8.90287 17.4474 9.17714 17.1098 9.40921C16.2448 10.0421 14.7258 10.3797 14.1773 9.19824C13.5655 7.84802 13.5655 5.21087 14.0085 4.15601C14.0929 3.94504 14.2195 3.79736 14.3461 3.73407C16.2237 2.95348 18.1014 7.34168 17.7427 8.64971Z"
                fill="url(#paint12_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.35842 15.8017C4.38795 16.1604 2.86897 14.9367 2.08838 12.9325C1.39219 11.1814 1.91962 9.78903 2.0673 9.49367C3.14325 9.81012 4.76772 11.1814 5.10527 12.616C5.40062 13.8186 5.5483 15.0844 5.35842 15.8017Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M12.2362 19.135C10.1687 19.768 8.69189 18.7553 8.69189 18.7553C9.09274 18.4177 12.2151 18.3966 12.3206 18.8608C12.3628 18.9452 12.3417 19.0506 12.2362 19.135Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.46 13.924C17.0464 16.2236 15.4853 15.9282 15.4853 15.9282C15.2954 15.5485 15.3798 13.924 16.0549 12.405C17.0676 10.1476 18.46 9.62017 18.9452 9.68347L18.9663 9.68347C19.2617 10.5484 19.4726 12.2784 18.46 13.924Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.1098 9.40923C16.2448 10.0421 14.7258 10.3797 14.1773 9.19826C13.5655 7.84804 13.5655 5.2109 14.0085 4.15604C14.3883 4.11384 15.1267 4.24043 15.9495 5.46406C17.1309 7.15183 17.5106 8.43876 17.1098 9.40923Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.0296 9.00841C18.8609 9.17719 18.671 9.24048 18.5444 9.15609C18.2068 8.96622 17.9537 7.44722 18.2069 7.00418C18.46 7.15186 18.8609 7.46832 18.9663 8.03794C19.0085 8.39659 19.0296 8.73415 19.0296 9.00841Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3.16444 7.32065C2.97457 7.70039 2.34165 8.3966 1.9619 8.50209C1.983 8.35441 2.27837 6.56115 3.01677 5.90714C3.26993 6.1392 3.41761 6.79322 3.16444 7.32065Z"
                fill="#FFFF45"
            />
            <path
                opacity="0.3"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.1899 12.363C15.0845 12.595 14.979 12.806 14.8313 13.017C14.7047 13.1646 14.557 13.2912 14.4726 13.46C14.1562 14.0507 14.2195 14.7258 14.0507 15.3377C13.9452 15.6752 13.692 15.9495 13.5865 16.287C13.5443 16.4347 13.5654 16.5824 13.5654 16.7512C13.5654 16.941 13.46 17.0676 13.3545 17.2153C13.2279 17.3841 13.0591 17.4896 12.8692 17.574C12.7216 17.6372 12.5528 17.6161 12.384 17.6161C12.0254 17.6161 11.6878 17.574 11.3291 17.4685C11.0127 17.3841 10.7173 17.2364 10.4009 17.1309C10.1899 17.0676 10.0211 17.0887 9.81016 17.1309C9.62029 17.1731 9.40931 17.152 9.21944 17.152C8.88189 17.152 8.56543 17.3419 8.27007 17.4896C8.0591 17.5951 7.91142 17.7216 7.82703 17.9537C7.72154 18.228 7.72154 18.4811 7.40508 18.5866C7.21521 18.6499 6.98314 18.5866 6.79327 18.5444C6.62449 18.5022 6.43462 18.5233 6.26584 18.5233C5.92829 18.5233 5.61183 18.4178 5.29538 18.2702C4.93673 18.0803 4.62027 17.806 4.34601 17.5318C4.19833 17.3841 3.98736 17.2997 3.83968 17.152C3.62871 16.9621 3.39664 16.7723 3.20677 16.5824C2.89032 16.2659 2.55276 15.9495 2.21521 15.6541C1.96205 15.4642 1.75108 15.2111 1.54011 14.979C1.37133 14.7891 1.26585 14.5149 1.13927 14.2828C0.886102 13.8398 0.675134 13.3334 0.548554 12.8271C0.400876 12.2575 0.232102 11.6456 0.253202 11.0549C0.253204 10.5486 0.189915 10.0845 0.189917 9.57813C0.147718 10.5275 0.189909 11.3081 0.295392 12.0465C0.147715 11.3714 0.0844265 10.6963 0.0844296 9.97897C0.0844381 7.99584 0.654068 6.16039 1.64564 4.62029C2.06758 3.96628 2.55282 3.35446 3.12244 2.82703C4.9157 1.07597 7.38407 1.52663e-05 10.0845 1.5269e-05C10.2955 1.52692e-05 10.5275 1.49473e-05 10.7385 0.0211121C11.8777 0.0844036 12.9537 0.358667 13.9664 0.78061C14.2195 1.05487 14.4727 1.37133 14.6626 1.68779C14.7469 1.81437 14.7891 1.96205 14.8735 2.08863C14.9368 2.21522 15.0212 2.25741 15.0001 2.40509C14.979 2.48948 14.9368 2.59497 14.8946 2.67936C14.7891 2.95362 14.4727 3.14349 14.2406 3.29117C13.9031 3.50214 13.5233 3.58653 13.1647 3.77641C12.9326 3.90299 12.8693 4.00848 12.7005 4.19835C12.6161 4.30384 12.5106 4.36713 12.4474 4.47261C12.2575 4.76797 12.152 5.18992 12.1731 5.52747C12.1942 6.20258 12.7216 6.68782 12.8482 7.32073C12.9537 7.86926 12.8693 8.45998 13.0591 8.98741C13.249 9.59922 13.7764 10.0845 14.2828 10.4431C14.4937 10.5908 14.6836 10.7174 14.8735 10.8862C15.0423 11.0549 15.2743 11.1393 15.4009 11.3503C15.5064 11.6878 15.3165 12.0465 15.1899 12.363Z"
                fill="url(#paint13_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14.3881 1.01257C14.3459 1.01257 14.3248 1.01257 14.2826 1.03367C14.1771 1.05476 14.0717 1.03367 13.9662 1.01257C13.8818 0.991473 13.8396 0.949279 13.7341 0.949279C13.6075 0.928182 13.502 0.885987 13.3755 0.86489C13.2489 0.843793 13.1434 0.801598 13.0168 0.759404C12.9113 0.71721 12.8691 0.738307 12.7847 0.759404C12.7003 0.780501 12.6371 0.738307 12.5527 0.71721C12.4683 0.675015 12.3628 0.675015 12.2784 0.653918C12.0252 0.611724 11.7721 0.527336 11.5189 0.464044C11.3712 0.42185 11.2235 0.42185 11.0548 0.42185C10.9282 0.42185 10.8227 0.464044 10.6961 0.464044C10.6117 0.464044 10.5484 0.442947 10.4641 0.442947C10.3797 0.42185 10.2953 0.442947 10.2109 0.442947C10.0843 0.42185 10.021 0.400752 9.89443 0.442947C9.78895 0.464044 9.72566 0.464044 9.62017 0.485141C9.51468 0.485141 9.3881 0.527335 9.28262 0.548433C9.09274 0.590627 8.88177 0.632821 8.6919 0.632821C8.56531 0.632821 8.39654 0.590627 8.29105 0.632821C8.22776 0.653919 8.18557 0.738307 8.12228 0.780502C8.01679 0.885988 7.9113 0.970376 7.82691 1.07586C7.74253 1.18135 7.65814 1.30793 7.65814 1.45561C7.65814 1.58219 7.72143 1.72987 7.78472 1.83536C7.84801 1.96194 7.8691 2.06743 7.74252 2.15182C7.59484 2.2573 7.40497 2.34169 7.23619 2.40498C7.10961 2.44718 7.00412 2.46827 6.91973 2.38389C6.87754 2.36279 6.85644 2.2995 6.81425 2.2573C6.77205 2.23621 6.70876 2.2573 6.66657 2.2784C6.53999 2.32059 6.4134 2.36279 6.28682 2.38389C6.20243 2.40498 6.13914 2.44718 6.05475 2.44718C5.97036 2.46827 5.90707 2.40498 5.80159 2.42608C5.67501 2.44718 5.52733 2.51047 5.40074 2.51047C5.29526 2.51047 5.16868 2.46827 5.08429 2.42608C5.04209 2.40498 5.021 2.36279 4.95771 2.38389C4.91551 2.38389 4.85222 2.44718 4.83112 2.48937C4.78893 2.53157 4.78893 2.59486 4.74673 2.63705C4.70454 2.70034 4.68344 2.74254 4.64125 2.80583C4.57796 2.91131 4.51466 3.0168 4.45137 3.12229C4.40918 3.18558 4.36698 3.29106 4.30369 3.35435C4.28259 3.39655 4.2193 3.41765 4.17711 3.43874C4.07162 3.50204 3.96614 3.58642 3.86065 3.64972C3.67078 3.7974 3.4809 3.96617 3.29103 4.11385C3.14335 4.21934 2.93238 4.28263 2.7636 4.36702C2.65811 4.40921 2.55263 4.45141 2.44714 4.4936C2.40495 4.5147 2.34166 4.5147 2.32056 4.55689C2.27837 4.59909 2.25727 4.64128 2.23617 4.70457C2.15178 4.81006 2.0463 4.93664 1.983 5.06322C1.94081 5.14761 1.91971 5.21091 1.87752 5.29529C1.83532 5.40078 1.77203 5.50627 1.75093 5.63285C1.66654 5.86492 1.66654 6.11808 1.56106 6.35015C1.51886 6.47674 1.43447 6.60332 1.37118 6.7299C1.2657 6.94087 1.2446 7.19404 1.2235 7.42611C1.2024 7.55269 1.2235 7.72147 1.24459 7.84805C1.26569 7.99573 1.26569 8.14341 1.26569 8.29109C1.26569 8.43877 1.1602 8.60755 1.07581 8.71303C0.991425 8.81852 0.843745 8.86071 0.738259 8.9662C0.65387 9.05059 0.548384 9.13498 0.506189 9.26156C0.485092 9.30375 0.506189 9.36705 0.506189 9.43034C0.485091 9.55692 0.442897 9.66241 0.442896 9.78899C0.421798 9.93667 0.421798 10.0844 0.421797 10.2531C0.421797 10.3375 0.421797 10.4008 0.421796 10.4852C0.421796 10.5696 0.442892 10.6329 0.463989 10.6962C0.463989 10.7384 0.463988 10.8017 0.463988 10.8438C0.463988 10.9071 0.506182 10.9704 0.506182 11.0126C0.548375 11.1603 0.569472 11.2869 0.590569 11.4346C0.611665 11.5612 0.674956 11.6877 0.696053 11.8143C0.759343 11.9831 0.780439 12.1519 0.822633 12.3417C0.843729 12.4683 0.843729 12.616 0.864825 12.7426C0.885922 12.8481 0.907019 12.9536 0.907018 13.059C0.907017 13.2278 0.864822 13.3755 0.864822 13.5443C0.86482 13.8185 0.970305 14.0928 1.03359 14.3671C1.05469 14.4515 1.07579 14.5148 1.09688 14.5991C0.400687 13.2489 0.020946 11.7088 0.020953 10.0843C0.0209616 8.10122 0.590591 6.26576 1.58216 4.72567C2.00411 4.07166 2.48934 3.45984 3.05897 2.93241C4.85223 1.18135 7.32059 0.105392 10.021 0.105392C10.232 0.105392 10.4641 0.105392 10.675 0.126489C11.983 0.126489 13.2489 0.464044 14.3881 1.01257Z"
                fill="url(#paint14_linear_3895_1515)"
            />
            <path
                opacity="0.3"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M13.5234 17.616C13.7133 17.4894 13.9032 17.3839 14.1142 17.2573C14.3251 17.1308 14.5361 17.0675 14.7682 16.962C14.9369 16.8987 14.958 16.8987 15.0846 17.0042C15.2112 17.1097 15.3589 17.1308 15.5066 17.1308C15.7175 17.1308 15.9496 17.1519 15.9707 17.4261C15.9918 17.8059 15.4433 18.1223 15.169 18.27C14.958 18.3966 14.726 18.481 14.4939 18.5865C14.304 18.6709 14.093 18.7763 13.8821 18.7974C13.6922 18.8185 13.5867 18.7341 13.4601 18.6076C13.3125 18.4388 13.3336 18.2911 13.3336 18.1012C13.3336 17.8481 13.3336 17.6793 13.5234 17.616Z"
                fill="url(#paint15_linear_3895_1515)"
            />
            <path
                opacity="0.3"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.4981 3.62858C16.6458 3.92394 16.7513 4.32479 16.9834 4.57795C17.11 4.70454 17.1943 4.72563 17.3631 4.72563C17.4475 4.72563 17.5952 4.74673 17.6796 4.72563C17.7851 4.68344 17.7851 4.55686 17.7851 4.45137C17.764 4.05053 17.5108 3.69187 17.2576 3.41761C17.0889 3.22774 16.8357 3.01676 16.5614 3.05896C16.477 3.24883 16.456 3.43871 16.4981 3.62858Z"
                fill="url(#paint16_linear_3895_1515)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.9918 19.3671C10.9707 19.4093 10.9285 19.4304 10.9496 19.4726C10.9707 19.4937 11.0129 19.5148 11.034 19.5148C11.0762 19.5359 11.1606 19.5148 11.2028 19.4937C11.245 19.4726 11.2239 19.4304 11.2028 19.3882C11.1606 19.3249 11.0973 19.3038 11.034 19.346L10.9918 19.3671Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.45114 2.59488C4.34565 2.63707 4.30346 2.63707 4.19797 2.72146C4.11358 2.78475 4.02919 2.84804 3.94481 2.93243C3.83932 3.03792 3.79713 3.14341 3.77603 3.24889C3.73383 3.35438 3.71273 3.48096 3.75493 3.54425C3.77603 3.56535 3.83932 3.56535 3.90261 3.56535C3.987 3.54425 4.07139 3.48096 4.15577 3.43877C4.26126 3.37547 4.34565 3.26999 4.43004 3.1645C4.49333 3.08011 4.51443 2.99573 4.55662 2.91134C4.57772 2.84805 4.59882 2.80585 4.61991 2.76366C4.64101 2.72146 4.64101 2.67927 4.61991 2.65817C4.59882 2.59488 4.57772 2.59488 4.45114 2.59488Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.63292 2.40488C5.59073 2.44707 5.50634 2.51037 5.56963 2.55256C5.59073 2.57366 5.61183 2.55256 5.63292 2.57366C5.65402 2.57366 5.65402 2.59476 5.67512 2.57366C5.73841 2.57366 5.71731 2.38378 5.63292 2.40488Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.94971 3.03794C5.9708 3.01685 6.013 3.01685 6.0341 3.01685C6.0341 3.05904 6.07629 3.12233 6.013 3.16453C5.9708 3.18562 5.9919 3.10123 5.9708 3.10123L5.94971 3.03794Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M6.56103 3.0378C6.62433 3.0589 6.66652 3.08 6.72981 3.10109C6.75091 3.08 6.772 3.08 6.7931 3.08C6.8142 3.0589 6.8353 3.01671 6.85639 2.99561C6.87749 2.95341 6.85639 2.91122 6.8353 2.86903C6.8142 2.84793 6.8142 2.80573 6.7931 2.78464C6.77201 2.76354 6.70871 2.76354 6.68762 2.78464C6.64542 2.80573 6.62433 2.82683 6.60323 2.86903C6.58213 2.89012 6.56103 2.95341 6.56103 2.97451C6.56103 3.01671 6.58213 3.0589 6.62433 3.08L6.56103 3.0378Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.06738 14.5991C7.13067 14.6202 7.17287 14.6413 7.23616 14.6624C7.25725 14.6413 7.27835 14.6413 7.29945 14.6413C7.32055 14.6202 7.34164 14.578 7.36274 14.5569C7.38384 14.5147 7.36274 14.4725 7.34164 14.4303C7.32055 14.4092 7.32055 14.367 7.29945 14.3459C7.27835 14.3248 7.21506 14.3248 7.19396 14.3459C7.15177 14.367 7.13067 14.3881 7.10958 14.4303C7.08848 14.4514 7.06738 14.5147 7.06738 14.5358C7.06738 14.578 7.08848 14.6202 7.13067 14.6413L7.06738 14.5991Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.93683 3.58636C4.91573 3.60746 4.89463 3.62855 4.87353 3.64965C4.89463 3.67075 4.91573 3.71294 4.95792 3.71294C4.97902 3.71294 5.00012 3.71294 5.00012 3.71294C5.02121 3.69185 5.00012 3.67075 5.02121 3.67075C5.04231 3.62855 5.04231 3.62855 5.02121 3.58636C5.00012 3.56526 5.00012 3.56526 4.97902 3.56526C4.95792 3.56526 4.93683 3.56526 4.91573 3.58636L4.93683 3.58636Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.06319 4.49348C5.06319 4.49348 5.02099 4.62007 5.06319 4.57787C5.10538 4.55678 5.10538 4.51458 5.06319 4.49348C5.08428 4.49348 5.08428 4.49348 5.06319 4.49348Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.24054 6.01253C4.19834 6.05473 4.19834 6.07583 4.17725 6.13912C4.19834 6.16021 4.21944 6.16021 4.24054 6.16021C4.28273 6.16021 4.28273 6.13912 4.28273 6.11802C4.28273 6.09692 4.30383 6.07583 4.28273 6.05473C4.28273 6.01253 4.26164 5.99144 4.24054 6.01253Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.50635 3.69194C5.52744 3.71304 5.54854 3.73414 5.54854 3.75524C5.52744 3.75524 5.50635 3.73414 5.50635 3.71304C5.50635 3.67085 5.50635 3.69194 5.52744 3.64975L5.50635 3.69194Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.21124 2.51039C5.19014 2.53149 5.16905 2.55258 5.14795 2.57368C5.16905 2.59478 5.14795 2.61587 5.19014 2.61587C5.21124 2.61587 5.23234 2.59478 5.25343 2.57368C5.27453 2.55258 5.27453 2.53149 5.27453 2.51039C5.27453 2.48929 5.27453 2.4471 5.25343 2.48929L5.21124 2.51039Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M9.05078 1.89854C9.05078 1.87744 9.07188 1.83525 9.07188 1.81415L9.09297 1.79306C9.11407 1.77196 9.11407 1.77196 9.13517 1.77196C9.15627 1.77196 9.17736 1.77196 9.21956 1.79306C9.30394 1.85635 9.09297 1.91964 9.07188 1.85635L9.05078 1.89854Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M9.76808 2.17276C9.74699 2.21495 9.72589 2.27824 9.76808 2.32044C9.81028 2.34154 9.89467 2.29934 9.91576 2.27825C9.97905 2.23605 10.0423 2.13057 9.97905 2.06727C9.95796 2.02508 9.85247 2.00398 9.81028 2.00398C9.70479 2.00398 9.68369 2.13057 9.6626 2.23605L9.76808 2.17276Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.0846 1.18126C10.0635 1.09687 10.0635 1.01248 10.1268 0.970284C10.169 0.949187 10.2323 0.928089 10.2744 0.970284C10.2955 0.991381 10.3166 1.03358 10.3377 1.05467C10.3588 1.09687 10.3588 1.09687 10.3377 1.13906C10.3166 1.22345 10.2955 1.28674 10.1901 1.28674C10.0635 1.28674 10.0635 1.20235 10.0635 1.07577L10.0635 1.18126L10.0846 1.18126Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.1606 2.65804C11.2239 2.63694 11.2872 2.61584 11.3294 2.55255C11.2872 2.53145 11.1817 2.46816 11.1606 2.55255L11.1606 2.65804Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.44726 15.9493C7.51056 15.9282 7.57385 15.9071 7.61604 15.8438C7.57385 15.8227 7.46836 15.7594 7.44727 15.8438L7.44726 15.9493Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14.3037 17.3839C14.367 17.3628 14.4303 17.3417 14.4725 17.2784C14.4303 17.2573 14.3248 17.194 14.3037 17.2784L14.3037 17.3839Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.9833 3.94504C12.0466 3.86066 12.131 3.73407 12.2576 3.79736C12.3209 3.83956 12.342 3.96614 12.2787 4.00834C12.2154 4.05053 12.1732 4.07163 12.0888 4.09272C12.0466 4.11382 11.9622 4.07163 11.9833 3.98724L11.9833 3.94504V3.94504Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.53214 5.78039C7.59543 5.696 7.67982 5.56941 7.8064 5.63271C7.86969 5.6749 7.89079 5.80148 7.8275 5.84368C7.76421 5.88587 7.72201 5.90697 7.63762 5.92807C7.59543 5.94916 7.51104 5.90697 7.53214 5.82258L7.53214 5.78039V5.78039Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14.9159 2.51035C14.9792 2.42596 15.0636 2.29938 15.1902 2.36267C15.2535 2.40487 15.2746 2.53145 15.2113 2.57364C15.148 2.61584 15.1058 2.63694 15.0214 2.65803C14.9792 2.67913 14.8948 2.63693 14.9159 2.55255L14.9159 2.51035V2.51035Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.7807 9.32465C10.844 9.24026 10.9284 9.11368 11.0549 9.17697C11.1182 9.21917 11.1393 9.34575 11.076 9.38794C11.0127 9.43014 10.9705 9.45124 10.8862 9.47233C10.844 9.49343 10.7596 9.45124 10.7807 9.36685L10.7807 9.32465V9.32465Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.17299 3.01672C7.0886 3.05892 6.96201 3.12221 6.94092 3.24879C6.94092 3.31208 6.96201 3.35428 7.0253 3.37537C7.0675 3.39647 7.15189 3.39647 7.21518 3.37537C7.29957 3.33318 7.38395 3.26989 7.40505 3.2066C7.42615 3.14331 7.42615 3.10111 7.40505 3.05892C7.38396 3.03782 7.36286 2.99563 7.32066 2.97453C7.21518 2.93233 7.15189 3.03782 7.0675 3.08001L7.17299 3.01672Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.42619 2.72133C7.46838 2.74243 7.51057 2.76352 7.53167 2.80572C7.48948 2.82682 7.44728 2.84791 7.40509 2.84791C7.3418 2.82682 7.3418 2.76352 7.3418 2.72133C7.3418 2.70023 7.40509 2.63694 7.42619 2.65804C7.44728 2.65804 7.44728 2.67914 7.44728 2.70023C7.46838 2.72133 7.46838 2.72133 7.44728 2.76353L7.42619 2.76353L7.42619 2.72133Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M2.97488 4.57791C2.89049 4.6623 2.80611 4.74669 2.76391 4.85217C2.74281 4.91546 2.78501 4.91546 2.8272 4.89437C2.93269 4.87327 3.01708 4.85217 3.12256 4.83107C3.18585 4.80998 3.27024 4.78888 3.29134 4.74669C3.31244 4.70449 3.33353 4.6412 3.33353 4.59901C3.33353 4.53571 3.27024 4.51462 3.22805 4.49352C3.10147 4.45133 2.91159 4.53571 2.8694 4.6623L2.97488 4.57791Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3.0378 5.02096C3.10109 5.02096 3.16438 5.04205 3.22767 5.06315C3.20657 5.08425 3.20657 5.10534 3.20657 5.12644C3.18547 5.16864 3.16438 5.18973 3.12218 5.21083C3.05889 5.25302 2.9745 5.25302 2.91121 5.23193C2.72134 5.16864 3.0167 4.95766 3.05889 5.02096L3.0378 5.02096Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M8.7553 1.01248C8.8186 0.970289 8.88189 0.949192 8.94518 0.928095C9.02957 0.906997 9.11395 0.906998 9.19834 0.906998C9.24054 0.906998 9.34602 0.906998 9.30383 0.970289C9.28273 1.05468 9.11395 1.11797 9.05066 1.13907C8.94518 1.18126 8.83969 1.24455 8.71311 1.26565C8.64982 1.26565 8.54433 1.28675 8.50214 1.22346C8.48104 1.16016 8.48104 1.11797 8.52324 1.07577C8.54433 1.03358 8.58653 1.01248 8.64982 0.991387C8.67092 0.991387 8.81859 0.949192 8.81859 0.991387L8.7553 1.01248Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.63744 1.03358C7.61634 1.05468 7.38428 1.18126 7.48976 1.24456C7.55305 1.26565 7.65854 1.26565 7.72183 1.24456C7.76402 1.22346 7.82732 1.18127 7.78512 1.11797C7.72183 0.991391 7.55305 1.07578 7.46867 1.11797L7.63744 1.03358Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.49365 9.30365C4.51475 9.38804 4.53585 9.49352 4.62023 9.55681C4.70462 9.62011 4.81011 9.59901 4.8734 9.53572C4.93669 9.49352 4.99998 9.45133 5.04218 9.43023C5.08437 9.40913 5.10547 9.40913 5.10547 9.34584C5.10547 9.28255 5.06327 9.21926 5.02108 9.17706C4.97888 9.13487 4.91559 9.07158 4.8523 9.05048C4.72572 9.00829 4.49365 9.05048 4.49365 9.21926L4.49365 9.30365Z"
                fill="#FFD32F"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.6665 9.40921C11.6876 9.4936 11.7087 9.59908 11.7931 9.66237C11.8775 9.72567 11.983 9.70457 12.0462 9.64128C12.1095 9.59908 12.1728 9.55689 12.215 9.53579C12.2572 9.51469 12.2783 9.51469 12.2783 9.4514C12.2783 9.38811 12.2361 9.32482 12.1939 9.28262C12.1517 9.24043 12.0884 9.17714 12.0252 9.15604C11.8986 9.11385 11.6665 9.15604 11.6665 9.32482L11.6665 9.40921Z"
                fill="#FFBA00"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M1.4554 13.0169C1.4554 13.0169 1.37101 13.3755 1.62417 13.8397C1.87733 14.3038 2.06721 14.2616 2.06721 14.2616C2.06721 14.2616 1.83514 13.4177 1.4554 13.0169Z"
                fill="#FFFF59"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.7638 8.10121C17.7638 8.10121 17.4685 8.9451 17.4263 9.07168C17.4263 9.05058 17.8904 8.924 17.7638 8.10121Z"
                fill="#FFFF59"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.3462 8.35432C19.3462 8.35432 19.1353 8.502 19.0298 8.90285C19.0298 8.90285 19.2829 9.02943 19.3462 8.35432Z"
                fill="#FFFF59"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.1177 16.2025C16.1177 16.2025 17.067 15.5907 17.6156 15.5485C17.6156 15.5485 16.9827 16.308 16.1177 16.2025Z"
                fill="#FFFF59"
            />
            <defs>
                <radialGradient
                    id="paint0_radial_3895_1515"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(3.82108 5.33226) scale(16.0553 16.0554)"
                >
                    <stop offset="0.00558659" stopColor="#FFB80B" />
                    <stop offset="0.258" stopColor="#FFB60C" />
                    <stop offset="0.384" stopColor="#FEAE10" />
                    <stop offset="0.4821" stopColor="#FCA117" />
                    <stop offset="0.5656" stopColor="#FA8E21" />
                    <stop offset="0.6392" stopColor="#F7762E" />
                    <stop offset="0.662" stopColor="#F66D33" />
                    <stop offset="0.7209" stopColor="#EF6836" />
                    <stop offset="0.8061" stopColor="#DC593D" />
                    <stop offset="0.9068" stopColor="#BD4049" />
                    <stop offset="0.9832" stopColor="#A02A54" />
                </radialGradient>
                <linearGradient
                    id="paint1_linear_3895_1515"
                    x1="0.853604"
                    y1="12.9473"
                    x2="5.69302"
                    y2="12.9473"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint2_linear_3895_1515"
                    x1="1.02403"
                    y1="12.9473"
                    x2="5.4371"
                    y2="12.9473"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint3_linear_3895_1515"
                    x1="1.5088"
                    y1="7.17199"
                    x2="3.43567"
                    y2="7.11089"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint4_linear_3895_1515"
                    x1="1.62777"
                    y1="7.16822"
                    x2="3.31308"
                    y2="7.11477"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint5_linear_3895_1515"
                    x1="17.4317"
                    y1="16.3751"
                    x2="17.4317"
                    y2="9.51867"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FF8E0B" />
                    <stop offset="0.3475" stopColor="#FD8B0D" />
                    <stop offset="0.5941" stopColor="#F98215" />
                    <stop offset="0.8113" stopColor="#F17221" />
                    <stop offset="1" stopColor="#E65D31" />
                </linearGradient>
                <linearGradient
                    id="paint6_linear_3895_1515"
                    x1="15.4121"
                    y1="12.9468"
                    x2="19.4476"
                    y2="12.9468"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint7_linear_3895_1515"
                    x1="18.7225"
                    y1="9.35888"
                    x2="18.7225"
                    y2="6.71269"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint8_linear_3895_1515"
                    x1="18.7211"
                    y1="9.18543"
                    x2="18.7211"
                    y2="6.8861"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint9_linear_3895_1515"
                    x1="10.5011"
                    y1="19.8742"
                    x2="10.5011"
                    y2="18.3326"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint10_linear_3895_1515"
                    x1="10.5004"
                    y1="19.7008"
                    x2="10.5004"
                    y2="18.506"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint11_linear_3895_1515"
                    x1="15.3341"
                    y1="10.1499"
                    x2="16.1988"
                    y2="3.63659"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint12_linear_3895_1515"
                    x1="15.3561"
                    y1="9.97803"
                    x2="16.1752"
                    y2="3.80818"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint13_linear_3895_1515"
                    x1="0.0165842"
                    y1="9.31129"
                    x2="15.3889"
                    y2="9.31136"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#F67C27" />
                    <stop offset="0.8891" stopColor="#ED6930" />
                    <stop offset="1" stopColor="#E76332" />
                </linearGradient>
                <linearGradient
                    id="paint14_linear_3895_1515"
                    x1="0.0164082"
                    y1="7.26467"
                    x2="14.394"
                    y2="7.26473"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint15_linear_3895_1515"
                    x1="13.3406"
                    y1="17.8577"
                    x2="15.977"
                    y2="17.8577"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint16_linear_3895_1515"
                    x1="16.471"
                    y1="3.90324"
                    x2="17.7686"
                    y2="3.90325"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
            </defs>
        </svg>
    );
};

export default Planet3;
