import React from "react";

type Props = {};

export const PlanetGreen = (props: Props) => {
    return (
        <svg
            width="71"
            height="70"
            viewBox="0 0 71 70"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M70.015 34.9846C70.015 35.3306 70.0073 35.6843 69.9996 36.0303C69.9304 38.2293 69.669 40.3822 69.2153 42.4583C68.7386 44.6496 68.0543 46.7718 67.1855 48.7939C66.6242 50.1164 65.9783 51.4005 65.2556 52.6307C63.5948 55.4679 61.5495 58.0514 59.189 60.312C56.544 62.8339 53.5069 64.9484 50.1776 66.5554C45.5873 68.7621 40.4511 70 35.0151 70C19.914 70 7.05048 60.4427 2.14496 47.0486C1.93736 46.4873 1.74513 45.9106 1.56829 45.3339C0.599486 42.1892 0.0535813 38.8522 0.0151367 35.3921C0.0151367 35.2614 0.0151367 35.123 0.0151367 34.9923C0.0151367 32.9624 0.191984 30.9787 0.522608 29.0488C0.676386 28.1415 0.868601 27.2496 1.09158 26.3653C1.42989 25.0275 1.84511 23.728 2.32951 22.4594C3.87498 18.4304 6.1509 14.7551 8.98811 11.6026C10.5566 9.85721 12.302 8.2656 14.1935 6.86621C16.1926 5.38225 18.3609 4.10589 20.6522 3.07557C23.6508 1.72232 26.8802 0.784271 30.2556 0.322935C31.8165 0.107645 33.4081 0 35.0228 0C43.2499 0 50.8158 2.83721 56.7901 7.58897C59.6657 9.87258 62.1723 12.6022 64.2099 15.6777C66.109 18.538 67.6007 21.6982 68.5925 25.0659C69.5075 28.1492 69.9996 31.4016 70.0227 34.7693C70.015 34.8232 70.015 34.9077 70.015 34.9846Z"
                fill="url(#paint0_radial_2824_1447)"
            />
            <path
                d="M42.2121 54.5454C40.9742 57.2212 37.2681 57.2212 33.3545 60.7196C29.4408 64.2181 23.8818 61.5423 22.8514 59.4817C21.8211 57.4211 27.7954 55.7756 29.4408 54.7453C31.0863 53.715 32.3242 48.1559 24.0893 50.0089C15.8545 51.862 14.0015 52.0696 8.64233 48.3635C5.85125 46.4336 3.62147 46.5182 2.12982 47.0333C0.791949 43.3965 0.0461335 39.4674 0 35.3769C2.16827 34.8925 5.22845 34.8925 9.26513 36.4226C18.5303 39.9211 19.9758 36.4226 29.4485 36.4226C38.9213 36.4226 40.3591 41.159 40.1592 46.7181C39.9516 52.2849 43.45 51.8697 42.2121 54.5454Z"
                fill="url(#paint1_linear_2824_1447)"
            />
            <path
                d="M70.0152 34.7462C65.3172 33.6236 60.1733 36.853 60.3425 43.2194C60.5501 51.0467 57.2515 50.224 55.6061 54.7528C54.7373 57.1364 56.8902 59.0048 59.1892 60.3042C56.5442 62.8262 53.507 64.9406 50.1778 66.5476C45.8028 62.8569 46.9561 58.1974 51.0774 52.2846C55.8137 45.4876 50.4623 42.6043 53.7531 32.724C56.0598 25.804 64.0255 24.9428 68.585 25.0428C69.4923 28.1183 69.9921 31.3784 70.0152 34.7462Z"
                fill="url(#paint2_linear_2824_1447)"
            />
            <path
                d="M69.2152 42.4584C68.4233 46.0876 67.07 49.5092 65.2477 52.6232C63.9714 46.7642 67.07 43.7809 69.2152 42.4584Z"
                fill="url(#paint3_linear_2824_1447)"
            />
            <path
                d="M64.1949 15.6546C59.6738 17.9151 54.0455 18.4226 49.6244 15.4239C43.8577 11.5102 42.0047 8.4193 31.5016 8.21939C25.412 8.09636 22.2288 5.35142 20.6372 3.06012C23.6359 1.70686 26.8652 0.768816 30.2407 0.30748C31.2325 2.38349 33.1932 4.43643 37.0684 3.89821C44.4805 2.86789 44.4805 2.86789 50.2472 6.98916C52.3924 8.52695 54.7145 8.37317 56.7751 7.58121C59.6507 9.85713 62.1573 12.5867 64.1949 15.6546Z"
                fill="url(#paint4_linear_2824_1447)"
            />
            <path
                d="M13.8014 14.186C14.4165 22.0133 11.3333 24.2739 5.15141 26.5421C3.33683 27.2111 1.79137 28.103 0.507324 29.041C0.899459 26.7651 1.50686 24.5584 2.3142 22.4516C2.94469 22.1517 3.62131 21.8673 4.32869 21.6058C8.24235 20.168 9.44951 18.3996 9.06506 13.371C9.01893 12.7943 8.98818 12.2023 8.9728 11.5948C10.5413 9.84946 12.2867 8.25785 14.1782 6.85847C13.7938 8.6423 13.5554 11.072 13.8014 14.186Z"
                fill="url(#paint5_linear_2824_1447)"
            />
            <path
                d="M30.2711 26.542C28.2028 24.4737 19.5605 26.542 17.915 23.0435C16.2696 19.5451 18.9453 15.839 23.6817 16.0389C28.4181 16.2465 32.5394 13.7707 35.0075 17.4768C37.4756 21.1828 44.8877 20.5677 46.5409 24.2738C47.9018 27.334 46.3409 32.4855 39.1287 31.6859C33.5697 31.0708 32.9469 29.2177 30.2711 26.542Z"
                fill="url(#paint6_linear_2824_1447)"
            />
            <g opacity="0.5">
                <path
                    d="M48.3943 35.1924C47.9638 33.8007 47.1564 35.1924 44.2731 35.6076C41.3897 36.0228 42.2124 38.491 43.8579 39.5213C45.511 40.5439 49.4247 38.4833 48.3943 35.1924Z"
                    fill="#146072"
                />
                <path
                    d="M19.1533 30.0407C20.1298 27.7648 17.0927 27.9801 15.032 27.1574C12.9714 26.3347 11.9411 27.7725 10.7109 30.0407C9.47294 32.309 11.5336 33.5392 14.2093 32.309C16.885 31.071 18.5382 31.4862 19.1533 30.0407Z"
                    fill="#146072"
                />
                <path
                    d="M21.214 30.4561C20.8373 29.6949 18.7459 31.4865 19.361 31.6941C19.9761 31.9017 21.8291 31.6941 21.214 30.4561Z"
                    fill="#146072"
                />
                <path
                    d="M54.1612 20.7756C52.7926 20.9448 51.8929 21.3907 52.1005 22.421C52.3081 23.4514 56.6293 23.2438 57.2521 22.8362C57.8672 22.421 55.8066 20.568 54.1612 20.7756Z"
                    fill="#146072"
                />
                <path
                    d="M39.952 13.571C39.2984 12.2716 37.6838 13.9862 36.8611 14.1862C36.0383 14.3938 36.0383 15.8316 38.2989 16.2468C40.5671 16.662 40.3595 14.3938 39.952 13.571Z"
                    fill="#146072"
                />
                <path
                    d="M17.9153 6.15903C16.4775 6.58961 15.6471 7.18935 16.885 7.80446C18.1229 8.41958 18.9456 9.65749 19.3532 8.21967C19.7684 6.77415 19.976 5.53623 17.9153 6.15903Z"
                    fill="#146072"
                />
                <path
                    d="M42.8353 40.1364C42.2202 40.0825 42.4202 41.5742 43.2506 41.7818C44.081 41.9894 45.0959 40.3363 42.8353 40.1364Z"
                    fill="#146072"
                />
                <path
                    d="M47.364 46.9256C46.4721 47.1486 45.0958 48.7786 45.7186 49.3937C46.3337 50.0089 47.364 49.3937 48.1868 49.3937C49.0095 49.4014 48.1868 46.7257 47.364 46.9256Z"
                    fill="#146072"
                />
                <path
                    d="M39.9521 62.3723C38.5373 62.726 36.4536 63.6102 36.4536 64.6405C36.4536 65.6708 38.3066 65.0557 40.7748 65.6708C43.2429 66.2859 45.9263 65.0557 44.896 62.38C43.8657 59.6965 41.5975 61.9571 39.9521 62.3723Z"
                    fill="#115560"
                />
                <path
                    d="M14.832 57.4287C14.0862 58.1745 13.1866 58.8665 14.0093 59.6969C14.832 60.5196 16.2775 59.4893 17.5078 59.6969C18.7457 59.9045 19.776 58.6666 19.1532 57.0212C18.5381 55.3681 16.0622 56.1908 14.832 57.4287Z"
                    fill="#115560"
                />
                <path
                    d="M19.1535 54.9607C18.8306 54.6377 18.1232 55.1683 18.7383 55.5758C19.3611 55.991 20.1838 55.991 19.1535 54.9607Z"
                    fill="#146072"
                />
                <path
                    d="M50.4548 27.9879C49.7781 27.4805 48.8093 29.0182 49.632 29.4258C50.4548 29.8333 51.2775 28.603 50.4548 27.9879Z"
                    fill="#146072"
                />
                <path
                    d="M27.5959 10.4803C27.1038 9.48839 25.9505 10.2727 25.7429 11.303C25.5353 12.3333 28.0111 11.303 27.5959 10.4803Z"
                    fill="#146072"
                />
                <path
                    d="M29.0411 10.0727C28.6259 10.0727 29.0411 11.5105 29.4563 11.3106C29.8638 11.103 30.0637 10.0727 29.0411 10.0727Z"
                    fill="#146072"
                />
                <path
                    d="M27.3883 65.6638C26.9731 65.6638 27.3883 67.1017 27.8035 66.9018C28.211 66.6942 28.4186 65.6638 27.3883 65.6638Z"
                    fill="#115560"
                />
            </g>
            <path
                opacity="0.35"
                d="M67.1855 48.7861C66.6242 50.1086 65.9783 51.3926 65.2556 52.6229C63.5948 55.4601 61.5495 58.0436 59.189 60.3041C56.544 62.8261 53.5069 64.9405 50.1776 66.5475C45.5873 68.7542 40.4511 69.9922 35.0151 69.9922C19.914 69.9922 7.05048 60.4348 2.14496 47.0407C1.93736 46.4794 1.74513 45.9027 1.56829 45.3261C0.599486 42.1813 0.0535813 38.8443 0.0151367 35.3843C0.0151367 35.2536 0.0151367 35.1152 0.0151367 34.9845C0.0151367 32.9546 0.191985 30.9708 0.522608 29.0409C0.676386 28.1336 0.868601 27.2417 1.09158 26.3575C5.65879 37.4372 16.2234 54.5682 38.2136 56.0906C40.0974 56.2213 41.9197 56.252 43.6728 56.1905C53.4069 55.8522 61.1727 52.7459 67.1855 48.7861Z"
                fill="url(#paint7_linear_2824_1447)"
            />
            <path
                opacity="0.5"
                d="M69.9997 36.0302C69.9305 38.2292 69.6691 40.3821 69.2154 42.4582C68.7387 44.6495 68.0544 46.7716 67.1855 48.7938C66.6242 50.1163 65.9784 51.4004 65.2556 52.6306C63.5948 55.4678 61.5496 58.0513 59.1891 60.3118C56.5441 62.8338 53.507 64.9483 50.1777 66.5553C45.5874 68.762 40.4512 69.9999 35.0151 69.9999C19.9141 69.9999 7.05055 60.4426 2.14503 47.0484C1.93743 46.4872 1.7452 45.9105 1.56836 45.3338C17.815 58.8586 32.1241 60.0274 43.6728 56.1983C55.8367 52.1539 64.9404 42.5581 69.9997 36.0302Z"
                fill="url(#paint8_linear_2824_1447)"
            />
            <defs>
                <radialGradient
                    id="paint0_radial_2824_1447"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(33.1553 14.6007) scale(48.8406 48.8407)"
                >
                    <stop stopColor="#83EF65" />
                    <stop offset="1" stopColor="#0C7293" />
                </radialGradient>
                <linearGradient
                    id="paint1_linear_2824_1447"
                    x1="17.9477"
                    y1="-6.05035"
                    x2="23.5337"
                    y2="80.1838"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#DBED4F" />
                    <stop offset="1" stopColor="#B9ED29" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint2_linear_2824_1447"
                    x1="55.0705"
                    y1="-8.45513"
                    x2="60.6565"
                    y2="77.7788"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#DBED4F" />
                    <stop offset="1" stopColor="#B9ED29" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint3_linear_2824_1447"
                    x1="63.4947"
                    y1="-9.00049"
                    x2="69.0808"
                    y2="77.2335"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#DBED4F" />
                    <stop offset="1" stopColor="#B9ED29" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint4_linear_2824_1447"
                    x1="41.3226"
                    y1="-7.56452"
                    x2="46.9086"
                    y2="78.6696"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#DBED4F" />
                    <stop offset="1" stopColor="#B9ED29" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint5_linear_2824_1447"
                    x1="5.83951"
                    y1="-5.26598"
                    x2="11.4255"
                    y2="80.9678"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#DBED4F" />
                    <stop offset="1" stopColor="#B9ED29" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint6_linear_2824_1447"
                    x1="30.231"
                    y1="-6.84618"
                    x2="35.817"
                    y2="79.3878"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#DBED4F" />
                    <stop offset="1" stopColor="#B9ED29" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint7_linear_2824_1447"
                    x1="14.4296"
                    y1="67.3562"
                    x2="35.0577"
                    y2="36.7432"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#CC622E" />
                    <stop offset="1" stopColor="#CC622E" stopOpacity="0.2" />
                </linearGradient>
                <linearGradient
                    id="paint8_linear_2824_1447"
                    x1="51.0165"
                    y1="76.5192"
                    x2="35.0976"
                    y2="39.3286"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#11727F" />
                    <stop offset="1" stopColor="#11727F" stopOpacity="0.2" />
                </linearGradient>
            </defs>
        </svg>
    );
};

export const PlanetOrange = (props: Props) => {
    return (
        <svg
            width="71"
            height="71"
            viewBox="0 0 71 71"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M70.8007 35.8007C70.8007 45.9168 66.5179 54.9992 59.6508 61.4232C56.4018 64.4507 52.4883 66.8874 48.2056 68.5119C44.3659 69.9887 40.1571 70.8009 35.8005 70.8009C34.2499 70.8009 32.6993 70.7271 31.2225 70.5056C24.503 69.6195 18.3005 66.8135 13.3533 62.6047C9.73514 59.5772 6.70772 55.8114 4.56639 51.6025C3.23728 48.9443 2.20354 46.0645 1.539 43.0371C1.02213 40.6742 0.80062 38.3113 0.80063 35.8007C0.80066 28.8598 2.79436 22.4357 6.26485 17.0454C7.74166 14.7563 9.43998 12.615 11.4337 10.769C17.7101 4.64027 26.3493 0.874428 35.8008 0.874428C36.5392 0.874428 37.3515 0.87443 38.0899 0.94827C42.0772 1.16979 45.843 2.12971 49.3873 3.60651C49.978 3.82803 50.5688 4.12339 51.1595 4.41875C54.5561 6.04323 57.6574 8.25843 60.3156 10.9167C66.8134 17.1931 70.8008 26.0539 70.8007 35.8007Z"
                fill="url(#paint0_radial_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.3406 58.9866C14.387 58.9866 8.99672 54.7039 6.41236 49.2397C3.23728 42.3726 3.16347 35.1363 4.71411 33.8072C5.15715 33.438 5.74787 33.2165 6.48626 33.2165C6.9293 33.2165 7.52002 33.2903 8.0369 33.438C11.7289 34.5456 16.8976 39.6405 19.1128 44.8093C21.2541 49.8305 20.6634 53.8178 19.9988 56.2545C19.5558 58.5436 18.3005 58.9866 17.3406 58.9866Z"
                fill="url(#paint1_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.5558 56.1067C19.1866 57.5097 18.5221 58.3957 17.3406 58.3957C14.8301 58.3957 9.51364 54.4084 7.00311 48.9442C3.75419 42.0771 3.97574 35.2838 5.15718 34.2501C5.7479 33.7332 6.78166 33.6593 7.96309 34.0285C11.7289 35.1361 17.4146 39.9357 18.596 44.9569C19.7035 49.1657 20.2204 53.5961 19.5558 56.1067Z"
                fill="url(#paint2_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.44631 30.9274C7.07711 30.9274 6.70791 30.7797 6.48639 30.4844C5.52648 29.3768 6.92945 25.4633 7.52017 24.0603C8.4801 21.8451 9.51386 20.6637 10.3999 20.6637C10.7691 20.6637 11.0645 20.8113 11.3599 21.0329L11.5075 21.1805C12.5413 22.2143 13.0582 24.651 12.0982 26.5709C11.3598 27.9738 9.21846 30.4105 7.74166 30.7797C7.74166 30.9274 7.59399 30.9274 7.44631 30.9274Z"
                fill="url(#paint3_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.8762 26.4232C11.2117 27.7523 8.99646 30.189 7.66734 30.5582C7.29815 30.632 7.00278 30.632 6.85511 30.4105C5.89519 29.2291 8.70114 21.1805 10.621 21.1067C10.9163 21.1067 11.2117 21.2544 11.4332 21.4759C12.2454 22.2881 12.7623 24.5772 11.8762 26.4232Z"
                fill="url(#paint4_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M56.9188 58.1005C55.7374 58.1005 54.8513 57.6575 54.4821 56.7714C53.7437 55.1469 54.113 49.1659 56.4759 43.9232C59.9464 36.0962 64.8198 34.0287 66.8135 34.0287C66.9612 34.0287 67.1088 34.0287 67.1827 34.0287C67.2565 34.0287 67.3304 34.0287 67.4042 34.1025C67.9211 34.2502 68.4379 34.6932 68.7333 35.3578C70.1362 38.2376 69.324 45.3262 67.0349 50.2735C65.0412 54.9254 60.0939 58.1005 56.9188 58.1005Z"
                fill="url(#paint5_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M66.5917 50.1257C63.7858 56.1805 56.3279 59.208 55.0727 56.5497C54.4081 55.2206 54.7035 49.5349 57.0664 44.2185C60.6107 36.3176 65.4842 34.4716 67.1825 34.6931L67.2563 34.6931C69.693 35.3576 69.3238 44.1446 66.5917 50.1257Z"
                fill="url(#paint6_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M66.0747 33.5856C65.7793 33.5856 65.5578 33.5117 65.3363 33.3641C63.8595 32.478 62.8996 26.7923 63.9334 25.0201C64.2287 24.5033 64.5979 24.3556 64.8194 24.3556C64.8933 24.3556 65.041 24.3556 65.1886 24.3556C66.8131 24.3556 68.4376 26.2754 69.0283 28.786C69.3975 30.5581 68.6591 32.0349 67.773 32.7733C67.2561 33.2902 66.6654 33.5856 66.0747 33.5856Z"
                fill="url(#paint7_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M67.4037 32.3302C66.813 32.9209 66.1485 33.1424 65.7054 32.8471C64.524 32.1825 63.6379 26.866 64.524 25.3154C64.6717 25.0939 64.8194 24.9462 64.9671 24.9462C66.1485 24.7247 67.8468 26.2753 68.4375 28.9336C68.7329 30.3365 68.1421 31.5918 67.4037 32.3302Z"
                fill="url(#paint8_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M38.0154 70.3579C37.7939 70.3579 37.5724 70.3579 37.3509 70.3579C33.7327 70.284 31.0007 68.7334 30.5576 67.4043C30.41 66.8874 30.4838 66.3705 30.853 66.0751C31.9606 65.1152 36.6125 65.0414 37.5724 65.0414C40.5998 65.0414 44.2918 65.3367 44.5872 66.7397C44.661 67.1089 44.661 67.6258 44.0703 68.2903C43.2581 69.1026 42.1505 70.3579 38.0154 70.3579Z"
                fill="url(#paint9_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M43.6276 67.7735C42.7415 68.7334 41.7078 69.841 37.3512 69.7671C33.1424 69.6195 30.1888 67.4043 31.2225 66.5182C32.6255 65.3367 43.5538 65.2629 43.923 66.8874C44.0706 67.1089 43.9968 67.4781 43.6276 67.7735Z"
                fill="url(#paint10_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M54.9993 36.3181C52.6364 36.3181 50.8643 35.2105 49.9043 33.2168C47.6892 28.3434 47.6892 18.8918 49.3137 15.126C49.7567 14.1661 50.1998 13.5754 50.7905 13.3538C51.3812 13.1323 51.9719 12.9846 52.6365 12.9846C54.704 12.9846 56.8454 14.3876 58.839 16.972C62.088 21.2547 64.377 28.1957 63.4909 31.297C63.1955 32.2569 62.3833 33.3645 61.0541 34.2506C59.2081 35.5058 56.993 36.3181 54.9993 36.3181Z"
                fill="url(#paint11_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M62.8995 31.0749C62.678 31.961 61.8658 32.9209 60.6843 33.7331C57.6569 35.9483 52.3404 37.1298 50.4206 32.9947C48.2793 28.269 48.2793 19.039 49.83 15.347C50.1253 14.6086 50.5684 14.0917 51.0114 13.8702C57.5832 11.1381 64.1548 26.4968 62.8995 31.0749Z"
                fill="url(#paint12_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.5555 56.1068C16.1589 57.3621 10.8424 53.0794 8.11037 46.0646C5.67368 39.9359 7.5197 35.0624 8.03658 34.0287C11.8024 35.1363 17.488 39.9359 18.6695 44.957C19.7032 49.1659 20.2201 53.5963 19.5555 56.1068Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M43.6272 67.7734C36.3909 69.9886 31.2222 66.4443 31.2222 66.4443C32.6251 65.2629 43.5534 65.1891 43.9226 66.8135C44.0703 67.1089 43.9964 67.4781 43.6272 67.7734Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M65.4104 49.5349C60.4631 57.5835 54.9989 56.5497 54.9989 56.5497C54.3344 55.2206 54.6298 49.5349 56.9927 44.2185C60.537 36.3176 65.4104 34.4716 67.1087 34.6931L67.1826 34.6931C68.2163 37.7205 68.9547 43.7754 65.4104 49.5349Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M60.6843 33.7332C57.6569 35.9484 52.3404 37.1299 50.4206 32.9948C48.2793 28.2691 48.2793 19.0391 49.83 15.3471C51.1591 15.1994 53.7435 15.6424 56.6232 19.9251C60.7582 25.8323 62.0873 30.3366 60.6843 33.7332Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M67.4038 32.3303C66.813 32.921 66.1485 33.1425 65.7054 32.8472C64.524 32.1826 63.6379 26.8661 64.524 25.3155C65.4101 25.8324 66.8131 26.94 67.1822 28.9336C67.3299 30.1889 67.4038 31.3704 67.4038 32.3303Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.8763 26.4232C11.2118 27.7523 8.99656 30.189 7.66744 30.5582C7.74128 30.0413 8.77506 23.7649 11.3595 21.4759C12.2455 22.2881 12.7624 24.5772 11.8763 26.4232Z"
                fill="#FFFF45"
            />
            <path
                opacity="0.3"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M53.9653 44.0712C53.5961 44.8834 53.2269 45.6218 52.71 46.3602C52.2669 46.8771 51.7501 47.3202 51.4547 47.9109C50.3471 49.9784 50.5686 52.3413 49.9779 54.4826C49.6087 55.6641 48.7226 56.624 48.3534 57.8054C48.2057 58.3223 48.2795 58.8392 48.2795 59.4299C48.2795 60.0945 47.9103 60.5375 47.5411 61.0544C47.0981 61.6451 46.5074 62.0143 45.8428 62.3097C45.3259 62.5312 44.7352 62.4574 44.1445 62.4574C42.8892 62.4574 41.7078 62.3097 40.4525 61.9405C39.3449 61.6451 38.3112 61.1282 37.2036 60.759C36.4652 60.5375 35.8745 60.6114 35.1361 60.759C34.4715 60.9067 33.7331 60.8329 33.0685 60.8329C31.8871 60.8329 30.7795 61.4975 29.7458 62.0143C29.0074 62.3835 28.4905 62.8266 28.1951 63.6388C27.8259 64.5987 27.8259 65.4848 26.7183 65.854C26.0537 66.0755 25.2415 65.854 24.577 65.7063C23.9862 65.5587 23.3217 65.6325 22.731 65.6325C21.5495 65.6325 20.4419 65.2633 19.3343 64.7464C18.0791 64.0818 16.9715 63.1219 16.0116 62.162C15.4947 61.6451 14.7563 61.3498 14.2394 60.8329C13.501 60.1683 12.6888 59.5038 12.0242 58.8392C10.9166 57.7316 9.7352 56.624 8.55377 55.5902C7.6677 54.9257 6.9293 54.0396 6.19091 53.2274C5.60019 52.5628 5.231 51.6029 4.78796 50.7906C3.90189 49.24 3.1635 47.4678 2.72047 45.6957C2.2036 43.702 1.61289 41.5606 1.68674 39.4931C1.68675 37.721 1.46524 36.0965 1.46525 34.3243C1.31755 37.6471 1.46522 40.3792 1.83441 42.9636C1.31754 40.6007 1.09603 38.2378 1.09604 35.7273C1.09607 28.7863 3.08977 22.3622 6.56026 16.9719C8.03707 14.6829 9.73539 12.5415 11.7291 10.6955C18.0055 4.5668 26.6447 0.800957 36.0962 0.800957C36.8346 0.800957 37.6469 0.800956 38.3853 0.874796C42.3726 1.09632 46.1384 2.05624 49.6827 3.53304C50.5688 4.49296 51.4549 5.60056 52.1194 6.70816C52.4148 7.1512 52.5625 7.66808 52.8578 8.11112C53.0794 8.55416 53.3747 8.70184 53.3009 9.21872C53.227 9.51408 53.0793 9.88328 52.9317 10.1786C52.5625 11.1386 51.4549 11.8031 50.6426 12.32C49.4612 13.0584 48.1321 13.3538 46.8768 14.0183C46.0645 14.4614 45.843 14.8306 45.2523 15.4951C44.9569 15.8643 44.5877 16.0858 44.3662 16.455C43.7017 17.4888 43.3325 18.9656 43.4063 20.147C43.4801 22.5099 45.3261 24.2082 45.7691 26.4234C46.1383 28.3433 45.843 30.4108 46.5075 32.2568C47.1721 34.3982 49.018 36.0965 50.7902 37.3518C51.5286 37.8686 52.1931 38.3117 52.8577 38.9024C53.4484 39.4931 54.2607 39.7885 54.7037 40.5269C55.0729 41.7083 54.4083 42.9636 53.9653 44.0712Z"
                fill="url(#paint13_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M51.1594 4.3449C51.0117 4.3449 50.9379 4.3449 50.7902 4.41874C50.421 4.49258 50.0518 4.41874 49.6826 4.3449C49.3872 4.27106 49.2395 4.12338 48.8703 4.12338C48.4273 4.04954 48.0581 3.90186 47.6151 3.82802C47.172 3.75418 46.8028 3.6065 46.3598 3.45882C45.9906 3.31114 45.8429 3.38498 45.5476 3.45882C45.2522 3.53266 45.0307 3.38498 44.7353 3.31114C44.44 3.16346 44.0708 3.16346 43.7754 3.08962C42.8893 2.94194 42.0033 2.64658 41.1172 2.42506C40.6003 2.27738 40.0834 2.27738 39.4927 2.27738C39.0497 2.27738 38.6805 2.42506 38.2374 2.42506C37.9421 2.42506 37.7205 2.35122 37.4252 2.35122C37.1298 2.27738 36.8345 2.35122 36.5391 2.35122C36.0961 2.27738 35.8746 2.20354 35.4315 2.35122C35.0623 2.42506 34.8408 2.42506 34.4716 2.4989C34.1024 2.4989 33.6594 2.64658 33.2902 2.72042C32.6256 2.8681 31.8872 3.01578 31.2226 3.01578C30.7796 3.01578 30.1889 2.8681 29.8197 3.01578C29.5982 3.08962 29.4505 3.38498 29.229 3.53266C28.8598 3.90186 28.4906 4.19722 28.1952 4.56642C27.8998 4.93562 27.6045 5.37866 27.6045 5.89554C27.6045 6.33858 27.826 6.85546 28.0475 7.22466C28.269 7.6677 28.3429 8.0369 27.8998 8.33226C27.383 8.70146 26.7184 8.99682 26.1277 9.21834C25.6846 9.36602 25.3154 9.43986 25.0201 9.1445C24.8724 9.07066 24.7986 8.84914 24.6509 8.70146C24.5032 8.62762 24.2817 8.70146 24.134 8.7753C23.691 8.92298 23.2479 9.07066 22.8049 9.1445C22.5095 9.21834 22.288 9.36602 21.9926 9.36602C21.6973 9.43986 21.4758 9.21833 21.1066 9.29217C20.6635 9.36601 20.1467 9.58754 19.7036 9.58754C19.3344 9.58754 18.8914 9.43985 18.596 9.29217C18.4483 9.21833 18.3745 9.07066 18.153 9.1445C18.0053 9.1445 17.7838 9.36602 17.7099 9.5137C17.5623 9.66138 17.5623 9.88289 17.4146 10.0306C17.2669 10.2521 17.1931 10.3998 17.0454 10.6213C16.8239 10.9905 16.6023 11.3597 16.3808 11.7289C16.2331 11.9504 16.0855 12.3196 15.8639 12.5411C15.7901 12.6888 15.5686 12.7627 15.4209 12.8365C15.0517 13.058 14.6825 13.3534 14.3133 13.5749C13.6487 14.0918 12.9842 14.6825 12.3196 15.1994C11.8027 15.5686 11.0643 15.7901 10.4736 16.0855C10.1044 16.2331 9.73522 16.3808 9.36602 16.5285C9.21834 16.6023 8.99682 16.6023 8.92298 16.75C8.7753 16.8977 8.70146 17.0454 8.62762 17.2669C8.33226 17.6361 7.96306 18.0791 7.74153 18.5222C7.59385 18.8175 7.52001 19.0391 7.37233 19.3344C7.22465 19.7036 7.00313 20.0728 6.92929 20.5159C6.63393 21.3281 6.63392 22.2142 6.26472 23.0264C6.11704 23.4695 5.82168 23.9125 5.60016 24.3555C5.23096 25.0939 5.15711 25.98 5.08327 26.7923C5.00943 27.2353 5.08326 27.826 5.1571 28.2691C5.23094 28.7859 5.23094 29.3028 5.23093 29.8197C5.23093 30.3366 4.86173 30.9273 4.56637 31.2965C4.27101 31.6657 3.75413 31.8134 3.38493 32.1826C3.08957 32.4779 2.72037 32.7733 2.57269 33.2163C2.49885 33.364 2.57269 33.5855 2.57268 33.8071C2.49884 34.2501 2.35116 34.6193 2.35116 35.0623C2.27732 35.5792 2.27732 36.0961 2.27731 36.6868C2.27731 36.9822 2.27731 37.2037 2.27731 37.4991C2.27731 37.7944 2.35115 38.0159 2.42499 38.2375C2.42498 38.3851 2.42498 38.6067 2.42498 38.7543C2.42498 38.9759 2.57266 39.1974 2.57266 39.3451C2.72034 39.8619 2.79418 40.305 2.86801 40.8219C2.94185 41.2649 3.16337 41.7079 3.23721 42.151C3.45872 42.7417 3.53256 43.3324 3.68024 43.997C3.75407 44.44 3.75407 44.9569 3.82791 45.3999C3.90175 45.7691 3.97559 46.1383 3.97559 46.5075C3.97558 47.0983 3.8279 47.6151 3.8279 48.2059C3.82789 49.1658 4.19709 50.1257 4.4186 51.0856C4.49244 51.381 4.56628 51.6025 4.64012 51.8979C2.20343 47.1721 0.874336 41.7818 0.874361 36.0961C0.874391 29.1551 2.86809 22.7311 6.33859 17.3407C7.81539 15.0517 9.51371 12.9103 11.5074 11.0643C17.7838 4.93562 26.4231 1.16978 35.8746 1.16978C36.613 1.16978 37.4252 1.16978 38.1636 1.24362C42.7417 1.24362 47.172 2.42506 51.1594 4.3449Z"
                fill="url(#paint14_linear_2824_1473)"
            />
            <path
                opacity="0.3"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M48.1316 62.4569C48.7961 62.0139 49.4607 61.6447 50.1991 61.2016C50.9375 60.7586 51.6759 60.5371 52.4881 60.1679C53.0788 59.9464 53.1527 59.9463 53.5957 60.3156C54.0388 60.6848 54.5556 60.7586 55.0725 60.7586C55.8109 60.7586 56.6232 60.8324 56.697 61.7924C56.7708 63.1215 54.851 64.2291 53.8911 64.746C53.1527 65.189 52.3404 65.4844 51.5282 65.8536C50.8636 66.1489 50.1252 66.5181 49.3868 66.592C48.7223 66.6658 48.3531 66.3704 47.91 65.9274C47.3932 65.3367 47.467 64.8198 47.467 64.1552C47.467 63.2691 47.467 62.6784 48.1316 62.4569Z"
                fill="url(#paint15_linear_2824_1473)"
            />
            <path
                opacity="0.3"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M58.5431 13.501C59.0599 14.5347 59.4291 15.9377 60.2414 16.8238C60.6844 17.2668 60.9798 17.3406 61.5705 17.3406C61.8658 17.3406 62.3827 17.4145 62.6781 17.3406C63.0473 17.193 63.0473 16.7499 63.0473 16.3807C62.9734 14.9778 62.0874 13.7225 61.2013 12.7626C60.6106 12.098 59.7245 11.3596 58.7646 11.5073C58.4692 12.1718 58.3954 12.8364 58.5431 13.501Z"
                fill="url(#paint16_linear_2824_1473)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M39.2708 68.5857C39.197 68.7333 39.0493 68.8072 39.1231 68.9549C39.197 69.0287 39.3447 69.1025 39.4185 69.1025C39.5662 69.1764 39.8615 69.1025 40.0092 69.0287C40.1569 68.9549 40.0831 68.8072 40.0092 68.6595C39.8615 68.438 39.64 68.3641 39.4185 68.5118L39.2708 68.5857Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.381 9.88297C16.0118 10.0307 15.8641 10.0307 15.4949 10.326C15.1995 10.5475 14.9042 10.7691 14.6088 11.0644C14.2396 11.4336 14.0919 11.8028 14.0181 12.172C13.8704 12.5412 13.7966 12.9843 13.9443 13.2058C14.0181 13.2796 14.2396 13.2796 14.4611 13.2796C14.7565 13.2058 15.0518 12.9843 15.3472 12.8366C15.7164 12.6151 16.0118 12.2459 16.3071 11.8767C16.5287 11.5813 16.6025 11.2859 16.7502 10.9906C16.824 10.7691 16.8979 10.6214 16.9717 10.4737C17.0455 10.326 17.0455 10.1783 16.9717 10.1045C16.8979 9.88297 16.824 9.88297 16.381 9.88297Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20.516 9.21796C20.3683 9.36564 20.073 9.58717 20.2945 9.73485C20.3683 9.80869 20.4422 9.73484 20.516 9.80868C20.5899 9.80868 20.5899 9.88252 20.6637 9.80868C20.8852 9.80868 20.8114 9.14412 20.516 9.21796Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M21.624 11.4337C21.6979 11.3598 21.8455 11.3598 21.9194 11.3598C21.9194 11.5075 22.0671 11.729 21.8455 11.8767C21.6979 11.9506 21.7717 11.6552 21.6979 11.6552L21.624 11.4337Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M23.7646 11.4332C23.9862 11.507 24.1338 11.5809 24.3554 11.6547C24.4292 11.5809 24.503 11.5809 24.5769 11.5809C24.6507 11.507 24.7246 11.3593 24.7984 11.2855C24.8722 11.1378 24.7984 10.9901 24.7246 10.8425C24.6507 10.7686 24.6507 10.6209 24.5769 10.5471C24.503 10.4733 24.2815 10.4733 24.2077 10.5471C24.06 10.6209 23.9862 10.6948 23.9123 10.8425C23.8385 10.9163 23.7646 11.1378 23.7646 11.2117C23.7646 11.3593 23.8385 11.507 23.9862 11.5809L23.7646 11.4332Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M25.5366 51.8977C25.7581 51.9715 25.9058 52.0454 26.1273 52.1192C26.2012 52.0454 26.275 52.0454 26.3489 52.0454C26.4227 51.9715 26.4965 51.8239 26.5704 51.75C26.6442 51.6023 26.5704 51.4547 26.4965 51.307C26.4227 51.2331 26.4227 51.0855 26.3489 51.0116C26.275 50.9378 26.0535 50.9378 25.9797 51.0116C25.832 51.0855 25.7581 51.1593 25.6843 51.307C25.6105 51.3808 25.5366 51.6023 25.5366 51.6762C25.5366 51.8239 25.6105 51.9715 25.7581 52.0454L25.5366 51.8977Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.0794 13.3531C18.0056 13.427 17.9317 13.5008 17.8579 13.5747C17.9317 13.6485 18.0056 13.7962 18.1533 13.7962C18.2271 13.7962 18.3009 13.7962 18.3009 13.7962C18.3748 13.7223 18.3009 13.6485 18.3748 13.6485C18.4486 13.5008 18.4486 13.5008 18.3748 13.3531C18.3009 13.2793 18.3009 13.2793 18.2271 13.2793C18.1533 13.2793 18.0794 13.2793 18.0056 13.3531L18.0794 13.3531Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.5227 16.5281C18.5227 16.5281 18.375 16.9711 18.5227 16.8234C18.6703 16.7496 18.6703 16.6019 18.5227 16.5281C18.5965 16.5281 18.5965 16.5281 18.5227 16.5281Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.6424 21.8448C15.4947 21.9924 15.4947 22.0663 15.4209 22.2878C15.4947 22.3616 15.5686 22.3616 15.6424 22.3616C15.7901 22.3616 15.7901 22.2878 15.7901 22.214C15.7901 22.1401 15.8639 22.0663 15.7901 21.9924C15.7901 21.8448 15.7163 21.7709 15.6424 21.8448Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20.0728 13.7227C20.1466 13.7965 20.2204 13.8704 20.2204 13.9442C20.1466 13.9442 20.0728 13.8704 20.0728 13.7965C20.0728 13.6489 20.0728 13.7227 20.1466 13.575L20.0728 13.7227Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19.0389 9.58724C18.9651 9.66108 18.8912 9.73492 18.8174 9.80876C18.8912 9.8826 18.8174 9.95644 18.9651 9.95644C19.0389 9.95644 19.1127 9.8826 19.1866 9.80876C19.2604 9.73492 19.2604 9.66108 19.2604 9.58724C19.2604 9.5134 19.2604 9.36572 19.1866 9.5134L19.0389 9.58724Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M32.478 7.44583C32.478 7.37199 32.5519 7.22431 32.5519 7.15047L32.6257 7.07663C32.6995 7.00279 32.6995 7.00278 32.7734 7.00278C32.8472 7.00278 32.9211 7.00279 33.0687 7.07663C33.3641 7.29815 32.6257 7.51967 32.5519 7.29815L32.478 7.44583Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M34.9893 8.40558C34.9155 8.55326 34.8416 8.77477 34.9893 8.92245C35.137 8.99629 35.4324 8.84862 35.5062 8.77478C35.7277 8.6271 35.9492 8.2579 35.7277 8.03638C35.6539 7.8887 35.2847 7.81486 35.137 7.81486C34.7678 7.81486 34.694 8.2579 34.6201 8.6271L34.9893 8.40558Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M36.0963 4.93531C36.0225 4.63995 36.0225 4.34459 36.244 4.19691C36.3917 4.12307 36.6132 4.04923 36.7609 4.19691C36.8347 4.27075 36.9085 4.41843 36.9824 4.49227C37.0562 4.63995 37.0562 4.63995 36.9824 4.78763C36.9085 5.08299 36.8347 5.30451 36.4655 5.30451C36.0225 5.30451 36.0225 5.00915 36.0225 4.56611L36.0225 4.93531L36.0963 4.93531Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M39.8618 10.104C40.0833 10.0302 40.3048 9.95633 40.4525 9.73481C40.3049 9.66097 39.9357 9.43945 39.8618 9.73481L39.8618 10.104Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M26.8657 56.6233C27.0872 56.5495 27.3088 56.4756 27.4564 56.2541C27.3088 56.1803 26.9396 55.9587 26.8657 56.2541L26.8657 56.6233Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M50.8638 61.6445C51.0853 61.5707 51.3068 61.4969 51.4545 61.2753C51.3068 61.2015 50.9376 60.98 50.8638 61.2753L50.8638 61.6445Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M42.7421 14.6086C42.9636 14.3132 43.259 13.8702 43.702 14.0917C43.9236 14.2394 43.9974 14.6824 43.7759 14.8301C43.5544 14.9778 43.4067 15.0516 43.1113 15.1254C42.9636 15.1993 42.6683 15.0516 42.7421 14.7562L42.7421 14.6086V14.6086Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M27.162 21.0322C27.3836 20.7369 27.6789 20.2938 28.122 20.5154C28.3435 20.663 28.4173 21.1061 28.1958 21.2538C27.9743 21.4014 27.8266 21.4753 27.5312 21.5491C27.3836 21.623 27.0882 21.4753 27.162 21.1799L27.162 21.0322V21.0322Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M53.0053 9.58712C53.2268 9.29176 53.5222 8.84873 53.9652 9.07025C54.1867 9.21793 54.2606 9.66097 54.0391 9.80865C53.8175 9.95633 53.6699 10.0302 53.3745 10.104C53.2268 10.1778 52.9315 10.0302 53.0053 9.73481L53.0053 9.58712V9.58712Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M38.5331 33.4372C38.7547 33.1419 39.05 32.6988 39.4931 32.9204C39.7146 33.068 39.7884 33.5111 39.5669 33.6588C39.3454 33.8064 39.1977 33.8803 38.9023 33.9541C38.7547 34.028 38.4593 33.8803 38.5331 33.5849L38.5331 33.4372V33.4372Z"
                fill="#FFC445"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M25.906 11.3594C25.6106 11.5071 25.1676 11.7286 25.0937 12.1717C25.0937 12.3932 25.1676 12.5409 25.3891 12.6147C25.5368 12.6885 25.8321 12.6885 26.0537 12.6147C26.349 12.467 26.6444 12.2455 26.7182 12.024C26.7921 11.8025 26.7921 11.6548 26.7182 11.5071C26.6444 11.4333 26.5705 11.2856 26.4229 11.2117C26.0537 11.0641 25.8321 11.4333 25.5368 11.5809L25.906 11.3594Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M26.7924 10.3255C26.9401 10.3994 27.0878 10.4732 27.1616 10.6209C27.0139 10.6947 26.8663 10.7686 26.7186 10.7686C26.4971 10.6947 26.4971 10.4732 26.4971 10.3255C26.4971 10.2517 26.7186 10.0302 26.7924 10.104C26.8663 10.104 26.8663 10.1778 26.8663 10.2517C26.9401 10.3255 26.9401 10.3255 26.8663 10.4732L26.7924 10.4732L26.7924 10.3255Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.2121 16.8236C10.9168 17.1189 10.6214 17.4143 10.4737 17.7835C10.3999 18.005 10.5476 18.005 10.6953 17.9312C11.0645 17.8573 11.3598 17.7835 11.729 17.7097C11.9505 17.6358 12.2459 17.562 12.3197 17.4143C12.3936 17.2666 12.4674 17.0451 12.4674 16.8974C12.4674 16.6759 12.2459 16.6021 12.0982 16.5282C11.6552 16.3805 10.9906 16.6759 10.8429 17.1189L11.2121 16.8236Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.4338 18.3742C11.6553 18.3742 11.8768 18.4481 12.0984 18.5219C12.0245 18.5957 12.0245 18.6696 12.0245 18.7434C11.9507 18.8911 11.8768 18.965 11.7292 19.0388C11.5076 19.1865 11.2123 19.1865 10.9908 19.1126C10.3262 18.8911 11.36 18.1527 11.5076 18.3742L11.4338 18.3742Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M31.4443 4.3446C31.6659 4.19692 31.8874 4.12308 32.1089 4.04924C32.4043 3.9754 32.6996 3.9754 32.995 3.9754C33.1427 3.9754 33.5119 3.9754 33.3642 4.19692C33.2903 4.49228 32.6996 4.7138 32.4781 4.78764C32.1089 4.93532 31.7397 5.15684 31.2967 5.23068C31.0751 5.23068 30.7059 5.30452 30.5583 5.083C30.4844 4.86148 30.4844 4.7138 30.6321 4.56612C30.7059 4.41844 30.8536 4.3446 31.0751 4.27076C31.149 4.27076 31.6659 4.12308 31.6659 4.27076L31.4443 4.3446Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M27.5306 4.41843C27.4568 4.49227 26.6445 4.93531 27.0137 5.15683C27.2352 5.23067 27.6044 5.23067 27.826 5.15683C27.9736 5.08299 28.1952 4.93532 28.0475 4.7138C27.826 4.27076 27.2353 4.56612 26.9399 4.7138L27.5306 4.41843Z"
                fill="#FFFF45"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.5283 33.3637C16.6022 33.659 16.676 34.0282 16.9714 34.2498C17.2667 34.4713 17.6359 34.3974 17.8574 34.1759C18.079 34.0282 18.3005 33.8806 18.4482 33.8067C18.5958 33.7329 18.6697 33.7329 18.6697 33.5114C18.6697 33.2898 18.522 33.0683 18.3743 32.9206C18.2266 32.7729 18.0051 32.5514 17.7836 32.4776C17.3406 32.3299 16.5283 32.4776 16.5283 33.0683L16.5283 33.3637Z"
                fill="#FFD32F"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M41.6338 33.7331C41.7076 34.0285 41.7815 34.3977 42.0768 34.6192C42.3722 34.8407 42.7414 34.7669 42.9629 34.5453C43.1844 34.3977 43.4059 34.25 43.5536 34.1761C43.7013 34.1023 43.7751 34.1023 43.7751 33.8808C43.7751 33.6593 43.6275 33.4377 43.4798 33.2901C43.3321 33.1424 43.1106 32.9209 42.8891 32.847C42.446 32.6993 41.6338 32.847 41.6338 33.4377L41.6338 33.7331Z"
                fill="#FFBA00"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.8954 46.36C5.8954 46.36 5.60004 47.6152 6.48611 49.2397C7.37218 50.8642 8.03674 50.7165 8.03674 50.7165C8.03674 50.7165 7.22451 47.7629 5.8954 46.36Z"
                fill="#FFFF59"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M62.9734 29.1551C62.9734 29.1551 61.9397 32.1087 61.792 32.5517C61.792 32.4779 63.4165 32.0349 62.9734 29.1551Z"
                fill="#FFFF59"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M68.5119 30.041C68.5119 30.041 67.7735 30.5579 67.4043 31.9608C67.4043 31.9608 68.2904 32.4039 68.5119 30.041Z"
                fill="#FFFF59"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M57.2139 57.5096C57.2139 57.5096 60.5366 55.3683 62.4565 55.2206C62.4565 55.2206 60.2413 57.8788 57.2139 57.5096Z"
                fill="#FFFF59"
            />
            <defs>
                <radialGradient
                    id="paint0_radial_2824_1473"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(14.1746 19.4638) scale(56.1936 56.1938)"
                >
                    <stop offset="0.00558659" stopColor="#FFB80B" />
                    <stop offset="0.258" stopColor="#FFB60C" />
                    <stop offset="0.384" stopColor="#FEAE10" />
                    <stop offset="0.4821" stopColor="#FCA117" />
                    <stop offset="0.5656" stopColor="#FA8E21" />
                    <stop offset="0.6392" stopColor="#F7762E" />
                    <stop offset="0.662" stopColor="#F66D33" />
                    <stop offset="0.7209" stopColor="#EF6836" />
                    <stop offset="0.8061" stopColor="#DC593D" />
                    <stop offset="0.9068" stopColor="#BD4049" />
                    <stop offset="0.9832" stopColor="#A02A54" />
                </radialGradient>
                <linearGradient
                    id="paint1_linear_2824_1473"
                    x1="3.78766"
                    y1="46.1165"
                    x2="20.7256"
                    y2="46.1166"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint2_linear_2824_1473"
                    x1="4.38513"
                    y1="46.1164"
                    x2="19.8309"
                    y2="46.1164"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint3_linear_2824_1473"
                    x1="6.08279"
                    y1="25.9028"
                    x2="12.8268"
                    y2="25.689"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint4_linear_2824_1473"
                    x1="6.49775"
                    y1="25.8897"
                    x2="12.3963"
                    y2="25.7026"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint5_linear_2824_1473"
                    x1="61.8125"
                    y1="58.1138"
                    x2="61.8125"
                    y2="34.1162"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FF8E0B" />
                    <stop offset="0.3475" stopColor="#FD8B0D" />
                    <stop offset="0.5941" stopColor="#F98215" />
                    <stop offset="0.8113" stopColor="#F17221" />
                    <stop offset="1" stopColor="#E65D31" />
                </linearGradient>
                <linearGradient
                    id="paint6_linear_2824_1473"
                    x1="54.7431"
                    y1="46.1147"
                    x2="68.8672"
                    y2="46.1148"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint7_linear_2824_1473"
                    x1="66.3288"
                    y1="33.557"
                    x2="66.3288"
                    y2="24.2953"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint8_linear_2824_1473"
                    x1="66.3238"
                    y1="32.9499"
                    x2="66.3238"
                    y2="24.9023"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint9_linear_2824_1473"
                    x1="37.5536"
                    y1="70.3604"
                    x2="37.5536"
                    y2="64.965"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint10_linear_2824_1473"
                    x1="37.5532"
                    y1="69.7537"
                    x2="37.5532"
                    y2="65.5718"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint11_linear_2824_1473"
                    x1="54.4688"
                    y1="36.3255"
                    x2="57.4954"
                    y2="13.529"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFA90B" />
                    <stop offset="0.3713" stopColor="#FFA60E" />
                    <stop offset="0.6354" stopColor="#FF9D16" />
                    <stop offset="0.868" stopColor="#FF8D25" />
                    <stop offset="1" stopColor="#FF8031" />
                </linearGradient>
                <linearGradient
                    id="paint12_linear_2824_1473"
                    x1="54.5465"
                    y1="35.724"
                    x2="57.4134"
                    y2="14.1296"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint13_linear_2824_1473"
                    x1="0.858582"
                    y1="33.3904"
                    x2="54.6615"
                    y2="33.3906"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#F67C27" />
                    <stop offset="0.8891" stopColor="#ED6930" />
                    <stop offset="1" stopColor="#E76332" />
                </linearGradient>
                <linearGradient
                    id="paint14_linear_2824_1473"
                    x1="0.858454"
                    y1="26.2272"
                    x2="51.1801"
                    y2="26.2274"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint15_linear_2824_1473"
                    x1="47.4916"
                    y1="63.3028"
                    x2="56.7191"
                    y2="63.3029"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
                <linearGradient
                    id="paint16_linear_2824_1473"
                    x1="58.448"
                    y1="14.4623"
                    x2="62.9895"
                    y2="14.4623"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop offset="0.0111732" stopColor="#FFE00B" />
                    <stop offset="0.3061" stopColor="#FFDD0D" />
                    <stop offset="0.5224" stopColor="#FFD412" />
                    <stop offset="0.7136" stopColor="#FFC41B" />
                    <stop offset="0.8891" stopColor="#FFAD27" />
                    <stop offset="1" stopColor="#FF9B31" />
                </linearGradient>
            </defs>
        </svg>
    );
};

export const PlanetRed = () => {
    return (
        <svg
            width="70"
            height="70"
            viewBox="0 0 70 70"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M69.9935 35.0063C69.9935 35.3041 69.9872 35.6019 69.9809 35.8997C69.9365 37.7688 69.7401 39.6063 69.4106 41.393C69.3726 41.6084 69.3282 41.8302 69.2839 42.0456C69.1445 42.7362 68.9798 43.4205 68.796 44.0921C68.1688 46.4365 67.3008 48.6857 66.2236 50.8083C65.8815 51.4862 65.514 52.1515 65.1275 52.8041C64.9944 53.0259 64.8614 53.254 64.722 53.4757C64.3291 54.103 63.9173 54.7239 63.4865 55.3195C62.6248 56.5297 61.6871 57.6765 60.6797 58.7663C59.1083 60.4643 57.3722 62.004 55.4968 63.3599C54.0268 64.4243 52.4682 65.3811 50.8335 66.2111C46.0752 68.6314 40.6896 69.9937 34.9872 69.9937C34.1319 69.9937 33.2765 69.962 32.4339 69.8986C28.1317 69.5882 24.045 68.4984 20.3131 66.775C17.2339 65.3494 14.3953 63.4929 11.88 61.2753C9.92214 59.552 8.16073 57.6131 6.62743 55.4969C3.19966 50.7639 0.931379 45.1439 0.228086 39.0424C0.0760224 37.7181 0 36.3686 0 35C0 33.9546 0.0443464 32.9155 0.13305 31.8954C0.399161 28.8731 1.05177 25.9649 2.03384 23.2151C2.33797 22.366 2.67377 21.5297 3.04126 20.7123C3.64318 19.3755 4.32113 18.0766 5.08145 16.8347C6.92521 13.7998 9.21884 11.0753 11.8736 8.73733C11.8736 8.73733 11.8736 8.73733 11.88 8.73099C13.7174 7.11531 15.7259 5.68338 17.8738 4.47321C21.4283 2.47737 25.3629 1.08345 29.5447 0.424511C31.3187 0.145728 33.1435 0 34.9936 0C44.6686 0 53.425 3.92831 59.7609 10.2706C61.6364 12.1524 63.3027 14.2433 64.7157 16.5116C65.9448 18.4884 66.984 20.592 67.8076 22.8032C68.2892 24.0958 68.6947 25.4263 69.0241 26.7886C69.5754 29.0758 69.8985 31.4455 69.9745 33.8785C69.9872 34.265 69.9935 34.6325 69.9935 35.0063Z"
                fill="url(#paint0_radial_2824_1531)"
            />
            <path
                d="M59.6913 10.5489C57.3597 17.8987 45.296 18.8808 28.3789 14.6673C18.083 12.1013 9.83353 14.7307 5.08154 17.0687C8.20518 11.9555 12.6087 7.71042 17.8549 4.77052C22.5562 4.46639 26.3451 6.00604 29.2026 7.29224C35.5766 10.1624 44.8271 12.0062 45.6508 8.72418C46.6519 4.72617 42.977 4.0102 34.962 2.98377C31.5786 2.55292 30.096 1.64054 29.5194 0.74083C31.2935 0.462046 33.1119 0.322655 34.962 0.322655C44.618 0.322655 53.3617 4.23196 59.6913 10.5489Z"
                fill="url(#paint1_linear_2824_1531)"
            />
            <path
                d="M67.725 23.0314C53.9316 34.6706 36.5267 31.1415 20.5664 29.2217C8.93353 27.8214 2.84463 30.3305 0.145508 32.0729C0.411619 29.0696 1.0579 26.1677 2.03998 23.4306C11.6073 21.4094 17.5821 22.4232 34.9554 24.9196C51.7394 27.3336 61.3004 20.0218 64.6331 16.7651C65.8623 18.7293 66.9014 20.8265 67.725 23.0314Z"
                fill="url(#paint2_linear_2824_1531)"
            />
            <path
                d="M69.8921 36.0514C69.8414 38.1423 69.6007 40.1888 69.1952 42.172C66.6164 41.437 63.1126 41.5891 56.3331 44.3832C46.8798 48.2799 42.9705 46.8416 30.4316 43.7686C17.8927 40.6957 12.7543 43.5659 13.1661 46.227C13.5779 48.8881 18.9192 52.582 29.2024 50.941C39.4794 49.3 48.939 53.8112 48.939 56.6814C48.939 59.5516 39.2767 56.0668 22.2139 60.578C18.6847 61.5094 15.1493 61.7185 11.8799 61.3257C5.55027 55.7753 1.25448 47.9821 0.240723 39.1877C5.60729 32.3322 14.9782 32.6997 24.064 35.779C34.9619 39.4665 42.1532 39.8783 55.313 36.5963C63.2013 34.6258 67.6238 35.2404 69.8921 36.0514Z"
                fill="url(#paint3_linear_2824_1531)"
            />
            <path
                d="M66.1413 50.8971C64.6714 53.7927 62.8022 56.4538 60.61 58.8171C59.951 55.2183 50.5801 54.0144 55.5095 51.3533C59.0577 49.4399 63.7717 50.2762 66.1413 50.8971Z"
                fill="url(#paint4_linear_2824_1531)"
            />
            <path
                d="M55.4338 63.3912C53.9638 64.4557 52.4052 65.4061 50.7768 66.2298C46.9626 65.6468 41.7481 65.7356 35.9823 68.3586C34.6771 68.9479 33.486 69.4611 32.4025 69.9046C28.1067 69.5942 24.0263 68.5107 20.3008 66.7937C23.0633 66.2614 25.5596 65.1146 31.6675 63.2328C41.4629 60.2232 50.7515 62.0353 55.4338 63.3912Z"
                fill="url(#paint5_linear_2824_1531)"
            />
            <path
                d="M20.1546 44.3832C17.4999 44.7127 17.8927 47.0443 19.331 48.2798C20.7692 49.509 27.1432 49.0972 27.555 47.6653C27.9669 46.227 23.443 43.9714 20.1546 44.3832Z"
                fill="url(#paint6_linear_2824_1531)"
            />
            <path
                d="M37.8321 4.62532C35.5638 4.62532 33.1055 3.80798 32.4846 5.44266C31.8636 7.07735 40.4995 8.92745 41.3232 7.90102C42.1469 6.88093 42.5588 4.62532 37.8321 4.62532Z"
                fill="url(#paint7_linear_2824_1531)"
            />
            <path
                d="M69.8858 34.0556C66.2046 33.8085 61.8328 32.8771 62.0926 31.4706C62.5488 28.9805 66.9523 27.5296 68.9354 26.991C69.4867 29.272 69.8098 31.629 69.8858 34.0556Z"
                fill="url(#paint8_linear_2824_1531)"
            />
            <path
                d="M63.5181 57.1122L63.7778 56.4279C63.6384 56.8018 63.5497 57.0362 63.5181 57.1122Z"
                fill="url(#paint9_linear_2824_1531)"
            />
            <path
                opacity="0.45"
                d="M63.4928 55.3195C62.6312 56.5297 61.6934 57.6765 60.686 58.7663C59.1147 60.4643 57.3786 62.0039 55.5032 63.3598C54.0332 64.4243 52.4746 65.381 50.8399 66.211C46.0816 68.6314 40.696 69.9936 34.9936 69.9936C34.1382 69.9936 33.2829 69.9619 32.4402 69.8986C28.1381 69.5881 24.0514 68.4983 20.3195 66.7749C17.2402 65.3493 14.4017 63.4929 11.8863 61.2753C5.55035 55.6996 1.24821 47.8684 0.234453 39.0423C0.0823894 37.7181 0.00634766 36.3685 0.00634766 35C0.00634766 33.9545 0.0507134 32.9154 0.139417 31.8953C0.405528 28.8731 1.05813 25.9648 2.04021 23.215C2.34434 22.366 2.68014 21.5297 3.04763 20.7123C10.2009 21.4916 19.8189 25.553 31.0716 37.7878C44.6053 52.4936 55.9657 55.5666 63.4928 55.3195Z"
                fill="url(#paint10_linear_2824_1531)"
            />
            <path
                opacity="0.45"
                d="M68.7961 44.0985C68.1688 46.4429 67.3008 48.6921 66.2237 50.8147C65.4253 52.3924 64.5129 53.9003 63.4928 55.3259C62.6312 56.5361 61.6934 57.6829 60.686 58.7727C59.1147 60.4707 57.3786 62.0104 55.5032 63.3663C54.0332 64.4307 52.4746 65.3875 50.8399 66.2175C46.0816 68.6378 40.696 70.0001 34.9936 70.0001C34.1382 70.0001 33.2829 69.9684 32.4402 69.905C28.1381 69.5946 24.0514 68.5048 20.3195 66.7814C17.2402 65.3558 14.4017 63.4993 11.8863 61.2817C9.9285 59.5584 8.1671 57.6195 6.63379 55.5033C12.1144 57.7146 18.349 59.2606 25.4263 59.7928C54.0839 61.947 64.8107 51.5116 68.7961 44.0985Z"
                fill="url(#paint11_linear_2824_1531)"
            />
            <path
                opacity="0.75"
                d="M69.9934 35.0063C69.9934 35.3041 69.9871 35.6019 69.9808 35.8997C69.9364 37.7688 69.74 39.6063 69.4105 41.393L65.1338 52.8041L63.8222 56.2889C64.044 55.6617 64.3671 54.6986 64.7282 53.4694C67.2119 44.8461 71.2226 23.0947 53.013 11.2274C30.1845 -3.65587 12.2347 8.49656 11.8862 8.73099C13.7237 7.11531 15.7321 5.68338 17.88 4.47321C21.4345 2.47737 25.3692 1.08345 29.5509 0.424511C31.325 0.145728 33.1498 0 34.9999 0C44.6749 0 53.4312 3.92831 59.7672 10.2706C61.6427 12.1524 63.309 14.2433 64.7219 16.5116C65.9511 18.4884 66.9902 20.592 67.8139 22.8032C68.2954 24.0958 68.7009 25.4263 69.0304 26.7886C69.5816 29.0758 69.9048 31.4455 69.9808 33.8785C69.9871 34.265 69.9934 34.6325 69.9934 35.0063Z"
                fill="url(#paint12_linear_2824_1531)"
            />
            <defs>
                <radialGradient
                    id="paint0_radial_2824_1531"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(33.147 11.8514) scale(52.4282 52.4283)"
                >
                    <stop stopColor="#FFB56F" />
                    <stop offset="1" stopColor="#FB367E" />
                </radialGradient>
                <linearGradient
                    id="paint1_linear_2824_1531"
                    x1="42.741"
                    y1="83.6687"
                    x2="25.7598"
                    y2="-30.8759"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint2_linear_2824_1531"
                    x1="42.2625"
                    y1="83.7403"
                    x2="25.2814"
                    y2="-30.8044"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint3_linear_2824_1531"
                    x1="41.8994"
                    y1="83.7936"
                    x2="24.9183"
                    y2="-30.751"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint4_linear_2824_1531"
                    x1="64.347"
                    y1="80.4664"
                    x2="47.3657"
                    y2="-34.079"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint5_linear_2824_1531"
                    x1="40.6667"
                    y1="83.9763"
                    x2="23.6857"
                    y2="-30.5679"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint6_linear_2824_1531"
                    x1="28.6605"
                    y1="85.7561"
                    x2="11.6795"
                    y2="-28.7883"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint7_linear_2824_1531"
                    x1="48.5253"
                    y1="82.8117"
                    x2="31.5441"
                    y2="-31.7329"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint8_linear_2824_1531"
                    x1="72.9706"
                    y1="79.1873"
                    x2="55.9894"
                    y2="-35.3574"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint9_linear_2824_1531"
                    x1="67.0999"
                    y1="80.0588"
                    x2="50.1169"
                    y2="-34.4914"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#E0386F" />
                    <stop offset="1" stopColor="#C93890" stopOpacity="0" />
                </linearGradient>
                <linearGradient
                    id="paint10_linear_2824_1531"
                    x1="21.5603"
                    y1="58.5992"
                    x2="40.5838"
                    y2="25.1685"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#CA1B6A" />
                    <stop offset="1" stopColor="#CA1B6A" stopOpacity="0.1" />
                </linearGradient>
                <linearGradient
                    id="paint11_linear_2824_1531"
                    x1="19.3654"
                    y1="84.9756"
                    x2="46.5351"
                    y2="34.3413"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#A41B6A" />
                    <stop offset="1" stopColor="#B51B6A" stopOpacity="0.13" />
                </linearGradient>
                <linearGradient
                    id="paint12_linear_2824_1531"
                    x1="62.8574"
                    y1="2.03879"
                    x2="43.0959"
                    y2="26.1255"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop stopColor="#FFB8B1" />
                    <stop offset="1" stopColor="#FFC4B1" stopOpacity="0.1" />
                </linearGradient>
            </defs>
        </svg>
    );
};
