/* 
 * NTop - an htop clone for Windows
 * Copyright (c) 2019 Gian Sass
 * 
 * This program is free software: you can redistribute it and/or modify  
 * it under the terms of the GNU General Public License as published by  
 * the Free Software Foundation, version 3.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UTIL_H
#define UTIL_H

#include <tchar.h>

#ifdef _MSC_VER
	#define NORETURN __declspec(noreturn)
#elif defined(__GNUC__) && defined(__MINGW32__)
	#define NORETURN __attribute__((noreturn))
#else
	#define NORETURN
#endif

NORETURN void Die(TCHAR *Fmt, ...);
void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);
void *xcalloc(size_t num, size_t size);

#ifdef UNICODE
	/*
	 * Zero extension is correct for converting any legal ASCII char
	 * to its corresponding UTF-16LE code unit
	 */
	#define TCharFromAscii(c) ((TCHAR)(unsigned char)c)
#else
	#define TCharFromAscii(c) (c)
#endif

/*
 * Use these zero-extending functions to defend against stdlib undefined behavior
 * specified by the is*-family of ctype functions
 */
#define IntFromTChar(t) ((int)(unsigned int)t)
#define IntFromChar(c) ((int)(unsigned int)c)

#endif
