# Using Markor to Write (and More) on an Android Device (The Plain Text Project)
_16. July 2019_

This a copy of the blog post [Using Markor to Write (and More) on an Android Device](https://plaintextproject.online/2019/07/16/markor.html), first published at _The Plain Text Project_ blog on 16. July 2019 by Scott Nesbitt. The post content is licensed [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/). 'I' and 'me' refers to the original author. Minor edits were done compared to the original post (references to LinkBox removed).

---

I have something of a like/dislike relationship with smartphones and tablet.
On one hand, they can be _very_ useful for getting some work done. Especially
writing. And not having to lug a laptop around is a bonus.

On the other hand, smartphones and tablets can distract us from our lives. And
they further blur the already blurry line between life and work. Because we
_can_ work from anywhere doesn’t mean we _should_.

As I wrote a couple of paragraphs ago, smartphones and tablets can be very
useful when you need to do a little work. In my case, that work is usually
writing. To do that, I need an editor.

Over the years, I’ve used a number of editors with a number of Android-powered
devices. Right my, my editor of choice is
[Markor](https://github.com/gsantner/markor).


## Getting Markor

Seeing as how Markor is open source, I got it (and update it) from
[F-Droid](https://f-droid.org). Why F-Droid? The site is devoted to free and
open source Android apps, and doesn’t add any of Google’s creepiness to the
mix. And since I don’t use Google services with the [version of
Android](https://lineageos.org), F-Droid is the best way to get those apps.

In case you’re wondering, you _can_ install Markor from the Google Play Store.
Visit the [Markor web page](https://github.com/gsantner/markor) for the link.

## Using Markor

Fire up the app, obviously!

![Markor, when you first run it](https://plaintextproject.online/images/markor/markor-main-screen.png)

At the bottom of the screen are these icons:

  * **QuickNote**
  * **To-Do**

I’ll be discussing the options related to those icons in a moment or two.

### Creating a Document

I use Markor mainly for writing. To start doing that, tap the **+** button on
the main screen. Markor prompts you for the name of your new document.

You can also choose the type of document to create:

  * Markdown
  * Plain Text
  * Todo.txt
  * Jekyll Post

Markor adds the extension based on what you choose — _.md_ for Markdown and
[Jekyll](https://plaintextproject.online/2018/10/03/jekyll.html) posts, and
_.txt_ for plain text and Todo.txt files.

Markor doesn’t use templates with the file types you select. With Jekyll
posts, for example, the editor doesn’t include a [front matter](https://jekyllrb.com/docs/front-matter/) block. Markor does, however,
uses Jekyll’s preferred file naming convention of _yyyy-mm-dd-slug.md_ — for
example, _2019-07-16-markor.md_.

When you’ve given your document a name, tap **OK**. You have a blank canvas on
which to write.

![Writing this article with Markor](https://plaintextproject.online/images/markor/writing-with-markor.png)

Start typing. You can add Markdown formatting using the keyboard. I usually
work with a folding Bluetooth keyboard rather than the on-screen one. It’s
faster and smoother. But if you prefer your phone’s or tablet’s soft keyboard,
or don’t have any other choice, you can quickly add formatting.

Notice the toolbar at the bottom of the screen. That’s the one which displays
if you created a **Markdown** or **Jekyll Post** file. If you don’t know
Markdown, you can tap an icon to add formatting. You can also add a date and
time stamp or change the colour of text.

## Organizing Your Documents

If you use Markor a lot, you’ll wind up with a lot of files. Maybe even ones
of different types or for different purposes.

A better way to organize them is to use _folders_. To create a folder, go to
Markor’s main screen and tap the **+** icon. Type a name for the folder, and
then tap **Folder**.

Create as many folders as you need. For example, I have folders for blog
posts, essays, and articles.

![Folders in Markor](https://plaintextproject.online/images/markor/markor-folders.png)

What if you’ve created files before you’ve created folders? Tap and hold the
files that you want to move, then tap the **Intents** menu (that’s the one
with three vertical dots on the top right of the window). Tap **Move** , and
then select the folder in which to place the files.

## Using Markor’s Other Options

Remember the other options on the main screen? The ones labelled _QuickNote_ and _To-Do_? Let’s take a quick look at them.

**QuickNote** enables you to just what it says on the tin: jot down a short
note or snippet, or copy a quote. There’s nothing else to say about it.

You’ll notice that **QuickNote** uses the same editor as the
one I use for writing, right down to the same toolbar at the bottom of the
screen.

**Todo** , as you’ve probably guessed, enables you to create task lists. Those
lists use the file format of the popular [Todo.txt](http://todotxt.org/)
utility.

![Writing this article with Markor](https://plaintextproject.online/images/markor/markor-todo.png)

You can add tags to task, as well as [contexts](http://tools-for-thought.com/2008/10/31/using-contexts-to-simplify-list-management/). 
You can give your tasks a priority or mark them as done.

## Getting Your Files Off Your Device

Markor’s great for writing a draft, but a time comes when you need to move a
file or three off your device to polish or publish it.

To do that, open the file in Markor. Tap the **Intents** menu and select
**Share**. I usually choose _Plain Text_ , although you can save your document
as a PDF or an HTML file.

A list of applications with which you can share files displays.

![Sharing a Markor file](https://plaintextproject.online/images/markor/markor-share.png)

I use [Nextcloud](https://nextcloud.com) to sync files between my devices.
When I tap the **Nextcloud** icon, I can choose the folder into which I want
to have the file. From there, I type a file name and the document is uploaded.

Something I noticed: when I select _Plain Text_ , Markor doesn’t upload the
file if I change the extension to _.md_. The extension has to stay _.txt_.
It’s annoying, I agree.

## Final Thoughts

Markor has one or two little annoyances, but it’s the best free/open source
text editor I’ve used in a while. It’s easy to use and it’s flexible. Plus it
works seamlessly with my folding Bluetooth keyboard. Combining my phone or
tablet with the keyboard and a lightweight stand give me a lightweight, plain
text writing rig.

