# TODO

* Envelopes:
  * Go to kill phase after release, in preparation for allowing release end
    value to be non-zero?
* In alternative controls mode, maybe display a small envelope editor?
* should LFOs take DAW offset within beat into account?
* Mod matrix should ideally indicate whether mod out is actually active

* Audio inconsistencies on attack, see vospi email
* Consider f64 interpolator and maybe even f64 parameters, since now we
  convert all the time in audio gen
* Percussion adjustments
  * A global percussion mode
    * Ignore note off events
    * Decay leads directly to release
  * Per-operator "constant volume modulation mode" with constant envelope
    volume, no mix out, ends when all operators not in mode have ended

* In modal for setting parameters by text, change to radios for fixed-value
  parameters
  * Dropdown won't work because of
    * https://github.com/iced-rs/iced_aw/issues/77
    * https://github.com/iced-rs/iced/issues/940
* Run miri on audio gen bench
* Aftertouch
  * Parameter for how much voice volume is affected?
* Consider scale factor for GUI
* Add other waveforms?
  * Look at TX81Z waveforms:
    * https://en.wikipedia.org/wiki/Yamaha_YM2414
    * https://www.tinyloops.com/doc/yamaha_tq5/waveforms.html
    * https://www.reddit.com/r/synthesizers/comments/rkyk6j/comment/hpgcu6r/?utm_source=share&utm_medium=web2x&context=3
  * Look at OPL waveforms: https://en.wikipedia.org/wiki/Yamaha_OPL
* GUI resources are not freed in Bitwig on macOS for both vst2 and clap plugins
* CLAP GUI doesn't open on Bitwig on Linux (well, sometimes it does)
* Include zoom state in patch?

## High priority

* When making breaking audio changes
  * exp2 scaling or similar for frequency and volume parameters for better
    external LFO potential
    * will require a fast f64 exp2 implementation, e.g. ported from sleef
  * consider portable mathematics everywhere
  * bhaskara constant power panning
* clap
  * Clap validation in CI
    * Converting parameter values between string and float multiple times
      doesn't yield same values
  * is note end event logic really 100% correct?
  * should parameter cookie be set again when automating?
  * versioning: use OctaSine 0.8 name
  * check for null everywhere
  * check for unwrap
  * consider using logging extension
  * Nice to have: maybe clap is better at supporting automating multiple
    parameters at the same time? Then it might be good to actually tell
    the host about changes to envelopes while dragging, not only on release
* iced 0.5 adjustments
  * Implement Widget for canvas widgets and clear cache on theme changes?
  * How handle external updates when knobs are dragged?
* Check for available updates at plugin start?
* Check that zlib-acknowledgement statements are generated by cargo-about?
* Interpolator const FACTOR division is not converted to reciprocal
  multiplication (but doing it manually doesn't seem to help
  performance)
* heavy CPU consumption in REAPER without anything playing
  * with clap and vst
  * also with other plugins
  * maybe buffers don't really need to be zeroed for clap?
  * maybe we could skip even more processing when there are no events and no
    active voices?
  * maybe this is all fine?

## Medium priority
* Unit tests for parsing parameter value text?
* GUI
  * Tooltips for parameter titles?
  * Envelopes
    * Reset values by double clicking draggers? At least for decay.
    * Display zoom level / viewport length in seconds/milliseconds?
    * Display corresponding value when hovering over dragger?
    * Display all volumes in dB?
  * Probably don't do / no longer relevant:
    * GUI: in operator freq ratio values, display number too? E.g. 2pi: 6.28
    * Add small marks to operator ratio knobs indicating factors of 2?
  * Consider adding widget for LFOs and operators showing cumulative
    frequency multiplier
  * Scrolling in dropdowns
    * iced 0.4: https://github.com/hecrj/iced/pull/872
    * Does scrolling (including touch) need to be added to baseview
      macOS code? What about other platforms?
* bench_process
  * try generating delta_frames with rng
  * try generating key velocity with rng
  * Is it a cause for concern that not keeping wave type fixed has different
    effect depending on SIMD width?

## Low priority

* GUI
  * Mouse drag movements in pick list transfer through to envelope editor

## Very low priority

* Process benchmark output not same on Windows as on macOS/Linux
* Record video of workflow, upload to YouTube
* Consider updating envelope and lfo values in process benchmark too. This
  would further improve usefulness of output hashing.
* GUI
  * Zoom towards center of envelope duration instead of viewport if
    envelope doesn't cover viewport? (Or maybe always)
  * Do I need to run update_host_display?
    * Should it be run on knob drag release?
* clippy
* Test that number of sync and processing parameters is equal
* suspend mode and so on, maybe just reset time, note time, envelopes etc on resume
* Fuzz Log10Table (cargo-fuzz?)
* Is it necessary to look at time signatures etc for bpm sync?
  https://rustaudio.github.io/vst-rs/vst/api/struct.TimeInfo.html
* Preset parameter from text
  * Implement simple parsing etc for all
  * DAW integration working anywhere?
* Nice online documentation

## Don't do

* Use sleef sincos for panning: doesn't seem to improve performance
* Free LFO mode. Difficult to sensibly combine with per-voice LFOs
* Cache sync value in interpolatable parameters too? Don't do this, it seems
  to hurt performance.
* proper beta scaling - double with doubling modulator frequency: too late now
* Add phase knobs. This isn't compatible with the fact that the voices have
  independent phases and FM is done by incrementing the phase. It probably
  wouldn't contribute a lot to audio generation flexibility to change this
  just to add possibility of setting operator phase in addition to frequency.
* Should lock groups be taken into account when automating?
  * Setting equivalent parameter for other envelopes in same group is not
    enough. If lock groups are automated, data will be not synced between
    envelopes, meaning that a full sync would probably have to be done for
    every envelope parameter automation access to preserve current GUI
    behaviour. An option would be to change current GUI behaviour to force
    sync when changing lock groups.
  * It's most likely a bad idea to automate host inside of handler for when
    host sets parameter, since it might cause host to set parameter again
