# Contributing Guidelines

Thank you for your interest in contributing to the tech-community-discords repository! We are looking for more discord groups to add to our expanding list.

If you are interested in adding a new discord server, please add it to the README.

## How to contribute

1. Check the `README` to see if your suggestion exists or not.
2. Fork the repository. Here are the [GitHub instructions for forking a repository](https://docs.github.com/en/get-started/quickstart/fork-a-repo).
3. In the command line, clone the repository by typing `git clone https://github.com/YOUR-GITHUB-USERNAME/tech-community-discords.git`
4. Then type `cd tech-community-discords` to go into the project's directory.
5. Create a branch and switch to that new branch by using the following command: `git checkout -b new-branch-name`
6. Update the `README.md` with your discord group suggestion(s).
   - Append the title and link to the discord server(s), to the list in the appropriate category/categories
7. In the command line, stage your changes by using the `git add .` command.
8. Commit your changes by using the `git commit -m "commit message"` command.
9. Push up your changes to the remote branch on GitHub by using the `git push -u origin branch_name` command.
10. Open a PR directed to our `master` branch.
11. The maintainers will review your PR and either request changes or approve it.

## Beginner Friendly Resources for using Git and GitHub

- [Getting Started with Git](https://www.thisdot.co/blog/getting-started-with-git)

## Attribution
This Contributing file is adapted from the [This Dot Community](https://github.com/thisdot/tech-community-slacks/blob/master/CONTRIBUTING.md)
