package com.grammatek.simaromur;

/**
 * This class is used to store the TTS audio data when the audio is finished playing. An item of
 * this class is fed to the TTSProcessingResultQueue and is processed by the onSynthesizeText()
 * method of the TTSService class.
 */
public class TTSProcessingResult {
    private byte[] mAudio;
    private boolean mIsStopped = false;
    private boolean mIsError = false;
    private final TTSRequest mTTsRequest;

    /**
     * Constructor for com.grammatek.simaromur.TTSProcessingResult.
     *
     * @param ttsRequest  TTSRequest as generated by onSynthesizeText()
     */
    public TTSProcessingResult(TTSRequest ttsRequest) {
        mTTsRequest = ttsRequest;
    }

    /**
     * Sets the processing result to stopped.
     */
    public void setToStopped() {
        mIsStopped = true;
    }

    /**
     * Returns true if the processing result is stopped, false otherwise.
     */
    public boolean isStopped() {
        return mIsStopped;
    }

    /**
     * Add audio data to the com.grammatek.simaromur.TTSProcessingResult.
     * @param audio Audio data to add.
     */
    public void addAudio(byte[] audio) {
        mAudio = audio;
    }

    /**
     * Returns the audio data.
     */
    public byte[] getAudio() {
        return mAudio;
    }

    /**
     * Set the com.grammatek.simaromur.TTSProcessingResult to an error state.
     */
    public void setError() {
        mIsError = true;
    }

    /**
     * Returns true if the processing result is an error, false otherwise.
     */
    public boolean isError() {
        return mIsError;
    }

    /**
     * Returns true if everythin is ok, false otherwise.
     */
    public boolean isOk() {
        return !isError();
    }

    /**
     * Returns true if the com.grammatek.simaromur.TTSProcessingResult is an error state.
     *
     * @return true if the com.grammatek.simaromur.TTSProcessingResult is an error state, false otherwise.
     */
    public boolean isEmpty() {
        return mAudio.length == 0;
    }

    /**
     * Returns the original tts request of the processing result
     * @return the uuid
     */
    public TTSRequest getTTSRequest() {
        return mTTsRequest;
    }
}
