/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;
import opennlp.tools.util.featuregen.ArtifactToSerializerMapper;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import opennlp.tools.util.featuregen.BrownBigramFeatureGenerator;
import opennlp.tools.util.featuregen.BrownCluster;
import opennlp.tools.util.featuregen.BrownTokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.BrownTokenFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.CharacterNgramFeatureGenerator;
import opennlp.tools.util.featuregen.CustomFeatureGenerator;
import opennlp.tools.util.featuregen.DictionaryFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PrefixFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import opennlp.tools.util.featuregen.SuffixFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.TokenPatternFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;
import opennlp.tools.util.featuregen.WordClusterDictionary;
import opennlp.tools.util.featuregen.WordClusterFeatureGenerator;
import opennlp.tools.util.model.ArtifactSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GeneratorFactory {
    private static Map<String, XmlFeatureGeneratorFactory> factories = new HashMap<String, XmlFeatureGeneratorFactory>();

    static AdaptiveFeatureGenerator createGenerator(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
        String elementName = generatorElement.getTagName();
        XmlFeatureGeneratorFactory generatorFactory = factories.get(elementName);
        if (generatorFactory == null) {
            throw new InvalidFormatException("Unexpected element: " + elementName);
        }
        return generatorFactory.create(generatorElement, resourceManager);
    }

    private static Document createDOM(InputStream xmlDescriptorIn) throws IOException, InvalidFormatException {
        Document xmlDescriptorDOM;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFacoty = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFacoty.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        try {
            xmlDescriptorDOM = documentBuilder.parse(xmlDescriptorIn);
        }
        catch (SAXException e) {
            throw new InvalidFormatException("Descriptor is not valid XML!", e);
        }
        return xmlDescriptorDOM;
    }

    public static AdaptiveFeatureGenerator create(InputStream xmlDescriptorIn, FeatureGeneratorResourceProvider resourceManager) throws IOException, InvalidFormatException {
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        Element generatorElement = xmlDescriptorDOM.getDocumentElement();
        return GeneratorFactory.createGenerator(generatorElement, resourceManager);
    }

    public static Map<String, ArtifactSerializer<?>> extractCustomArtifactSerializerMappings(InputStream xmlDescriptorIn) throws IOException, InvalidFormatException {
        NodeList customElements;
        HashMap mapping = new HashMap();
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression exp = xPath.compile("//custom");
            customElements = (NodeList)exp.evaluate(xmlDescriptorDOM.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("The hard coded XPath expression should always be valid!");
        }
        for (int i = 0; i < customElements.getLength(); ++i) {
            Element customElement;
            AdaptiveFeatureGenerator generator;
            if (!(customElements.item(i) instanceof Element) || !((generator = GeneratorFactory.createGenerator(customElement = (Element)customElements.item(i), null)) instanceof ArtifactToSerializerMapper)) continue;
            ArtifactToSerializerMapper mapper = (ArtifactToSerializerMapper)((Object)generator);
            mapping.putAll(mapper.getArtifactSerializerMapping());
        }
        return mapping;
    }

    public static List<Element> getDescriptorElements(InputStream xmlDescriptorIn) throws IOException, InvalidFormatException {
        NodeList allElements;
        ArrayList<Element> elements = new ArrayList<Element>();
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression exp = xPath.compile("//*");
            allElements = (NodeList)exp.evaluate(xmlDescriptorDOM.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("The hard coded XPath expression should always be valid!");
        }
        for (int i = 0; i < allElements.getLength(); ++i) {
            if (!(allElements.item(i) instanceof Element)) continue;
            Element customElement = (Element)allElements.item(i);
            elements.add(customElement);
        }
        return elements;
    }

    static {
        AggregatedFeatureGeneratorFactory.register(factories);
        CachedFeatureGeneratorFactory.register(factories);
        CharacterNgramFeatureGeneratorFactory.register(factories);
        DefinitionFeatureGeneratorFactory.register(factories);
        DictionaryFeatureGeneratorFactory.register(factories);
        DocumentBeginFeatureGenerator.register(factories);
        PreviousMapFeatureGeneratorFactory.register(factories);
        SentenceFeatureGeneratorFactory.register(factories);
        TokenClassFeatureGeneratorFactory.register(factories);
        TokenFeatureGeneratorFactory.register(factories);
        BigramNameFeatureGeneratorFactory.register(factories);
        TokenPatternFeatureGeneratorFactory.register(factories);
        PrefixFeatureGeneratorFactory.register(factories);
        SuffixFeatureGeneratorFactory.register(factories);
        WindowFeatureGeneratorFactory.register(factories);
        WordClusterFeatureGeneratorFactory.register(factories);
        BrownClusterTokenFeatureGeneratorFactory.register(factories);
        BrownClusterTokenClassFeatureGeneratorFactory.register(factories);
        BrownClusterBigramFeatureGeneratorFactory.register(factories);
        CustomFeatureGeneratorFactory.register(factories);
    }

    static interface XmlFeatureGeneratorFactory {
        public AdaptiveFeatureGenerator create(Element var1, FeatureGeneratorResourceProvider var2) throws InvalidFormatException;
    }

    static class AggregatedFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        AggregatedFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            LinkedList<AdaptiveFeatureGenerator> aggregatedGenerators = new LinkedList<AdaptiveFeatureGenerator>();
            NodeList childNodes = generatorElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element aggregatedGeneratorElement = (Element)childNode;
                aggregatedGenerators.add(GeneratorFactory.createGenerator(aggregatedGeneratorElement, resourceManager));
            }
            return new AggregatedFeatureGenerator(aggregatedGenerators.toArray(new AdaptiveFeatureGenerator[aggregatedGenerators.size()]));
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("generators", new AggregatedFeatureGeneratorFactory());
        }
    }

    static class CachedFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        private CachedFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            Element cachedGeneratorElement = null;
            NodeList kids = generatorElement.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node childNode = kids.item(i);
                if (!(childNode instanceof Element)) continue;
                cachedGeneratorElement = (Element)childNode;
                break;
            }
            if (cachedGeneratorElement == null) {
                throw new InvalidFormatException("Could not find containing generator element!");
            }
            AdaptiveFeatureGenerator cachedGenerator = GeneratorFactory.createGenerator(cachedGeneratorElement, resourceManager);
            return new CachedFeatureGenerator(cachedGenerator);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("cache", new CachedFeatureGeneratorFactory());
        }
    }

    static class CharacterNgramFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CharacterNgramFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            int max;
            int min;
            String minString = generatorElement.getAttribute("min");
            try {
                min = Integer.parseInt(minString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("min attribute '" + minString + "' is not a number!", e);
            }
            String maxString = generatorElement.getAttribute("max");
            try {
                max = Integer.parseInt(maxString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("max attribute '" + maxString + "' is not a number!", e);
            }
            return new CharacterNgramFeatureGenerator(min, max);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("charngram", new CharacterNgramFeatureGeneratorFactory());
        }
    }

    static class DefinitionFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        private static final String ELEMENT_NAME = "definition";

        private DefinitionFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            return new OutcomePriorFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put(ELEMENT_NAME, new DefinitionFeatureGeneratorFactory());
        }
    }

    static class DictionaryFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        DictionaryFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String dictResourceKey = generatorElement.getAttribute("dict");
            Object dictResource = resourceManager.getResource(dictResourceKey);
            if (!(dictResource instanceof Dictionary)) {
                throw new InvalidFormatException("No dictionary resource for key: " + dictResourceKey);
            }
            String prefix = generatorElement.getAttribute("prefix");
            return new DictionaryFeatureGenerator(prefix, (Dictionary)dictResource);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("dictionary", new DictionaryFeatureGeneratorFactory());
        }
    }

    static class DocumentBeginFeatureGenerator
    implements XmlFeatureGeneratorFactory {
        DocumentBeginFeatureGenerator() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new PreviousMapFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("docbegin", new DocumentBeginFeatureGenerator());
        }
    }

    static class PreviousMapFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        PreviousMapFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new PreviousMapFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("prevmap", new PreviousMapFeatureGeneratorFactory());
        }
    }

    static class SentenceFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        SentenceFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            String beginFeatureString = generatorElement.getAttribute("begin");
            boolean beginFeature = true;
            if (beginFeatureString.length() != 0) {
                beginFeature = Boolean.parseBoolean(beginFeatureString);
            }
            String endFeatureString = generatorElement.getAttribute("end");
            boolean endFeature = true;
            if (endFeatureString.length() != 0) {
                endFeature = Boolean.parseBoolean(endFeatureString);
            }
            return new SentenceFeatureGenerator(beginFeature, endFeature);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("sentence", new SentenceFeatureGeneratorFactory());
        }
    }

    static class TokenClassFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenClassFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new TokenClassFeatureGenerator(true);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("tokenclass", new TokenClassFeatureGeneratorFactory());
        }
    }

    static class TokenFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new TokenFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("token", new TokenFeatureGeneratorFactory());
        }
    }

    static class BigramNameFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        BigramNameFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new BigramNameFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("bigram", new BigramNameFeatureGeneratorFactory());
        }
    }

    static class TokenPatternFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        TokenPatternFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new TokenPatternFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("tokenpattern", new TokenPatternFeatureGeneratorFactory());
        }
    }

    static class PrefixFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        PrefixFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new PrefixFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("prefix", new PrefixFeatureGeneratorFactory());
        }
    }

    static class SuffixFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        SuffixFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) {
            return new SuffixFeatureGenerator();
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("suffix", new SuffixFeatureGeneratorFactory());
        }
    }

    static class WindowFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        WindowFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            int nextLength;
            int prevLength;
            Element nestedGeneratorElement = null;
            NodeList kids = generatorElement.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node childNode = kids.item(i);
                if (!(childNode instanceof Element)) continue;
                nestedGeneratorElement = (Element)childNode;
                break;
            }
            if (nestedGeneratorElement == null) {
                throw new InvalidFormatException("window feature generator must contain an aggregator element");
            }
            AdaptiveFeatureGenerator nestedGenerator = GeneratorFactory.createGenerator(nestedGeneratorElement, resourceManager);
            String prevLengthString = generatorElement.getAttribute("prevLength");
            try {
                prevLength = Integer.parseInt(prevLengthString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("prevLength attribute '" + prevLengthString + "' is not a number!", e);
            }
            String nextLengthString = generatorElement.getAttribute("nextLength");
            try {
                nextLength = Integer.parseInt(nextLengthString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException("nextLength attribute '" + nextLengthString + "' is not a number!", e);
            }
            return new WindowFeatureGenerator(nestedGenerator, prevLength, nextLength);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("window", new WindowFeatureGeneratorFactory());
        }
    }

    static class WordClusterFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        WordClusterFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String dictResourceKey = generatorElement.getAttribute("dict");
            boolean lowerCaseDictionary = "true".equals(generatorElement.getAttribute("lowerCase"));
            Object dictResource = resourceManager.getResource(dictResourceKey);
            if (!(dictResource instanceof WordClusterDictionary)) {
                throw new InvalidFormatException("Not a WordClusterDictionary resource for key: " + dictResourceKey);
            }
            return new WordClusterFeatureGenerator((WordClusterDictionary)dictResource, dictResourceKey, lowerCaseDictionary);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("wordcluster", new WordClusterFeatureGeneratorFactory());
        }
    }

    static class BrownClusterTokenFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        BrownClusterTokenFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String dictResourceKey = generatorElement.getAttribute("dict");
            Object dictResource = resourceManager.getResource(dictResourceKey);
            if (!(dictResource instanceof BrownCluster)) {
                throw new InvalidFormatException("Not a BrownLexicon resource for key: " + dictResourceKey);
            }
            return new BrownTokenFeatureGenerator((BrownCluster)dictResource);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("brownclustertoken", new BrownClusterTokenFeatureGeneratorFactory());
        }
    }

    static class BrownClusterTokenClassFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        BrownClusterTokenClassFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String dictResourceKey = generatorElement.getAttribute("dict");
            Object dictResource = resourceManager.getResource(dictResourceKey);
            if (!(dictResource instanceof BrownCluster)) {
                throw new InvalidFormatException("Not a BrownLexicon resource for key: " + dictResourceKey);
            }
            return new BrownTokenClassFeatureGenerator((BrownCluster)dictResource);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("brownclustertokenclass", new BrownClusterTokenClassFeatureGeneratorFactory());
        }
    }

    static class BrownClusterBigramFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        BrownClusterBigramFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String dictResourceKey = generatorElement.getAttribute("dict");
            Object dictResource = resourceManager.getResource(dictResourceKey);
            if (!(dictResource instanceof BrownCluster)) {
                throw new InvalidFormatException("Not a BrownLexicon resource for key: " + dictResourceKey);
            }
            return new BrownBigramFeatureGenerator((BrownCluster)dictResource);
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("brownclusterbigram", new BrownClusterBigramFeatureGeneratorFactory());
        }
    }

    static class CustomFeatureGeneratorFactory
    implements XmlFeatureGeneratorFactory {
        CustomFeatureGeneratorFactory() {
        }

        @Override
        public AdaptiveFeatureGenerator create(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            String featureGeneratorClassName = generatorElement.getAttribute("class");
            AdaptiveFeatureGenerator generator = ExtensionLoader.instantiateExtension(AdaptiveFeatureGenerator.class, featureGeneratorClassName);
            if (generator instanceof CustomFeatureGenerator) {
                CustomFeatureGenerator customGenerator = (CustomFeatureGenerator)generator;
                HashMap<String, String> properties = new HashMap<String, String>();
                NamedNodeMap attributes = generatorElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    if ("class".equals(attribute.getNodeName())) continue;
                    properties.put(attribute.getNodeName(), attribute.getNodeValue());
                }
                if (resourceManager != null) {
                    customGenerator.init(properties, resourceManager);
                }
            }
            return generator;
        }

        static void register(Map<String, XmlFeatureGeneratorFactory> factoryMap) {
            factoryMap.put("custom", new CustomFeatureGeneratorFactory());
        }
    }
}

