/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.DataIndexer;

public abstract class AbstractDataIndexer
implements DataIndexer {
    private int numEvents;
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;
    protected int[] predCounts;

    @Override
    public int[][] getContexts() {
        return this.contexts;
    }

    @Override
    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    @Override
    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    @Override
    public String[] getPredLabels() {
        return this.predLabels;
    }

    @Override
    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    @Override
    public int[] getPredCounts() {
        return this.predCounts;
    }

    protected int sortAndMerge(List<ComparableEvent> eventsToCompare, boolean sort) {
        int numUniqueEvents = 1;
        this.numEvents = eventsToCompare.size();
        if (sort) {
            Collections.sort(eventsToCompare);
            ComparableEvent ce = eventsToCompare.get(0);
            for (int i = 1; i < this.numEvents; ++i) {
                ComparableEvent ce2 = eventsToCompare.get(i);
                if (ce.compareTo(ce2) == 0) {
                    ++ce.seen;
                    eventsToCompare.set(i, null);
                    continue;
                }
                ce = ce2;
                ++numUniqueEvents;
            }
        } else {
            numUniqueEvents = eventsToCompare.size();
        }
        if (sort) {
            System.out.println("done. Reduced " + this.numEvents + " events to " + numUniqueEvents + ".");
        }
        this.contexts = new int[numUniqueEvents][];
        this.outcomeList = new int[numUniqueEvents];
        this.numTimesEventsSeen = new int[numUniqueEvents];
        int j = 0;
        for (int i = 0; i < this.numEvents; ++i) {
            ComparableEvent evt = eventsToCompare.get(i);
            if (null == evt) continue;
            this.numTimesEventsSeen[j] = evt.seen;
            this.outcomeList[j] = evt.outcome;
            this.contexts[j] = evt.predIndexes;
            ++j;
        }
        return numUniqueEvents;
    }

    @Override
    public int getNumEvents() {
        return this.numEvents;
    }

    protected static void update(String[] ec, Set<String> predicateSet, Map<String, Integer> counter, int cutoff) {
        for (String s : ec) {
            Integer i = counter.get(s);
            if (i == null) {
                counter.put(s, 1);
            } else {
                counter.put(s, i + 1);
            }
            if (predicateSet.contains(s) || counter.get(s) < cutoff) continue;
            predicateSet.add(s);
        }
    }

    protected static String[] toIndexedStringArray(Map<String, Integer> labelToIndexMap) {
        String[] array = new String[labelToIndexMap.size()];
        Iterator<String> iterator = labelToIndexMap.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            array[labelToIndexMap.get((Object)label).intValue()] = label = iterator.next();
        }
        return array;
    }

    @Override
    public float[][] getValues() {
        return null;
    }
}

