/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.formats.brat.AnnotationConfiguration;
import opennlp.tools.formats.brat.AttributeAnnotation;
import opennlp.tools.formats.brat.BratAnnotation;
import opennlp.tools.formats.brat.RelationAnnotation;
import opennlp.tools.formats.brat.SpanAnnotation;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class BratAnnotationStream
implements ObjectStream<BratAnnotation> {
    private final Map<String, BratAnnotationParser> parsers = new HashMap<String, BratAnnotationParser>();
    private final AnnotationConfiguration config;
    private final BufferedReader reader;
    private final String id;

    BratAnnotationStream(AnnotationConfiguration config, String id, InputStream in) {
        this.config = config;
        this.id = id;
        this.reader = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        this.parsers.put("Span", new SpanAnnotationParser());
        this.parsers.put("Entity", new SpanAnnotationParser());
        this.parsers.put("Relation", new RelationAnnotationParser());
        this.parsers.put("Attribute", new AttributeAnnotationParser());
    }

    @Override
    public BratAnnotation read() throws IOException {
        String line = this.reader.readLine();
        if (line != null) {
            Span[] tokens = WhitespaceTokenizer.INSTANCE.tokenizePos(line);
            if (tokens.length > 2) {
                String typeClass = this.config.getTypeClass(tokens[1].getCoveredText(line).toString());
                BratAnnotationParser parser = this.parsers.get(typeClass);
                if (parser == null) {
                    throw new IOException("Failed to parse ann document with id " + this.id + " type class, no parser registered: " + tokens[1].getCoveredText(line).toString());
                }
                return parser.parse(tokens, line);
            }
        } else {
            return null;
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.reader.reset();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    static class SpanAnnotationParser
    extends BratAnnotationParser {
        private static final int BEGIN_OFFSET = 2;
        private static final int END_OFFSET = 3;

        SpanAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] values, CharSequence line) throws IOException {
            if (values.length > 4) {
                String type = values[1].getCoveredText(line).toString();
                int endOffset = -1;
                int firstTextTokenIndex = -1;
                for (int i = 3; i < values.length; ++i) {
                    if (values[i].getCoveredText(line).toString().contains(";")) continue;
                    endOffset = this.parseInt(values[i].getCoveredText(line).toString());
                    firstTextTokenIndex = i + 1;
                    break;
                }
                String id = values[0].getCoveredText(line).toString();
                String coveredText = line.subSequence(values[firstTextTokenIndex].getStart(), values[values.length - 1].getEnd()).toString();
                return new SpanAnnotation(id, type, new Span(this.parseInt(values[2].getCoveredText(line).toString()), endOffset, type), coveredText);
            }
            throw new InvalidFormatException("Line must have at least 5 fields");
        }
    }

    static class RelationAnnotationParser
    extends BratAnnotationParser {
        private static final int ARG1_OFFSET = 2;
        private static final int ARG2_OFFSET = 3;

        RelationAnnotationParser() {
        }

        private String parseArg(String arg) throws InvalidFormatException {
            if (arg.length() > 4) {
                return arg.substring(5).trim();
            }
            throw new InvalidFormatException("Failed to parse argument: " + arg);
        }

        @Override
        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            return new RelationAnnotation(tokens[0].getCoveredText(line).toString(), tokens[1].getCoveredText(line).toString(), this.parseArg(tokens[2].getCoveredText(line).toString()), this.parseArg(tokens[3].getCoveredText(line).toString()));
        }
    }

    static class AttributeAnnotationParser
    extends BratAnnotationParser {
        private static final int ATTACHED_TO_OFFSET = 2;
        private static final int VALUE_OFFSET = 3;

        AttributeAnnotationParser() {
        }

        @Override
        BratAnnotation parse(Span[] values, CharSequence line) throws IOException {
            if (values.length == 3 || values.length == 4) {
                String value = null;
                if (values.length == 4) {
                    value = values[3].getCoveredText(line).toString();
                }
                return new AttributeAnnotation(values[0].getCoveredText(line).toString(), values[1].getCoveredText(line).toString(), values[2].getCoveredText(line).toString(), value);
            }
            throw new InvalidFormatException("Line must have 3 or 4 fields");
        }
    }

    static abstract class BratAnnotationParser {
        static final int ID_OFFSET = 0;
        static final int TYPE_OFFSET = 1;

        BratAnnotationParser() {
        }

        BratAnnotation parse(Span[] tokens, CharSequence line) throws IOException {
            return null;
        }

        protected int parseInt(String intString) throws InvalidFormatException {
            try {
                return Integer.parseInt(intString);
            }
            catch (NumberFormatException e) {
                throw new InvalidFormatException(e);
            }
        }
    }
}

