<?php
/**
 * @filesource modules/inventory/views/image.php
 *
 * @copyright 2016 Goragod.com
 * @license https://www.kotchasan.com/license/
 *
 * @see https://www.kotchasan.com/
 */

namespace Inventory\Image;

use Kotchasan\Html;

/**
 * module=inventory-image
 *
 * @author Goragod Wiriya <admin@goragod.com>
 *
 * @since 1.0
 */
class View extends \Gcms\View
{
    /**
     * ตั้งค่าบริษัท
     *
     * @return string
     */
    public function render()
    {
        $form = Html::create('form', [
            'id' => 'setup_frm',
            'class' => 'setup_frm',
            'autocomplete' => 'off',
            'action' => 'index.php/inventory/model/image/submit',
            'onsubmit' => 'doFormSubmit',
            'token' => true,
            'ajax' => true
        ]);
        $fieldset = $form->add('fieldset', [
            'titleClass' => 'icon-thumbnail',
            'title' => '{LNG_Pictures for a receipt}'
        ]);
        // delete_logo
        $fieldset->add('checkbox', [
            'id' => 'delete_logo',
            'itemClass' => 'item',
            'label' => '{LNG_remove this photo}',
            'value' => 1
        ]);
        // logo
        $fieldset->add('file', [
            'id' => 'logo',
            'labelClass' => 'g-input icon-upload',
            'itemClass' => 'item',
            'label' => '{LNG_Company logo}',
            'comment' => '{LNG_Select image size 500 * 500 pixels, type jpg, PNG and webp.}',
            'dataPreview' => 'logoImage',
            'previewSrc' => is_file(ROOT_PATH.DATA_FOLDER.'logo'.self::$cfg->stored_img_type) ? WEB_URL.DATA_FOLDER.'logo'.self::$cfg->stored_img_type : WEB_URL.'skin/img/blank.gif'
        ]);
        $fieldset = $form->add('fieldset', [
            'class' => 'submit'
        ]);
        // submit
        $fieldset->add('submit', [
            'class' => 'button save large icon-save',
            'value' => '{LNG_Save}'
        ]);
        // คืนค่า HTML
        return $form->render();
    }
}
