<?php
/**
 * @filesource modules/inventory/models/products.php
 *
 * @copyright 2016 Goragod.com
 * @license https://www.kotchasan.com/license/
 *
 * @see https://www.kotchasan.com/
 */

namespace Inventory\Products;

use Kotchasan\Database\Sql;

/**
 * model=inventory-products
 *
 * @author Goragod Wiriya <admin@goragod.com>
 *
 * @since 1.0
 */
class Model extends \Kotchasan\Model
{
    /**
     * Query ข้อมูลสำหรับส่งให้กับ DataTable
     *
     * @param array $params
     *
     * @return \Kotchasan\Database\QueryBuilder
     */
    public static function toDataTable($params)
    {
        $where = [
            ['V.count_stock', [0, 1]],
            ['V.inuse', 1]
        ];
        if ($params['category_id'] > 0) {
            $where[] = ['V.category_id', $params['category_id']];
        }
        $q1 = static::createQuery()
            ->select('V.id', Sql::CONCAT(['V.topic', 'I.topic'], 'topic', ', '), 'I.product_no', 'V.category_id', 'I.price', 'V.stock', 'I.unit', 'V.count_stock')
            ->from('inventory V')
            ->join('inventory_items I', 'LEFT', [['I.inventory_id', 'V.id']])
            ->where($where);
        $where[0] = ['V.count_stock', 2];
        $q2 = static::createQuery()
            ->select('V.id', 'V.topic', 'I.product_no', 'V.category_id', 'I.price', 'V.stock', 'I.unit', 'V.count_stock')
            ->from('inventory V')
            ->join('inventory_items I', 'LEFT', ['I.inventory_id', 'V.id'])
            ->where($where)
            ->groupBy('V.id');
        return static::createQuery()
            ->union($q1, $q2);
    }
}
