<?php
/**
 * @filesource modules/inventory/models/autocomplete.php
 *
 * @copyright 2016 Goragod.com
 * @license https://www.kotchasan.com/license/
 *
 * @see https://www.kotchasan.com/
 */

namespace Inventory\Autocomplete;

use Gcms\Login;
use Kotchasan\Database\Sql;
use Kotchasan\Http\Request;

/**
 * ค้นหา สำหรับ autocomplete
 *
 * @author Goragod Wiriya <admin@goragod.com>
 *
 * @since 1.0
 */
class Model extends \Kotchasan\Model
{
    /**
     * ค้นหา สำหรับ autocomplete
     * คืนค่าเป็น JSON
     *
     * @param Request $request
     */
    public function findCustomer(Request $request)
    {
        if ($request->initSession() && $request->isReferer() && Login::isMember()) {
            try {
                // ข้อความค้นหา
                $search = $request->post('name')->topic();
                if ($search != '') {
                    $where = [];
                    $select = ['id customer_id', 'company customer', 'name', 'email', 'phone', 'customer_no'];
                    $order = [];
                    foreach (explode(',', $request->post('from', 'name,email')->filter('a-z,_')) as $item) {
                        if ($item == 'name') {
                            if ($search != '') {
                                $where[] = ['name', 'LIKE', "%$search%"];
                            }
                            $order[] = 'name';
                        }
                        if ($item == 'email') {
                            if ($search != '') {
                                $where[] = ['email', 'LIKE', "%$search%"];
                            }
                            $order[] = 'email';
                        }
                        if ($item == 'phone') {
                            if ($search != '') {
                                $where[] = ['phone', 'LIKE', "$search%"];
                            }
                            $order[] = 'phone';
                        }
                        if ($item == 'company') {
                            if ($search != '') {
                                $where[] = ['company', 'LIKE', "%$search%"];
                            }
                            $order[] = 'company';
                        }
                        if ($item == 'customer_no') {
                            if ($search != '') {
                                $where[] = ['customer_no', 'LIKE', "%$search%"];
                            }
                            $order[] = 'customer_no';
                        }
                        if ($item == 'discount') {
                            $select[] = 'discount';
                        }
                    }
                    $result = $this->db()->createQuery()
                        ->select($select)
                        ->from('customer')
                        ->where($where, 'OR')
                        ->order($order)
                        ->limit($request->post('count')->toInt())
                        ->toArray()
                        ->execute();
                    // คืนค่า JSON
                    if (!empty($result)) {
                        echo json_encode($result);
                    }
                }
            } catch (\Kotchasan\InputItemException $e) {
            }
        }
    }

    /**
     * ค้นหาสินค้า สำหรับ autocomplete ที่กำลังใช้งานอยู่
     * คืนค่าเป็น JSON
     *
     * @param Request $request
     */
    public function findProduct(Request $request)
    {
        if ($request->initSession() && $request->isReferer() && Login::isMember()) {
            try {
                $search = $request->post('name')->topic();
                if ($search != '') {
                    $status = $request->post('status')->filter('A-Z');
                    $where = [];
                    if (in_array($status, self::$cfg->sell_status)) {
                        // ขาย
                        $where[] = ['V.inuse', 1];
                        if ($status == 'OUT') {
                            $where[] = ['I.instock', 1];
                        }
                    }
                    $andWhere = [];
                    $order = [];
                    foreach (explode(',', $request->post('from', 'product_no,topic')->filter('a-z_,')) as $item) {
                        if ($item == 'product_no') {
                            if ($search != '') {
                                $andWhere[] = ['I.product_no', 'LIKE', "%$search%"];
                            }
                            $order[] = 'I.product_no';
                        }
                        if ($item == 'topic') {
                            if ($search != '') {
                                $andWhere[] = ['V.topic', 'LIKE', "%$search%"];
                            }
                            $order[] = 'V.topic';
                        }
                    }
                    $return = $this->db()->createQuery()
                        ->select('I.product_no', Sql::CONCAT(['V.topic', 'I.topic'], 'topic', ' '), 'I.price', 'V.cost', 'V.stock', 'V.count_stock', 'I.unit')
                        ->from('inventory V')
                        ->join('inventory_items I', 'INNER', ['I.inventory_id', 'V.id'])
                        ->where($where)
                        ->andWhere($andWhere, 'OR')
                        ->order('I.product_no')
                        ->limit($request->post('count')->toInt())
                        ->toArray()
                        ->execute();
                    // คืนค่า JSON
                    echo json_encode($return);
                }
            } catch (\Kotchasan\InputItemException $e) {
            }
        }
    }
}
