<?php
/**
 * @filesource modules/inventory/controllers/orders.php
 *
 * @copyright 2016 Goragod.com
 * @license https://www.kotchasan.com/license/
 *
 * @see https://www.kotchasan.com/
 */

namespace Inventory\Orders;

use Gcms\Login;
use Kotchasan\Html;
use Kotchasan\Http\Request;
use Kotchasan\Language;

/**
 * module=inventory-orders
 *
 * @author Goragod Wiriya <admin@goragod.com>
 *
 * @since 1.0
 */
class Controller extends \Gcms\Controller
{
    /**
     * รายการ Orders
     *
     * @param Request $request
     *
     * @return string
     */
    public function render(Request $request)
    {
        // ค่าที่ส่งมา
        $params = [
            'order_status' => Language::get('ORDER_STATUS'),
            'from' => $request->request('from')->date(),
            'to' => $request->request('to')->date(),
            'status' => $request->request('status')->filter('A-Z')
        ];
        // สมาชิก
        $login = Login::isMember();
        if (in_array($params['status'], self::$cfg->buy_status) && Login::checkPermission($login, 'can_manage_inventory')) {
            // จัดซื้อ
            $this->menu = 'purchase';
            $sub_title = '{LNG_Purchase}';
            $title = '{LNG_Order report} ';
        } elseif (in_array($params['status'], self::$cfg->sell_status) && Login::checkPermission($login, 'can_inventory_order')) {
            // พนักงานขาย
            $params['status'] = isset($params['order_status'][$params['status']]) ? $params['status'] : 'OUT';
            $this->menu = 'sales';
            $sub_title = '{LNG_Sales}';
            $title = '{LNG_Sales report} ';
        } else {
            // ไม่สามารถทำรายการได้
            $params['status'] = null;
        }
        if (isset($params['order_status'][$params['status']])) {
            $title .= $params['order_status'][$params['status']];
            $this->title = Language::trans($title);
            // แสดงผล
            $section = Html::create('section');
            // breadcrumbs
            $breadcrumbs = $section->add('nav', [
                'class' => 'breadcrumbs'
            ]);
            $ul = $breadcrumbs->add('ul');
            $ul->appendChild('<li><a href="index.php" class="icon-home">{LNG_Home}</a></li>');
            $ul->appendChild('<li><span>'.$sub_title.'</span></li>');
            $ul->appendChild('<li><span>{LNG_Report}</span></li>');
            $section->add('header', [
                'innerHTML' => '<h2 class="icon-report">'.$this->title.'</h2>'
            ]);
            $div = $section->add('div', [
                'class' => 'content_bg'
            ]);
            // แสดงตาราง
            $div->appendChild(\Inventory\Orders\View::create()->render($request, $params));
            // คืนค่า HTML
            return $section->render();
        }
        // 404
        return \Index\Error\Controller::execute($this, $request->getUri());
    }
}
