#!/usr/bin/env python
#
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""This example submits a Site for approval."""

# Import appropriate modules from the client library.
from googleads import ad_manager

# Set the id of the site to submit for approval.
SITE_ID = 'INSERT_SITE_ID_HERE'


def main(client):
  # Initialize appropriate service.
  site_service = client.GetService('SiteService', version='v202402')

  # Create a statement to select Site.
  statement = (ad_manager.StatementBuilder(version='v202402')
               .Where('id = :id')
               .WithBindVariable('id', SITE_ID))

  response = site_service.performSiteAction(
      {'xsi_type': 'SubmitSiteForApproval'}, statement.ToStatement())

  print('\nNumber of sites changed: %s' % response['numChanges'])


if __name__ == '__main__':
  # Initialize client object.
  ad_manager_client = ad_manager.AdManagerClient.LoadFromStorage()
  main(ad_manager_client)
